/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.MathType;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.bom.TCData;
import visad.java2d.DisplayImplJ2D;

public class TCDataTest {
    public static void main(String[] args) throws VisADException, RemoteException {
        TCData data = new TCData();
        MathType mtTC = data.getType();
        System.out.println("MathType:\n" + mtTC);
        double[] daTimes = new double[]{0.0, 1000.0, 2000.0};
        float[] faLats = new float[]{10.0f, 11.0f, 12.0f};
        float[] faLons = new float[]{160.0f, 165.0f, 170.0f};
        float[] faErrors = new float[]{0.0f, 0.0f, 0.0f};
        int[] iaConfidence = new int[]{2, 3, 4};
        int[] iaLocationStyles = new int[]{2, 3, 4};
        float[] faWind_means = new float[]{50.0f, 60.0f, 70.0f};
        float[] faWind_gusts = new float[]{60.0f, 70.0f, 80.0f};
        float[] faCentral_pressures = new float[]{990.0f, 985.0f, 980.0f};
        int[] iaCategories = new int[]{2, 3, 4};
        int[] iaIntensityStyles = new int[]{2, 3, 4};
        float[] faGaleRadii = new float[]{200.0f, 210.0f, 220.0f};
        float[] faStormRadii = new float[]{100.0f, 110.0f, 120.0f};
        float[] faHurricaneRadii = new float[]{60.0f, 70.0f, 80.0f};
        float[] faRadiiOfMaximumWinds = new float[]{50.0f, 60.0f, 70.0f};
        int[] iaSizeStyles = new int[]{2, 3, 4};
        float[] faDepth = new float[]{200.0f, 200.0f, 200.0f};
        float[] faEyeDiameter = new float[]{50.0f, 60.0f, 70.0f};
        float[] faPressureOfLastClosedIsobar = new float[]{200.0f, 210.0f, 220.0f};
        int[] iaStructureStyles = new int[]{2, 3, 4};
        FlatField ffFixes = TCData.makeLocations(daTimes, faLats, faLons, faErrors, iaConfidence, iaLocationStyles, faWind_means, faWind_gusts, faCentral_pressures, iaCategories, iaIntensityStyles, faGaleRadii, faStormRadii, faHurricaneRadii, faRadiiOfMaximumWinds, iaSizeStyles, faDepth, faEyeDiameter, faPressureOfLastClosedIsobar, iaStructureStyles);
        String sTrackType = new String("Observed");
        String sTrackName = new String("RealTime");
        int iBaseDateTime = 4000;
        int iCreateDateTime = 5000;
        String sDisplayType = new String("IDunno");
        Tuple tTrack = TCData.makeTrack(sTrackType, sTrackName, iBaseDateTime, iCreateDateTime, sDisplayType, ffFixes);
        int iTrackID = 0;
        FieldImpl fiTrack = TCData.makeTrackField(iTrackID, tTrack);
        String sCountry = new String("Australia");
        String sState = new String("WA");
        int iYear = 2000;
        int iNumber = 0;
        String sHistoricalName = new String("Olga");
        int iOpenDate = 5000;
        int iCloseDate = 15000;
        int iArchiveMode = 0;
        int iRealTimeMode = 0;
        Tuple tDisturbance = TCData.makeDisturbance(sCountry, sState, iYear, iNumber, sHistoricalName, iOpenDate, iCloseDate, iArchiveMode, iRealTimeMode, fiTrack);
        TCData tcd = new TCData();
        tcd.addDisturbance(0, tDisturbance);
        FieldImpl fiTCD = tcd.getData();
        DisplayImplJ2D display = new DisplayImplJ2D("display");
        display.addMap(new ScalarMap(TCData.rtTime, Display.XAxis));
        display.addMap(new ScalarMap(TCData.rtCentralPressure, Display.YAxis));
        DataReferenceImpl driTC = new DataReferenceImpl("TC");
        driTC.setData(tTrack);
        display.addReference(driTC, null);
        JFrame frame = new JFrame("TCData Display Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        ((Component)frame).setSize(300, 300);
        ((Component)frame).setVisible(true);
    }
}

