/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.CommonUnit;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.EarthVectorType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ReferenceException;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.VisADException;
import visad.bom.BoxDragRendererJ3D;
import visad.bom.RubberBandBoxRendererJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.ContourWidget;
import visad.util.LabeledColorWidget;
import visad.util.Util;
import visad.util.VisADSlider;

public class CutAndPasteFields
implements ActionListener {
    private boolean debug = true;
    private Field grids = null;
    private DisplayImpl display = null;
    private int blend = 0;
    private Object lock = new Object();
    private RealType t = null;
    private RealType x = null;
    private RealType y = null;
    private RealTupleType xy = null;
    private MathType range = null;
    private int rangedim = 0;
    private int nts = 0;
    Set tset = null;
    Set xyset = null;
    int nx;
    int ny;
    int rx;
    int ry;
    float[][] cut = null;
    float[][] replaced = null;
    FlatField replacedff = null;
    int replacedixlow;
    int replacedixhi;
    int replacediylow;
    int replacediyhi;
    AnimationControl acontrol = null;
    ScalarMap tmap = null;
    ScalarMap xmap = null;
    ScalarMap ymap = null;
    private double xlow;
    private double xhi;
    private double ylow;
    private double yhi;
    private int ixlow;
    private int ixhi;
    private int iylow;
    private int iyhi;
    private CellImpl cell_rbb = null;
    private CellImpl cell_xlyl = null;
    private CellImpl cell_xlyh = null;
    private CellImpl cell_xhyl = null;
    private CellImpl cell_xhyh = null;
    private DataReferenceImpl ref_rbb = null;
    private DataReferenceImpl ref_xlyl = null;
    private DataReferenceImpl ref_xlyh = null;
    private DataReferenceImpl ref_xhyl = null;
    private DataReferenceImpl ref_xhyh = null;
    private DataReferenceImpl ref_rect = null;
    private RubberBandBoxRendererJ3D rbbr = null;
    private BoxDragRendererJ3D xlylr = null;
    private BoxDragRendererJ3D xlyhr = null;
    private BoxDragRendererJ3D xhylr = null;
    private BoxDragRendererJ3D xhyhr = null;
    private DefaultRendererJ3D rectr = null;
    private CutAndPasteFields thiscp = null;
    private static final int NSTAS = 64;
    private static final int NTIMES = 10;

    public CutAndPasteFields(Field gs, DisplayImplJ3D d) throws VisADException, RemoteException {
        this(gs, d, 0);
    }

    public CutAndPasteFields(Field gs, DisplayImplJ3D d, int b) throws VisADException, RemoteException {
        this.grids = gs;
        this.display = d;
        if (b >= 0) {
            this.blend = b;
        }
        this.thiscp = this;
        FunctionType gstype = (FunctionType)gs.getType();
        RealTupleType domain = gstype.getDomain();
        int domdim = domain.getDimension();
        if (domdim == 1) {
            this.t = (RealType)domain.getComponent(0);
            this.tset = gs.getDomainSet();
            FunctionType gridtype = (FunctionType)gstype.getRange();
            this.xy = gridtype.getDomain();
            int dim = this.xy.getDimension();
            if (dim != 2) {
                throw new VisADException("bad grid Field domain dimension: " + dim);
            }
            this.range = gridtype.getRange();
            this.nts = this.tset.getLength();
            int i = 0;
            while (i < this.nts) {
                FlatField ff = (FlatField)gs.getSample(i);
                Set s = ff.getDomainSet();
                if (this.xyset == null) {
                    this.xyset = s;
                } else if (!this.xyset.equals(s)) {
                    throw new VisADException("grid sets must match in animation");
                }
                ++i;
            }
        } else if (domdim == 2) {
            this.t = null;
            this.tset = null;
            this.xy = domain;
            this.range = gstype.getRange();
            this.xyset = gs.getDomainSet();
        } else {
            throw new VisADException("bad grid Field domain dimension: " + domdim);
        }
        this.x = (RealType)this.xy.getComponent(0);
        this.y = (RealType)this.xy.getComponent(1);
        if (!(this.xyset instanceof LinearSet)) {
            throw new VisADException("grid set must be LinearSet");
        }
        this.nx = ((LinearSet)((Object)this.xyset)).getLinear1DComponent(0).getLength();
        this.ny = ((LinearSet)((Object)this.xyset)).getLinear1DComponent(1).getLength();
        if (this.range instanceof RealType) {
            this.rangedim = 1;
        } else if (this.range instanceof RealTupleType) {
            this.rangedim = ((RealTupleType)this.range).getDimension();
        } else {
            throw new VisADException("bad grid Field range type: " + this.range);
        }
        Vector scalar_map_vector = this.display.getMapVector();
        Enumeration enumeration = scalar_map_vector.elements();
        while (enumeration.hasMoreElements()) {
            ScalarMap map = (ScalarMap)enumeration.nextElement();
            ScalarType scalar = map.getScalar();
            DisplayRealType dreal = map.getDisplayScalar();
            if (scalar.equals(this.t)) {
                if (!Display.Animation.equals(dreal)) continue;
                this.tmap = map;
                this.acontrol = (AnimationControl)((Object)this.tmap.getControl());
                continue;
            }
            if (scalar.equals(this.x)) {
                if (!Display.XAxis.equals(dreal) && !Display.YAxis.equals(dreal) && !Display.ZAxis.equals(dreal)) continue;
                this.xmap = map;
                continue;
            }
            if (!scalar.equals(this.y) || !Display.XAxis.equals(dreal) && !Display.YAxis.equals(dreal) && !Display.ZAxis.equals(dreal)) continue;
            this.ymap = map;
        }
        if (this.xmap == null || this.ymap == null) {
            throw new VisADException("grid domain RealType must be mapped to XAxis, YAxis or ZAxis");
        }
        if (this.t != null && this.tmap == null) {
            throw new VisADException("grid sequence must be mapped to Animation");
        }
        this.ref_rbb = new DataReferenceImpl("rbb");
        this.ref_xlyl = new DataReferenceImpl("xlyl");
        this.ref_xlyh = new DataReferenceImpl("xlyh");
        this.ref_xhyl = new DataReferenceImpl("xhyl");
        this.ref_xhyh = new DataReferenceImpl("xhyh");
        this.ref_rect = new DataReferenceImpl("rect");
        this.rbbr = new RubberBandBoxRendererJ3D(this.x, this.y);
        this.display.addReferences((DataRenderer)this.rbbr, this.ref_rbb);
        this.rbbr.suppressExceptions(true);
        this.rbbr.toggle(false);
        this.xlylr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xlylr, this.ref_xlyl);
        this.xlylr.suppressExceptions(true);
        this.xlylr.toggle(false);
        this.xlyhr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xlyhr, this.ref_xlyh);
        this.xlyhr.suppressExceptions(true);
        this.xlyhr.toggle(false);
        this.xhylr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xhylr, this.ref_xhyl);
        this.xhylr.suppressExceptions(true);
        this.xhylr.toggle(false);
        this.xhyhr = new BoxDragRendererJ3D(this.thiscp);
        this.display.addReferences((DataRenderer)this.xhyhr, this.ref_xhyh);
        this.xhyhr.suppressExceptions(true);
        this.xhyhr.toggle(false);
        this.rectr = new DefaultRendererJ3D();
        this.display.addReferences((DataRenderer)this.rectr, this.ref_rect);
        this.rectr.suppressExceptions(true);
        this.rectr.toggle(false);
        this.cell_xlyl = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.this.lock;
                synchronized (object) {
                    RealTuple rt = (RealTuple)CutAndPasteFields.this.ref_xlyl.getData();
                    if (rt == null) {
                        return;
                    }
                    double xl = ((Real)rt.getComponent(0)).getValue();
                    double yl = ((Real)rt.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(xl, CutAndPasteFields.this.xlow) || !Util.isApproximatelyEqual(yl, CutAndPasteFields.this.ylow)) {
                        CutAndPasteFields.this.xhi += xl - CutAndPasteFields.this.xlow;
                        CutAndPasteFields.this.yhi += yl - CutAndPasteFields.this.ylow;
                        CutAndPasteFields.this.xlow = xl;
                        CutAndPasteFields.this.ylow = yl;
                        CutAndPasteFields.this.drag();
                    }
                }
            }
        };
        this.cell_xlyh = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.this.lock;
                synchronized (object) {
                    RealTuple rt = (RealTuple)CutAndPasteFields.this.ref_xlyh.getData();
                    if (rt == null) {
                        return;
                    }
                    double xl = ((Real)rt.getComponent(0)).getValue();
                    double yh = ((Real)rt.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(xl, CutAndPasteFields.this.xlow) || !Util.isApproximatelyEqual(yh, CutAndPasteFields.this.yhi)) {
                        CutAndPasteFields.this.xhi += xl - CutAndPasteFields.this.xlow;
                        CutAndPasteFields.this.ylow += yh - CutAndPasteFields.this.yhi;
                        CutAndPasteFields.this.xlow = xl;
                        CutAndPasteFields.this.yhi = yh;
                        CutAndPasteFields.this.drag();
                    }
                }
            }
        };
        this.cell_xhyl = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.this.lock;
                synchronized (object) {
                    RealTuple rt = (RealTuple)CutAndPasteFields.this.ref_xhyl.getData();
                    if (rt == null) {
                        return;
                    }
                    double xh = ((Real)rt.getComponent(0)).getValue();
                    double yl = ((Real)rt.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(xh, CutAndPasteFields.this.xhi) || !Util.isApproximatelyEqual(yl, CutAndPasteFields.this.ylow)) {
                        CutAndPasteFields.this.xlow += xh - CutAndPasteFields.this.xhi;
                        CutAndPasteFields.this.yhi += yl - CutAndPasteFields.this.ylow;
                        CutAndPasteFields.this.xhi = xh;
                        CutAndPasteFields.this.ylow = yl;
                        CutAndPasteFields.this.drag();
                    }
                }
            }
        };
        this.cell_xhyh = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.this.lock;
                synchronized (object) {
                    RealTuple rt = (RealTuple)CutAndPasteFields.this.ref_xhyh.getData();
                    if (rt == null) {
                        return;
                    }
                    double xh = ((Real)rt.getComponent(0)).getValue();
                    double yh = ((Real)rt.getComponent(1)).getValue();
                    if (!Util.isApproximatelyEqual(xh, CutAndPasteFields.this.xhi) || !Util.isApproximatelyEqual(yh, CutAndPasteFields.this.yhi)) {
                        CutAndPasteFields.this.xlow += xh - CutAndPasteFields.this.xhi;
                        CutAndPasteFields.this.ylow += yh - CutAndPasteFields.this.yhi;
                        CutAndPasteFields.this.xhi = xh;
                        CutAndPasteFields.this.yhi = yh;
                        CutAndPasteFields.this.drag();
                    }
                }
            }
        };
        this.cell_rbb = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Object object = CutAndPasteFields.this.lock;
                synchronized (object) {
                    double t;
                    Set set = (Set)CutAndPasteFields.this.ref_rbb.getData();
                    if (set == null) {
                        return;
                    }
                    float[][] samples = set.getSamples();
                    if (samples == null) {
                        return;
                    }
                    CutAndPasteFields.this.xlow = samples[0][0];
                    CutAndPasteFields.this.ylow = samples[1][0];
                    CutAndPasteFields.this.xhi = samples[0][1];
                    CutAndPasteFields.this.yhi = samples[1][1];
                    if (CutAndPasteFields.this.xlow > CutAndPasteFields.this.xhi) {
                        t = CutAndPasteFields.this.xlow;
                        CutAndPasteFields.this.xlow = CutAndPasteFields.this.xhi;
                        CutAndPasteFields.this.xhi = t;
                    }
                    if (CutAndPasteFields.this.ylow > CutAndPasteFields.this.yhi) {
                        t = CutAndPasteFields.this.ylow;
                        CutAndPasteFields.this.ylow = CutAndPasteFields.this.yhi;
                        CutAndPasteFields.this.yhi = t;
                    }
                    if (!CutAndPasteFields.this.getIndices(true)) {
                        System.out.println("bad box");
                        return;
                    }
                    CutAndPasteFields.this.getRect();
                    CutAndPasteFields.this.replacedff = null;
                    CutAndPasteFields.this.cell_rbb.removeReference(CutAndPasteFields.this.ref_rbb);
                    CutAndPasteFields.this.drag();
                    CutAndPasteFields.this.cell_xlyl.addReference(CutAndPasteFields.this.ref_xlyl);
                    CutAndPasteFields.this.cell_xlyh.addReference(CutAndPasteFields.this.ref_xlyh);
                    CutAndPasteFields.this.cell_xhyl.addReference(CutAndPasteFields.this.ref_xhyl);
                    CutAndPasteFields.this.cell_xhyh.addReference(CutAndPasteFields.this.ref_xhyh);
                    CutAndPasteFields.this.display.disableAction();
                    CutAndPasteFields.this.xlylr.toggle(true);
                    CutAndPasteFields.this.xlyhr.toggle(true);
                    CutAndPasteFields.this.xhylr.toggle(true);
                    CutAndPasteFields.this.xhyhr.toggle(true);
                    CutAndPasteFields.this.rectr.toggle(true);
                    CutAndPasteFields.this.rbbr.toggle(false);
                    CutAndPasteFields.this.display.enableAction();
                }
            }
        };
    }

    public void start() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            this.cell_rbb.addReference(this.ref_rbb);
            Gridded2DSet dummy_set = new Gridded2DSet((MathType)this.xy, null, 1);
            this.ref_rbb.setData(dummy_set);
            this.rbbr.toggle(true);
        }
    }

    public void stop() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            this.display.disableAction();
            this.rbbr.toggle(false);
            this.xlylr.toggle(false);
            this.xlyhr.toggle(false);
            this.xhylr.toggle(false);
            this.xhyhr.toggle(false);
            this.rectr.toggle(false);
            this.ref_xlyl.setData(null);
            this.ref_xlyh.setData(null);
            this.ref_xhyl.setData(null);
            this.ref_xhyh.setData(null);
            this.ref_rect.setData(null);
            this.display.enableAction();
            try {
                this.cell_rbb.removeReference(this.ref_rbb);
            }
            catch (ReferenceException e) {
                // empty catch block
            }
            try {
                this.cell_xlyl.removeReference(this.ref_xlyl);
            }
            catch (ReferenceException e) {
                // empty catch block
            }
            try {
                this.cell_xlyh.removeReference(this.ref_xlyh);
            }
            catch (ReferenceException e) {
                // empty catch block
            }
            try {
                this.cell_xhyl.removeReference(this.ref_xhyl);
            }
            catch (ReferenceException e) {
                // empty catch block
            }
            try {
                this.cell_xhyh.removeReference(this.ref_xhyh);
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
        }
    }

    public void undo() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            if (this.replacedff != null) {
                float[][] samples = this.replacedff.getFloats(false);
                int ix = this.replacedixlow;
                while (ix <= this.replacedixhi) {
                    int iy = this.replacediylow;
                    while (iy <= this.replacediyhi) {
                        int i = ix + this.nx * iy;
                        int j = ix - this.replacedixlow + this.rx * (iy - this.replacediylow);
                        int k = 0;
                        while (k < this.rangedim) {
                            samples[k][i] = this.replaced[k][j];
                            ++k;
                        }
                        ++iy;
                    }
                    ++ix;
                }
                this.replacedff.setSamples(samples, false);
            }
            this.replacedff = null;
        }
        this.stop();
    }

    public void setBlend(int b) {
        if (b >= 0) {
            this.blend = b;
        }
    }

    private boolean getIndices(boolean rubber) throws VisADException {
        int t;
        Object samples = new float[][]{{(float)this.xlow, (float)this.xhi}, {(float)this.ylow, (float)this.yhi}};
        int[] indices = this.xyset.valueToIndex((float[][])samples);
        int indexlow = indices[0];
        int indexhi = indices[1];
        if (indexlow < 0 || indexhi < 0) {
            return false;
        }
        if (rubber) {
            samples = this.xyset.indexToValue(indices);
            this.xlow = samples[0][0];
            this.ylow = samples[1][0];
            this.xhi = samples[0][1];
            this.yhi = samples[1][1];
        }
        if (indexlow > indexhi) {
            t = indexlow;
            indexlow = indexhi;
            indexhi = t;
        }
        this.iylow = indexlow / this.nx;
        this.ixlow = indexlow % this.nx;
        this.iyhi = indexhi / this.nx;
        this.ixhi = indexhi % this.nx;
        if (this.ixlow > this.ixhi) {
            t = this.ixlow;
            this.ixlow = this.ixhi;
            this.ixhi = t;
        }
        if (this.iylow > this.iyhi) {
            t = this.iylow;
            this.iylow = this.iyhi;
            this.iyhi = t;
        }
        if (rubber) {
            this.rx = this.ixhi - this.ixlow + 1;
            this.ry = this.iyhi - this.iylow + 1;
        } else {
            int tx = this.ixhi - this.ixlow + 1;
            int ty = this.iyhi - this.iylow + 1;
            if (this.rx != tx) {
                if (this.ixlow + this.rx - 1 < this.nx) {
                    this.ixhi = this.ixlow + this.rx - 1;
                } else {
                    this.ixlow = this.ixhi - (this.rx - 1);
                }
            }
            if (this.ry != ty) {
                if (this.iylow + this.ry - 1 < this.ny) {
                    this.iyhi = this.iylow + this.ry - 1;
                } else {
                    this.iylow = this.iyhi - (this.ry - 1);
                }
            }
        }
        return true;
    }

    private void getRect() throws VisADException, RemoteException {
        FlatField ff = null;
        if (this.t != null) {
            int index = this.getAnimationIndex();
            if (index < 0 || index >= this.nts) {
                return;
            }
            ff = (FlatField)this.grids.getSample(index);
        } else {
            ff = (FlatField)this.grids;
        }
        float[][] samples = ff.getFloats(false);
        this.cut = new float[this.rangedim][this.rx * this.ry];
        int ix = this.ixlow;
        while (ix <= this.ixhi) {
            int iy = this.iylow;
            while (iy <= this.iyhi) {
                int i = ix + this.nx * iy;
                int j = ix - this.ixlow + this.rx * (iy - this.iylow);
                int k = 0;
                while (k < this.rangedim) {
                    this.cut[k][j] = samples[k][i];
                    ++k;
                }
                ++iy;
            }
            ++ix;
        }
    }

    private void replaceRect() throws VisADException, RemoteException {
        int index = 0;
        if (this.t != null && ((index = this.getAnimationIndex()) < 0 || index >= this.nts)) {
            return;
        }
        if (!this.getIndices(false)) {
            System.out.println("bad box");
            return;
        }
        if (this.replacedff != null) {
            float[][] samples = this.replacedff.getFloats(false);
            int ix = this.replacedixlow;
            while (ix <= this.replacedixhi) {
                int iy = this.replacediylow;
                while (iy <= this.replacediyhi) {
                    int i = ix + this.nx * iy;
                    int j = ix - this.replacedixlow + this.rx * (iy - this.replacediylow);
                    int k = 0;
                    while (k < this.rangedim) {
                        samples[k][i] = this.replaced[k][j];
                        ++k;
                    }
                    ++iy;
                }
                ++ix;
            }
            this.replacedff.setSamples(samples, false);
        }
        FlatField ff = null;
        ff = this.t != null ? (FlatField)this.grids.getSample(index) : (FlatField)this.grids;
        float[][] samples = ff.getFloats(false);
        this.replaced = new float[this.rangedim][this.rx * this.ry];
        int ix = this.ixlow;
        while (ix <= this.ixhi) {
            int iy = this.iylow;
            while (iy <= this.iyhi) {
                int i = ix + this.nx * iy;
                int j = ix - this.ixlow + this.rx * (iy - this.iylow);
                int k = 0;
                while (k < this.rangedim) {
                    this.replaced[k][j] = samples[k][i];
                    ++k;
                }
                if (this.blend == 0) {
                    int k2 = 0;
                    while (k2 < this.rangedim) {
                        samples[k2][i] = this.cut[k2][j];
                        ++k2;
                    }
                } else {
                    int d = ix - this.ixlow;
                    if (this.ixhi - ix < d) {
                        d = this.ixhi - ix;
                    }
                    if (iy - this.iylow < d) {
                        d = iy - this.iylow;
                    }
                    if (this.iyhi - iy < d) {
                        d = this.iyhi - iy;
                    }
                    if (d > this.blend) {
                        int k3 = 0;
                        while (k3 < this.rangedim) {
                            samples[k3][i] = this.cut[k3][j];
                            ++k3;
                        }
                    } else {
                        float a = (float)d / (float)this.blend;
                        float b = 1.0f - a;
                        int k4 = 0;
                        while (k4 < this.rangedim) {
                            samples[k4][i] = b * samples[k4][i] + a * this.cut[k4][j];
                            ++k4;
                        }
                    }
                }
                ++iy;
            }
            ++ix;
        }
        ff.setSamples(samples, false);
        this.replacedff = ff;
        this.replacedixlow = this.ixlow;
        this.replacedixhi = this.ixhi;
        this.replacediylow = this.iylow;
        this.replacediyhi = this.iyhi;
    }

    private int getAnimationIndex() throws VisADException {
        int[] indices = new int[]{this.acontrol.getCurrent()};
        Set aset = this.acontrol.getSet();
        double[][] values = aset.indexToDouble(indices);
        int[] tindices = this.tset.doubleToIndex(values);
        return tindices[0];
    }

    private void drag() throws VisADException, RemoteException {
        this.display.disableAction();
        this.ref_xlyl.setData(new RealTuple(this.xy, new double[]{this.xlow, this.ylow}));
        this.ref_xlyh.setData(new RealTuple(this.xy, new double[]{this.xlow, this.yhi}));
        this.ref_xhyl.setData(new RealTuple(this.xy, new double[]{this.xhi, this.ylow}));
        this.ref_xhyh.setData(new RealTuple(this.xy, new double[]{this.xhi, this.yhi}));
        float[][] samples = new float[][]{{(float)this.xlow, (float)this.xlow, (float)this.xhi, (float)this.xhi, (float)this.xlow}, {(float)this.ylow, (float)this.yhi, (float)this.yhi, (float)this.ylow, (float)this.ylow}};
        this.ref_rect.setData(new Gridded2DSet((MathType)this.xy, (float[][])samples, 5));
        this.display.enableAction();
    }

    void drag_release() {
        Object object = this.lock;
        synchronized (object) {
            block7: {
                try {
                    this.replaceRect();
                }
                catch (VisADException e) {
                    if (this.debug) {
                        System.out.println("release fail: " + e.toString());
                    }
                }
                catch (RemoteException e) {
                    if (!this.debug) break block7;
                    System.out.println("release fail: " + e.toString());
                }
            }
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        RealType lat = RealType.Latitude;
        RealType lon = RealType.Longitude;
        RealTupleType xy = new RealTupleType(x, y);
        RealType windx = RealType.getRealType("windx", CommonUnit.meterPerSecond);
        RealType windy = RealType.getRealType("windy", CommonUnit.meterPerSecond);
        RealType red = RealType.getRealType("red");
        RealType green = RealType.getRealType("green");
        EarthVectorType windxy = new EarthVectorType(windx, windy);
        RealType time = RealType.Time;
        double startt = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet time_set = new Linear1DSet((MathType)time, startt, startt + 2700.0, 10);
        Integer2DSet grid_set = new Integer2DSet((MathType)xy, 64, 64);
        RealTupleType tuple_type = new RealTupleType(new RealType[]{lon, lat, windx, windy, red, green});
        FunctionType field_type = new FunctionType(xy, tuple_type);
        FunctionType seq_type = new FunctionType(time, field_type);
        DisplayImplJ3D display1 = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap ymap = new ScalarMap(y, Display.YAxis);
        display1.addMap(ymap);
        ScalarMap xmap = new ScalarMap(x, Display.XAxis);
        display1.addMap(xmap);
        ScalarMap cmap = null;
        cmap = args.length > 0 ? new ScalarMap(windy, Display.RGB) : new ScalarMap(windy, Display.IsoContour);
        display1.addMap(cmap);
        ScalarMap amap = new ScalarMap(time, Display.Animation);
        display1.addMap(amap);
        AnimationControl acontrol = (AnimationControl)((Object)amap.getControl());
        acontrol.setStep(500);
        FieldImpl field = new FieldImpl(seq_type, time_set);
        double[][] values = new double[6][4096];
        int k = 0;
        while (k < 10) {
            FlatField ff = new FlatField(field_type, grid_set);
            int m = 0;
            int i = 0;
            while (i < 64) {
                int j = 0;
                while (j < 64) {
                    double u = 2.0 * (double)i / 63.0 - 1.0;
                    double v = 2.0 * (double)j / 63.0 - 1.0;
                    values[0][m] = 10.0 * u;
                    values[1][m] = 10.0 * v - 40.0;
                    double fx = (double)k + 30.0 * u;
                    double fy = 30.0 * v;
                    double fd = 57.29577951308232 * Math.atan2(-fx, -fy) + (double)k * 15.0;
                    double fs = Math.sqrt(fx * fx + fy * fy);
                    values[2][m] = fd;
                    values[3][m] = fs;
                    values[4][m] = u;
                    values[5][m] = v;
                    ++m;
                    ++j;
                }
                ++i;
            }
            ff.setSamples(values);
            field.setSample(k, (Data)ff);
            ++k;
        }
        DataReferenceImpl seq_ref = new DataReferenceImpl("seq");
        seq_ref.setData(field);
        display1.addReference(seq_ref);
        final CutAndPasteFields cp = new CutAndPasteFields(field, display1);
        final DataReferenceImpl blend_ref = new DataReferenceImpl("blend_ref");
        VisADSlider blend_slider = new VisADSlider("blend", 0, 10, 0, 1.0, blend_ref, RealType.Generic);
        CellImpl blend_cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                int blend = (int)((Real)blend_ref.getData()).getValue();
                cp.setBlend(blend);
            }
        };
        blend_cell.addReference(blend_ref);
        JFrame frame = new JFrame("test CollectiveBarbManipulation");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel1.add(display1.getComponent());
        panel1.setMaximumSize(new Dimension(400, 600));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 0));
        JButton start = new JButton("start");
        start.addActionListener(cp);
        start.setActionCommand("start");
        JButton stop = new JButton("stop");
        stop.addActionListener(cp);
        stop.setActionCommand("stop");
        JButton undo = new JButton("undo");
        undo.addActionListener(cp);
        undo.setActionCommand("undo");
        panel3.add(start);
        panel3.add(stop);
        panel3.add(undo);
        panel2.add(new AnimationWidget(amap));
        if (args.length > 0) {
            LabeledColorWidget lcw = new LabeledColorWidget(cmap);
            lcw.setMaximumSize(new Dimension(400, 200));
            panel2.add(lcw);
        } else {
            ContourWidget cw = new ContourWidget(cmap);
            cw.setMaximumSize(new Dimension(400, 200));
            panel2.add(cw);
        }
        panel2.add(new JLabel(" "));
        panel2.add(blend_slider);
        panel2.add(new JLabel(" "));
        panel2.add(panel3);
        panel2.setMaximumSize(new Dimension(400, 600));
        panel.add(panel1);
        panel.add(panel2);
        frame.getContentPane().add(panel);
        ((Component)frame).setSize(800, 600);
        ((Component)frame).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("start")) {
            try {
                this.start();
            }
            catch (VisADException ex) {
                ex.printStackTrace();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        } else if (cmd.equals("stop")) {
            try {
                this.stop();
            }
            catch (VisADException ex) {
                ex.printStackTrace();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        } else if (cmd.equals("undo")) {
            try {
                this.undo();
            }
            catch (VisADException ex) {
                ex.printStackTrace();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }
}

