/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import visad.AnimationControl;
import visad.VisADException;
import visad.bio.BioAnimWidget;
import visad.bio.BioVisAD;
import visad.bio.ToolPanel;
import visad.browser.Divider;
import visad.util.Util;

public class ViewToolPanel
extends ToolPanel {
    private JCheckBox twoD;
    private JButton zoomIn2;
    private JButton zoomReset2;
    private JButton zoomOut2;
    private JCheckBox threeD;
    private JButton zoomIn3;
    private JButton zoomReset3;
    private JButton zoomOut3;
    private JCheckBox volume;
    private JCheckBox preview;
    private JToggleButton loRes;
    private JToggleButton hiRes;
    private JCheckBox autoSwitch;
    private BioAnimWidget anim;
    private JCheckBox planeSelect;
    private JLabel sliceResLabel1;
    private JLabel sliceResLabel2;
    private JTextField sliceResX;
    private JTextField sliceResY;
    private JCheckBox sliceUpdate;

    public ViewToolPanel(BioVisAD biovis) {
        super(biovis);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.twoD = new JCheckBox("2-D", true);
        this.twoD.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.twoD.isSelected();
                ViewToolPanel.this.bio.set2D(b);
                ViewToolPanel.this.zoomIn2.setEnabled(b);
                ViewToolPanel.this.zoomReset2.setEnabled(b);
                ViewToolPanel.this.zoomOut2.setEnabled(b);
            }
        });
        p.add(this.twoD);
        this.zoomIn2 = new JButton("Zoom in");
        this.zoomIn2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(false, 1.5);
            }
        });
        p.add(this.zoomIn2);
        this.zoomReset2 = new JButton("Reset");
        this.zoomReset2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.resetZoom(false);
            }
        });
        p.add(this.zoomReset2);
        this.zoomOut2 = new JButton("Zoom out");
        this.zoomOut2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(false, 0.667);
            }
        });
        p.add(this.zoomOut2);
        this.controls.add(ToolPanel.pad(p));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        boolean okay3d = this.bio.display3 != null;
        this.threeD = new JCheckBox("3-D", okay3d);
        this.threeD.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.threeD.isSelected();
                ViewToolPanel.this.bio.set3D(b);
                ViewToolPanel.this.zoomIn3.setEnabled(b);
                ViewToolPanel.this.zoomReset3.setEnabled(b);
                ViewToolPanel.this.zoomOut3.setEnabled(b);
                ViewToolPanel.this.volume.setEnabled(b);
            }
        });
        this.threeD.setEnabled(okay3d);
        p.add(this.threeD);
        this.zoomIn3 = new JButton("Zoom in");
        this.zoomIn3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(true, 2.0);
            }
        });
        this.zoomIn3.setEnabled(okay3d);
        p.add(this.zoomIn3);
        this.zoomReset3 = new JButton("Reset");
        this.zoomReset3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.resetZoom(true);
            }
        });
        this.zoomReset3.setEnabled(okay3d);
        p.add(this.zoomReset3);
        this.zoomOut3 = new JButton("Zoom out");
        this.zoomOut3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(true, 0.5);
            }
        });
        this.zoomOut3.setEnabled(okay3d);
        p.add(this.zoomOut3);
        this.controls.add(ToolPanel.pad(p));
        this.volume = new JCheckBox("Render 3-D image stack as a volume", false);
        this.volume.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.volume.isSelected();
                ViewToolPanel.this.bio.setVolume(b);
            }
        });
        this.volume.setEnabled(okay3d);
        this.controls.add(ToolPanel.pad(this.volume));
        this.preview = new JCheckBox("Previous/next preview displays", false);
        this.preview.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.preview.isSelected();
                ViewToolPanel.this.bio.setPreview(b);
            }
        });
        this.preview.setEnabled(okay3d);
        this.controls.add(ToolPanel.pad(this.preview));
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.loRes = new JToggleButton("Lo-res", false);
        this.loRes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.sm.setMode(true);
            }
        });
        this.loRes.setEnabled(false);
        p.add(this.loRes);
        this.hiRes = new JToggleButton("Hi-res", true);
        this.hiRes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationControl control = ViewToolPanel.this.anim.getControl();
                try {
                    if (control != null) {
                        control.setOn(false);
                    }
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    exc.printStackTrace();
                }
                ViewToolPanel.this.bio.sm.setMode(false);
            }
        });
        this.hiRes.setEnabled(false);
        p.add(this.hiRes);
        this.controls.add(ToolPanel.pad(p));
        this.autoSwitch = new JCheckBox("Auto-switch resolutions", true);
        this.autoSwitch.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ViewToolPanel.this.bio.sm.setAutoSwitch(ViewToolPanel.this.autoSwitch.isSelected());
            }
        });
        this.autoSwitch.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.autoSwitch));
        this.controls.add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.anim = new BioAnimWidget(this.bio);
        this.anim.setEnabled(false);
        p.add(this.anim);
        this.controls.add(ToolPanel.pad(p));
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.planeSelect = new JCheckBox("Arbitrary data slice", false);
        this.planeSelect.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean ps = ViewToolPanel.this.planeSelect.isSelected();
                ViewToolPanel.this.sliceResLabel1.setEnabled(ps);
                ViewToolPanel.this.sliceResX.setEnabled(ps);
                ViewToolPanel.this.sliceResLabel2.setEnabled(ps);
                ViewToolPanel.this.sliceResY.setEnabled(ps);
                ViewToolPanel.this.sliceUpdate.setEnabled(ps);
                ViewToolPanel.this.bio.sm.setPlaneSelect(ps);
                ViewToolPanel.this.bio.vert.setEnabled(!ps);
                ViewToolPanel.this.bio.toolMeasure.setEnabled(!ps);
                ViewToolPanel.this.bio.mm.pool2.setSlice(ps ? -1 : ViewToolPanel.this.bio.sm.getSlice());
            }
        });
        this.planeSelect.setEnabled(false);
        p.add(this.planeSelect);
        this.sliceUpdate = new JCheckBox("Update continuously", false);
        this.sliceUpdate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ViewToolPanel.this.bio.sm.setPlaneContinuous(ViewToolPanel.this.sliceUpdate.isSelected());
            }
        });
        this.sliceUpdate.setEnabled(false);
        p.add(Box.createHorizontalStrut(10));
        p.add(this.sliceUpdate);
        this.controls.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.sliceResLabel1 = new JLabel("Slice resolution: ");
        this.sliceResX = new JTextField();
        this.sliceResLabel2 = new JLabel(" by ");
        this.sliceResY = new JTextField();
        DocumentListener doc = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void update(DocumentEvent e) {
                String sx = ViewToolPanel.this.sliceResX.getText();
                String sy = ViewToolPanel.this.sliceResY.getText();
                try {
                    int resx = Integer.parseInt(sx);
                    int resy = Integer.parseInt(sy);
                    ViewToolPanel.this.bio.sm.setSliceRange(resx, resy);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
            }
        };
        Util.adjustTextField(this.sliceResX);
        Util.adjustTextField(this.sliceResY);
        this.sliceResX.getDocument().addDocumentListener(doc);
        this.sliceResY.getDocument().addDocumentListener(doc);
        this.sliceResLabel1.setForeground(Color.black);
        this.sliceResLabel2.setForeground(Color.black);
        this.sliceResLabel1.setEnabled(false);
        this.sliceResLabel2.setEnabled(false);
        this.sliceResX.setEnabled(false);
        this.sliceResY.setEnabled(false);
        p.add(this.sliceResLabel1);
        p.add(this.sliceResX);
        p.add(this.sliceResLabel2);
        p.add(this.sliceResY);
        this.controls.add(p);
    }

    public void setEnabled(boolean enabled) {
        boolean b = enabled && this.bio.sm.hasThumbnails();
        this.loRes.setEnabled(b);
        this.hiRes.setEnabled(b);
        this.autoSwitch.setEnabled(b);
        this.anim.setEnabled(b);
        this.planeSelect.setEnabled(enabled && this.bio.sm.getNumberOfSlices() > 1);
        b = enabled && this.planeSelect.isSelected();
        this.sliceResLabel1.setEnabled(b);
        this.sliceResX.setEnabled(b);
        this.sliceResLabel2.setEnabled(b);
        this.sliceResY.setEnabled(b);
    }

    public void setMode(boolean lowres) {
        this.loRes.setSelected(lowres);
        this.hiRes.setSelected(!lowres);
    }

    void setControl(AnimationControl control) {
        this.anim.setControl(control);
    }

    void setSliceRange(int x, int y) {
        this.sliceResX.setText("" + x);
        this.sliceResY.setText("" + y);
    }
}

