/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import visad.VisADException;
import visad.bio.ToolPanel;
import visad.util.Util;

public class ProgressDialog
extends JDialog {
    private static final int MINIMUM_WIDTH = 300;
    private JProgressBar bar;
    private JLabel label;
    private VisADException exc;

    public ProgressDialog(Frame owner, String info) {
        super(owner, "Please wait...", true);
        this.doGUI(info);
    }

    public ProgressDialog(Dialog owner, String info) {
        super(owner, "Please wait...", true);
        this.doGUI(info);
    }

    private void doGUI(String info) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        this.setContentPane(pane);
        this.label = new JLabel(info + "...");
        pane.add(ToolPanel.pad(this.label));
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.bar.setString("0%");
        pane.add(this.bar);
        this.pack();
        this.setResizable(false);
        Util.centerWindow(this);
    }

    public void setVisible(boolean visible) {
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width > 300 ? d.width : 300, d.height);
    }

    public void setPercent(int value) {
        this.bar.setString(value + "%");
        this.bar.setValue(value);
    }

    public void setText(String info) {
        this.label.setText(info + "...");
    }

    public void setException(VisADException exc) {
        this.exc = exc;
    }

    public void checkException() throws VisADException {
        if (this.exc != null) {
            throw this.exc;
        }
    }

    public void kill() {
        super.setVisible(false);
    }

    public static void main(String[] args) throws Exception {
        final ProgressDialog dialog = new ProgressDialog((Frame)null, "Testing ProgressDialog");
        Thread t = new Thread(new Runnable(){

            public void run() {
                int percent = 0;
                while (percent <= 100) {
                    try {
                        Thread.sleep((int)(Math.random() * 200.0));
                    }
                    catch (InterruptedException exc) {
                        exc.printStackTrace();
                    }
                    dialog.setPercent(++percent);
                    if (percent != 90) continue;
                    dialog.setText("Almost done");
                }
                dialog.kill();
            }
        });
        t.start();
        dialog.show();
        dialog.checkException();
        System.exit(0);
    }
}

