/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRenderer;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.VisADException;
import visad.bio.PlaneListener;
import visad.data.visad.VisADForm;
import visad.java3d.DirectManipulationRendererJ3D;

public class PlaneSelector
implements DisplayListener {
    protected static final double EPS = 1.0E-10;
    protected DisplayImpl display;
    protected DataReferenceImpl[] refs = new DataReferenceImpl[5];
    protected DataRenderer[] renderers = new DataRenderer[5];
    protected CellImpl cell;
    protected RealType xtype;
    protected RealType ytype;
    protected RealType ztype;
    protected float lox;
    protected float loy;
    protected float loz;
    protected float hix;
    protected float hiy;
    protected float hiz;
    protected boolean snap;
    protected boolean visible;
    protected boolean endpointMode;
    protected double[][][] pos;
    protected int numIndices;
    protected int index;
    protected Gridded3DSet lines;
    protected Vector listeners = new Vector();
    private int mx;
    private int my;
    private boolean m_ctrl;

    public PlaneSelector(DisplayImpl display) {
        this.display = display;
        this.cell = new CellImpl(){

            public void doAction() {
                int len = PlaneSelector.this.refs.length - 2;
                RealTuple[] tuple = new RealTuple[len];
                int i = 0;
                while (i < len) {
                    tuple[i] = (RealTuple)PlaneSelector.this.refs[i + 2].getData();
                    if (tuple[i] == null) {
                        if (PlaneSelector.this.xtype == null) {
                            return;
                        }
                        double vx = i < 2 ? (double)PlaneSelector.this.lox : (double)PlaneSelector.this.hix;
                        double vy = i < 2 ? (double)PlaneSelector.this.loy : (double)PlaneSelector.this.hiy;
                        double vz = i == 0 ? (double)PlaneSelector.this.loz : (double)PlaneSelector.this.hiz;
                        PlaneSelector.this.setData(i, vx, vy, vz);
                        return;
                    }
                    ++i;
                }
                int vcount = 0;
                PlaneSelector.this.lines = null;
                float[][] samples = null;
                RealTupleType type = (RealTupleType)tuple[0].getType();
                if (PlaneSelector.this.snap) {
                    double[] x = new double[len];
                    double[] y = new double[len];
                    double[] z = new double[len];
                    int i2 = 0;
                    while (i2 < len) {
                        boolean zm;
                        boolean cz2;
                        double[] values = tuple[i2].getValues();
                        double vx = values[0];
                        double vy = values[1];
                        double vz = values[2];
                        boolean cx1 = vx < (double)PlaneSelector.this.lox;
                        boolean cx2 = vx > (double)PlaneSelector.this.hix;
                        boolean cy1 = vy < (double)PlaneSelector.this.loy;
                        boolean cy2 = vy > (double)PlaneSelector.this.hiy;
                        boolean cz1 = vz < (double)PlaneSelector.this.loz;
                        boolean bl = cz2 = vz > (double)PlaneSelector.this.hiz;
                        if (cx1) {
                            vx = PlaneSelector.this.lox;
                        } else if (cx2) {
                            vx = PlaneSelector.this.hix;
                        }
                        if (cy1) {
                            vy = PlaneSelector.this.loy;
                        } else if (cy2) {
                            vy = PlaneSelector.this.hiy;
                        }
                        if (cz1) {
                            vz = PlaneSelector.this.loz;
                        } else if (cz2) {
                            vz = PlaneSelector.this.hiz;
                        }
                        boolean changed = cx1 || cx2 || cy1 || cy2 || cz1 || cz2;
                        double rx = Math.abs(PlaneSelector.this.hix - PlaneSelector.this.lox);
                        double ry = Math.abs(PlaneSelector.this.hiy - PlaneSelector.this.loy);
                        double rz = Math.abs(PlaneSelector.this.hiz - PlaneSelector.this.loz);
                        double dx1 = Math.abs(vx - (double)PlaneSelector.this.lox) / rx;
                        double dx2 = Math.abs(vx - (double)PlaneSelector.this.hix) / rx;
                        double dy1 = Math.abs(vy - (double)PlaneSelector.this.loy) / ry;
                        double dy2 = Math.abs(vy - (double)PlaneSelector.this.hiy) / ry;
                        double dz1 = Math.abs(vz - (double)PlaneSelector.this.loz) / rz;
                        double dz2 = Math.abs(vz - (double)PlaneSelector.this.hiz) / rz;
                        boolean xm = dx1 == 0.0 || dx2 == 0.0;
                        boolean ym = dy1 == 0.0 || dy2 == 0.0;
                        boolean bl2 = zm = dz1 == 0.0 || dz2 == 0.0;
                        if (!xm && !ym || !xm && !zm || !ym && !zm) {
                            boolean snapz;
                            boolean axisx = dx1 < dx2;
                            boolean axisy = dy1 < dy2;
                            boolean axisz = dz1 < dz2;
                            double distx = axisx ? dx1 : dx2;
                            double disty = axisy ? dy1 : dy2;
                            double distz = axisz ? dz1 : dz2;
                            boolean snapx = distx <= distz || distx <= disty;
                            boolean snapy = disty <= distx || disty <= distz;
                            boolean bl3 = snapz = !snapx || !snapy;
                            if (snapx) {
                                double d = vx = axisx ? (double)PlaneSelector.this.lox : (double)PlaneSelector.this.hix;
                            }
                            if (snapy) {
                                double d = vy = axisy ? (double)PlaneSelector.this.loy : (double)PlaneSelector.this.hiy;
                            }
                            if (snapz) {
                                vz = axisz ? (double)PlaneSelector.this.loz : (double)PlaneSelector.this.hiz;
                            }
                            changed = true;
                        }
                        if (changed) {
                            PlaneSelector.this.setData(i2, vx, vy, vz);
                            return;
                        }
                        x[i2] = vx;
                        y[i2] = vy;
                        z[i2] = vz;
                        ++i2;
                    }
                    double NaN = Double.NaN;
                    double[][] p = new double[][]{{NaN, PlaneSelector.this.lox, PlaneSelector.this.lox, PlaneSelector.this.lox, PlaneSelector.this.lox, NaN, PlaneSelector.this.hix, NaN, PlaneSelector.this.hix, NaN, PlaneSelector.this.hix, PlaneSelector.this.hix}, {PlaneSelector.this.loy, NaN, PlaneSelector.this.loy, NaN, PlaneSelector.this.hiy, PlaneSelector.this.hiy, PlaneSelector.this.hiy, PlaneSelector.this.hiy, NaN, PlaneSelector.this.loy, PlaneSelector.this.loy, NaN}, {PlaneSelector.this.loz, PlaneSelector.this.loz, NaN, PlaneSelector.this.hiz, NaN, PlaneSelector.this.loz, NaN, PlaneSelector.this.hiz, PlaneSelector.this.hiz, PlaneSelector.this.hiz, NaN, PlaneSelector.this.loz}};
                    boolean[] valid = new boolean[12];
                    int i3 = 0;
                    while (i3 < 12) {
                        double t;
                        double s;
                        double px0 = p[0][i3] - x[0];
                        double py0 = p[1][i3] - y[0];
                        double pz0 = p[2][i3] - z[0];
                        double x10 = x[1] - x[0];
                        double y10 = y[1] - y[0];
                        double z10 = z[1] - z[0];
                        double x20 = x[2] - x[0];
                        double y20 = y[2] - y[0];
                        double z20 = z[2] - z[0];
                        if (px0 != px0) {
                            s = (y20 * pz0 - z20 * py0) / (y20 * z10 - z20 * y10);
                            t = y20 == 0.0 ? (pz0 - s * z10) / z20 : (py0 - s * y10) / y20;
                            p[0][i3] = x[0] + s * x10 + t * x20;
                            valid[i3] = p[0][i3] >= (double)PlaneSelector.this.lox && p[0][i3] <= (double)PlaneSelector.this.hix;
                        } else if (py0 != py0) {
                            s = (z20 * px0 - x20 * pz0) / (z20 * x10 - x20 * z10);
                            t = z20 == 0.0 ? (px0 - s * x10) / x20 : (pz0 - s * z10) / z20;
                            p[1][i3] = y[0] + s * y10 + t * y20;
                            valid[i3] = p[1][i3] >= (double)PlaneSelector.this.loy && p[1][i3] <= (double)PlaneSelector.this.hiy;
                        } else {
                            s = (x20 * py0 - y20 * px0) / (x20 * y10 - y20 * x10);
                            t = x20 == 0.0 ? (py0 - s * y10) / y20 : (px0 - s * x10) / x20;
                            p[2][i3] = z[0] + s * z10 + t * z20;
                            boolean bl = valid[i3] = p[2][i3] >= (double)PlaneSelector.this.loz && p[2][i3] <= (double)PlaneSelector.this.hiz;
                        }
                        if (valid[i3]) {
                            int j = 0;
                            while (j < i3) {
                                if (valid[j] && Math.abs(p[0][i3] - p[0][j]) < 1.0E-10 && Math.abs(p[1][i3] - p[1][j]) < 1.0E-10 && Math.abs(p[2][i3] - p[2][j]) < 1.0E-10) {
                                    valid[i3] = false;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (valid[i3]) {
                            ++vcount;
                        }
                        ++i3;
                    }
                    if (vcount > 0) {
                        try {
                            float[] ux = new float[vcount];
                            float[] uy = new float[vcount];
                            float[] uz = new float[vcount];
                            int i4 = 0;
                            int c = 0;
                            while (i4 < 12) {
                                if (valid[i4]) {
                                    ux[c] = (float)p[0][i4];
                                    uy[c] = (float)p[1][i4];
                                    uz[c] = (float)p[2][i4];
                                    ++c;
                                }
                                ++i4;
                            }
                            boolean[] hull = new boolean[vcount];
                            samples = new float[3][vcount + 1];
                            samples[0][0] = ux[0];
                            samples[1][0] = uy[0];
                            samples[2][0] = uz[0];
                            hull[0] = true;
                            int i5 = 1;
                            while (i5 < vcount) {
                                double sx = samples[0][i5 - 1];
                                double sy = samples[1][i5 - 1];
                                double sz = samples[2][i5 - 1];
                                boolean xok = sx == (double)PlaneSelector.this.lox || sx == (double)PlaneSelector.this.hix;
                                boolean yok = sy == (double)PlaneSelector.this.loy || sy == (double)PlaneSelector.this.hiy;
                                boolean zok = sz == (double)PlaneSelector.this.loz || sz == (double)PlaneSelector.this.hiz;
                                int j = 1;
                                while (j < vcount) {
                                    if (!hull[j] && (xok && sx == (double)ux[j] || yok && sy == (double)uy[j] || zok && sz == (double)uz[j])) {
                                        samples[0][i5] = ux[j];
                                        samples[1][i5] = uy[j];
                                        samples[2][i5] = uz[j];
                                        hull[j] = true;
                                        break;
                                    }
                                    ++j;
                                }
                                ++i5;
                            }
                            samples[0][vcount] = samples[0][0];
                            samples[1][vcount] = samples[1][0];
                            samples[2][vcount] = samples[2][0];
                            PlaneSelector.this.lines = new Gridded3DSet((MathType)type, samples, vcount + 1, null, null, null, false);
                        }
                        catch (VisADException exc) {
                            exc.printStackTrace();
                        }
                    }
                } else {
                    vcount = 3;
                    samples = new float[3][vcount + 1];
                    double[] values = tuple[0].getValues();
                    int j = 0;
                    while (j < 3) {
                        float f = (float)values[j];
                        samples[j][vcount] = f;
                        samples[j][0] = f;
                        PlaneSelector.this.pos[PlaneSelector.this.index][0][j] = values[j];
                        ++j;
                    }
                    int i6 = 1;
                    while (i6 < len) {
                        values = tuple[i6].getValues();
                        int j2 = 0;
                        while (j2 < 3) {
                            samples[j2][i6] = (float)values[j2];
                            PlaneSelector.this.pos[PlaneSelector.this.index][i6][j2] = values[j2];
                            ++j2;
                        }
                        ++i6;
                    }
                    if (PlaneSelector.this.endpointMode) {
                        int ndx = 0;
                        while (ndx < PlaneSelector.this.numIndices) {
                            if (ndx != PlaneSelector.this.index) {
                                int i7 = 0;
                                while (i7 < 3) {
                                    int j3 = 0;
                                    while (j3 < 3) {
                                        PlaneSelector.this.pos[ndx][i7][j3] = PlaneSelector.this.pos[PlaneSelector.this.index][i7][j3];
                                        ++j3;
                                    }
                                    ++i7;
                                }
                            }
                            ++ndx;
                        }
                    }
                    try {
                        PlaneSelector.this.lines = new Gridded3DSet((MathType)type, samples, vcount + 1, null, null, null, false);
                    }
                    catch (VisADException exc) {
                        exc.printStackTrace();
                    }
                }
                Gridded3DSet plane = null;
                try {
                    if (vcount == 3) {
                        float[][] samps = new float[3][4];
                        int i8 = 0;
                        while (i8 < 3) {
                            samps[i8][0] = samples[i8][0];
                            samps[i8][1] = (samples[i8][0] + samples[i8][1]) / 2.0f;
                            samps[i8][2] = samples[i8][2];
                            samps[i8][3] = samples[i8][1];
                            ++i8;
                        }
                        plane = new Gridded3DSet((MathType)type, samps, 2, 2, null, null, null, false);
                    } else if (vcount == 4) {
                        float[][] samps = new float[3][4];
                        int i9 = 0;
                        while (i9 < 3) {
                            samps[i9][0] = samples[i9][0];
                            samps[i9][1] = samples[i9][1];
                            samps[i9][2] = samples[i9][3];
                            samps[i9][3] = samples[i9][2];
                            ++i9;
                        }
                        plane = new Gridded3DSet((MathType)type, samps, 2, 2, null, null, null, false);
                    } else if (vcount == 5) {
                        float[][] samps = new float[3][6];
                        int i10 = 0;
                        while (i10 < 3) {
                            samps[i10][0] = samples[i10][0];
                            samps[i10][1] = samples[i10][1];
                            samps[i10][2] = samples[i10][4];
                            samps[i10][3] = (samples[i10][1] + samples[i10][2]) / 2.0f;
                            samps[i10][4] = samples[i10][3];
                            samps[i10][5] = samples[i10][2];
                            ++i10;
                        }
                        plane = new Gridded3DSet((MathType)type, samps, 2, 3, null, null, null, false);
                    } else if (vcount == 6) {
                        float[][] samps = new float[3][6];
                        int i11 = 0;
                        while (i11 < 3) {
                            samps[i11][0] = samples[i11][0];
                            samps[i11][1] = samples[i11][1];
                            samps[i11][2] = samples[i11][5];
                            samps[i11][3] = samples[i11][2];
                            samps[i11][4] = samples[i11][4];
                            samps[i11][5] = samples[i11][3];
                            ++i11;
                        }
                        plane = new Gridded3DSet((MathType)type, samps, 2, 3, null, null, null, false);
                    }
                    PlaneSelector.this.refs[0].setData(PlaneSelector.this.lines);
                    PlaneSelector.this.refs[1].setData(plane);
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    exc.printStackTrace();
                }
                PlaneSelector.this.notifyListeners();
            }
        };
        this.cell.disableAction();
        try {
            int i = 0;
            while (i < this.refs.length) {
                if (i > 1) {
                    this.refs[i] = new DataReferenceImpl("bio_plane" + i);
                    this.cell.addReference(this.refs[i]);
                } else {
                    this.refs[i] = new DataReferenceImpl(i == 0 ? "bio_edges" : "bio_plane");
                }
                ++i;
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        this.cell.enableAction();
    }

    public void toggle(boolean visible) {
        this.visible = visible;
        int i = 0;
        while (i < 2) {
            this.renderers[i].toggle(visible);
            ++i;
        }
        int i2 = 2;
        while (i2 < this.renderers.length) {
            this.renderers[i2].toggle(visible && this.endpointMode);
            ++i2;
        }
    }

    public void init(RealType xtype, RealType ytype, RealType ztype, int numTime, float lox, float loy, float loz, float hix, float hiy, float hiz) throws VisADException, RemoteException {
        this.xtype = xtype;
        this.ytype = ytype;
        this.ztype = ztype;
        this.snap = lox == lox;
        this.visible = false;
        this.endpointMode = true;
        this.numIndices = numTime;
        this.pos = new double[this.numIndices][3][3];
        if (this.snap) {
            this.lox = lox;
            this.loy = loy;
            this.loz = loz;
            this.hix = hix;
            this.hiy = hiy;
            this.hiz = hiz;
            this.index = -1;
        } else {
            this.loz = 0.0f;
            this.loy = 0.0f;
            this.lox = 0.0f;
            this.hiz = 1.0f;
            this.hiy = 1.0f;
            this.hix = 1.0f;
            this.index = 0;
        }
        DisplayRenderer displayRenderer = this.display.getDisplayRenderer();
        int i = 0;
        while (i < this.refs.length) {
            ConstantMap[] maps;
            if (i == 0) {
                this.renderers[i] = displayRenderer.makeDefaultRenderer();
                maps = this.snap ? new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue), new ConstantMap(3.0, Display.LineWidth)} : new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(3.0, Display.LineWidth)};
            } else if (i == 1) {
                this.renderers[i] = displayRenderer.makeDefaultRenderer();
                maps = this.snap ? new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue), new ConstantMap(0.75, Display.Alpha)} : new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(0.75, Display.Alpha)};
            } else {
                this.renderers[i] = new DirectManipulationRendererJ3D();
                this.renderers[i].setPickCrawlToCursor(false);
                maps = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(6.0, Display.PointSize)};
            }
            this.renderers[i].suppressExceptions(true);
            this.renderers[i].toggle(false);
            this.display.addReferences(this.renderers[i], this.refs[i], maps);
            ++i;
        }
    }

    public Field extractSlice(FieldImpl field, int resx, int resy, int hix, int hiy) throws VisADException, RemoteException {
        if (this.lines == null) {
            return null;
        }
        float[][] samples = this.lines.getSamples(false);
        float[] x = samples[0];
        float[] y = samples[1];
        float[] z = samples[2];
        int numpts = x.length - 1;
        double longest = 0.0;
        int index = -1;
        int i = 0;
        while (i < numpts) {
            float dx = x[i] - x[i + 1];
            float dy = y[i] - y[i + 1];
            float dz = z[i] - z[i + 1];
            double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (len > longest) {
                longest = len;
                index = i;
            }
            ++i;
        }
        int p1 = index;
        int p2 = (index + 1) % numpts;
        int p = 0;
        while (p == p1 || p == p2) {
            ++p;
        }
        float[] c1 = new float[3];
        float[] c2 = new float[3];
        float[] proj = new float[3];
        PlaneSelector.project(x, y, z, x[p1], y[p1], z[p1], x[p2], y[p2], z[p2], p, c1, c2, proj);
        float[] c3 = new float[3];
        float[] l = PlaneSelector.corner(proj, c1, new float[]{x[p], y[p], z[p]});
        PlaneSelector.project(x, y, z, c1[0], c1[1], c1[2], l[0], l[1], l[2], -1, c1, c3, proj);
        float[] c4 = PlaneSelector.corner(c1, c2, c3);
        SetType type3 = (SetType)this.lines.getType();
        float[][] samp3 = new float[][]{{c1[0], c2[0], c3[0], c4[0]}, {c1[1], c2[1], c3[1], c4[1]}, {c1[2], c2[2], c3[2], c4[2]}};
        Gridded3DSet box3 = new Gridded3DSet((MathType)type3, (float[][])samp3, 2, 2, null, null, null, false);
        int rx = resx - 1;
        int ry = resy - 1;
        int len = resx * resy;
        float[][] grid = new float[2][len];
        int j = 0;
        while (j < resy) {
            int i2 = 0;
            while (i2 < resx) {
                index = j * resx + i2;
                grid[0][index] = (float)i2 / (float)rx;
                grid[1][index] = (float)j / (float)ry;
                ++i2;
            }
            ++j;
        }
        Gridded3DSet set3 = new Gridded3DSet((MathType)type3, box3.gridToValue(grid), resx, resy, null, null, null, false);
        FieldImpl slice3 = (FieldImpl)field.resample(set3, 101, 202);
        RealType[] rt = type3.getDomain().getRealComponents();
        RealTupleType type2 = new RealTupleType(new RealType[]{rt[0], rt[1]});
        float[][] samp2 = new float[2][resx * resy];
        int j2 = 0;
        while (j2 < resy) {
            int i3 = 0;
            while (i3 < resx) {
                index = resx * j2 + i3;
                samp2[0][index] = (float)hix * (float)i3 / (float)resx;
                samp2[1][index] = (float)hiy * (float)j2 / (float)resy;
                ++i3;
            }
            ++j2;
        }
        Gridded2DSet set2 = new Gridded2DSet(type2, samp2, resx, resy, null, null, null, false);
        FunctionType ftype3 = (FunctionType)slice3.getType();
        FunctionType ftype2 = new FunctionType(type2, ftype3.getRange());
        FlatField slice2 = new FlatField(ftype2, set2);
        slice2.setSamples(slice3.getValues(false), false);
        return slice2;
    }

    public void addListener(PlaneListener l) {
        this.listeners.add(l);
    }

    public void removeListener(PlaneListener l) {
        this.listeners.remove(l);
    }

    public void setMode(boolean endpoints) {
        if (this.endpointMode == endpoints) {
            return;
        }
        this.endpointMode = endpoints;
        if (this.endpointMode) {
            this.display.removeDisplayListener(this);
        } else {
            this.display.addDisplayListener(this);
        }
        this.toggle(this.visible);
    }

    public void setIndex(int index) {
        if (this.index == index) {
            return;
        }
        this.index = index;
        int i = 0;
        while (i < 3) {
            this.setData(i, this.pos[index][i][0], this.pos[index][i][1], this.pos[index][i][2]);
            ++i;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void displayChanged(DisplayEvent e) {
        boolean ctrl;
        int id = e.getId();
        InputEvent event = e.getInputEvent();
        if (event == null || !(event instanceof MouseEvent)) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int mods = e.getModifiers();
        boolean right = (mods & 4) != 0;
        boolean bl = ctrl = (mods & 2) != 0;
        if (!right) {
            return;
        }
        if (id == 1) {
            this.mx = x;
            this.my = y;
            this.m_ctrl = ctrl;
        } else if (id != 18 || this.m_ctrl) {
            // empty if block
        }
    }

    void saveState(PrintWriter fout) throws IOException, VisADException {
        int i = 2;
        while (i < this.refs.length) {
            Real[] realArray;
            RealTuple tuple = (RealTuple)this.refs[i].getData();
            if (tuple == null) {
                Real[] realArray2 = new Real[3];
                realArray2[0] = null;
                realArray2[1] = null;
                realArray = realArray2;
                realArray2[2] = null;
            } else {
                realArray = tuple.getRealComponents();
            }
            Real[] r = realArray;
            int j = 0;
            while (j < 3) {
                double value = r[j] == null ? Double.NaN : r[j].getValue();
                fout.println(value);
                ++j;
            }
            ++i;
        }
    }

    void restoreState(BufferedReader fin) throws IOException, VisADException {
        int i = 0;
        while (i < this.refs.length - 2) {
            try {
                double x = Double.parseDouble(fin.readLine().trim());
                double y = Double.parseDouble(fin.readLine().trim());
                double z = Double.parseDouble(fin.readLine().trim());
                this.setData(i, x, y, z);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    protected void setData(int i, double x, double y, double z) {
        try {
            this.refs[i + 2].setData(new RealTuple(new Real[]{new Real(this.xtype, x), new Real(this.ytype, y), new Real(this.ztype, z)}));
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    protected void notifyListeners() {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            PlaneListener l = (PlaneListener)this.listeners.elementAt(i);
            l.planeChanged();
            ++i;
        }
    }

    protected static void project(float[] x, float[] y, float[] z, float p1x, float p1y, float p1z, float p2x, float p2y, float p2z, int p, float[] min, float[] max, float[] proj) {
        int numpts = x.length - 1;
        float x21 = p2x - p1x;
        float y21 = p2y - p1y;
        float z21 = p2z - p1z;
        float maxdist = x21 * x21 + y21 * y21 + z21 * z21;
        min[0] = p1x;
        min[1] = p1y;
        min[2] = p1z;
        max[0] = p2x;
        max[1] = p2y;
        max[2] = p2z;
        int p3 = 0;
        while (p3 < numpts) {
            float x31 = x[p3] - p1x;
            float y31 = y[p3] - p1y;
            float z31 = z[p3] - p1z;
            float u = (x31 * x21 + y31 * y21 + z31 * z21) / (x21 * x21 + y21 * y21 + z21 * z21);
            float px = p1x + u * x21;
            float py = p1y + u * y21;
            float pz = p1z + u * z21;
            if (p3 == p) {
                proj[0] = px;
                proj[1] = py;
                proj[2] = pz;
            }
            float pminx = px - min[0];
            float pminy = py - min[1];
            float pminz = pz - min[2];
            float pdistmin = pminx * pminx + pminy * pminy + pminz * pminz;
            float pmaxx = px - max[0];
            float pmaxy = py - max[1];
            float pmaxz = pz - max[2];
            float pdistmax = pmaxx * pmaxx + pmaxy * pmaxy + pmaxz * pmaxz;
            if (pdistmin > maxdist || pdistmax > maxdist) {
                if (pdistmin > pdistmax) {
                    maxdist = pdistmin;
                    max[0] = px;
                    max[1] = py;
                    max[2] = pz;
                } else {
                    maxdist = pdistmax;
                    min[0] = px;
                    min[1] = py;
                    min[2] = pz;
                }
            }
            ++p3;
        }
    }

    private static float[] corner(float[] c1, float[] c2, float[] c3) {
        float[] c4 = new float[c1.length];
        int i = 0;
        while (i < c1.length) {
            c4[i] = c3[i] + c2[i] - c1[i];
            ++i;
        }
        return c4;
    }

    protected static void save(String file, DataImpl data) {
        System.err.print("Saving " + file + "... ");
        File f = new File(file);
        if (f.exists()) {
            f.delete();
        }
        VisADForm saver = new VisADForm(true);
        try {
            saver.save(file, data, false);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.err.println("done.");
    }
}

