/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.util.Vector;
import visad.bio.BioVisAD;
import visad.bio.MeasureGroup;
import visad.bio.MeasureLine;
import visad.bio.MeasureThing;
import visad.bio.PoolPoint;

public class MeasurePoint
extends MeasureThing {
    double x;
    double y;
    double z;
    Color preferredColor;
    int selected;
    Vector lines;
    PoolPoint[] pt;

    public MeasurePoint(double x, double y, double z) {
        this(x, y, z, Color.white, BioVisAD.noneGroup);
    }

    public MeasurePoint(double x, double y, double z, Color color, MeasureGroup group) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.preferredColor = color;
        this.color = color;
        this.group = group;
        this.lines = new Vector();
        this.pt = new PoolPoint[2];
    }

    public MeasurePoint(MeasurePoint point, double z) {
        this.x = point.x;
        this.y = point.y;
        this.z = z;
        this.preferredColor = point.preferredColor;
        this.color = point.color;
        this.group = point.group;
        this.lines = new Vector();
        this.pt = new PoolPoint[2];
        this.stdId = point.stdId;
    }

    public void setColor(Color color) {
        this.preferredColor = color;
        this.refreshColor();
    }

    public void setStdId(int stdId) {
        this.stdId = stdId;
    }

    public void setCoordinates(PoolPoint p, double x, double y, double z) {
        if (this.x == x && this.y == y && this.z == z) {
            return;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        int i = 0;
        while (i < this.pt.length) {
            if (this.pt[i] != null && this.pt[i] != p) {
                this.pt[i].refresh();
            }
            ++i;
        }
    }

    public void refreshColor() {
        if (this.lines.isEmpty()) {
            this.color = this.preferredColor;
        } else {
            int size = this.lines.size();
            Color c = ((MeasureLine)this.lines.elementAt((int)0)).color;
            int i = 1;
            while (i < size) {
                MeasureLine line = (MeasureLine)this.lines.elementAt(i);
                if (line.color != c) {
                    this.color = Color.white;
                    return;
                }
                ++i;
            }
            this.color = c;
        }
    }
}

