/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import visad.VisADException;
import visad.bio.BioVisAD;
import visad.bio.MeasureDataFile;
import visad.bio.MeasureList;
import visad.bio.MeasurePool;
import visad.util.Util;

public class MeasureManager {
    MeasureList[] lists;
    MeasurePool pool2;
    MeasurePool pool3;
    int maxId = 0;
    Vector groups = new Vector();
    boolean changed = false;
    private BioVisAD bio;
    private JFileChooser fileBox = Util.getVisADFileChooser();

    public MeasureManager(BioVisAD biovis) throws VisADException, RemoteException {
        this.bio = biovis;
        this.pool2 = new MeasurePool(this.bio, this.bio.display2, 2);
        if (this.bio.display3 != null) {
            this.pool3 = new MeasurePool(this.bio, this.bio.display3, 3);
        }
    }

    public void initLists(int timesteps) throws VisADException, RemoteException {
        this.lists = new MeasureList[timesteps];
        int i = 0;
        while (i < timesteps) {
            this.lists[i] = new MeasureList(this.bio);
            ++i;
        }
        this.pool2.set(this.lists[0]);
        if (this.pool3 != null) {
            this.pool3.set(this.lists[0]);
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.lists.length) {
            this.lists[i].removeAll();
            ++i;
        }
    }

    public MeasureList getList() {
        return this.lists[this.bio.sm.getIndex()];
    }

    public void checkSave() {
        boolean hasMeasure = false;
        if (this.lists != null) {
            int i = 0;
            while (i < this.lists.length) {
                if (this.lists[i].hasMeasurements()) {
                    hasMeasure = true;
                    break;
                }
                ++i;
            }
        }
        if (!this.changed || !hasMeasure) {
            return;
        }
        int ans = JOptionPane.showConfirmDialog(this.bio, "Save measurements?", "BioVisAD", 0, 3);
        if (ans != 0) {
            return;
        }
        this.saveMeasurements();
    }

    public void restoreMeasurements() {
        this.bio.setWaitCursor(true);
        this.fileBox.setDialogType(0);
        if (this.fileBox.showOpenDialog(this.bio) != 0) {
            this.bio.setWaitCursor(false);
            return;
        }
        File f = this.fileBox.getSelectedFile();
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this.bio, f.getName() + " does not exist", "Cannot load file", 0);
            this.bio.setWaitCursor(false);
            return;
        }
        try {
            new MeasureDataFile(this.bio, f).read();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        this.bio.setWaitCursor(false);
    }

    public void saveMeasurements() {
        this.bio.setWaitCursor(true);
        this.fileBox.setDialogType(1);
        if (this.fileBox.showSaveDialog(this.bio) != 0) {
            this.bio.setWaitCursor(false);
            return;
        }
        File f = this.fileBox.getSelectedFile();
        try {
            MeasureDataFile mdf = new MeasureDataFile(this.bio, f);
            if (this.bio.toolAlign.getUseMicrons()) {
                double mw = this.bio.toolAlign.getMicronWidth();
                double mh = this.bio.toolAlign.getMicronHeight();
                double mx = mw / (double)this.bio.sm.res_x;
                double my = mh / (double)this.bio.sm.res_y;
                double sd = this.bio.toolAlign.getSliceDistance();
                mdf.write(mx, my, sd);
            } else {
                mdf.write();
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this.changed = false;
        this.bio.setWaitCursor(false);
    }
}

