/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.Real;
import visad.RealTuple;
import visad.VisADException;
import visad.bio.BioUtil;
import visad.bio.BioVisAD;
import visad.bio.MeasureGroup;
import visad.bio.MeasureLine;
import visad.bio.MeasureList;
import visad.bio.MeasurePoint;
import visad.bio.MeasureToolPanel;
import visad.bio.SliceManager;

public class MeasureDataFile {
    private static final String[] VARIABLES = new String[]{"x", "y", "slice"};
    private static final String BEGIN_LABEL = "# BioVisAD measurement data file";
    private static final String UNIT_LABEL = "Unit = ";
    private static final String STANDARD_LABEL = "# Standard measurements";
    private static final String GROUP_LABEL = "# Groups";
    private static final String ALL_LABEL = "# All measurements";
    private BioVisAD bio;
    private File file;

    public MeasureDataFile(BioVisAD biovis, File file) {
        this.bio = biovis;
        this.file = file;
    }

    public void write() throws IOException {
        this.write(Double.NaN, Double.NaN, Double.NaN);
    }

    public void write(double mx, double my, double sd) throws IOException {
        boolean microns;
        int numIndices = this.bio.mm.lists.length;
        int numSlices = this.bio.sm.getNumberOfSlices();
        int numStd = MeasureToolPanel.maxId;
        MData[][][] stdData = new MData[numStd][numIndices][numSlices];
        boolean bl = microns = mx == mx && my == my && sd == sd;
        if (!microns) {
            sd = 1.0;
            my = 1.0;
            mx = 1.0;
        }
        Vector<MData> v = new Vector<MData>();
        int minLen = 2;
        int maxLen = 1;
        int index = 0;
        while (index < numIndices) {
            MeasureList list = this.bio.mm.lists[index];
            Vector lines = list.getLines();
            Vector points = list.getPoints();
            int lsize = lines.size();
            int i = 0;
            while (i < lsize) {
                MeasureLine line = (MeasureLine)lines.elementAt(i);
                double[][] vals = new double[][]{{line.ep1.x, line.ep2.x}, {line.ep1.y, line.ep2.y}, {line.ep1.z, line.ep2.z}};
                int r = line.color.getRed();
                int g = line.color.getGreen();
                int b = line.color.getBlue();
                MData data = new MData(index, line.stdId, line.group.getId(), mx, my, sd, vals, r, g, b);
                if (data.stdId >= 0) {
                    stdData[data.stdId][index][data.slice] = data;
                }
                v.add(data);
                maxLen = 2;
                ++i;
            }
            int psize = points.size();
            int i2 = 0;
            while (i2 < psize) {
                MeasurePoint point = (MeasurePoint)points.elementAt(i2);
                if (point.lines.isEmpty()) {
                    double[][] vals = new double[][]{{point.x}, {point.y}, {point.z}};
                    int r = point.color.getRed();
                    int g = point.color.getGreen();
                    int b = point.color.getBlue();
                    MData data = new MData(index, point.stdId, point.group.getId(), mx, my, sd, vals, r, g, b);
                    if (data.stdId >= 0) {
                        stdData[data.stdId][index][data.slice] = data;
                    }
                    v.add(data);
                    minLen = 1;
                }
                ++i2;
            }
            ++index;
        }
        PrintWriter fout = new PrintWriter(new FileWriter(this.file));
        fout.println(BEGIN_LABEL);
        fout.println();
        fout.println(UNIT_LABEL + (microns ? "microns (" + mx + ", " + my + ", " + sd + ")" : "pixels"));
        fout.println();
        fout.println();
        fout.println(STANDARD_LABEL);
        int std = 0;
        while (std < numStd) {
            MData d = stdData[std][0][0];
            if (d != null) {
                int gid = d.groupId;
                MeasureGroup group = (MeasureGroup)this.bio.mm.groups.elementAt(gid);
                fout.println();
                fout.println("[" + std + "] " + group.getName());
                String tabs = "";
                int slice = 0;
                while (slice < numSlices) {
                    tabs = tabs + "\t";
                    ++slice;
                }
                int len = d.values[0].length;
                if (len == 2) {
                    fout.print("distance" + tabs);
                }
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < len) {
                        fout.print(VARIABLES[i] + (j + 1));
                        if (i < 1 || j < len - 1) {
                            fout.print(tabs);
                        }
                        ++j;
                    }
                    ++i;
                }
                fout.println();
                int index2 = 0;
                while (index2 < numIndices) {
                    if (len == 2) {
                        int slice2 = 0;
                        while (slice2 < numSlices) {
                            fout.print(stdData[std][index2][slice2].dist + "\t");
                            ++slice2;
                        }
                    }
                    int i3 = 0;
                    while (i3 < 2) {
                        int j = 0;
                        while (j < len) {
                            int slice3 = 0;
                            while (slice3 < numSlices) {
                                fout.print(stdData[std][index2][slice3].values[i3][j]);
                                if (i3 < 1 || j < len - 1 || slice3 < numSlices - 1) {
                                    fout.print("\t");
                                }
                                ++slice3;
                            }
                            ++j;
                        }
                        ++i3;
                    }
                    fout.println();
                    ++index2;
                }
            }
            ++std;
        }
        fout.println();
        fout.println();
        fout.println(GROUP_LABEL);
        fout.println();
        fout.println("No\tName\tDescription");
        int numGroups = this.bio.mm.groups.size();
        int g = 0;
        while (g < numGroups) {
            MeasureGroup group = (MeasureGroup)this.bio.mm.groups.elementAt(g);
            fout.println(g + "\t" + group.getName() + "\t" + group.getDescription());
            ++g;
        }
        fout.println();
        fout.println();
        fout.println(ALL_LABEL);
        int i = minLen;
        while (i <= maxLen) {
            int size = v.size();
            boolean doHeader = true;
            int j = 0;
            while (j < size) {
                MData data = (MData)v.elementAt(j);
                int len = data.values[0].length;
                if (i == len) {
                    if (doHeader) {
                        fout.println();
                        fout.println(MeasureDataFile.getHeader(i));
                        doHeader = false;
                    }
                    fout.println(data);
                }
                ++j;
            }
            ++i;
        }
        fout.close();
    }

    /*
     * Unable to fully structure code
     */
    public void read() throws IOException, VisADException {
        block25: {
            mpp = NaN;
            mx = 1.0;
            my = 1.0;
            sd = 1.0;
            microns = false;
            fin = new BufferedReader(new FileReader(this.file));
            ln = "";
            while (!ln.startsWith("Unit = ")) {
                ln = fin.readLine().trim();
            }
            if (ln.indexOf("microns") > 0) {
                microns = true;
                left = ln.indexOf("(");
                st = new StringTokenizer(ln.substring(left + 1, right = ln.indexOf(")")), ",");
                count = st.countTokens();
                if (count == 2) {
                    mpp = Double.parseDouble(st.nextToken().trim());
                    sd = Double.parseDouble(st.nextToken().trim());
                } else if (count == 3) {
                    mx = Double.parseDouble(st.nextToken().trim());
                    my = Double.parseDouble(st.nextToken().trim());
                    sd = Double.parseDouble(st.nextToken().trim());
                } else {
                    microns = false;
                }
            }
            while (!ln.equals("# Groups")) {
                ln = fin.readLine().trim();
            }
            while (!ln.startsWith("No")) {
                ln = fin.readLine().trim();
            }
            groups = new Vector<String>();
            while ((ln = fin.readLine().trim()) != null && !ln.equals("")) {
                groups.add(ln);
            }
            break block25;
lbl38:
            // 1 sources

            while (true) {
                ln = fin.readLine().trim();
                break;
            }
        }
        ** while (!ln.equals((Object)"# All measurements"))
lbl42:
        // 1 sources

        v = new Vector<MData>();
        len = 0;
        while ((ln = fin.readLine()) != null) {
            if ((ln = ln.trim()).startsWith("Timestep")) {
                ndx = ln.lastIndexOf("slice2");
                v0 = len = ndx >= 0 ? 2 : 1;
            }
            if (ln.equals("") || ln.startsWith("#") || ln.startsWith("Timestep")) continue;
            v.add(new MData(ln, len, mx, my, sd));
        }
        fin.close();
        gsize = groups.size();
        this.bio.mm.groups.removeAllElements();
        i = 0;
        while (i < gsize) {
            g = (String)groups.elementAt(i);
            st = new StringTokenizer(g, "\t");
            id = Integer.parseInt(st.nextToken());
            name = st.nextToken();
            v1 = desc = st.hasMoreTokens() != false ? st.nextToken() : "";
            if (id == BioVisAD.noneGroup.getId()) {
                this.bio.mm.groups.add(BioVisAD.noneGroup);
            } else {
                group = new MeasureGroup(this.bio, name);
                group.setDescription(desc);
                group.setId(id);
                if (id >= this.bio.mm.maxId) {
                    this.bio.mm.maxId = id + 1;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.bio.mm.lists.length) {
            this.bio.mm.lists[i].removeAll();
            ++i;
        }
        size = v.size();
        index = this.bio.sm.getIndex();
        k = 0;
        while (k < size) {
            data = (MData)v.elementAt(k);
            list = this.bio.mm.lists[data.index];
            len = data.values[0].length;
            values = new RealTuple[len];
            j = 0;
            while (j < len) {
                reals = new Real[3];
                i = 0;
                while (i < 3) {
                    reals[i] = new Real(i < 2 ? this.bio.sm.dtypes[i] : SliceManager.Z_TYPE, data.values[i][j]);
                    ++i;
                }
                values[j] = new RealTuple(reals);
                ++j;
            }
            color = new Color(data.r, data.g, data.b);
            group = (MeasureGroup)this.bio.mm.groups.elementAt(data.groupId);
            if (data.stdId >= MeasureToolPanel.maxId) {
                MeasureToolPanel.maxId = data.stdId + 1;
            }
            if (len == 1) {
                x = data.values[0][0];
                y = data.values[1][0];
                z = data.values[2][0];
                point = new MeasurePoint(x, y, z, color, group);
                point.setStdId(data.stdId);
                list.addMarker(point, false);
            } else if (len == 2) {
                x1 = data.values[0][0];
                y1 = data.values[1][0];
                z1 = data.values[2][0];
                x2 = data.values[0][1];
                y2 = data.values[1][1];
                z2 = data.values[2][1];
                ep1 = new MeasurePoint(x1, y1, z1, color, group);
                ep2 = new MeasurePoint(x2, y2, z2, color, group);
                line = new MeasureLine(ep1, ep2, color, group, false);
                line.setStdId(data.stdId);
                list.addLine(line, false);
            }
            ++k;
        }
        this.bio.mm.pool2.refresh(true);
        if (this.bio.mm.pool3 != null) {
            this.bio.mm.pool3.refresh(true);
        }
        this.bio.toolMeasure.updateInfo(microns, mx, my, sd);
    }

    private static String getHeader(int len) {
        StringBuffer sb = new StringBuffer();
        sb.append("Timestep\tStandard ID\tGroup number\tRed\tGreen\tBlue\t");
        if (len == 2) {
            sb.append("Distance\t");
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < len) {
                sb.append(VARIABLES[i] + (j + 1));
                if (i < 2 || j < len - 1) {
                    sb.append("\t");
                }
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public class MData {
        public int index;
        public int slice;
        public int stdId;
        public int groupId;
        public double[][] values;
        public int r;
        public int g;
        public int b;
        public double dist;

        public MData(String line, int len, double mx, double my, double sd) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            this.index = Integer.parseInt(st.nextToken());
            this.stdId = Integer.parseInt(st.nextToken());
            this.groupId = Integer.parseInt(st.nextToken());
            this.r = Integer.parseInt(st.nextToken());
            this.g = Integer.parseInt(st.nextToken());
            this.b = Integer.parseInt(st.nextToken());
            if (len == 2) {
                this.dist = Double.parseDouble(st.nextToken());
            }
            this.values = new double[3][len];
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < len) {
                    this.values[i][j] = Double.parseDouble(st.nextToken());
                    if (i == 0) {
                        double[] dArray = this.values[i];
                        int n = j;
                        dArray[n] = dArray[n] / mx;
                    } else if (i == 1) {
                        double[] dArray = this.values[i];
                        int n = j;
                        dArray[n] = dArray[n] / my;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public MData(int index, int stdId, int groupId, double mx, double my, double sd, double[][] values, int r, int g, int b) {
            this.index = index;
            this.stdId = stdId;
            this.groupId = groupId;
            this.values = values;
            this.r = r;
            this.g = g;
            this.b = b;
            int len = values[0].length;
            this.slice = (int)values[2][0];
            int j = 1;
            while (j < len) {
                if ((int)values[2][j] != this.slice) {
                    this.slice = -1;
                    break;
                }
                ++j;
            }
            this.dist = len == 2 ? BioUtil.getDistance(values[0][0], values[1][0], values[2][0], values[0][1], values[1][1], values[2][1], mx, my, sd) : -1.0;
            int j2 = 0;
            while (j2 < len) {
                double[] dArray = values[0];
                int n = j2;
                dArray[n] = dArray[n] * mx;
                double[] dArray2 = values[1];
                int n2 = j2++;
                dArray2[n2] = dArray2[n2] * my;
            }
        }

        public String toString() {
            int len = this.values[0].length;
            StringBuffer sb = new StringBuffer();
            sb.append(this.index + "\t");
            sb.append(this.stdId + "\t" + this.groupId + "\t" + this.r + "\t" + this.g + "\t" + this.b + "\t");
            if (len == 2) {
                sb.append(this.dist + "\t");
            }
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < len) {
                    sb.append(this.values[i][j]);
                    if (i < 2 || j < len - 1) {
                        sb.append("\t");
                    }
                    ++j;
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

