/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.Display;
import visad.DisplayRealType;
import visad.RealType;
import visad.bio.BioColorWidget;
import visad.bio.BioVisAD;
import visad.bio.ToolPanel;
import visad.browser.Divider;

public class ColorToolPanel
extends ToolPanel
implements ItemListener {
    private static final DisplayRealType[] COLOR_TYPES = new DisplayRealType[]{Display.Red, Display.Green, Display.Blue, Display.RGB};
    private JLabel brightnessLabel;
    private JSlider brightness;
    private JLabel brightnessValue;
    private JLabel contrastLabel;
    private JSlider contrast;
    private JLabel contrastValue;
    private BioColorWidget red;
    private BioColorWidget green;
    private BioColorWidget blue;
    private JCheckBox composite;
    private JCheckBox colorize;
    private JComboBox selector;
    private int cc = 0;
    private boolean ignore = false;

    public ColorToolPanel(BioVisAD biovis) {
        super(biovis);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.brightnessLabel = new JLabel("Brightness: ");
        this.brightnessLabel.setForeground(Color.black);
        this.brightnessLabel.setAlignmentY(0.0f);
        p.add(this.brightnessLabel);
        this.brightness = new JSlider(0, 256, 128);
        this.brightness.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorToolPanel.this.doColorTable();
            }
        });
        this.brightness.setAlignmentY(0.0f);
        p.add(this.brightness);
        this.brightnessValue = new JLabel("128");
        Dimension colorValueSize = new JLabel("256").getPreferredSize();
        this.brightnessValue.setPreferredSize(colorValueSize);
        this.brightnessValue.setAlignmentY(0.0f);
        p.add(this.brightnessValue);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.contrastLabel = new JLabel("Contrast: ");
        this.contrastLabel.setForeground(Color.black);
        this.contrastLabel.setPreferredSize(this.brightnessLabel.getPreferredSize());
        this.contrastLabel.setAlignmentY(0.0f);
        p.add(this.contrastLabel);
        this.contrast = new JSlider(0, 256, 128);
        this.contrast.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorToolPanel.this.doColorTable();
            }
        });
        this.contrast.setAlignmentY(0.0f);
        this.contrast.setMajorTickSpacing(64);
        this.contrast.setMinorTickSpacing(16);
        this.contrast.setPaintTicks(true);
        p.add(this.contrast);
        this.contrastValue = new JLabel("128");
        this.contrastValue.setPreferredSize(colorValueSize);
        this.contrastValue.setAlignmentY(0.0f);
        p.add(this.contrastValue);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        this.controls.add(Box.createVerticalStrut(5));
        ++this.cc;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.red = new BioColorWidget(this.bio, 0);
        this.red.addItemListener(this);
        p.add(this.red);
        this.green = new BioColorWidget(this.bio, 1);
        this.green.addItemListener(this);
        p.add(this.green);
        this.blue = new BioColorWidget(this.bio, 2);
        this.blue.addItemListener(this);
        p.add(this.blue);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
        this.composite = new JCheckBox("Composite image coloring", false);
        this.composite.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = !ColorToolPanel.this.composite.isSelected();
                ColorToolPanel.this.red.setEnabled(b);
                ColorToolPanel.this.green.setEnabled(b);
                ColorToolPanel.this.blue.setEnabled(b);
                ColorToolPanel.this.doColorTable();
            }
        });
        this.controls.add(ToolPanel.pad(this.composite));
        ++this.cc;
        this.colorize = new JCheckBox("Colorize image stack across slices", false);
        this.colorize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ColorToolPanel.this.doColorTable();
            }
        });
        this.colorize.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.colorize));
        ++this.cc;
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        this.cc += 3;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel selLabel = new JLabel("Color table: ");
        selLabel.setForeground(Color.black);
        p.add(selLabel);
        this.selector = new JComboBox();
        this.selector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ndx = ColorToolPanel.this.selector.getSelectedIndex() + ColorToolPanel.this.cc;
                int i = ColorToolPanel.this.cc;
                while (i < ColorToolPanel.this.controls.getComponentCount()) {
                    ColorToolPanel.this.controls.getComponent(i).setVisible(i == ndx);
                    ++i;
                }
            }
        });
        p.add(this.selector);
        this.controls.add(ToolPanel.pad(p));
        ++this.cc;
    }

    public void setEnabled(boolean enabled) {
        this.brightnessLabel.setEnabled(enabled);
        this.brightness.setEnabled(enabled);
        this.contrastLabel.setEnabled(enabled);
        this.contrast.setEnabled(enabled);
    }

    public void addWidget(String s, JComponent c) {
        this.selector.addItem(s);
        c.setVisible(this.selector.getItemCount() == 1);
        this.controls.add(c);
    }

    public void removeAllWidgets() {
        this.selector.removeAllItems();
        int size = this.controls.getComponentCount();
        int i = this.controls.getComponentCount();
        while (i > this.cc) {
            this.controls.remove(this.cc);
            --i;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.doColorTable();
    }

    void doColorTable() {
        if (this.ignore) {
            return;
        }
        int bright = this.brightness.getValue();
        int cont = this.contrast.getValue();
        boolean comp = this.composite.isSelected();
        this.bio.setImageColors(bright, cont, comp, this.red.getSelectedItem(), this.green.getSelectedItem(), this.blue.getSelectedItem());
        this.brightnessValue.setText("" + bright);
        this.contrastValue.setText("" + cont);
    }

    void guessTypes() {
        this.red.removeItemListener(this);
        this.green.removeItemListener(this);
        this.blue.removeItemListener(this);
        this.red.guessType();
        this.green.guessType();
        this.blue.guessType();
        this.red.addItemListener(this);
        this.green.addItemListener(this);
        this.blue.addItemListener(this);
    }

    void setColors(int bright, int cont, RealType r, RealType g, RealType b) {
        this.ignore = true;
        this.brightness.setValue(bright);
        this.contrast.setValue(cont);
        this.red.setSelectedItem(r);
        this.green.setSelectedItem(g);
        this.blue.setSelectedItem(b);
        this.ignore = false;
        this.doColorTable();
    }
}

