/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import ij.ImagePlus;
import ij.io.FileSaver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.BaseColorControl;
import visad.Data;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.bio.AlignToolPanel;
import visad.bio.ColorToolPanel;
import visad.bio.ExportDialog;
import visad.bio.FileSeriesWidget;
import visad.bio.ImageStackWidget;
import visad.bio.ImportDialog;
import visad.bio.MeasureGroup;
import visad.bio.MeasureManager;
import visad.bio.MeasureToolPanel;
import visad.bio.SliceManager;
import visad.bio.StateManager;
import visad.bio.ViewToolPanel;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.ExtensionFileFilter;
import visad.util.GUIFrame;
import visad.util.Util;

public class BioVisAD
extends GUIFrame
implements ChangeListener {
    private static final String TITLE = "BioVisAD";
    static final int COLOR_DETAIL = 256;
    static final int NORMAL_BRIGHTNESS = 128;
    static final int NORMAL_CONTRAST = 128;
    static MeasureGroup noneGroup;
    static final float[][] rainbow;
    DisplayImpl display2;
    DisplayImpl display3;
    DisplayImpl previous;
    DisplayImpl next;
    JPanel previewPane;
    ImageStackWidget vert;
    FileSeriesWidget horiz;
    ViewToolPanel toolView;
    ColorToolPanel toolColor;
    AlignToolPanel toolAlign;
    MeasureToolPanel toolMeasure;
    MeasureManager mm;
    SliceManager sm;
    StateManager state;
    private ImportDialog importer;
    private ExportDialog exporter;
    private JPanel displayPane;
    private JMenuItem fileExport;
    private int brightness;
    private int contrast;
    private boolean composite;
    private RealType red;
    private RealType green;
    private RealType blue;
    private String prefix;

    public BioVisAD() throws VisADException, RemoteException {
        super(true);
        this.setTitle(TITLE);
        this.importer = new ImportDialog();
        this.exporter = new ExportDialog(this);
        this.addMenuItem("File", "Open...", "fileOpen", 'o');
        this.fileExport = this.addMenuItem("File", "Export...", "fileExport", 'e');
        this.addMenuItem("File", "Take snapshot...", "fileSnap", 's');
        this.addMenuSeparator("File");
        this.addMenuItem("File", "Exit", "fileExit", 'x');
        this.fileExport.setEnabled(false);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        this.setContentPane(pane);
        this.displayPane = new JPanel();
        this.displayPane.setLayout(new BoxLayout(this.displayPane, 1));
        pane.add((Component)this.displayPane, "Center");
        if (Util.canDoJava3D()) {
            this.display2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
            this.display3 = new DisplayImplJ3D("display3");
            this.previous = new DisplayImplJ3D("previous");
            this.next = new DisplayImplJ3D("next");
            this.previewPane = new JPanel();
            this.previewPane.setPreferredSize(new Dimension(0, 130));
            this.previewPane.setLayout(new BoxLayout(this.previewPane, 0));
            this.previewPane.add(this.previous.getComponent());
            this.previewPane.add(this.next.getComponent());
            this.previewPane.setVisible(false);
        } else {
            this.display2 = new DisplayImplJ2D("display2");
            this.next = null;
            this.previous = null;
            this.display3 = null;
            this.previewPane = null;
        }
        this.display2.getDisplayRenderer().setPickThreshhold(Float.MAX_VALUE);
        this.display2.enableEvent(18);
        this.displayPane.add(this.display2.getComponent());
        if (this.display3 != null) {
            GraphicsModeControl gmc = this.display3.getGraphicsModeControl();
            gmc.setLineWidth(2.0f);
            DisplayRendererJ3D renderer = (DisplayRendererJ3D)this.display3.getDisplayRenderer();
            renderer.setPickThreshhold(Float.MAX_VALUE);
            this.display3.enableEvent(18);
            this.displayPane.add(this.display3.getComponent());
            this.displayPane.add(this.previewPane);
        }
        this.mm = new MeasureManager(this);
        this.sm = new SliceManager(this);
        this.state = new StateManager(this);
        if (noneGroup == null) {
            noneGroup = new MeasureGroup(this, "NONE");
        }
        this.vert = new ImageStackWidget(this);
        this.vert.setAlignmentY(0.0f);
        pane.add((Component)this.vert, "West");
        this.horiz = new FileSeriesWidget(this);
        this.horiz.addChangeListener(this);
        pane.add((Component)this.horiz, "South");
        JTabbedPane tabs = new JTabbedPane();
        pane.add((Component)tabs, "East");
        this.toolView = new ViewToolPanel(this);
        tabs.addTab("View", this.toolView);
        this.toolColor = new ColorToolPanel(this);
        tabs.addTab("Color", this.toolColor);
        this.toolAlign = new AlignToolPanel(this);
        tabs.addTab("Align", this.toolAlign);
        this.toolMeasure = new MeasureToolPanel(this);
        tabs.addTab("Measure", this.toolMeasure);
    }

    public void set2D(boolean twoD) {
        this.display2.getComponent().setVisible(twoD);
    }

    public void set3D(boolean threeD) {
        if (this.display3 == null) {
            return;
        }
        this.display3.getComponent().setVisible(threeD);
    }

    public void setVolume(boolean volume) {
        this.sm.setVolumeRender(volume);
    }

    public void setPreview(boolean preview) {
        if (this.previewPane == null) {
            return;
        }
        this.previewPane.setVisible(preview);
    }

    public void setZoom(boolean threeD, double scale) {
        DisplayImpl d = threeD ? this.display3 : this.display2;
        try {
            ProjectionControl control = d.getProjectionControl();
            double[] matrix = control.getMatrix();
            double[] zoom = d.make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0);
            control.setMatrix(d.multiply_matrix(zoom, matrix));
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    public void resetZoom(boolean threeD) {
        DisplayImpl d = threeD ? this.display3 : this.display2;
        try {
            d.getProjectionControl().resetProjection();
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    public void setAspect(double x, double y, double z) {
        double d = x > y ? x : y;
        double xasp = x / d;
        double yasp = y / d;
        double zasp = z == z ? z / d : 1.0;
        ProjectionControl pc2 = this.display2.getProjectionControl();
        try {
            pc2.setAspect(new double[]{xasp, yasp, zasp});
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        if (this.display3 != null) {
            ProjectionControl pc3 = this.display3.getProjectionControl();
            ProjectionControl pcPp = this.previous.getProjectionControl();
            ProjectionControl pcPn = this.next.getProjectionControl();
            try {
                pc3.setAspect(new double[]{xasp, yasp, zasp});
                pcPp.setAspect(new double[]{xasp, yasp, zasp});
                pcPn.setAspect(new double[]{xasp, yasp, zasp});
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
    }

    public void setImageColors(int brightness, int contrast, boolean composite, RealType r, RealType g, RealType b) {
        int i;
        float[] bvals;
        float[] gvals;
        float[] rvals;
        if (this.brightness == brightness && this.contrast == contrast && this.composite == composite && this.red == r && this.green == g && this.blue == b) {
            return;
        }
        this.brightness = brightness;
        this.contrast = contrast;
        this.composite = composite;
        this.red = r;
        this.green = g;
        this.blue = b;
        BaseColorControl[] cc2 = this.sm.getColorControls2D();
        if (cc2 == null) {
            return;
        }
        BaseColorControl[] cc3 = this.sm.getColorControls3D();
        BaseColorControl[][] ccP = this.sm.getColorControlsPreview();
        double mid = 128.0;
        double slope = (double)contrast <= mid ? (double)contrast / mid : mid / (double)(256 - contrast);
        if (slope == Double.POSITIVE_INFINITY) {
            slope = Double.MAX_VALUE;
        }
        double mag = slope + 1.0;
        double center = mag * (double)brightness / 256.0 - 0.5 * (mag - 1.0);
        float[] vals = new float[256];
        if (composite) {
            rvals = new float[256];
            gvals = new float[256];
            bvals = new float[256];
            i = 0;
            while (i < 256) {
                rvals[i] = (float)(slope * ((double)rainbow[0][i] - 0.5) + center);
                gvals[i] = (float)(slope * ((double)rainbow[1][i] - 0.5) + center);
                bvals[i] = (float)(slope * ((double)rainbow[2][i] - 0.5) + center);
                if (rvals[i] > 1.0f) {
                    rvals[i] = 1.0f;
                }
                if (rvals[i] < 0.0f) {
                    rvals[i] = 0.0f;
                }
                if (gvals[i] > 1.0f) {
                    gvals[i] = 1.0f;
                }
                if (gvals[i] < 0.0f) {
                    gvals[i] = 0.0f;
                }
                if (bvals[i] > 1.0f) {
                    bvals[i] = 1.0f;
                }
                if (bvals[i] < 0.0f) {
                    bvals[i] = 0.0f;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < 256) {
                vals[i] = (float)(0.5 * slope * ((double)i / mid - 1.0) + center);
                ++i;
            }
            bvals = vals;
            gvals = vals;
            rvals = gvals;
        }
        i = 0;
        while (i < 256) {
            if (vals[i] < 0.0f) {
                vals[i] = 0.0f;
            } else if (vals[i] > 1.0f) {
                vals[i] = 1.0f;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < cc2.length) {
            if (i2 >= this.sm.rtypes.length) break;
            RealType rt = this.sm.rtypes[i2];
            float[][] t2 = new float[3][256];
            if (composite) {
                int j = 0;
                while (j < 3) {
                    System.arraycopy(rainbow[j], 0, t2[j], 0, 256);
                    ++j;
                }
            }
            if (composite) {
                t2[0] = rvals;
                t2[1] = gvals;
                t2[2] = bvals;
            } else {
                if (rt.equals(r)) {
                    System.arraycopy(rvals, 0, t2[0], 0, 256);
                }
                if (rt.equals(g)) {
                    System.arraycopy(gvals, 0, t2[1], 0, 256);
                }
                if (rt.equals(b)) {
                    System.arraycopy(bvals, 0, t2[2], 0, 256);
                }
            }
            float[][] t3 = new float[4][];
            System.arraycopy(t2, 0, t3, 0, 3);
            t3[3] = new float[256];
            int j = 0;
            while (j < 256) {
                t3[3][j] = 1.0f;
                ++j;
            }
            try {
                if (cc2[i2] != null) {
                    cc2[i2].setTable(t2);
                }
                if (cc3 != null && cc3[i2] != null) {
                    cc3[i2].setTable(t3);
                }
                if (ccP != null) {
                    int j2 = 0;
                    while (j2 < ccP.length) {
                        if (ccP[j2] != null && ccP[j2][i2] != null) {
                            ccP[j2][i2].setTable(t3);
                        }
                        ++j2;
                    }
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
            ++i2;
        }
        this.state.saveState(true);
    }

    public void fileOpen() {
        final BioVisAD frame = this;
        Util.invoke(false, new Runnable(){

            public void run() {
                if (BioVisAD.this.importer.showDialog(frame) != 1) {
                    return;
                }
                File[] f = BioVisAD.this.importer.getSeries();
                BioVisAD.this.prefix = BioVisAD.this.importer.getPrefix();
                BioVisAD.this.sm.setThumbnails(BioVisAD.this.importer.getThumbs(), BioVisAD.this.importer.getThumbResX(), BioVisAD.this.importer.getThumbResY());
                if (f == null || f.length < 1) {
                    JOptionPane.showMessageDialog(frame, "Invalid series", "Cannot load series", 0);
                    return;
                }
                BioVisAD.this.sm.setSeries(f, BioVisAD.this.importer.getFilesAsSlices());
                BioVisAD.this.fileExport.setEnabled(true);
            }
        });
    }

    public void fileExport() {
        Util.invoke(false, new Runnable(){

            public void run() {
                if (BioVisAD.this.exporter.showDialog() != 1) {
                    return;
                }
                BioVisAD.this.exporter.export();
            }
        });
    }

    public void fileSnap() {
        final BioVisAD bio = this;
        Thread t = new Thread(new Runnable(){

            public void run() {
                JFileChooser fileBox = new JFileChooser();
                fileBox.addChoosableFileFilter(new ExtensionFileFilter(new String[]{"jpg", "jpeg"}, "JPEG files"));
                fileBox.addChoosableFileFilter(new ExtensionFileFilter("raw", "RAW files"));
                fileBox.addChoosableFileFilter(new ExtensionFileFilter(new String[]{"tif", "tiff"}, "TIFF files"));
                int rval = fileBox.showSaveDialog(bio);
                if (rval == 0) {
                    boolean has3;
                    BioVisAD.this.setWaitCursor(true);
                    String file = fileBox.getSelectedFile().getPath();
                    String ext = "";
                    int dot = file.indexOf(".");
                    if (dot >= 0) {
                        ext = file.substring(dot + 1).toLowerCase();
                    }
                    boolean tiff = ext.equals("tif") || ext.equals("tiff");
                    boolean jpeg = ext.equals("jpg") || ext.equals("jpeg");
                    boolean raw = ext.equals("raw");
                    if (!(tiff || jpeg || raw)) {
                        JOptionPane.showMessageDialog(bio, "Invalid filename (" + file + "): " + "extension must be TIFF, JPEG or RAW.", "Cannot export snapshot", 0);
                        BioVisAD.this.setWaitCursor(false);
                        return;
                    }
                    boolean has2 = BioVisAD.this.display2.getComponent().isVisible();
                    boolean bl = has3 = BioVisAD.this.display3 != null && BioVisAD.this.display3.getComponent().isVisible();
                    if (!has2 && !has3) {
                        JOptionPane.showMessageDialog(bio, "No displays are visible.", "Cannot export snapshot", 0);
                        BioVisAD.this.setWaitCursor(false);
                        return;
                    }
                    BufferedImage image2 = has2 ? BioVisAD.this.display2.getImage() : null;
                    BufferedImage image3 = has3 ? BioVisAD.this.display3.getImage() : null;
                    int w2 = 0;
                    int h2 = 0;
                    int w3 = 0;
                    int h3 = 0;
                    int type = 1;
                    if (has2) {
                        w2 = image2.getWidth();
                        h2 = image2.getHeight();
                        type = image2.getType();
                    }
                    if (has3) {
                        w3 = image3.getWidth();
                        h3 = image3.getHeight();
                        type = image3.getType();
                    }
                    BufferedImage img = new BufferedImage(w2 > w3 ? w2 : w3, h2 + h3, type);
                    Graphics2D g = img.createGraphics();
                    if (has2) {
                        g.drawImage((Image)image2, 0, 0, null);
                    }
                    if (has3) {
                        g.drawImage((Image)image3, 0, h2, null);
                    }
                    FileSaver saver = new FileSaver(new ImagePlus("null", img));
                    if (tiff) {
                        saver.saveAsTiff(file);
                    } else if (jpeg) {
                        saver.saveAsJpeg(file);
                    } else if (raw) {
                        saver.saveAsRaw(file);
                    }
                    BioVisAD.this.setWaitCursor(false);
                }
            }
        });
        t.start();
    }

    public void fileExit() {
        this.mm.checkSave();
        this.state.destroy();
        System.exit(0);
    }

    public void stateChanged(ChangeEvent e) {
        int max = this.horiz.getMaximum();
        int cur = this.horiz.getValue();
        this.setTitle("BioVisAD - " + this.prefix + " (" + cur + "/" + max + ")");
    }

    void setWaitCursor(boolean wait) {
        this.setCursor(wait ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor());
    }

    void saveState(PrintWriter fout) throws IOException, VisADException {
        fout.println(this.prefix);
        fout.println(this.brightness);
        fout.println(this.contrast);
        fout.println(this.red == null ? "null" : this.red.getName());
        fout.println(this.green == null ? "null" : this.green.getName());
        fout.println(this.blue == null ? "null" : this.blue.getName());
        this.sm.saveState(fout);
    }

    void restoreState(BufferedReader fin) throws IOException, VisADException {
        this.prefix = fin.readLine().trim();
        int bright = Integer.parseInt(fin.readLine().trim());
        int cont = Integer.parseInt(fin.readLine().trim());
        String r = fin.readLine().trim();
        String g = fin.readLine().trim();
        String b = fin.readLine().trim();
        RealType red = r.equals("null") ? null : RealType.getRealType(r);
        RealType green = g.equals("null") ? null : RealType.getRealType(g);
        RealType blue = b.equals("null") ? null : RealType.getRealType(b);
        this.sm.restoreState(fin);
        this.toolColor.setColors(bright, cont, red, green, blue);
    }

    public static RealTuple[] copy(RealTuple[] tuples) {
        return BioVisAD.copy(tuples, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static RealTuple[] copy(RealTuple[] tuples, int slice) {
        try {
            void exc;
            RealTuple[] n_tuples = new RealTuple[tuples.length];
            int j = 0;
            while (j < tuples.length) {
                int dim = tuples[j].getDimension();
                Data[] comps = tuples[j].getComponents();
                Real[] n_comps = new Real[dim];
                int i = 0;
                while (i < dim) {
                    RealType type;
                    double value;
                    Real real = (Real)comps[i];
                    if (slice >= 0 && i == dim - 1) {
                        value = slice;
                        type = SliceManager.Z_TYPE;
                    } else {
                        value = real.getValue();
                        type = (RealType)real.getType();
                    }
                    n_comps[i] = new Real(type, value, real.getUnit(), real.getError());
                    ++i;
                }
                RealTupleType tuple_type = (RealTupleType)tuples[j].getType();
                RealType[] real_types = tuple_type.getRealComponents();
                RealType[] n_real_types = new RealType[dim];
                System.arraycopy(real_types, 0, n_real_types, 0, dim);
                n_tuples[j] = new RealTuple(new RealTupleType(n_real_types), n_comps, tuples[j].getCoordinateSystem());
                ++j;
            }
            return exc;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public static void dump(RealTuple tuple) {
        Data[] comps = tuple.getComponents();
        int i = 0;
        while (i < comps.length) {
            Real real = (Real)comps[i];
            System.out.println("#" + i + ": type=" + real.getType() + "; value=" + real.getValue());
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        final BioVisAD bio = new BioVisAD();
        bio.pack();
        bio.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                bio.fileExit();
            }
        });
        Util.centerWindow(bio);
        bio.show();
        bio.state.checkState();
    }

    static {
        rainbow = BaseColorControl.initTableVis5D(new float[3][256]);
    }
}

