/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.util.Vector;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.MouseBehavior;
import visad.ScalarMap;
import visad.VisADRay;

public class BioUtil {
    public static double[] pixelToDomain(DisplayImpl d, int x, int y) {
        return BioUtil.cursorToDomain(d, BioUtil.pixelToCursor(d, x, y));
    }

    public static double[] pixelToCursor(DisplayImpl d, int x, int y) {
        MouseBehavior mb = d.getDisplayRenderer().getMouseBehavior();
        VisADRay ray = mb.findRay(x, y);
        return ray.position;
    }

    public static double[] cursorToDomain(DisplayImpl d, double[] cursor) {
        Vector maps = d.getMapVector();
        int numMaps = maps.size();
        ScalarMap map_x = null;
        ScalarMap map_y = null;
        ScalarMap map_z = null;
        int i = 0;
        while (i < numMaps) {
            if (map_x != null && map_y != null && map_z != null) break;
            ScalarMap map = (ScalarMap)maps.elementAt(i);
            DisplayRealType drt = map.getDisplayScalar();
            if (drt.equals(Display.XAxis)) {
                map_x = map;
            } else if (drt.equals(Display.YAxis)) {
                map_y = map;
            } else if (drt.equals(Display.ZAxis)) {
                map_z = map;
            }
            ++i;
        }
        double[] scale_offset = new double[2];
        double[] dummy = new double[2];
        double[] values = new double[3];
        if (map_x == null) {
            values[0] = Double.NaN;
        } else {
            map_x.getScale(scale_offset, dummy, dummy);
            values[0] = (cursor[0] - scale_offset[1]) / scale_offset[0];
        }
        if (map_y == null) {
            values[1] = Double.NaN;
        } else {
            map_y.getScale(scale_offset, dummy, dummy);
            values[1] = (cursor[1] - scale_offset[1]) / scale_offset[0];
        }
        if (map_z == null) {
            values[2] = Double.NaN;
        } else {
            map_z.getScale(scale_offset, dummy, dummy);
            values[2] = (cursor[2] - scale_offset[1]) / scale_offset[0];
        }
        return values;
    }

    public static double getDistance(double ax, double ay, double bx, double by, double vx, double vy) {
        double y;
        double x;
        double abx = ax - bx;
        double aby = ay - by;
        double vax = vx - ax;
        double vay = vy - ay;
        double c = (vax * abx + vay * aby) / (abx * abx + aby * aby);
        double px = c * abx + ax;
        double py = c * aby + ay;
        int flag = 0;
        if (px > ax && px > bx) {
            flag = ax > bx ? 1 : 2;
        } else if (px < ax && px < bx) {
            flag = ax < bx ? 1 : 2;
        } else if (py > ay && py > by) {
            flag = ay > by ? 1 : 2;
        } else if (py < ay && py < by) {
            int n = flag = ay < by ? 1 : 2;
        }
        if (flag == 0) {
            x = px - vx;
            y = py - vy;
        } else if (flag == 1) {
            x = ax - vx;
            y = ay - vy;
        } else {
            x = bx - vx;
            y = by - vy;
        }
        return Math.sqrt(x * x + y * y);
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2, double mx, double my, double sd) {
        double distx = mx * (x2 - x1);
        double disty = my * (y2 - y1);
        double distz = sd * (z2 - z1);
        return Math.sqrt(distx * distx + disty * disty + distz * distz);
    }

    public static boolean intersects(double x1, double y1, double x2, double y2, double ax, double ay, double bx, double by) {
        double t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        if (BioUtil.contains(x1, y1, x2, y2, ax, ay) || BioUtil.contains(x1, y1, x2, y2, bx, by)) {
            return true;
        }
        if (ax == bx) {
            if (ax < x1 || ax > x2) {
                return false;
            }
            return ay <= y1 && by >= y1 || ay <= y2 && by >= y2 || ay >= y1 && by <= y1 || ay >= y2 && by <= y2;
        }
        if (ay == by) {
            if (ay < y1 || ay > y2) {
                return false;
            }
            return ax <= x1 && bx >= x1 || ax <= x2 && bx >= x2 || ax >= x1 && bx <= x1 || ax >= x2 && bx <= x2;
        }
        double m = (by - ay) / (bx - ax);
        double b = ay - m * ax;
        double left_y = m * x1 + b;
        if (left_y >= y1 && left_y <= y2) {
            return true;
        }
        double right_y = m * x2 + b;
        if (right_y >= y1 && right_y <= y2) {
            return true;
        }
        double top_x = (y1 - b) / m;
        if (top_x >= x1 && top_x <= x2) {
            return true;
        }
        double bottom_x = (y2 - b) / m;
        return bottom_x >= x1 && bottom_x <= x2;
    }

    public static boolean contains(double x1, double y1, double x2, double y2, double vx, double vy) {
        double t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        return vx >= x1 && vx <= x2 && vy >= y1 && vy <= y2;
    }
}

