/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import visad.bio.BioVisAD;
import visad.bio.DoubleTextCheckBox;
import visad.bio.ToolPanel;
import visad.browser.Convert;
import visad.browser.Divider;
import visad.util.Util;

public class AlignToolPanel
extends ToolPanel {
    private DoubleTextCheckBox useMicrons = new DoubleTextCheckBox("Use microns instead of pixels", "by", "", "", false);
    private JLabel sliceDistLabel;
    private JTextField sliceDistance;
    private JCheckBox zAspect;
    private JCheckBox drift;
    private JToggleButton driftLock;

    public AlignToolPanel(BioVisAD biovis) {
        super(biovis);
        this.useMicrons.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean b = AlignToolPanel.this.useMicrons.isSelected();
                AlignToolPanel.this.sliceDistLabel.setEnabled(b);
                AlignToolPanel.this.sliceDistance.setEnabled(b);
                AlignToolPanel.this.bio.toolMeasure.updateFileButtons();
            }
        });
        this.useMicrons.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.useMicrons));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.sliceDistLabel = new JLabel("Microns between slices: ");
        this.sliceDistLabel.setForeground(Color.black);
        this.sliceDistLabel.setEnabled(false);
        p.add(this.sliceDistLabel);
        this.sliceDistance = new JTextField();
        Util.adjustTextField(this.sliceDistance);
        this.sliceDistance.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                AlignToolPanel.this.bio.toolMeasure.updateFileButtons();
            }

            public void insertUpdate(DocumentEvent e) {
                AlignToolPanel.this.bio.toolMeasure.updateFileButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                AlignToolPanel.this.bio.toolMeasure.updateFileButtons();
            }
        });
        this.sliceDistance.setEnabled(false);
        p.add(this.sliceDistance);
        this.controls.add(ToolPanel.pad(p));
        this.zAspect = new JCheckBox("Use micron information for Z-scale", true);
        this.zAspect.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AlignToolPanel.this.updateAspect(true);
            }
        });
        this.zAspect.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.zAspect));
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        this.drift = new JCheckBox("Drift correction", false);
        this.drift.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean doDrift = AlignToolPanel.this.drift.isSelected();
                AlignToolPanel.this.bio.sm.setAlignStacks(doDrift);
            }
        });
        this.drift.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.drift));
        this.driftLock = new JToggleButton("Lock size and shape", false);
        this.driftLock.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignToolPanel.this.bio.sm.align.setMode(!AlignToolPanel.this.driftLock.isSelected());
            }
        });
        this.driftLock.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.driftLock));
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.useMicrons.setEnabled(true);
            this.zAspect.setEnabled(true);
            this.bio.toolMeasure.updateFileButtons();
            this.drift.setEnabled(true);
            this.driftLock.setEnabled(true);
        } else {
            this.useMicrons.setEnabled(false);
            this.sliceDistLabel.setEnabled(false);
            this.sliceDistance.setEnabled(false);
            this.zAspect.setEnabled(false);
            this.drift.setEnabled(false);
            this.driftLock.setEnabled(true);
        }
    }

    public boolean getUseMicrons() {
        return this.useMicrons.isSelected();
    }

    public double getMicronWidth() {
        double d = Convert.getDouble(this.useMicrons.getFirstValue());
        return d <= 0.0 ? Double.NaN : d;
    }

    public double getMicronHeight() {
        double d = Convert.getDouble(this.useMicrons.getSecondValue());
        return d <= 0.0 ? Double.NaN : d;
    }

    public double getSliceDistance() {
        double d = Convert.getDouble(this.sliceDistance.getText());
        return d <= 0.0 ? Double.NaN : d;
    }

    void updateInfo(boolean microns, double mx, double my, double sd) {
        double mw = (double)this.bio.sm.res_x * mx;
        double mh = (double)this.bio.sm.res_y * my;
        if (microns) {
            this.useMicrons.setValues("" + mw, "" + mh);
        } else {
            this.useMicrons.setValues("", "");
        }
        this.sliceDistance.setText(microns ? "" + sd : "");
        this.useMicrons.setSelected(microns);
    }

    void setSliceDistance(double sd) {
        String dist = "" + sd;
        if (dist.equals(this.sliceDistance.getText())) {
            return;
        }
        this.sliceDistance.setText(dist);
    }

    void setDriftLock(boolean lock) {
        this.driftLock.setSelected(lock);
    }

    void updateAspect(boolean force) {
        boolean doAspect;
        boolean bl = doAspect = this.zAspect.isEnabled() && this.zAspect.isSelected();
        if (!doAspect && !force) {
            return;
        }
        boolean microns = this.getUseMicrons();
        double mw = this.getMicronWidth();
        double mh = this.getMicronHeight();
        double sd = this.getSliceDistance();
        if (doAspect && microns && mw == mw && mh == mh && sd == sd) {
            int slices = this.bio.sm.getNumberOfSlices();
            this.bio.setAspect(mw, mh, (double)slices * sd);
        } else if (force) {
            this.bio.setAspect(this.bio.sm.res_x, this.bio.sm.res_y, Double.NaN);
        }
    }
}

