/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.SphericalCoordinateSystem;
import visad.VisADException;
import visad.VisADGeometryArray;

public class VisADLineArray
extends VisADGeometryArray {
    private static final float LIMIT = 1.0f;
    private static final float ALPHA = 0.01f;

    public static VisADLineArray merge(VisADLineArray[] arrays) throws VisADException {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        VisADLineArray array = new VisADLineArray();
        VisADGeometryArray.merge(arrays, array);
        return array;
    }

    public VisADGeometryArray adjustSeam(DataRenderer renderer) throws VisADException {
        float limit_length;
        CoordinateSystem coord_sys = renderer.getDisplayCoordinateSystem();
        if (coord_sys == null || coord_sys instanceof SphericalCoordinateSystem || this.coordinates == null) {
            return this;
        }
        int len = this.coordinates.length / 3;
        if (len < 6) {
            return this;
        }
        float[][] cs = new float[3][len];
        int j = 0;
        int i = 0;
        while (i < len) {
            cs[0][i] = this.coordinates[j++];
            cs[1][i] = this.coordinates[j++];
            cs[2][i] = this.coordinates[j++];
            ++i;
        }
        float[][] rs = coord_sys.fromReference(cs);
        boolean[] test = new boolean[len];
        boolean any_split = false;
        if (len < 2) {
            return this;
        }
        float[][] bs = new float[3][len / 2];
        float[][] ss = new float[3][len / 2];
        float ALPHA1 = 1.01f;
        float ALPHA1m = 0.99f;
        int i2 = 0;
        while (i2 < len / 2) {
            bs[0][i2] = ALPHA1 * rs[0][2 * i2] - 0.01f * rs[0][2 * i2 + 1];
            bs[1][i2] = ALPHA1 * rs[1][2 * i2] - 0.01f * rs[1][2 * i2 + 1];
            bs[2][i2] = ALPHA1 * rs[2][2 * i2] - 0.01f * rs[2][2 * i2 + 1];
            ss[0][i2] = ALPHA1 * rs[0][2 * i2 + 1] - 0.01f * rs[0][2 * i2];
            ss[1][i2] = ALPHA1 * rs[1][2 * i2 + 1] - 0.01f * rs[1][2 * i2];
            ss[2][i2] = ALPHA1 * rs[2][2 * i2 + 1] - 0.01f * rs[2][2 * i2];
            ++i2;
        }
        float[][] ds = coord_sys.toReference(bs);
        float[][] es = coord_sys.toReference(ss);
        float IALPHA = 100.0f;
        int i3 = 0;
        while (i3 < len) {
            float a0 = cs[0][i3 + 1] - cs[0][i3];
            float a1 = cs[1][i3 + 1] - cs[1][i3];
            float a2 = cs[2][i3 + 1] - cs[2][i3];
            float b0 = IALPHA * (cs[0][i3] - ds[0][i3 / 2]);
            float b1 = IALPHA * (cs[1][i3] - ds[1][i3 / 2]);
            float b2 = IALPHA * (cs[2][i3] - ds[2][i3 / 2]);
            float aa = a0 * a0 + a1 * a1 + a2 * a2;
            float aminusb = (b0 - a0) * (b0 - a0) + (b1 - a1) * (b1 - a1) + (b2 - a2) * (b2 - a2);
            float abratio = aminusb / aa;
            float c0 = IALPHA * (cs[0][i3 + 1] - es[0][i3 / 2]);
            float c1 = IALPHA * (cs[1][i3 + 1] - es[1][i3 / 2]);
            float c2 = IALPHA * (cs[2][i3 + 1] - es[2][i3 / 2]);
            float aminusc = (c0 + a0) * (c0 + a0) + (c1 + a1) * (c1 + a1) + (c2 + a2) * (c2 + a2);
            float acratio = aminusc / aa;
            boolean bl = test[i3] = 0.01f < abratio || 0.01f < acratio;
            if (test[i3]) {
                any_split = true;
            }
            i3 += 2;
        }
        bs = null;
        ss = null;
        if (!any_split) {
            return this;
        }
        float[] lengths = new float[len];
        int i4 = 0;
        while (i4 < len) {
            lengths[i4] = 0.0f;
            ++i4;
        }
        float mean_length = 0.0f;
        float var_length = 0.0f;
        float max_length = 0.0f;
        int num_length = 0;
        int i5 = 0;
        while (i5 < len) {
            float cd = (cs[0][i5 + 1] - cs[0][i5]) * (cs[0][i5 + 1] - cs[0][i5]) + (cs[1][i5 + 1] - cs[1][i5]) * (cs[1][i5 + 1] - cs[1][i5]) + (cs[2][i5 + 1] - cs[2][i5]) * (cs[2][i5 + 1] - cs[2][i5]);
            if (!test[i5]) {
                lengths[i5] = cd;
                ++num_length;
                mean_length += lengths[i5];
                var_length += lengths[i5] * lengths[i5];
                if (lengths[i5] > max_length) {
                    max_length = lengths[i5];
                }
            }
            i5 += 2;
        }
        if (num_length < 2) {
            return this;
        }
        if (max_length >= (limit_length = (mean_length /= (float)num_length) + 1.0f * (var_length = (float)Math.sqrt((var_length - mean_length * mean_length) / (float)num_length)))) {
            int i6 = 0;
            while (i6 < len) {
                test[i6] = test[i6] || lengths[i6] > limit_length;
                i6 += 2;
            }
        }
        cs = null;
        rs = null;
        Object lastcoord = null;
        Object lastcol = null;
        VisADLineArray array = new VisADLineArray();
        float[] coords = new float[3 * this.coordinates.length];
        int color_length = 0;
        byte[] cols = null;
        if (this.colors != null) {
            color_length = 3;
            cols = new byte[3 * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        int ki = 0;
        int kj = 0;
        j = 0;
        int i7 = 0;
        while (i7 < 3 * len) {
            if (!test[i7 / 3]) {
                coords[ki] = this.coordinates[i7];
                coords[ki + 1] = this.coordinates[i7 + 1];
                coords[ki + 2] = this.coordinates[i7 + 2];
                coords[ki + 3] = this.coordinates[i7 + 3];
                coords[ki + 4] = this.coordinates[i7 + 4];
                coords[ki + 5] = this.coordinates[i7 + 5];
                ki += 6;
                if (color_length == 3) {
                    cols[kj] = this.colors[j];
                    cols[kj + 1] = this.colors[j + 1];
                    cols[kj + 2] = this.colors[j + 2];
                    cols[kj + 3] = this.colors[j + 3];
                    cols[kj + 4] = this.colors[j + 4];
                    cols[kj + 5] = this.colors[j + 5];
                    kj += 6;
                } else if (color_length == 4) {
                    cols[kj] = this.colors[j];
                    cols[kj + 1] = this.colors[j + 1];
                    cols[kj + 2] = this.colors[j + 2];
                    cols[kj + 3] = this.colors[j + 3];
                    cols[kj + 4] = this.colors[j + 4];
                    cols[kj + 5] = this.colors[j + 5];
                    cols[kj + 6] = this.colors[j + 6];
                    cols[kj + 7] = this.colors[j + 7];
                    kj += 8;
                }
            } else {
                any_split = true;
            }
            j += 2 * color_length;
            i7 += 6;
        }
        if (!any_split) {
            return this;
        }
        array.vertexCount = ki / 3;
        array.coordinates = new float[ki];
        System.arraycopy(coords, 0, array.coordinates, 0, ki);
        if (this.colors != null) {
            array.colors = new byte[kj];
            System.arraycopy(cols, 0, array.colors, 0, kj);
        }
        return array;
    }

    public Object clone() {
        VisADLineArray array = new VisADLineArray();
        this.copy(array);
        return array;
    }
}

