/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Vector;
import visad.DisplayException;
import visad.VisADSceneGraphObject;

public class VisADGroup
extends VisADSceneGraphObject {
    private Vector children = new Vector();

    public synchronized void addChild(VisADSceneGraphObject child) throws DisplayException {
        if (child == null) {
            return;
        }
        VisADSceneGraphObject visADSceneGraphObject = child;
        synchronized (visADSceneGraphObject) {
            if (child.parent != null) {
                throw new DisplayException("VisADGroup.addChild: already has parent");
            }
            this.children.addElement(child);
            child.parent = this;
        }
    }

    public synchronized int numChildren() {
        return this.children.size();
    }

    public synchronized VisADSceneGraphObject getChild(int index) {
        return (VisADSceneGraphObject)this.children.elementAt(index);
    }

    public synchronized void setChild(VisADSceneGraphObject child, int index) throws DisplayException {
        if (child == null) {
            return;
        }
        VisADSceneGraphObject visADSceneGraphObject = child;
        synchronized (visADSceneGraphObject) {
            if (child.parent != null) {
                throw new DisplayException("VisADGroup.setChild: already has parent");
            }
            VisADSceneGraphObject c = null;
            if (this.children.size() > index) {
                c = (VisADSceneGraphObject)this.children.elementAt(index);
                if (c != null) {
                    VisADSceneGraphObject visADSceneGraphObject2 = c;
                    synchronized (visADSceneGraphObject2) {
                        c.parent = null;
                        this.children.setElementAt(child, index);
                    }
                }
                this.children.setElementAt(child, index);
            } else {
                this.children.addElement(child);
            }
            child.parent = this;
        }
    }

    public synchronized void removeChild(int index) {
        VisADSceneGraphObject c = (VisADSceneGraphObject)this.children.elementAt(index);
        if (c != null) {
            VisADSceneGraphObject visADSceneGraphObject = c;
            synchronized (visADSceneGraphObject) {
                c.parent = null;
                this.children.removeElementAt(index);
            }
        }
    }

    void detachChild(VisADSceneGraphObject child) {
        this.children.removeElement(child);
    }

    public synchronized Vector getChildren() {
        return (Vector)this.children.clone();
    }

    public String toString() {
        String s = this.getClass().getName() + " ";
        Vector vector = this.children;
        synchronized (vector) {
            int n = this.children.size();
            s = s + n + " ";
            int i = 0;
            while (i < n) {
                s = s + this.children.elementAt(i).toString();
                ++i;
            }
        }
        return s;
    }
}

