/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.Field;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.Text;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.VisADError;
import visad.VisADException;

public class Tuple
extends DataImpl
implements TupleIface {
    Data[] tupleComponents;

    public Tuple(TupleType type) {
        super(type);
        if (type instanceof RealTupleType && !(this instanceof RealTuple)) {
            throw new VisADError("must construct as RealTupleType");
        }
    }

    public Tuple(TupleType type, Data[] datums) throws VisADException, RemoteException {
        this(type, datums, true);
    }

    public Tuple(TupleType type, Data[] datums, boolean copy) throws VisADException, RemoteException {
        super(type);
        if (!Tuple.checkTupleType(type, datums)) {
            throw new TypeException("Tuple: type does not match data");
        }
        if (type instanceof RealTupleType && !(this instanceof RealTuple)) {
            throw new TypeException("must construct as RealTupleType");
        }
        int n = datums.length;
        this.tupleComponents = new Data[n];
        int i = 0;
        while (i < n) {
            this.tupleComponents[i] = copy ? (Data)datums[i].dataClone() : datums[i];
            if (this.tupleComponents[i] instanceof DataImpl) {
                ((DataImpl)this.tupleComponents[i]).setParent(this);
            }
            ++i;
        }
    }

    public Tuple(Data[] datums, boolean copy) throws VisADException, RemoteException {
        this(Tuple.buildTupleType(datums), datums, copy);
    }

    public Tuple(Data[] datums) throws VisADException, RemoteException {
        this(Tuple.buildTupleType(datums), datums, true);
    }

    public static Tuple makeTuple(Data[] datums) throws VisADException, RemoteException {
        return new Tuple(datums);
    }

    static boolean checkTupleType(TupleType type, Data[] datums) throws VisADException, RemoteException {
        if (datums == null || type == null) {
            return false;
        }
        int n = datums.length;
        if (n != type.getDimension()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (!type.getComponent(i).equals(datums[i].getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static TupleType buildTupleType(Data[] datums) throws VisADException, RemoteException {
        if (datums == null) {
            throw new TypeException("Tuple: # components must be > 0");
        }
        int n = datums.length;
        if (n < 1) {
            throw new TypeException("Tuple: # components must be > 0");
        }
        MathType[] types = new MathType[n];
        boolean allReal = true;
        int i = 0;
        while (i < n) {
            types[i] = datums[i].getType();
            if (!(types[i] instanceof RealType)) {
                allReal = false;
            }
            ++i;
        }
        if (allReal) {
            RealType[] real_types = new RealType[n];
            int i2 = 0;
            while (i2 < n) {
                real_types[i2] = (RealType)types[i2];
                ++i2;
            }
            return new RealTupleType(real_types);
        }
        return new TupleType(types);
    }

    public Real[] getRealComponents() throws VisADException, RemoteException {
        if (this.tupleComponents == null) {
            return null;
        }
        Vector<Data> reals = new Vector<Data>();
        int i = 0;
        while (i < this.tupleComponents.length) {
            if (this.tupleComponents[i] instanceof Real) {
                reals.addElement(this.tupleComponents[i]);
            } else if (this.tupleComponents[i] instanceof RealTuple) {
                RealTuple rt = (RealTuple)this.tupleComponents[i];
                int j = 0;
                while (j < rt.getDimension()) {
                    reals.addElement(rt.getComponent(j));
                    ++j;
                }
            }
            ++i;
        }
        if (reals.size() == 0) {
            return null;
        }
        Real[] realComponents = new Real[reals.size()];
        int i2 = 0;
        while (i2 < reals.size()) {
            realComponents[i2] = (Real)reals.elementAt(i2);
            ++i2;
        }
        return realComponents;
    }

    public Data[] getComponents() {
        return this.tupleComponents;
    }

    public int getDimension() {
        if (this.tupleComponents != null) {
            return this.tupleComponents.length;
        }
        return ((TupleType)this.getType()).getDimension();
    }

    public Data getComponent(int i) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return ((TupleType)this.Type).getComponent(i).missingData();
        }
        if (0 <= i && i < this.tupleComponents.length) {
            return this.tupleComponents[i];
        }
        throw new TypeException("Tuple: component index out of range");
    }

    public boolean isMissing() {
        return this.tupleComponents == null;
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof RealTuple) {
            throw new TypeException("Tuple.binary: types don't match");
        }
        if (data instanceof Tuple) {
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("Tuple.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException();
            }
            if (this.isMissing() || data.isMissing()) {
                return new Tuple((TupleType)new_type);
            }
            Data[] datums = new Data[this.tupleComponents.length];
            int j = 0;
            while (j < this.tupleComponents.length) {
                MathType m_type = ((TupleType)new_type).getComponent(j);
                datums[j] = this.tupleComponents[j].binary(((Tuple)data).getComponent(j), op, m_type, sampling_mode, error_mode);
                ++j;
            }
            return new Tuple(datums);
        }
        if (data instanceof Real) {
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException();
            }
            if (this.isMissing() || data.isMissing()) {
                return new Tuple((TupleType)new_type);
            }
            Data[] datums = new Data[this.tupleComponents.length];
            int j = 0;
            while (j < this.tupleComponents.length) {
                MathType m_type = ((TupleType)new_type).getComponent(j);
                datums[j] = this.tupleComponents[j].binary(data, op, m_type, sampling_mode, error_mode);
                ++j;
            }
            return new Tuple(datums);
        }
        if (data instanceof Text) {
            throw new TypeException("Tuple.binary: types don't match");
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(new_type)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(op), new_type, sampling_mode, error_mode);
        }
        throw new TypeException("Tuple.binary");
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(new_type)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        TupleType T_type = (TupleType)new_type;
        if (this.isMissing()) {
            return new Tuple((TupleType)new_type);
        }
        Data[] datums = new Data[this.tupleComponents.length];
        int j = 0;
        while (j < this.tupleComponents.length) {
            datums[j] = this.tupleComponents[j].unary(op, T_type.getComponent(j), sampling_mode, error_mode);
            ++j;
        }
        return new Tuple(datums);
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return shadow;
        }
        int i = 0;
        while (i < this.tupleComponents.length) {
            shadow = this.tupleComponents[i].computeRanges(((ShadowTupleType)type).getComponent(i), shadow);
            ++i;
        }
        return shadow;
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        if (this.isMissing() || error == null || error.isMissing()) {
            return this;
        }
        int n = this.tupleComponents.length;
        Data[] newComponents = new Data[n];
        int i = 0;
        while (i < n) {
            Data errorComponent = ((Tuple)error).getComponent(i);
            newComponents[i] = this.tupleComponents[i].adjustSamplingError(errorComponent, error_mode);
            ++i;
        }
        return new Tuple(newComponents);
    }

    public Data __getitem__(int index) throws VisADException, RemoteException {
        return this.getComponent(index);
    }

    public int __len__() {
        return this.getDimension();
    }

    public int getLength() {
        return this.getDimension();
    }

    public Object clone() {
        Tuple tuple;
        try {
            if (this.tupleComponents == null) {
                tuple = new Tuple((TupleType)this.getType());
            } else {
                int n = this.tupleComponents.length;
                Data[] datums = new Data[n];
                int i = 0;
                while (i < n) {
                    datums[i] = (Data)this.tupleComponents[i].dataClone();
                    ++i;
                }
                tuple = new Tuple(datums);
            }
        }
        catch (VisADException e) {
            throw new VisADError("Tuple.clone: VisADException occurred");
        }
        catch (RemoteException e) {
            throw new VisADError("Tuple.clone: RemoteException occurred");
        }
        return tuple;
    }

    public String longString(String pre) throws VisADException, RemoteException {
        String s = pre + "Tuple\n" + pre + "  Type: " + this.Type.toString() + "\n";
        if (this.isMissing()) {
            return s + "  missing\n";
        }
        int i = 0;
        while (i < this.tupleComponents.length) {
            s = s + pre + "  Tuple Component " + i + ":\n" + this.tupleComponents[i].longString(pre + "    ");
            ++i;
        }
        return s;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (!(obj instanceof Tuple)) {
            equals = false;
        } else {
            Tuple that = (Tuple)obj;
            if (this == that) {
                equals = true;
            } else if (this.tupleComponents == null || that.tupleComponents == null) {
                equals = this.tupleComponents == that.tupleComponents;
            } else if (this.tupleComponents.length != that.tupleComponents.length) {
                equals = false;
            } else {
                equals = true;
                int i = 0;
                while (i < this.tupleComponents.length) {
                    if (!this.tupleComponents[i].equals(that.tupleComponents[i])) {
                        equals = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.tupleComponents != null) {
            int i = 0;
            while (i < this.tupleComponents.length) {
                hashCode ^= this.tupleComponents[i].hashCode();
                ++i;
            }
        }
        return hashCode;
    }
}

