/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Stream2D {
    static float LENGTH = 0.015f;

    static void stream_trace(float[] ugrid, float[] vgrid, int nr, int nc, float dir, float[][] vr2, float[][] vc2, int[] numv, byte[] markarrow, byte[] markstart, byte[] markend, int nrarrow, int ncarrow, int nrstart, int ncstart, int nrend, int ncend, float row, float col, float step, float rowlength, float collength, int irend, int icend, Gridded2DSet spatial_set, float[][] spatial_values) throws VisADException {
        int num = numv[0];
        int nend = 0;
        float[] vr = vr2[0];
        float[] vc = vc2[0];
        while (true) {
            int ira;
            int ica;
            int ir = (int)row;
            int ic = (int)col;
            float a = row - (float)ir;
            float c = col - (float)ic;
            float ac = a * c;
            float ad = a * (1.0f - c);
            float bc = (1.0f - a) * c;
            float bd = (1.0f - a) * (1.0f - c);
            float ubd = ugrid[ir * nc + ic];
            float ubc = ugrid[ir * nc + ic + 1];
            float uad = ugrid[(ir + 1) * nc + ic];
            float uac = ugrid[(ir + 1) * nc + (ic + 1)];
            float vbd = vgrid[ir * nc + ic];
            float vbc = vgrid[ir * nc + (ic + 1)];
            float vad = vgrid[(ir + 1) * nc + ic];
            float vac = vgrid[(ir + 1) * nc + (ic + 1)];
            if (ubd != ubd || ubc != ubc || uad != uad || uac != uac || vbd != vbd || vbc != vbc || vad != vad || vac != vac) break;
            float u = bd * ubd + bc * ubc + ad * uad + ac * uac;
            float v = bd * vbd + bc * vbc + ad * vad + ac * vac;
            float prevrow = row;
            float prevcol = col;
            float[][] loc = spatial_set.gridToValue(new float[][]{{prevcol}, {prevrow}});
            float[] fArray = loc[1];
            fArray[0] = fArray[0] + step * dir * v;
            float[] fArray2 = loc[0];
            fArray2[0] = fArray2[0] + step * dir * u;
            float[][] grid = spatial_set.valueToGrid(loc);
            row = grid[1][0];
            col = grid[0][0];
            if (row < 0.0f || col < 0.0f || row >= (float)(nr - 1) || col >= (float)(nc - 1)) break;
            int ire = (int)((double)((float)nrend * row) / ((double)nr - 1.0));
            int ice = (int)((double)((float)ncend * col) / ((double)nc - 1.0));
            if (ire != irend || ice != icend) {
                icend = ice;
                irend = ire;
                if (markend[icend * nrend + irend] == 1) break;
                markend[icend * nrend + irend] = 1;
                nend = 0;
            }
            if (++nend > 100) break;
            if (num >= vr.length - 4) {
                float[] tmp = new float[vr.length + 50];
                System.arraycopy(vr, 0, tmp, 0, vr.length);
                vr = tmp;
                tmp = new float[vc.length + 50];
                System.arraycopy(vc, 0, tmp, 0, vc.length);
                vc = tmp;
            }
            vr[num] = prevrow;
            vc[num++] = prevcol;
            vr[num] = row;
            vc[num++] = col;
            int ics = (int)((double)((float)ncstart * col) / ((double)nc - 1.0));
            int irs = (int)((double)((float)nrstart * row) / ((double)nr - 1.0));
            if (markstart[ics * nrstart + irs] == 0) {
                markstart[ics * nrstart + irs] = 1;
            }
            if (markarrow[(ica = (int)((double)((float)ncarrow * col) / ((double)nc - 1.0))) * nrstart + (ira = (int)((double)((float)nrarrow * row) / ((double)nr - 1.0)))] != 0) continue;
            markarrow[ica * nrstart + ira] = 1;
            double rv = dir * (row - prevrow);
            double cv = dir * (col - prevcol);
            double vl = Math.sqrt(rv * rv + cv * cv);
            if (vl > 1.0E-9) {
                rv /= vl;
                cv /= vl;
            }
            if (num >= vr.length - 6) {
                float[] tmp = new float[vr.length + 50];
                System.arraycopy(vr, 0, tmp, 0, vr.length);
                vr = tmp;
                tmp = new float[vc.length + 50];
                System.arraycopy(vc, 0, tmp, 0, vc.length);
                vc = tmp;
            }
            vr[num] = row;
            vc[num++] = col;
            vr[num] = row - (float)(rv + cv) * rowlength;
            vc[num++] = col + (float)(rv - cv) * collength;
            vr[num] = row;
            vc[num++] = col;
            vr[num] = row + (float)(cv - rv) * rowlength;
            vc[num++] = col - (float)(cv + rv) * collength;
        }
        numv[0] = num;
        vr2[0] = vr;
        vc2[0] = vc;
    }

    static int stream(float[] ugrid, float[] vgrid, int nr, int nc, float density, float stepFactor, float arrowScale, float[][][] vr, float[][][] vc, int[][] numv, int[] numl, Gridded2DSet spatial_set) throws VisADException {
        int n_lines = 0;
        int[] num = new int[1];
        if ((double)density < 0.5) {
            density = 0.5f;
        }
        if ((double)density > 2.0) {
            density = 2.0f;
        }
        int nrarrow = (int)(15.0f * density);
        int ncarrow = (int)(15.0f * density);
        int nrstart = (int)(15.0f * density);
        int ncstart = (int)(15.0f * density);
        int nrend = 4 * nrstart;
        int ncend = 4 * ncstart;
        float rowlength = LENGTH * (float)nr / density;
        float collength = LENGTH * (float)nc / density;
        rowlength *= arrowScale;
        collength *= arrowScale;
        numv[0] = new int[50];
        vr[0] = new float[50][];
        vc[0] = new float[50][];
        byte[] markarrow = new byte[nrstart * ncstart];
        byte[] markstart = new byte[nrstart * ncstart];
        byte[] markend = new byte[nrend * ncend];
        int kk = 0;
        while (kk < nrstart * ncstart) {
            markstart[kk] = 0;
            markarrow[kk] = 1;
            ++kk;
        }
        int kk2 = 0;
        while (kk2 < nrend * ncend) {
            markend[kk2] = 0;
            ++kk2;
        }
        int ir = 1;
        while (ir < nrarrow) {
            int ic = 1;
            while (ic < ncarrow) {
                markarrow[ic * nrarrow + ir] = 0;
                ic += 3;
            }
            ir += 3;
        }
        float umax = Float.MIN_VALUE;
        float vmax = Float.MIN_VALUE;
        int kk3 = 0;
        while (kk3 < ugrid.length) {
            if (ugrid[kk3] > umax) {
                umax = ugrid[kk3];
            }
            if (vgrid[kk3] > vmax) {
                vmax = vgrid[kk3];
            }
            ++kk3;
        }
        float smax = (float)Math.sqrt(umax * umax + vmax * vmax);
        float[][] spatial_values = spatial_set.getSamples(false);
        int[] lens = spatial_set.getLengths();
        int lenX = lens[0];
        float dist_x = Math.abs(spatial_values[0][lenX + 1] - spatial_values[0][0]);
        float dist_y = Math.abs(spatial_values[1][lenX + 1] - spatial_values[1][0]);
        float dist = (dist_x + dist_y) / 2.0f;
        float step = stepFactor * (dist / smax);
        int icstart = 0;
        while (icstart < ncstart) {
            int irstart = 0;
            while (irstart < nrstart) {
                if (markstart[icstart * nrstart + irstart] == 0) {
                    float[] ftmp;
                    int[] tmp;
                    markstart[icstart * nrstart + irstart] = 1;
                    float row = ((float)nr - 1.0f) * ((float)irstart + 0.5f) / (float)nrstart;
                    float col = ((float)nc - 1.0f) * ((float)icstart + 0.5f) / (float)ncstart;
                    int irend = (int)((float)nrend * row / ((float)nr - 1.0f));
                    int icend = (int)((float)ncend * col / ((float)nc - 1.0f));
                    markend[icend * nrend + irend] = 1;
                    if (n_lines == vr[0].length) {
                        float[][] f_tmp = new float[vr[0].length + 50][];
                        System.arraycopy(vr[0], 0, f_tmp, 0, vr[0].length);
                        vr[0] = f_tmp;
                        f_tmp = new float[vc[0].length + 50][];
                        System.arraycopy(vc[0], 0, f_tmp, 0, vc[0].length);
                        vc[0] = f_tmp;
                    }
                    float[][] vr2 = new float[1][];
                    float[][] vc2 = new float[1][];
                    vr2[0] = new float[200];
                    vc2[0] = new float[200];
                    vr[0][n_lines] = vr2[0];
                    vc[0][n_lines] = vc2[0];
                    float dir = 1.0f;
                    num[0] = 0;
                    Stream2D.stream_trace(ugrid, vgrid, nr, nc, dir, vr2, vc2, num, markarrow, markstart, markend, nrarrow, ncarrow, nrstart, ncstart, nrend, ncend, row, col, step, rowlength, collength, irend, icend, spatial_set, spatial_values);
                    vr[0][n_lines] = vr2[0];
                    vc[0][n_lines] = vc2[0];
                    if (num[0] > 0) {
                        if (n_lines == numv[0].length) {
                            tmp = new int[numv[0].length + 50];
                            System.arraycopy(numv[0], 0, tmp, 0, numv[0].length);
                            numv[0] = tmp;
                        }
                        ftmp = new float[num[0]];
                        System.arraycopy(vr[0][n_lines], 0, ftmp, 0, ftmp.length);
                        vr[0][n_lines] = ftmp;
                        ftmp = new float[num[0]];
                        System.arraycopy(vc[0][n_lines], 0, ftmp, 0, ftmp.length);
                        vc[0][n_lines] = ftmp;
                        numv[0][n_lines] = num[0];
                        ++n_lines;
                    }
                    markend[icend * nrend + irend] = 1;
                    if (n_lines == vr[0].length) {
                        float[][] f_tmp = new float[vr[0].length + 50][];
                        System.arraycopy(vr[0], 0, f_tmp, 0, vr[0].length);
                        vr[0] = f_tmp;
                        f_tmp = new float[vc[0].length + 50][];
                        System.arraycopy(vc[0], 0, f_tmp, 0, vc[0].length);
                        vc[0] = f_tmp;
                    }
                    vr2 = new float[1][];
                    vc2 = new float[1][];
                    vr2[0] = new float[200];
                    vc2[0] = new float[200];
                    vr[0][n_lines] = vr2[0];
                    vc[0][n_lines] = vc2[0];
                    dir = -1.0f;
                    num[0] = 0;
                    Stream2D.stream_trace(ugrid, vgrid, nr, nc, dir, vr2, vc2, num, markarrow, markstart, markend, nrarrow, ncarrow, nrstart, ncstart, nrend, ncend, row, col, step, rowlength, collength, irend, icend, spatial_set, spatial_values);
                    vr[0][n_lines] = vr2[0];
                    vc[0][n_lines] = vc2[0];
                    if (num[0] > 0) {
                        if (n_lines == numv[0].length) {
                            tmp = new int[numv[0].length + 50];
                            System.arraycopy(numv[0], 0, tmp, 0, numv[0].length);
                            numv[0] = tmp;
                        }
                        ftmp = new float[num[0]];
                        System.arraycopy(vr[0][n_lines], 0, ftmp, 0, ftmp.length);
                        vr[0][n_lines] = ftmp;
                        ftmp = new float[num[0]];
                        System.arraycopy(vc[0][n_lines], 0, ftmp, 0, ftmp.length);
                        vc[0][n_lines] = ftmp;
                        numv[0][n_lines] = num[0];
                        ++n_lines;
                    }
                }
                ++irstart;
            }
            ++icstart;
        }
        int[] tmp = new int[n_lines];
        System.arraycopy(numv[0], 0, tmp, 0, n_lines);
        numv[0] = tmp;
        numl[0] = n_lines;
        return 1;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int nr = 50;
        int nc = 50;
        DisplayImplJ3D dpy = new DisplayImplJ3D("display");
        RealType u_wind = RealType.getRealType("u_wind");
        RealType v_wind = RealType.getRealType("v_wind");
        RealTupleType uv = new RealTupleType(u_wind, v_wind);
        FunctionType f_type = new FunctionType(RealTupleType.SpatialCartesian2DTuple, uv);
        Integer2DSet d_set = new Integer2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, nr, nc);
        FlatField uv_field = new FlatField(f_type, d_set);
        float[][] uv_values = new float[2][nr * nc];
        double ang = Math.PI * 2 / (double)nr;
        int jj = 0;
        while (jj < nc) {
            int ii = 0;
            while (ii < nr) {
                int idx = jj * nr + ii;
                uv_values[0][idx] = 5.0f + -20.0f * (float)Math.cos(0.5 * ang * (double)ii);
                uv_values[1][idx] = -10.0f * (float)Math.cos(0.5 * ang * (double)ii);
                ++ii;
            }
            ++jj;
        }
        uv_field.setSamples(uv_values, false);
        int[] numl = new int[1];
        int maxv = 1000;
        int max_lines = 100;
        int[][] n_verts = new int[1][];
        float[][][] vr = new float[1][max_lines][maxv];
        float[][][] vc = new float[1][max_lines][maxv];
        Stream2D.stream(uv_values[0], uv_values[1], nr, nc, 1.0f, 1.0f, 1.0f, vr, vc, n_verts, numl, null);
        ScalarMap xmap = new ScalarMap(RealType.XAxis, Display.XAxis);
        ScalarMap ymap = new ScalarMap(RealType.YAxis, Display.YAxis);
        dpy.addMap(xmap);
        dpy.addMap(ymap);
        ScalarMap flowx = new ScalarMap(u_wind, Display.Flow1X);
        ScalarMap flowy = new ScalarMap(v_wind, Display.Flow1Y);
        dpy.addMap(flowx);
        dpy.addMap(flowy);
        FlowControl flow_cntrl = (FlowControl)flowx.getControl();
        flow_cntrl.setFlowScale(0.04f);
        flow_cntrl = (FlowControl)flowy.getControl();
        flow_cntrl.setFlowScale(0.04f);
        DataReferenceImpl ref = new DataReferenceImpl("wind");
        ref.setData(uv_field);
        dpy.addReference(ref);
        SampledSet[] gsets = new Gridded2DSet[numl[0]];
        int s_idx = 0;
        while (s_idx < numl[0]) {
            float[][] strm_values = new float[2][n_verts[0][s_idx]];
            System.arraycopy(vc[0][s_idx], 0, strm_values[0], 0, n_verts[0][s_idx]);
            System.arraycopy(vr[0][s_idx], 0, strm_values[1], 0, n_verts[0][s_idx]);
            gsets[s_idx] = new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, strm_values, n_verts[0][s_idx]);
            ++s_idx;
        }
        UnionSet uset = new UnionSet(gsets);
        DataReferenceImpl strm_ref = new DataReferenceImpl("stream");
        strm_ref.setData(uset);
        ConstantMap[] strm_cm = new ConstantMap[]{new ConstantMap(0.1, Display.Red), new ConstantMap(0.8, Display.Green), new ConstantMap(0.1, Display.Blue), new ConstantMap(1.5, Display.LineWidth)};
        dpy.addReference(strm_ref, strm_cm);
        JFrame jframe = new JFrame();
        jframe.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        jframe.setContentPane((JPanel)dpy.getComponent());
        ((Component)jframe).setVisible(true);
    }
}

