/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.IntegerSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SetException;
import visad.SetIface;
import visad.SetType;
import visad.ShadowType;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADGeometryArray;

public abstract class Set
extends DataImpl
implements SetIface {
    int DomainDimension;
    int Length = 0;
    CoordinateSystem DomainCoordinateSystem;
    boolean hashCodeSet = false;
    int hashCode = 0;
    Unit[] SetUnits;
    ErrorEstimate[] SetErrors;

    public Set(MathType type) throws VisADException {
        this(type, null, null, null);
    }

    public Set(MathType type, CoordinateSystem coord_sys) throws VisADException {
        this(type, coord_sys, null, null);
    }

    public Set(MathType type, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(Set.adjustType(type));
        this.DomainDimension = Set.getDimension(type);
        RealTupleType DomainType = ((SetType)this.Type).getDomain();
        CoordinateSystem cs = DomainType.getCoordinateSystem();
        if (coord_sys == null) {
            this.DomainCoordinateSystem = cs;
        } else {
            if (cs == null || !cs.getReference().equals(coord_sys.getReference())) {
                throw new CoordinateSystemException("Set: coord_sys " + coord_sys.getReference() + " must match Type.DefaultCoordinateSystem " + (cs == null ? null : cs.getReference()));
            }
            this.DomainCoordinateSystem = coord_sys;
        }
        if (this.DomainCoordinateSystem != null && !Unit.canConvertArray(this.DomainCoordinateSystem.getCoordinateSystemUnits(), DomainType.getDefaultUnits())) {
            throw new UnitException("Set: CoordinateSystem Units must be convertable with DomainType default Units");
        }
        if (units == null) {
            this.SetUnits = this.DomainCoordinateSystem == null ? DomainType.getDefaultUnits() : this.DomainCoordinateSystem.getCoordinateSystemUnits();
        } else {
            if (units.length != this.DomainDimension) {
                throw new UnitException("Set: units dimension " + units.length + " does not match Domain dimension " + this.DomainDimension);
            }
            this.SetUnits = new Unit[this.DomainDimension];
            Unit[] dunits = DomainType.getDefaultUnits();
            int i = 0;
            while (i < this.DomainDimension) {
                this.SetUnits[i] = units[i] == null && dunits[i] != null ? dunits[i] : (((RealType)DomainType.getComponent(i)).isInterval() ? units[i].getAbsoluteUnit() : units[i]);
                ++i;
            }
        }
        if (!Unit.canConvertArray(this.SetUnits, DomainType.getDefaultUnits())) {
            throw new UnitException("Set: Actual units not convertable with DomainType default units ");
        }
        if (this.SetUnits == null) {
            this.SetUnits = new Unit[this.DomainDimension];
        }
        this.SetErrors = new ErrorEstimate[this.DomainDimension];
        if (errors != null) {
            if (errors.length != this.DomainDimension) {
                throw new SetException("Set: errors dimension " + errors.length + " does not match Domain dimension " + this.DomainDimension);
            }
            int i = 0;
            while (i < this.DomainDimension) {
                this.SetErrors[i] = errors[i];
                ++i;
            }
        }
    }

    static int getDimension(MathType type) throws VisADException {
        if (type instanceof SetType) {
            return ((SetType)type).getDomain().getDimension();
        }
        if (type instanceof RealTupleType) {
            return ((RealTupleType)type).getDimension();
        }
        if (type instanceof RealType) {
            return 1;
        }
        throw new TypeException("Set: Type must be SetType or RealTupleType, not " + type.getClass().getName());
    }

    static MathType adjustType(MathType type) throws VisADException {
        if (type instanceof SetType) {
            return type;
        }
        if (type instanceof RealTupleType) {
            return new SetType(type);
        }
        if (type instanceof RealType) {
            return new SetType(type);
        }
        throw new TypeException("Set: Type must be SetType, RealTupleType or RealType, not " + type.getClass().getName());
    }

    public Unit[] getSetUnits() {
        return Unit.copyUnitsArray(this.SetUnits);
    }

    public ErrorEstimate[] getSetErrors() {
        return ErrorEstimate.copyErrorsArray(this.SetErrors);
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.DomainCoordinateSystem;
    }

    public int getDimension() {
        return this.DomainDimension;
    }

    public int getManifoldDimension() {
        return this.DomainDimension;
    }

    public int getLength() throws VisADException {
        return this.Length;
    }

    public int __len__() throws VisADException {
        return this.Length;
    }

    public int[] getWedge() {
        int[] wedge = new int[this.Length];
        int i = 0;
        while (i < this.Length) {
            wedge[i] = i;
            ++i;
        }
        return wedge;
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        int n = this.getLength();
        int[] indices = new int[n];
        int i = 0;
        while (i < n) {
            indices[i] = i;
            ++i;
        }
        return this.indexToValue(indices);
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        return Set.floatToDouble(this.getSamples(true));
    }

    public void cram_missing(boolean[] range_select) {
    }

    public abstract float[][] indexToValue(int[] var1) throws VisADException;

    public abstract int[] valueToIndex(float[][] var1) throws VisADException;

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        return this.computeRanges(type, shadow, null, false);
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow, double[][] ranges, boolean domain) throws VisADException {
        this.setAnimationSampling(type, shadow, domain);
        return shadow;
    }

    void setAnimationSampling(ShadowType type, DataShadow shadow, boolean domain) throws VisADException {
    }

    public Set merge1DSets(Set set) throws VisADException {
        int i;
        if (this.DomainDimension != 1 || set.getDimension() != 1 || this.equals(set)) {
            return this;
        }
        int length = this.getLength();
        int[] indices = this.getWedge();
        double[][] old_values = this.indexToDouble(indices);
        ErrorEstimate[] errors_out = new ErrorEstimate[1];
        double[][] values = CoordinateSystem.transformCoordinates(((SetType)set.getType()).getDomain(), set.getCoordinateSystem(), set.getSetUnits(), null, ((SetType)this.Type).getDomain(), this.DomainCoordinateSystem, this.SetUnits, null, old_values);
        int set_length = set.getLength();
        boolean[] set_indices = new boolean[set_length];
        int i2 = 0;
        while (i2 < set_length) {
            set_indices[i2] = true;
            ++i2;
        }
        if (set_length > 1) {
            int[] test_indices = set.doubleToIndex(values);
            try {
                int i3 = 0;
                while (i3 < length) {
                    if (test_indices[i3] > -1) {
                        set_indices[test_indices[i3]] = false;
                    }
                    ++i3;
                }
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new VisADException("Cannot merge sets");
            }
        } else {
            double[][] set_values = set.getDoubles();
            double set_val = set_values[0][0];
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            i = 0;
            while (i < length) {
                if (values[0][i] > max) {
                    max = values[0][i];
                }
                if (values[0][i] < min) {
                    min = values[0][i];
                }
                ++i;
            }
            double delt = (max - min) / (double)length;
            if (min - delt < set_val && set_val < max + delt) {
                set_indices[0] = false;
            }
        }
        int num_new = 0;
        int i4 = 0;
        while (i4 < set_length) {
            if (set_indices[i4]) {
                ++num_new;
            }
            ++i4;
        }
        if (num_new == 0) {
            return this;
        }
        int[] new_indices = new int[num_new];
        num_new = 0;
        int i5 = 0;
        while (i5 < set_length) {
            if (set_indices[i5]) {
                new_indices[num_new] = i5;
                ++num_new;
            }
            ++i5;
        }
        double[][] new_values = set.indexToDouble(new_indices);
        new_values = CoordinateSystem.transformCoordinates(((SetType)this.Type).getDomain(), this.DomainCoordinateSystem, this.SetUnits, null, ((SetType)set.getType()).getDomain(), set.getCoordinateSystem(), set.getSetUnits(), null, new_values);
        double[][] all_values = new double[1][length + num_new];
        int i6 = 0;
        while (i6 < length) {
            all_values[0][i6] = old_values[0][i6];
            ++i6;
        }
        i = 0;
        while (i < num_new) {
            all_values[0][length + i] = new_values[0][i];
            ++i;
        }
        QuickSort.sort(all_values[0]);
        return new Gridded1DDoubleSet(this.Type, all_values, all_values[0].length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, false);
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        throw new SetException("Set.makeSpatial: not valid for this Set");
    }

    public VisADGeometryArray make1DGeometry(byte[][] color_values) throws VisADException {
        throw new SetException("Set.make1DGeometry: not valid for this Set");
    }

    public VisADGeometryArray make2DGeometry(byte[][] color_values, boolean indexed) throws VisADException {
        throw new SetException("Set.make2DGeometry: not valid for this Set");
    }

    public VisADGeometryArray[] make3DGeometry(byte[][] color_values) throws VisADException {
        throw new SetException("Set.make3DGeometry: not valid for this Set");
    }

    public VisADGeometryArray makePointGeometry(byte[][] color_values) throws VisADException {
        throw new SetException("Set.makePointGeometry: not valid for this Set");
    }

    public VisADGeometryArray[] makeIsoLines(float[] intervals, float lowlimit, float highlimit, float base, float[] fieldValues, byte[][] color_values, boolean[] swap, boolean dash, boolean fill, ScalarMap[] smap) throws VisADException {
        throw new SetException("Set.makeIsoLines: not valid for this Set");
    }

    public VisADGeometryArray makeIsoSurface(float isolevel, float[] fieldValues, byte[][] color_values, boolean indexed) throws VisADException {
        throw new SetException("Set.makeIsoSurface: not valid for this Set");
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        return Set.floatToDouble(this.indexToValue(index));
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        return this.valueToIndex(Set.doubleToFloat(value));
    }

    public static double[][] floatToDouble(float[][] value) {
        if (value == null) {
            return null;
        }
        double[][] val = new double[value.length][];
        int i = 0;
        while (i < value.length) {
            if (value[i] == null) {
                val[i] = null;
            } else {
                val[i] = new double[value[i].length];
                int j = 0;
                while (j < value[i].length) {
                    val[i][j] = value[i][j];
                    ++j;
                }
            }
            ++i;
        }
        return val;
    }

    public static float[][] doubleToFloat(double[][] value) {
        if (value == null) {
            return null;
        }
        float[][] val = new float[value.length][];
        int i = 0;
        while (i < value.length) {
            if (value[i] == null) {
                val[i] = null;
            } else {
                val[i] = new float[value[i].length];
                int j = 0;
                while (j < value[i].length) {
                    val[i][j] = (float)value[i][j];
                    ++j;
                }
            }
            ++i;
        }
        return val;
    }

    public static float[][] copyFloats(float[][] samples) {
        if (samples == null) {
            return null;
        }
        int dim = samples.length;
        float[][] s_copy = new float[dim][];
        int j = 0;
        while (j < dim) {
            int len = samples[j].length;
            s_copy[j] = new float[len];
            System.arraycopy(samples[j], 0, s_copy[j], 0, len);
            ++j;
        }
        return s_copy;
    }

    public static double[][] copyDoubles(double[][] samples) {
        if (samples == null) {
            return null;
        }
        int dim = samples.length;
        double[][] s_copy = new double[dim][];
        int j = 0;
        while (j < dim) {
            int len = samples[j].length;
            s_copy[j] = new double[len];
            System.arraycopy(samples[j], 0, s_copy[j], 0, len);
            ++j;
        }
        return s_copy;
    }

    public void getNeighbors(int[][] neighbors) throws VisADException {
        throw new UnimplementedException("Set: getNeighbors()");
    }

    public void getNeighbors(int[][] neighbors, float[][] weights) throws VisADException {
        throw new UnimplementedException("Set: getNeighbors()");
    }

    public int[][] getNeighbors(int dimension) throws VisADException {
        throw new UnimplementedException("Set: getNeighbors()");
    }

    public boolean testNotEqualsCache(Set set) {
        return false;
    }

    public void addNotEqualsCache(Set set) {
    }

    public boolean testEqualsCache(Set set) {
        return false;
    }

    public void addEqualsCache(Set set) {
    }

    public boolean equalUnitAndCS(Set set) {
        if (this.DomainCoordinateSystem == null ? set.DomainCoordinateSystem != null : !this.DomainCoordinateSystem.equals(set.DomainCoordinateSystem)) {
            return false;
        }
        if (this.SetUnits != null || set.SetUnits != null) {
            if (this.SetUnits == null || set.SetUnits == null) {
                return false;
            }
            int n = this.SetUnits.length;
            if (n != set.SetUnits.length) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (this.SetUnits[i] != null || set.SetUnits[i] != null) {
                    if (this.SetUnits[i] == null || set.SetUnits[i] == null) {
                        return false;
                    }
                    if (!this.SetUnits[i].equals(set.SetUnits[i])) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public int unitAndCSHashCode() {
        int hashCode = 0;
        if (this.DomainCoordinateSystem != null) {
            hashCode ^= this.DomainCoordinateSystem.hashCode();
        }
        if (this.SetUnits != null) {
            int i = 0;
            while (i < this.SetUnits.length) {
                if (this.SetUnits[i] != null) {
                    hashCode ^= this.SetUnits[i].hashCode();
                }
                ++i;
            }
        }
        return hashCode;
    }

    public Data __getitem__(int index) throws VisADException, RemoteException {
        int[] indices = new int[]{index};
        float[][] values = this.indexToValue(indices);
        RealType[] types = ((SetType)this.getType()).getDomain().getRealComponents();
        Real[] reals = new Real[this.DomainDimension];
        int i = 0;
        while (i < this.DomainDimension) {
            reals[i] = new Real(types[i], values[i][0], this.SetUnits[i]);
            ++i;
        }
        if (this.DomainDimension == 1) {
            return reals[0];
        }
        RealTupleType rtt = ((SetType)this.getType()).getDomain();
        return new RealTuple(rtt, reals, this.getCoordinateSystem());
    }

    public abstract boolean equals(Object var1);

    public abstract Object clone();

    public abstract Object cloneButType(MathType var1) throws VisADException;

    public String longString() throws VisADException {
        return this.longString("");
    }

    public String longString(String pre) throws VisADException {
        throw new TypeException("Set.longString");
    }

    public static void main(String[] args) throws VisADException {
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType count = RealType.getRealType("count");
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        MathType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType((RealType[])types2);
        try {
            TupleType radiancexxx = new TupleType(types2);
        }
        catch (TypeException e) {
            e.printStackTrace();
        }
        try {
            FunctionType image_tuplexxx = new FunctionType(earth_location, radiance);
        }
        catch (TypeException e) {
            System.out.println(e);
        }
        try {
            FunctionType image_visxxx = new FunctionType(earth_location, vis_radiance);
        }
        catch (TypeException e) {
            System.out.println(e);
        }
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        FunctionType image_vis = new FunctionType(earth_location, vis_radiance);
        FunctionType image_ir = new FunctionType(earth_location, ir_radiance);
        FunctionType ir_histogram = new FunctionType(ir_radiance, count);
        System.out.println(image_tuple);
        System.out.println(ir_histogram);
        Linear2DSet set2d = new Linear2DSet((MathType)earth_location, 0.0, 127.0, 128, 0.0, 127.0, 128);
        Linear1DSet set1d = new Linear1DSet((MathType)ir_radiance, 0.0, 255.0, 256);
        Integer2DSet iset2d = new Integer2DSet((MathType)earth_location, 128, 128);
        Integer1DSet iset1d = new Integer1DSet((MathType)ir_radiance, 256);
        FlatField imaget1 = new FlatField(image_tuple, set2d);
        FlatField imagev1 = new FlatField(image_vis, set2d);
        FlatField imager1 = new FlatField(image_ir, set2d);
        FlatField histogram1 = new FlatField(ir_histogram, set1d);
        System.out.println(imaget1);
        System.out.println(histogram1);
        System.out.println(set2d);
        System.out.println(set1d);
        System.out.println(iset2d);
        System.out.println(iset1d);
        if (set1d instanceof IntegerSet) {
            System.out.println(" set1d ");
        }
        if (set2d instanceof IntegerSet) {
            System.out.println(" set2d ");
        }
        if (iset1d instanceof IntegerSet) {
            System.out.println(" iset1d ");
        }
        if (iset2d instanceof IntegerSet) {
            System.out.println(" iset2d ");
        }
        System.out.println("");
        int i = 14;
        int s = 12;
        int b = 10;
        Real t = new Real(1.0);
        Real x = new Real(12.0);
        Real y = new Real(12.0);
        Real u = new Real(i);
        Real v = new Real(s);
        Real w = new Real(b);
        System.out.println(t);
        System.out.println("" + x + " " + y + " " + u + " " + v + " " + w);
    }
}

