/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.ConstantMap;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.MessageEvent;
import visad.MouseBehavior;
import visad.MouseHelper;
import visad.ReferenceException;
import visad.RemoteActionImpl;
import visad.RemoteDataReference;
import visad.RemoteDisplay;
import visad.RemoteReferenceLinkImpl;
import visad.RemoteSlaveDisplay;
import visad.RemoteVisADException;
import visad.ScalarMap;
import visad.ThingReference;
import visad.VisADException;
import visad.collab.DisplayMonitor;
import visad.collab.DisplayMonitorImpl;
import visad.collab.DisplaySync;
import visad.collab.DisplaySyncImpl;
import visad.collab.RemoteDisplayMonitor;
import visad.collab.RemoteDisplayMonitorImpl;
import visad.collab.RemoteDisplaySync;
import visad.collab.RemoteDisplaySyncImpl;

public class RemoteDisplayImpl
extends RemoteActionImpl
implements RemoteDisplay {
    public RemoteDisplayImpl(DisplayImpl d) throws RemoteException {
        super(d);
    }

    public void addSlave(RemoteSlaveDisplay display) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.addSlave(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.addSlave(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl d = (DisplayImpl)this.AdaptedAction;
        ((DisplayImpl)this.AdaptedAction).addSlave(display);
    }

    public void removeSlave(RemoteSlaveDisplay display) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.removeSlave(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.removeSlave(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl d = (DisplayImpl)this.AdaptedAction;
        d.removeSlave(display);
    }

    public void removeAllSlaves() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.removeAllSlaves(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.removeAllSlaves(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl d = (DisplayImpl)this.AdaptedAction;
        d.removeAllSlaves();
    }

    public boolean hasSlaves() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.hasSlaves(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.removeAllSlaves(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl d = (DisplayImpl)this.AdaptedAction;
        return d.hasSlaves();
    }

    public void sendMouseEvent(MouseEvent e) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl d = (DisplayImpl)this.AdaptedAction;
        MouseBehavior mb = d.getMouseBehavior();
        if (mb == null) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): MouseBehavior is null");
        }
        MouseHelper mh = mb.getMouseHelper();
        if (mh == null) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): MouseHelper is null");
        }
        Component c = d.getComponent();
        int id = e.getID();
        long when = e.getWhen();
        int mods = e.getModifiers();
        int x = e.getX();
        int y = e.getY();
        int clicks = e.getClickCount();
        boolean popup = e.isPopupTrigger();
        MouseEvent ne = new MouseEvent(c, id, when, mods, x, y, clicks, popup);
        mh.processEvent(ne, -1);
    }

    public void addReference(ThingReference ref) throws VisADException, RemoteException {
        if (!(ref instanceof DataReference)) {
            throw new ReferenceException("RemoteDisplayImpl.addReference: ref must be DataReference");
        }
        this.addReference((DataReference)ref, null);
    }

    public void addReference(DataReference ref, ConstantMap[] constant_maps) throws VisADException, RemoteException {
        if (!(ref instanceof RemoteDataReference)) {
            throw new RemoteVisADException("RemoteDisplayImpl.addReference: requires RemoteDataReference");
        }
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.addReference: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).adaptedAddReference((RemoteDataReference)ref, this, constant_maps);
    }

    public void addReferences(DataRenderer renderer, DataReference ref) throws VisADException, RemoteException {
        this.addReferences(renderer, new DataReference[]{ref}, null);
    }

    public void addReferences(DataRenderer renderer, DataReference ref, ConstantMap[] constant_maps) throws VisADException, RemoteException {
        this.addReferences(renderer, new DataReference[]{ref}, new ConstantMap[][]{constant_maps});
    }

    public void addReferences(DataRenderer renderer, DataReference[] refs) throws VisADException, RemoteException {
        this.addReferences(renderer, refs, null);
    }

    public void addReferences(DataRenderer renderer, DataReference[] refs, ConstantMap[][] constant_maps) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.addReferences: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).adaptedAddReferences(renderer, refs, this, constant_maps);
    }

    public void removeReference(ThingReference ref) throws VisADException, RemoteException {
        if (!(ref instanceof DataReference)) {
            throw new ReferenceException("RemoteDisplayImpl.addReference: ref must be DataReference");
        }
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.removeReference: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).adaptedDisplayRemoveReference((DataReference)ref);
    }

    public void addMap(ScalarMap map) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.addMap: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).addMap(map);
    }

    public void clearMaps() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.clearMaps: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).clearMaps();
    }

    public void destroy() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.destroy: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).destroy();
    }

    public String getDisplayClassName() throws RemoteException {
        return this.AdaptedAction.getClass().getName();
    }

    public int getDisplayAPI() throws RemoteException, VisADException {
        return ((DisplayImpl)this.AdaptedAction).getAPI();
    }

    public String getDisplayRendererClassName() throws RemoteException {
        DisplayRenderer dr = ((DisplayImpl)this.AdaptedAction).getDisplayRenderer();
        return dr.getClass().getName();
    }

    public Vector getMapVector() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException(this.getClass().getName() + ".getMapVector: " + "AdaptedAction is null");
        }
        return ((DisplayImpl)this.AdaptedAction).getMapVector();
    }

    public Vector getConstantMapVector() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException(this.getClass().getName() + ".getConstantMapVector: " + "AdaptedAction is null");
        }
        return ((DisplayImpl)this.AdaptedAction).getConstantMapVector();
    }

    public GraphicsModeControl getGraphicsModeControl() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException(this.getClass().getName() + ".getGraphicsModeControl: " + "AdaptedAction is null");
        }
        return ((DisplayImpl)this.AdaptedAction).getGraphicsModeControl();
    }

    public Vector getReferenceLinks() throws VisADException, RemoteException {
        Vector<RemoteReferenceLinkImpl> links = new Vector<RemoteReferenceLinkImpl>();
        Vector rv = ((DisplayImpl)this.AdaptedAction).getRenderers();
        Enumeration e = rv.elements();
        while (e.hasMoreElements()) {
            DataRenderer dr = (DataRenderer)e.nextElement();
            DataDisplayLink[] dl = dr.getLinks();
            if (dl == null) continue;
            int i = 0;
            while (i < dl.length) {
                try {
                    links.addElement(new RemoteReferenceLinkImpl(dl[i]));
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                ++i;
            }
        }
        return links;
    }

    public RemoteDisplayMonitor getRemoteDisplayMonitor() throws RemoteException {
        DisplayMonitor dpyMon = ((DisplayImpl)this.AdaptedAction).getDisplayMonitor();
        return new RemoteDisplayMonitorImpl((DisplayMonitorImpl)dpyMon);
    }

    public DisplaySync getDisplaySync() throws RemoteException {
        return ((DisplayImpl)this.AdaptedAction).getDisplaySync();
    }

    public RemoteDisplaySync getRemoteDisplaySync() throws RemoteException {
        DisplaySync dpySync = ((DisplayImpl)this.AdaptedAction).getDisplaySync();
        return new RemoteDisplaySyncImpl((DisplaySyncImpl)dpySync);
    }

    public void sendMessage(MessageEvent msg) throws RemoteException {
        ((DisplayImpl)this.AdaptedAction).sendMessage(msg);
    }
}

