/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Action;
import visad.ActionImpl;
import visad.ReferenceException;
import visad.ThingChangedEvent;
import visad.ThingReference;
import visad.VisADException;

public class ReferenceActionLink {
    ThingReference ref;
    ActionImpl local_action;
    Action action;
    private long id;
    private String name;
    private long NewTick;
    private long OldTick;
    private boolean tickFlag;
    private boolean Ball;

    public ReferenceActionLink(ThingReference r, ActionImpl local_a, Action a, long jd) throws RemoteException, VisADException {
        if (r == null || a == null) {
            throw new ReferenceException("ReferenceActionLink: ThingReference and Action cannot be null");
        }
        this.ref = r;
        this.local_action = local_a;
        this.action = a;
        this.Ball = true;
        this.id = jd;
        this.name = this.ref.getName();
        this.NewTick = this.ref.getTick();
        this.OldTick = this.NewTick - 1L;
    }

    long getId() {
        return this.id;
    }

    public ThingReference getThingReference() {
        return this.ref;
    }

    public ActionImpl getLocalAction() {
        return this.local_action;
    }

    public Action getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    synchronized void incTick(long t) {
        this.NewTick = t;
    }

    public synchronized void setTicks() {
        this.tickFlag = this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
        this.OldTick = this.NewTick;
    }

    public synchronized boolean peekTicks() {
        return this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
    }

    public synchronized boolean checkTicks() {
        return this.tickFlag;
    }

    synchronized void resetTicks() {
        this.tickFlag = false;
    }

    ThingChangedEvent getThingChangedEvent() throws RemoteException, VisADException {
        ThingChangedEvent event = null;
        if (this.Ball) {
            this.Ball = false;
            event = this.ref.acknowledgeThingChanged(this.action);
        }
        return event;
    }

    void acknowledgeThingChangedEvent(long actionTick) {
        this.NewTick = actionTick;
        this.Ball = true;
    }
}

