/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.Field;
import visad.MathType;
import visad.Real;
import visad.RealTupleIface;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowRealTupleType;
import visad.ShadowType;
import visad.Tuple;
import visad.TupleIface;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class RealTuple
extends Tuple
implements RealTupleIface {
    private CoordinateSystem TupleCoordinateSystem;
    private Unit[] TupleUnits;

    public RealTuple(RealTupleType type) {
        super(type);
        this.TupleCoordinateSystem = type.getCoordinateSystem();
        if (this.tupleComponents != null) {
            int n = this.tupleComponents.length;
            this.TupleUnits = new Unit[n];
            int i = 0;
            while (i < n) {
                this.TupleUnits[i] = null;
                ++i;
            }
        }
    }

    public RealTuple(RealTupleType type, Real[] reals, CoordinateSystem coord_sys) throws VisADException, RemoteException {
        super(type, reals);
        this.init_coord_sys(coord_sys);
    }

    public RealTuple(Real[] reals) throws VisADException, RemoteException {
        super(reals);
        this.init_coord_sys(null);
    }

    public RealTuple(RealTupleType type, double[] values) throws VisADException, RemoteException {
        this(type, RealTuple.buildRealArray(type, values), null);
    }

    private void init_coord_sys(CoordinateSystem coord_sys) throws VisADException {
        CoordinateSystem cs = ((RealTupleType)this.Type).getCoordinateSystem();
        if (coord_sys == null) {
            this.TupleCoordinateSystem = cs;
        } else {
            if (cs == null || !cs.getReference().equals(coord_sys.getReference())) {
                throw new CoordinateSystemException("RealTuple: coord_sys " + coord_sys.getReference() + " must match" + " Type.DefaultCoordinateSystem " + (cs == null ? null : cs.getReference()));
            }
            this.TupleCoordinateSystem = coord_sys;
        }
        if (this.TupleCoordinateSystem != null && !Unit.canConvertArray(this.TupleCoordinateSystem.getCoordinateSystemUnits(), ((RealTupleType)this.Type).getDefaultUnits())) {
            throw new UnitException("RealTuple: CoordinateSystem Units must be convertable with Type default Units");
        }
        int n = this.tupleComponents.length;
        this.TupleUnits = new Unit[n];
        int i = 0;
        while (i < n) {
            this.TupleUnits[i] = ((Real)this.tupleComponents[i]).getUnit();
            ++i;
        }
        if (!Unit.canConvertArray(this.TupleUnits, ((RealTupleType)this.Type).getDefaultUnits())) {
            throw new UnitException("Tuple: Units must be convertable with Type default Units");
        }
        if (this.TupleCoordinateSystem != null && !Unit.canConvertArray(this.TupleCoordinateSystem.getCoordinateSystemUnits(), this.TupleUnits)) {
            throw new UnitException("Tuple: Units must be convertable with CoordinateSystem Units");
        }
    }

    private static Real[] buildRealArray(RealTupleType type, double[] values) throws VisADException {
        Real[] reals = new Real[values.length];
        int i = 0;
        while (i < values.length) {
            reals[i] = new Real((RealType)type.getComponent(i), values[i]);
            ++i;
        }
        return reals;
    }

    public double[] getValues() {
        int n = this.getDimension();
        double[] values = new double[n];
        int i = 0;
        while (i < n) {
            values[i] = ((Real)this.tupleComponents[i]).getValue();
            ++i;
        }
        return values;
    }

    public Unit[] getTupleUnits() {
        return Unit.copyUnitsArray(this.TupleUnits);
    }

    public ErrorEstimate[] getErrors() throws VisADException, RemoteException {
        int n = this.getDimension();
        ErrorEstimate[] errors = new ErrorEstimate[n];
        int i = 0;
        while (i < n) {
            errors[i] = ((Real)this.getComponent(i)).getError();
            ++i;
        }
        return errors;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.TupleCoordinateSystem;
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof RealTuple) {
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("RealTuple.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("RealTuple.binary: new_type doesn't match return type");
            }
            if (this.isMissing() || data.isMissing()) {
                return new RealTuple((RealTupleType)new_type);
            }
            double[][] vals = new double[this.tupleComponents.length][1];
            int j = 0;
            while (j < this.tupleComponents.length) {
                vals[j][0] = ((Real)((RealTuple)data).getComponent(j)).getValue();
                ++j;
            }
            ErrorEstimate[] errors_out = new ErrorEstimate[this.tupleComponents.length];
            vals = CoordinateSystem.transformCoordinates((RealTupleType)this.Type, this.TupleCoordinateSystem, this.TupleUnits, errors_out, (RealTupleType)data.getType(), ((RealTuple)data).getCoordinateSystem(), ((RealTuple)data).getTupleUnits(), ((RealTuple)data).getErrors(), vals);
            Real[] reals = new Real[this.tupleComponents.length];
            int j2 = 0;
            while (j2 < this.tupleComponents.length) {
                Real real = new Real((RealType)((RealTupleType)this.Type).getComponent(j2), vals[j2][0], this.TupleUnits[j2], errors_out[j2]);
                MathType m_type = ((RealTupleType)new_type).getComponent(j2);
                reals[j2] = (Real)this.tupleComponents[j2].binary(real, op, m_type, sampling_mode, error_mode);
                ++j2;
            }
            return new RealTuple((RealTupleType)new_type, reals, null);
        }
        if (data instanceof TupleIface) {
            throw new TypeException("RealTuple.binary: types don't match");
        }
        if (data instanceof Real) {
            if (this.isMissing() || data.isMissing()) {
                return new RealTuple((RealTupleType)this.Type);
            }
            Real[] reals = new Real[this.tupleComponents.length];
            int j = 0;
            while (j < this.tupleComponents.length) {
                MathType m_type = ((RealTupleType)new_type).getComponent(j);
                reals[j] = (Real)this.tupleComponents[j].binary(data, op, m_type, sampling_mode, error_mode);
                ++j;
            }
            return new RealTuple((RealTupleType)new_type, reals, null);
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(new_type)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(op), new_type, sampling_mode, error_mode);
        }
        throw new TypeException("RealTuple.binary");
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(new_type)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        RealTupleType RT_type = (RealTupleType)new_type;
        if (this.isMissing()) {
            return new RealTuple((RealTupleType)this.Type);
        }
        Real[] reals = new Real[this.tupleComponents.length];
        int j = 0;
        while (j < this.tupleComponents.length) {
            reals[j] = (Real)this.tupleComponents[j].unary(op, RT_type.getComponent(j), sampling_mode, error_mode);
            ++j;
        }
        return new RealTuple((RealTupleType)new_type, reals, this.TupleCoordinateSystem);
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        shadow = super.computeRanges(type, shadow);
        ShadowRealTupleType shad_ref = ((ShadowRealTupleType)type).getReference();
        if (this.isMissing() || shad_ref == null) {
            return shadow;
        }
        int n = this.tupleComponents.length;
        double[][] ranges = new double[2][n];
        int i = 0;
        while (i < n) {
            double value = ((Real)this.tupleComponents[i]).getValue();
            Unit unit = ((RealType)((RealTupleType)this.Type).getComponent(i)).getDefaultUnit();
            if (unit != null && !unit.equals(this.TupleUnits[i])) {
                value = unit.toThis(value, this.TupleUnits[i]);
            }
            if (value != value) {
                return shadow;
            }
            ranges[0][i] = value;
            ranges[1][i] = value;
            ++i;
        }
        return this.computeReferenceRanges((ShadowRealTupleType)type, this.TupleCoordinateSystem, ((RealTupleType)this.Type).getDefaultUnits(), shadow, shad_ref, ranges);
    }

    public Object clone() {
        RealTuple tuple;
        try {
            Real[] comps = new Real[this.tupleComponents.length];
            int i = 0;
            while (i < this.tupleComponents.length) {
                comps[i] = (Real)this.tupleComponents[i];
                ++i;
            }
            tuple = new RealTuple((RealTupleType)this.Type, comps, this.TupleCoordinateSystem);
        }
        catch (VisADException e) {
            throw new VisADError("RealTuple.clone: VisADException occurred");
        }
        catch (RemoteException e) {
            throw new VisADError("RealTuple.clone: RemoteException occurred");
        }
        return tuple;
    }

    public String toString() {
        if (this.isMissing()) {
            return "missing";
        }
        String s = "(" + this.tupleComponents[0];
        int i = 1;
        while (i < this.tupleComponents.length) {
            s = s + ", " + this.tupleComponents[i];
            ++i;
        }
        return s + ")";
    }

    public String longString(String pre) throws VisADException, RemoteException {
        String s = pre + "RealTuple\n" + pre + "  Type: " + this.Type.toString() + "\n";
        if (this.isMissing()) {
            return s + "  missing\n";
        }
        int i = 0;
        while (i < this.tupleComponents.length) {
            s = s + pre + "  Tuple Component " + i + ": Value = " + ((Real)this.tupleComponents[i]).getValue() + "  (TypeName = " + ((RealType)this.tupleComponents[i].getType()).getName() + ")\n";
            ++i;
        }
        return s;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int b = 10;
        Real w = new Real(b);
        Real[] reals1 = new Real[]{new Real(1.0), new Real(2.0), new Real(3.0)};
        RealTuple rt1 = new RealTuple(reals1);
        Real[] reals2 = new Real[]{new Real(6.0), new Real(5.0), new Real(4.0)};
        RealTuple rt2 = new RealTuple(reals2);
        System.out.println("rt1 = " + rt1 + "\nrt2 = " + rt2);
        System.out.println("rt1 + rt2 = " + rt1.add(rt2));
        System.out.println("rt1 - rt2 = " + rt1.subtract(rt2));
        System.out.println("rt1 * rt2 = " + rt1.multiply(rt2));
        System.out.println("rt1 / rt2 = " + rt1.divide(rt2));
        System.out.println("sqrt(rt1) = " + rt1.sqrt());
        System.out.println("rt1 + w = " + rt1.add(w));
        System.out.println("rt1 - w = " + rt1.subtract(w));
        System.out.println("rt1 * w = " + rt1.multiply(w));
        System.out.println("rt1 / w = " + rt1.divide(w));
        System.out.println("w + rt2 = " + w.add(rt2));
        System.out.println("w - rt2 = " + w.subtract(rt2));
        System.out.println("w * rt2 = " + w.multiply(rt2));
        System.out.println("w / rt2 = " + w.divide(rt2));
    }
}

