/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import visad.CommonUnit;
import visad.Data;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayRealType;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetType;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public abstract class MathType
implements Serializable {
    boolean SystemIntrinsic;
    private static Vector timeAliases = MathType.makeTimeAliasVector();

    public MathType() {
        this(false);
    }

    MathType(boolean b) {
        this.SystemIntrinsic = b;
    }

    public abstract boolean equals(Object var1);

    public abstract boolean equalsExceptName(MathType var1);

    public abstract boolean equalsExceptNameButUnits(MathType var1) throws VisADException;

    public abstract MathType cloneDerivative(RealType var1) throws VisADException;

    public abstract MathType binary(MathType var1, int var2, Vector var3) throws VisADException;

    public abstract MathType unary(int var1, Vector var2) throws VisADException;

    public abstract Data missingData() throws VisADException, RemoteException;

    public abstract ShadowType buildShadowType(DataDisplayLink var1, ShadowType var2) throws VisADException, RemoteException;

    public String toString() {
        return this.prettyString(0);
    }

    public String prettyString() {
        return this.prettyString(0);
    }

    public abstract String prettyString(int var1);

    public static MathType stringToType(String s) throws VisADException {
        int length = s.length();
        String r = "";
        int i = 0;
        while (i < length) {
            String t = s.substring(i, i + 1);
            if (!(t.equals(" ") || t.equals("\t") || t.equals("\n"))) {
                r = r + t;
            }
            ++i;
        }
        length = r.length();
        if (length == 0) {
            throw new TypeException("MathType.stringToType: badly formed string");
        }
        int[] len = new int[]{length};
        MathType type = MathType.stringToType(r, len);
        if (length != len[0]) {
            throw new TypeException("MathType.stringToType: badly formed string");
        }
        return type;
    }

    private static MathType stringToType(String s, int[] len) throws VisADException {
        String s0 = s.substring(0, 1);
        if (s.startsWith("Set") || s.startsWith("SET") || s.startsWith("set")) {
            SetType ret_type2;
            int[] lensr;
            String sr = s.substring(3);
            MathType type0 = MathType.stringToType(sr, lensr = new int[]{sr.length()});
            if (type0 instanceof RealType) {
                ret_type2 = new SetType((RealType)type0);
            } else if (type0 instanceof RealTupleType) {
                ret_type2 = new SetType((RealTupleType)type0);
            } else {
                throw new TypeException("MathType.stringToType: badly formed string");
            }
            len[0] = 3 + lensr[0];
            return ret_type2;
        }
        if (s0.equals("(")) {
            TupleType ret_type2;
            String sr = s.substring(1);
            int[] lensr = new int[]{sr.length()};
            MathType type0 = MathType.stringToType(sr, lensr);
            String t = sr.substring(lensr[0]);
            if (type0 == null || t == null || t.equals("")) {
                throw new TypeException("MathType.stringToType: badly formed string");
            }
            if (t.startsWith("->")) {
                if (!(type0 instanceof RealType) && !(type0 instanceof RealTupleType)) {
                    throw new TypeException("MathType.stringToType: badly formed string");
                }
                String tr = t.substring(2);
                int[] lentr = new int[]{tr.length()};
                MathType type1 = MathType.stringToType(tr, lentr);
                t = tr.substring(lentr[0]);
                if (!t.startsWith(")") || type1 == null) {
                    throw new TypeException("MathType.stringToType: badly formed string");
                }
                len[0] = 1 + lensr[0] + 2 + lentr[0] + 1;
                FunctionType ret_type2 = new FunctionType(type0, type1);
                return ret_type2;
            }
            Vector<MathType> v = new Vector<MathType>();
            v.addElement(type0);
            int lentup = 1 + lensr[0];
            while (t.startsWith(",")) {
                int[] lentr;
                String tr = t.substring(1);
                MathType type1 = MathType.stringToType(tr, lentr = new int[]{tr.length()});
                if (type1 == null) {
                    throw new TypeException("MathType.stringToType: badly formed string");
                }
                v.addElement(type1);
                lentup = lentup + 1 + lentr[0];
                t = tr.substring(lentr[0]);
            }
            if (!t.startsWith(")")) {
                throw new TypeException("MathType.stringToType: badly formed string");
            }
            len[0] = lentup + 1;
            MathType[] types = new MathType[v.size()];
            boolean all_real = true;
            int i = 0;
            while (i < v.size()) {
                types[i] = (MathType)v.elementAt(i);
                all_real &= types[i] instanceof RealType;
                ++i;
            }
            if (all_real) {
                RealType[] rtypes = new RealType[v.size()];
                int i2 = 0;
                while (i2 < v.size()) {
                    rtypes[i2] = (RealType)types[i2];
                    ++i2;
                }
                ret_type2 = new RealTupleType(rtypes);
            } else {
                ret_type2 = new TupleType(types);
            }
            return ret_type2;
        }
        if (0 <= s0.compareTo("a") && s0.compareTo("z") <= 0 || 0 <= s0.compareTo("A") && s0.compareTo("Z") <= 0) {
            ScalarType ret_type2;
            int i = 1;
            while (i < len[0]) {
                s0 = s.substring(i, i + 1);
                if (!(0 <= s0.compareTo("a") && s0.compareTo("z") <= 0 || 0 <= s0.compareTo("A") && s0.compareTo("Z") <= 0 || 0 <= s0.compareTo("0") && s0.compareTo("9") <= 0 || s0.equals("_"))) {
                    len[0] = i;
                    break;
                }
                ++i;
            }
            String rs = s.substring(0, len[0]);
            String t = s.substring(len[0]);
            if (t.startsWith("(Text)")) {
                ret_type2 = TextType.getTextType(rs);
                len[0] = len[0] + 6;
            } else {
                ret_type2 = RealType.getRealType(rs);
            }
            return ret_type2;
        }
        throw new TypeException("MathType.stringToType: badly formed string");
    }

    private static Vector makeTimeAliasVector() {
        Vector<String> v = new Vector<String>();
        v.add("time");
        v.add("Time");
        v.add("TIME");
        return v;
    }

    public static void addTimeAlias(String name) {
        Vector vector = timeAliases;
        synchronized (vector) {
            timeAliases.add(name);
        }
    }

    /*
     * Unable to fully structure code
     */
    public ScalarMap[] guessMaps(boolean threeD) {
        m = this;
        var4_3 = MathType.timeAliases;
        synchronized (var4_3) {
            len = MathType.timeAliases.size();
            ds = new DataStruct[1][len];
            i = 0;
            while (i < len) {
                name = (String)MathType.timeAliases.elementAt(i);
                ds[0][i] = new DataStruct(name);
                ++i;
            }
        }
        this.findTimeFunction(m, ds, null);
        timeFunc = -1;
        i = 0;
        while (i < ds[0].length) {
            if (ds[0][i].fvalid && ds[0][i].funcs.size() > 0) {
                timeFunc = i;
                break;
            }
            ++i;
        }
        flist = new Vector<E>();
        slist = new Vector<E>();
        tlist = new Vector<E>();
        if (timeFunc < 0) {
            this.buildTypeList(m, flist, slist, tlist);
        } else {
            i = 0;
            while (i < ds[0][timeFunc].funcs.size()) {
                f = (FunctionType)ds[0][timeFunc].funcs.elementAt(i);
                this.buildTypeList(f.getRange(), flist, slist, tlist);
                ++i;
            }
        }
        numfuncs = flist.size();
        t = threeD != false ? 0 : 4;
        while (t < 7) {
            fi = 0;
            while (fi < numfuncs) {
                ft = (FunctionType)flist.elementAt(fi);
                block48 : switch (t) {
                    case 0: {
                        if (!ft.getFlat() || (domain = ft.getDomain()).getDimension() != 3) break;
                        range = ft.getRange();
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                x = (RealType)ref.getComponent(0);
                                y = (RealType)ref.getComponent(1);
                                z = (RealType)ref.getComponent(2);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            x = (RealType)domain.getComponent(0);
                            y = (RealType)domain.getComponent(1);
                            z = (RealType)domain.getComponent(2);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        if (range instanceof RealType) {
                            a = (RealType)range;
                            try {
                                smaps = new ScalarMap[timeFunc < 0 ? 4 : 5];
                                if (RealType.Latitude.equals(x)) {
                                    smaps[0] = new ScalarMap(x, Display.YAxis);
                                    smaps[1] = new ScalarMap(y, Display.XAxis);
                                } else {
                                    smaps[0] = new ScalarMap(x, Display.XAxis);
                                    smaps[1] = new ScalarMap(y, Display.YAxis);
                                }
                                smaps[2] = new ScalarMap(z, Display.ZAxis);
                                smaps[3] = new ScalarMap(a, Display.IsoContour);
                                if (timeFunc >= 0) {
                                    o = ds[0][timeFunc].funcs.elementAt(0);
                                    rtt = ((FunctionType)o).getDomain();
                                    time = (RealType)rtt.getComponent(0);
                                    smaps[4] = new ScalarMap(time, Display.Animation);
                                }
                                return smaps;
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        if (!(range instanceof TupleType)) break;
                        tt = (TupleType)range;
                        i = 0;
                        while (i < tt.getDimension()) {
                            try {
                                mt = tt.getComponent(i);
                            }
                            catch (VisADException exc) {
                                break block48;
                            }
                            if (mt instanceof RealType) {
                                a = (RealType)mt;
                                try {
                                    smaps = new ScalarMap[timeFunc < 0 ? 4 : 5];
                                    if (RealType.Latitude.equals(x)) {
                                        smaps[0] = new ScalarMap(x, Display.YAxis);
                                        smaps[1] = new ScalarMap(y, Display.XAxis);
                                    } else {
                                        smaps[0] = new ScalarMap(x, Display.XAxis);
                                        smaps[1] = new ScalarMap(y, Display.YAxis);
                                    }
                                    smaps[2] = new ScalarMap(z, Display.ZAxis);
                                    smaps[3] = new ScalarMap(a, Display.IsoContour);
                                    if (timeFunc >= 0) {
                                        o = ds[0][timeFunc].funcs.elementAt(0);
                                        rtt = ((FunctionType)o).getDomain();
                                        time = (RealType)rtt.getComponent(0);
                                        smaps[4] = new ScalarMap(time, Display.Animation);
                                    }
                                    return smaps;
                                }
                                catch (VisADException exc) {
                                    break block48;
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 1: {
                        domain = ft.getDomain();
                        if (domain.getDimension() != 1) break;
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                z = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            z = (RealType)domain.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = ft.getRange();
                        rf = null;
                        if (range instanceof FunctionType) {
                            rf = (FunctionType)range;
                            if (!rf.getFlat() || rf.getDomain().getDimension() != 2) {
                                break;
                            }
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    rf = null;
                                    break;
                                }
                                if (ttci instanceof FunctionType) {
                                    ftci = (FunctionType)ttci;
                                    if (!ftci.getFlat() || ftci.getDomain().getDimension() != 2) break;
                                    rf = ftci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (rf == null) break;
                        rfd = rf.getDomain();
                        cs = rfd.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                x = (RealType)ref.getComponent(0);
                                y = (RealType)ref.getComponent(1);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            x = (RealType)rfd.getComponent(0);
                            y = (RealType)rfd.getComponent(1);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = rf.getRange();
                        a = null;
                        if (range instanceof RealType) {
                            a = (RealType)range;
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    break;
                                }
                                if (ttci instanceof RealType) {
                                    a = (RealType)ttci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (a == null) break;
                        try {
                            smaps = new ScalarMap[timeFunc < 0 ? 4 : 5];
                            if (RealType.Latitude.equals(x)) {
                                smaps[0] = new ScalarMap(x, Display.YAxis);
                                smaps[1] = new ScalarMap(y, Display.XAxis);
                            } else {
                                smaps[0] = new ScalarMap(x, Display.XAxis);
                                smaps[1] = new ScalarMap(y, Display.YAxis);
                            }
                            smaps[2] = new ScalarMap(z, Display.ZAxis);
                            smaps[3] = new ScalarMap(a, Display.IsoContour);
                            if (timeFunc >= 0) {
                                o = ds[0][timeFunc].funcs.elementAt(0);
                                rtt = ((FunctionType)o).getDomain();
                                time = (RealType)rtt.getComponent(0);
                                smaps[4] = new ScalarMap(time, Display.Animation);
                            }
                            return smaps;
                        }
                        catch (VisADException exc) {
                            // empty catch block
                        }
                    }
                    case 2: {
                        domain = ft.getDomain();
                        if (domain.getDimension() != 2) break;
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                x = (RealType)ref.getComponent(0);
                                y = (RealType)ref.getComponent(1);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            x = (RealType)domain.getComponent(0);
                            y = (RealType)domain.getComponent(1);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = ft.getRange();
                        rf = null;
                        if (range instanceof FunctionType) {
                            rf = (FunctionType)range;
                            if (!rf.getFlat() || rf.getDomain().getDimension() != 1) {
                                break;
                            }
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    rf = null;
                                    break;
                                }
                                if (ttci instanceof FunctionType) {
                                    ftci = (FunctionType)ttci;
                                    if (!ftci.getFlat() || ftci.getDomain().getDimension() != 1) break;
                                    rf = ftci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (rf == null) break;
                        rfd = rf.getDomain();
                        cs = rfd.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                z = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            z = (RealType)rfd.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = rf.getRange();
                        a = null;
                        if (range instanceof RealType) {
                            a = (RealType)range;
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    break;
                                }
                                if (ttci instanceof RealType) {
                                    a = (RealType)ttci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (a == null) break;
                        try {
                            smaps = new ScalarMap[timeFunc < 0 ? 4 : 5];
                            if (RealType.Latitude.equals(x)) {
                                smaps[0] = new ScalarMap(x, Display.YAxis);
                                smaps[1] = new ScalarMap(y, Display.XAxis);
                            } else {
                                smaps[0] = new ScalarMap(x, Display.XAxis);
                                smaps[1] = new ScalarMap(y, Display.YAxis);
                            }
                            smaps[2] = new ScalarMap(z, Display.ZAxis);
                            smaps[3] = new ScalarMap(a, Display.IsoContour);
                            if (timeFunc >= 0) {
                                o = ds[0][timeFunc].funcs.elementAt(0);
                                rtt = ((FunctionType)o).getDomain();
                                time = (RealType)rtt.getComponent(0);
                                smaps[4] = new ScalarMap(time, Display.Animation);
                            }
                            return smaps;
                        }
                        catch (VisADException exc) {
                            // empty catch block
                        }
                    }
                    case 3: {
                        domain = ft.getDomain();
                        if (domain.getDimension() != 1) break;
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                x = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            x = (RealType)domain.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = ft.getRange();
                        rf = null;
                        if (range instanceof FunctionType) {
                            rf = (FunctionType)range;
                            if (rf.getDomain().getDimension() != 1) {
                                break;
                            }
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    rf = null;
                                    break;
                                }
                                if (ttci instanceof FunctionType) {
                                    ftci = (FunctionType)ttci;
                                    if (ftci.getDomain().getDimension() != 1) break;
                                    rf = ftci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (rf == null) break;
                        rfd = rf.getDomain();
                        cs = rfd.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                y = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            y = (RealType)rfd.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = rf.getRange();
                        rf = null;
                        if (range instanceof FunctionType) {
                            rf = (FunctionType)range;
                            if (rf.getDomain().getDimension() != 1) {
                                break;
                            }
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    rf = null;
                                    break;
                                }
                                if (ttci instanceof FunctionType) {
                                    ftci = (FunctionType)ttci;
                                    if (ftci.getDomain().getDimension() != 1) break;
                                    rf = ftci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (rf == null) break;
                        rfd = rf.getDomain();
                        cs = rfd.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                z = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            z = (RealType)rfd.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = rf.getRange();
                        a = null;
                        if (range instanceof RealType) {
                            a = (RealType)range;
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    break;
                                }
                                if (ttci instanceof RealType) {
                                    a = (RealType)ttci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (a == null) break;
                        try {
                            smaps = new ScalarMap[timeFunc < 0 ? 4 : 5];
                            if (RealType.Latitude.equals(x)) {
                                smaps[0] = new ScalarMap(x, Display.YAxis);
                                smaps[1] = new ScalarMap(y, Display.XAxis);
                            } else {
                                smaps[0] = new ScalarMap(x, Display.XAxis);
                                smaps[1] = new ScalarMap(y, Display.YAxis);
                            }
                            smaps[2] = new ScalarMap(z, Display.ZAxis);
                            smaps[3] = new ScalarMap(a, Display.IsoContour);
                            if (timeFunc >= 0) {
                                o = ds[0][timeFunc].funcs.elementAt(0);
                                rtt = ((FunctionType)o).getDomain();
                                time = (RealType)rtt.getComponent(0);
                                smaps[4] = new ScalarMap(time, Display.Animation);
                            }
                            return smaps;
                        }
                        catch (VisADException exc) {
                            // empty catch block
                        }
                    }
                    case 4: {
                        if (!ft.getFlat() || (domain = ft.getDomain()).getDimension() != 2) break;
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                x = (RealType)ref.getComponent(0);
                                y = (RealType)ref.getComponent(1);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            x = (RealType)domain.getComponent(0);
                            y = (RealType)domain.getComponent(1);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = ft.getRange();
                        rgb = new RealType[3];
                        rgbc = 0;
                        if (!(range instanceof TupleType)) ** GOTO lbl472
                        tt = (TupleType)range;
                        i = 0;
                        while (i < tt.getDimension()) {
                            try {
                                ttci = tt.getComponent(i);
                            }
                            catch (VisADException exc) {
                                ** GOTO lbl474
                            }
                            if (ttci instanceof RealType && rgbc < 3) {
                                rgb[rgbc++] = (RealType)ttci;
                            }
                            ++i;
                        }
                        ** GOTO lbl474
lbl472:
                        // 1 sources

                        if (range instanceof RealType) {
                            rgb[rgbc++] = (RealType)range;
                        }
lbl474:
                        // 5 sources

                        if (rgbc == 0) break;
                        if (rgbc < 3) {
                            try {
                                smaps = new ScalarMap[timeFunc < 0 ? 3 : 4];
                                if (RealType.Latitude.equals(x)) {
                                    smaps[0] = new ScalarMap(x, Display.YAxis);
                                    smaps[1] = new ScalarMap(y, Display.XAxis);
                                } else {
                                    smaps[0] = new ScalarMap(x, Display.XAxis);
                                    smaps[1] = new ScalarMap(y, Display.YAxis);
                                }
                                smaps[2] = new ScalarMap(rgb[0], Display.RGB);
                                if (timeFunc >= 0) {
                                    o = ds[0][timeFunc].funcs.elementAt(0);
                                    rtt = ((FunctionType)o).getDomain();
                                    time = (RealType)rtt.getComponent(0);
                                    smaps[3] = new ScalarMap(time, Display.Animation);
                                }
                                return smaps;
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            smaps = new ScalarMap[timeFunc < 0 ? 5 : 6];
                            if (RealType.Latitude.equals(x)) {
                                smaps[0] = new ScalarMap(x, Display.YAxis);
                                smaps[1] = new ScalarMap(y, Display.XAxis);
                            } else {
                                smaps[0] = new ScalarMap(x, Display.XAxis);
                                smaps[1] = new ScalarMap(y, Display.YAxis);
                            }
                            smaps[2] = new ScalarMap(rgb[0], Display.Red);
                            smaps[3] = new ScalarMap(rgb[1], Display.Green);
                            smaps[4] = new ScalarMap(rgb[2], Display.Blue);
                            if (timeFunc >= 0) {
                                o = ds[0][timeFunc].funcs.elementAt(0);
                                rtt = ((FunctionType)o).getDomain();
                                time = (RealType)rtt.getComponent(0);
                                smaps[5] = new ScalarMap(time, Display.Animation);
                            }
                            return smaps;
                        }
                        catch (VisADException exc) {
                            break;
                        }
                    }
                    case 5: {
                        domain = ft.getDomain();
                        if (domain.getDimension() != 1) break;
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                x = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            x = (RealType)domain.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = ft.getRange();
                        if (!(range instanceof FunctionType) || !(ft = (FunctionType)range).getFlat() || (domain = ft.getDomain()).getDimension() != 1) break;
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                y = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            y = (RealType)domain.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = ft.getRange();
                        a = null;
                        if (range instanceof RealType) {
                            a = (RealType)range;
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    break;
                                }
                                if (ttci instanceof RealType) {
                                    a = (RealType)ttci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (a == null) break;
                        try {
                            smaps = new ScalarMap[timeFunc < 0 ? 3 : 4];
                            if (RealType.Latitude.equals(x)) {
                                smaps[0] = new ScalarMap(x, Display.YAxis);
                                smaps[1] = new ScalarMap(y, Display.XAxis);
                            } else {
                                smaps[0] = new ScalarMap(x, Display.XAxis);
                                smaps[1] = new ScalarMap(y, Display.YAxis);
                            }
                            smaps[2] = new ScalarMap(a, threeD != false ? Display.ZAxis : Display.RGB);
                            if (timeFunc >= 0) {
                                o = ds[0][timeFunc].funcs.elementAt(0);
                                rtt = ((FunctionType)o).getDomain();
                                time = (RealType)rtt.getComponent(0);
                                smaps[3] = new ScalarMap(time, Display.Animation);
                            }
                            return smaps;
                        }
                        catch (VisADException exc) {
                            // empty catch block
                        }
                    }
                    case 6: {
                        if (!ft.getFlat() || (domain = ft.getDomain()).getDimension() != 1) break;
                        cs = domain.getCoordinateSystem();
                        if (cs != null) {
                            ref = cs.getReference();
                            try {
                                x = (RealType)ref.getComponent(0);
                            }
                            catch (VisADException exc) {
                                break;
                            }
                        }
                        try {
                            x = (RealType)domain.getComponent(0);
                        }
                        catch (VisADException exc) {
                            break;
                        }
                        range = ft.getRange();
                        a = null;
                        if (range instanceof RealType) {
                            a = (RealType)range;
                        } else if (range instanceof TupleType) {
                            tt = (TupleType)range;
                            i = 0;
                            while (i < tt.getDimension()) {
                                try {
                                    ttci = tt.getComponent(i);
                                }
                                catch (VisADException exc) {
                                    break;
                                }
                                if (ttci instanceof RealType) {
                                    a = (RealType)ttci;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (a == null) break;
                        try {
                            smaps = new ScalarMap[timeFunc < 0 ? 2 : 3];
                            if (RealType.Latitude.equals(x)) {
                                smaps[0] = new ScalarMap(x, Display.YAxis);
                                smaps[1] = new ScalarMap(a, Display.XAxis);
                            } else {
                                smaps[0] = new ScalarMap(x, Display.XAxis);
                                smaps[1] = new ScalarMap(a, Display.YAxis);
                            }
                            if (timeFunc >= 0) {
                                o = ds[0][timeFunc].funcs.elementAt(0);
                                rtt = ((FunctionType)o).getDomain();
                                time = (RealType)rtt.getComponent(0);
                                smaps[2] = new ScalarMap(time, Display.Animation);
                            }
                            return smaps;
                        }
                        catch (VisADException exc) {
                            // empty catch block
                        }
                    }
                }
                ++fi;
            }
            ++t;
        }
        spatial = new DisplayRealType[]{Display.XAxis, Display.YAxis, Display.ZAxis};
        mark = new boolean[]{false, false, false};
        maxdim = threeD != false ? 3 : 2;
        numsets = slist.size();
        dim = maxdim;
        while (dim >= 1) {
            si = 0;
            while (si < numsets) {
                st = (SetType)slist.elementAt(si);
                domain = st.getDomain();
                cs = domain.getCoordinateSystem();
                if (cs != null) {
                    domain = cs.getReference();
                }
                if (domain.getDimension() == dim) {
                    try {
                        smaps = new ScalarMap[timeFunc < 0 ? dim : dim + 1];
                        i = 0;
                        while (i < dim) {
                            rt = (RealType)domain.getComponent(i);
                            if (RealType.Latitude.equals(rt)) {
                                smaps[i] = new ScalarMap(rt, spatial[1]);
                                mark[1] = true;
                            } else if (RealType.Longitude.equals(rt)) {
                                smaps[i] = new ScalarMap(rt, spatial[0]);
                                mark[0] = true;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < dim) {
                            rt = (RealType)domain.getComponent(i);
                            if (!RealType.Latitude.equals(rt) && !RealType.Longitude.equals(rt)) {
                                j = 0;
                                while (j < 3) {
                                    if (!mark[j]) {
                                        smaps[i] = new ScalarMap(rt, spatial[j]);
                                        mark[j] = true;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        if (timeFunc >= 0) {
                            o = ds[0][timeFunc].funcs.elementAt(0);
                            rtt = ((FunctionType)o).getDomain();
                            time = (RealType)rtt.getComponent(0);
                            smaps[dim] = new ScalarMap(time, Display.Animation);
                        }
                        return smaps;
                    }
                    catch (VisADException exc) {
                        // empty catch block
                    }
                }
                ++si;
            }
            --dim;
        }
        numtuples = tlist.size();
        if (numtuples >= 1) {
            domain = (RealTupleType)tlist.elementAt(0);
            cs = domain.getCoordinateSystem();
            if (cs != null) {
                domain = cs.getReference();
            }
            if ((dim = domain.getDimension()) > maxdim) {
                dim = maxdim;
            }
            try {
                smaps = new ScalarMap[timeFunc < 0 ? dim : dim + 1];
                i = 0;
                while (i < dim) {
                    rt = (RealType)domain.getComponent(i);
                    smaps[i] = new ScalarMap(rt, spatial[i]);
                    ++i;
                }
                if (timeFunc >= 0) {
                    o = ds[0][timeFunc].funcs.elementAt(0);
                    rtt = ((FunctionType)o).getDomain();
                    time = (RealType)rtt.getComponent(0);
                    smaps[dim] = new ScalarMap(time, Display.Animation);
                }
                return smaps;
            }
            catch (VisADException exc) {
                // empty catch block
            }
        }
        return null;
    }

    private void buildTypeList(MathType mt, Vector flist, Vector slist, Vector tlist) {
        if (mt instanceof TupleType) {
            TupleType tt = (TupleType)mt;
            if (tt instanceof RealTupleType) {
                tlist.addElement(mt);
            } else {
                int i = 0;
                while (i < tt.getDimension()) {
                    try {
                        this.buildTypeList(tt.getComponent(i), flist, slist, tlist);
                    }
                    catch (VisADException exc) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        } else if (mt instanceof SetType) {
            slist.addElement(mt);
        } else if (mt instanceof FunctionType) {
            flist.addElement(mt);
            FunctionType ft = (FunctionType)mt;
            this.buildTypeList(ft.getRange(), flist, slist, tlist);
        }
    }

    private void findTimeFunction(MathType mt, DataStruct[][] info, Hashtable invalid) {
        boolean wasnull = false;
        if (invalid == null) {
            invalid = new Hashtable<String, RealType>();
            wasnull = true;
        }
        if (mt instanceof TupleType) {
            TupleType tt = (TupleType)mt;
            int i = 0;
            while (i < tt.getDimension()) {
                MathType tc = null;
                try {
                    tc = tt.getComponent(i);
                }
                catch (VisADException exc) {
                    // empty catch block
                }
                this.findTimeFunction(tc, info, invalid);
                ++i;
            }
        } else if (mt instanceof SetType) {
            SetType st = (SetType)mt;
            this.findTimeFunction(st.getDomain(), info, invalid);
        } else if (mt instanceof FunctionType) {
            FunctionType ft = (FunctionType)mt;
            RealTupleType domain = ft.getDomain();
            MathType range = ft.getRange();
            RealType rtc0 = null;
            try {
                rtc0 = (RealType)domain.getComponent(0);
            }
            catch (VisADException exc) {
                // empty catch block
            }
            boolean found = false;
            if (rtc0 != null && domain.getDimension() == 1) {
                String rtname = rtc0.getName();
                int i = 0;
                while (i < info[0].length) {
                    if (rtname.equals(info[0][i].name)) {
                        info[0][i].funcs.addElement(ft);
                        found = true;
                    }
                    ++i;
                }
                Unit rtc0_unit = rtc0.getDefaultUnit();
                if (SI.second.isConvertible(rtc0_unit) || CommonUnit.secondsSinceTheEpoch.isConvertible(rtc0_unit)) {
                    int len = info[0].length;
                    DataStruct[] temp = new DataStruct[len + 1];
                    int i2 = 0;
                    while (i2 < len) {
                        temp[i2] = info[0][i2];
                        ++i2;
                    }
                    temp[len] = new DataStruct(rtname);
                    temp[len].funcs.addElement(ft);
                    info[0] = temp;
                    found = true;
                }
            }
            if (!found) {
                this.findTimeFunction(domain, info, invalid);
            }
            this.findTimeFunction(range, info, invalid);
        } else if (mt instanceof RealType) {
            RealType rt = (RealType)mt;
            String rtname = rt.getName();
            invalid.put(rtname, rt);
        }
        if (wasnull) {
            int i = 0;
            while (i < info[0].length) {
                if (invalid.get(info[0][i].name) != null) {
                    info[0][i].fvalid = false;
                }
                ++i;
            }
        }
    }

    public static boolean findScalarType(MathType mt, ScalarType st) throws VisADException {
        if (mt == null || st == null) {
            return false;
        }
        if (mt instanceof TupleType) {
            TupleType tt = (TupleType)mt;
            int i = 0;
            while (i < tt.getDimension()) {
                MathType tc = tt.getComponent(i);
                if (MathType.findScalarType(tc, st)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (mt instanceof SetType) {
            SetType et = (SetType)mt;
            return MathType.findScalarType(et.getDomain(), st);
        }
        if (mt instanceof FunctionType) {
            FunctionType ft = (FunctionType)mt;
            RealTupleType domain = ft.getDomain();
            MathType range = ft.getRange();
            return MathType.findScalarType(domain, st) || MathType.findScalarType(range, st);
        }
        if (mt instanceof ScalarType) {
            return mt.equals(st);
        }
        return false;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType X = RealType.getRealType("Xxxxxx");
        RealType Y = RealType.getRealType("Yyyyyy");
        RealType Z = RealType.getRealType("Zzzzzz");
        RealType A = RealType.getRealType("Aaaaaa");
        RealType B = RealType.getRealType("Bbbbbb");
        RealType[] domain2d = new RealType[]{X, Y};
        RealTupleType Domain2d = new RealTupleType(domain2d);
        RealType[] range2d = new RealType[]{A, B};
        RealTupleType Range2d = new RealTupleType(range2d);
        FunctionType Field2d1 = new FunctionType(Domain2d, A);
        FunctionType Field2d2 = new FunctionType(Domain2d, Range2d);
        FunctionType Field2d3 = new FunctionType(Domain2d, B);
        FunctionType function = new FunctionType(X, Field2d2);
        MathType[] littles = new MathType[]{Range2d, Field2d1, function};
        TupleType little = new TupleType(littles);
        FunctionType little_function = new FunctionType(X, little);
        SetType set = new SetType(Domain2d);
        MathType[] types = new MathType[]{Range2d, little_function, Field2d1, Field2d2, function, set, Field2d3};
        TupleType tuple = new TupleType(types);
        FunctionType big_function = new FunctionType(Range2d, tuple);
        System.out.println("prettyString for first MathType:");
        String s1 = big_function.prettyString();
        System.out.println(s1 + "\n");
        MathType t1 = MathType.stringToType(s1);
        System.out.println("stringToType for first MathType:");
        System.out.println(t1.prettyString() + "\n");
        RealType T = RealType.getRealType("time");
        RealTupleType Domain1d = new RealTupleType(new RealType[]{T});
        RealType Rxx = RealType.getRealType("Red");
        RealType Gxx = RealType.getRealType("Green");
        RealType Bxx = RealType.getRealType("Blue");
        RealTupleType Range3d = new RealTupleType(new RealType[]{Rxx, Gxx, Bxx});
        FunctionType image = new FunctionType(Domain2d, Range3d);
        function = new FunctionType(Domain1d, image);
        System.out.println("prettyString for second MathType:");
        String s2 = function.prettyString();
        System.out.println(s2 + "\n");
        MathType t2 = MathType.stringToType(s2);
        System.out.println("stringToType for second MathType:");
        System.out.println(t2.prettyString() + "\n");
        System.out.println("Guessing at some good mappings for this MathType...");
        ScalarMap[] smaps = function.guessMaps(true);
        if (smaps == null) {
            System.out.println("Could not identify a good set of mappings!");
        } else {
            int i = 0;
            while (i < smaps.length) {
                ScalarType s = smaps[i].getScalar();
                DisplayRealType ds = smaps[i].getDisplayScalar();
                System.out.println(s.getName() + " -> " + ds.getName());
                ++i;
            }
        }
        String s3 = "((Row, Col, Lev) -> Radiance)";
        String s3s = MathType.stringToType(s3).prettyString();
        System.out.println("s3 = \n" + s3 + "\ns3s = \n" + s3s);
    }

    private class DataStruct {
        boolean fvalid = true;
        String name;
        Vector funcs = new Vector();

        DataStruct(String s) {
            this.name = s;
        }
    }
}

