/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.QuickSort;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Irregular1DSet
extends IrregularSet {
    float LowX;
    float HiX;
    Gridded1DSet SortedSet;

    public Irregular1DSet(MathType type, float[][] samples) throws VisADException {
        this(type, samples, null, null, null, true);
    }

    public Irregular1DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, coord_sys, units, errors, true);
    }

    public Irregular1DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, samples, samples.length, coord_sys, units, errors, null, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        float[][] sortedSamples = new float[1][this.Length];
        int i = 0;
        while (i < this.Length) {
            sortedSamples[0][i] = this.Samples[0][i];
            ++i;
        }
        this.newToOld = QuickSort.sort(sortedSamples[0]);
        this.oldToNew = new int[this.Length];
        int i2 = 0;
        while (i2 < this.Length) {
            this.oldToNew[this.newToOld[i2]] = i2;
            ++i2;
        }
        this.SortedSet = new Gridded1DSet(type, sortedSamples, this.Length, coord_sys, units, errors, false);
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        if (samples.length == 3) {
            return new Irregular3DSet((MathType)type, samples, this.newToOld, this.oldToNew, null, null, null, false);
        }
        if (samples.length == 2) {
            return new Irregular2DSet((MathType)type, samples, this.newToOld, this.oldToNew, null, null, null, false);
        }
        if (samples.length == 1) {
            return new Irregular1DSet((MathType)type, samples, null, null, null, false);
        }
        throw new SetException("Irregular1DSet.makeSpatial: bad samples length");
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int[] newIndex = new int[index.length];
        int i = 0;
        while (i < index.length) {
            newIndex[i] = 0 <= index[i] && index[i] < this.Length ? this.oldToNew[index[i]] : -1;
            ++i;
        }
        float[][] value = this.SortedSet.indexToValue(newIndex);
        return value;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        int[] index = this.SortedSet.valueToIndex(value);
        int[] newIndex = new int[index.length];
        int i = 0;
        while (i < index.length) {
            newIndex[i] = index[i] == -1 ? -1 : this.newToOld[index[i]];
            ++i;
        }
        return newIndex;
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        this.SortedSet.valueToInterp(value, indices, weights);
        int j = 0;
        while (j < indices.length) {
            if (indices[j] != null) {
                int[] newIndex = new int[indices[j].length];
                int i = 0;
                while (i < indices[j].length) {
                    newIndex[i] = this.newToOld[indices[j][i]];
                    ++i;
                }
                indices[j] = newIndex;
            }
            ++j;
        }
    }

    public float getLowX() {
        return this.LowX;
    }

    public float getHiX() {
        return this.HiX;
    }

    public Object clone() {
        try {
            return new Irregular1DSet(this.Type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException e) {
            throw new VisADError("Irregular1DSet.clone: " + e.toString());
        }
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new Irregular1DSet(type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] argv) throws VisADException {
        float[][] samp = new float[][]{{130.0f, 55.0f, 37.0f, 28.0f, 61.0f, 40.0f, 104.0f, 52.0f, 65.0f, 12.0f}};
        int length = samp[0].length;
        int[] index = new int[length];
        int i = 0;
        while (i < length) {
            index[i] = i;
            ++i;
        }
        RealType test1 = RealType.getRealType("x");
        RealType[] t_array = new RealType[]{test1};
        RealTupleType t_tuple = new RealTupleType(t_array);
        Irregular1DSet iSet1D = new Irregular1DSet((MathType)t_tuple, samp);
        System.out.println("Samples (indexToValue test):");
        float[][] value = iSet1D.indexToValue(index);
        int i2 = 0;
        while (i2 < iSet1D.Length) {
            System.out.println("#" + i2 + ":\t" + value[0][i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < iSet1D.Length) {
            System.out.println("#" + i3 + ":\t" + iSet1D.oldToNew[i3] + " " + iSet1D.newToOld[i3]);
            ++i3;
        }
        System.out.println("\nvalueToIndex test:");
        float[][] value2 = new float[][]{{10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 80.0f, 90.0f, 100.0f, 110.0f, 120.0f, 130.0f}};
        int[] index2 = iSet1D.valueToIndex(value2);
        int i4 = 0;
        while (i4 < index2.length) {
            System.out.println(value2[0][i4] + "\t--> " + index2[i4]);
            ++i4;
        }
        System.out.println("\nvalueToInterp test:");
        int[][] indices = new int[value2[0].length][];
        float[][] weights = new float[value2[0].length][];
        iSet1D.valueToInterp(value2, indices, weights);
        int i5 = 0;
        while (i5 < value2[0].length) {
            System.out.print(value2[0][i5] + "\t--> [" + indices[i5][0]);
            int j = 1;
            while (j < indices[i5].length) {
                System.out.print(", " + indices[i5][j]);
                ++j;
            }
            System.out.print("]\tweight total: ");
            float total = 0.0f;
            int j2 = 0;
            while (j2 < weights[i5].length) {
                total += weights[i5][j2];
                ++j2;
            }
            System.out.println(total);
            ++i5;
        }
    }
}

