/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class IntegerNDSet
extends LinearNDSet
implements IntegerSet {
    public IntegerNDSet(int[] lengths) throws VisADException {
        this((MathType)IntegerNDSet.get_generic_type(lengths), lengths, null, null, null);
    }

    public IntegerNDSet(MathType type, int[] lengths) throws VisADException {
        this(type, lengths, null, null, null);
    }

    public IntegerNDSet(MathType type, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, LinearNDSet.get_linear1d_array(type, IntegerNDSet.get_firsts(lengths), IntegerNDSet.get_lasts(lengths), lengths), coord_sys, units, errors);
    }

    public IntegerNDSet(MathType type, Integer1DSet[] sets) throws VisADException {
        this(type, sets, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public IntegerNDSet(MathType type, Integer1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, sets, coord_sys, units, errors);
    }

    public static GriddedSet create(MathType type, int[] lengths) throws VisADException {
        return IntegerNDSet.create(type, lengths, null, null, null);
    }

    public static GriddedSet create(MathType type, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        switch (lengths.length) {
            case 1: {
                return new Integer1DSet(type, lengths[0], coord_sys, units, errors);
            }
            case 2: {
                return new Integer2DSet(type, lengths[0], lengths[1], coord_sys, units, errors);
            }
            case 3: {
                return new Integer3DSet(type, lengths[0], lengths[1], lengths[2], coord_sys, units, errors);
            }
        }
        return new IntegerNDSet(type, lengths, coord_sys, units, errors);
    }

    private static SetType get_generic_type(int[] lengths) throws VisADException {
        if (lengths == null || lengths.length == 0) {
            throw new SetException("IntegerNDSet: bad lengths");
        }
        int n = lengths.length;
        RealType[] reals = new RealType[n];
        int i = 0;
        while (i < n) {
            reals[i] = RealType.Generic;
            ++i;
        }
        return new SetType(new RealTupleType(reals));
    }

    private static double[] get_firsts(int[] lengths) {
        double[] firsts = new double[lengths.length];
        int j = 0;
        while (j < lengths.length) {
            firsts[j] = 0.0;
            ++j;
        }
        return firsts;
    }

    private static double[] get_lasts(int[] lengths) {
        double[] lasts = new double[lengths.length];
        int j = 0;
        while (j < lengths.length) {
            lasts[j] = lengths[j] - 1;
            ++j;
        }
        return lasts;
    }

    private static int[] get_lengths(Real[] lengths) {
        int[] ss = new int[lengths.length];
        int j = 0;
        while (j < lengths.length) {
            ss[j] = (int)lengths[j].getValue();
            ++j;
        }
        return ss;
    }

    public Object clone() {
        try {
            int[] lens = new int[this.DomainDimension];
            int j = 0;
            while (j < this.DomainDimension) {
                lens[j] = this.L[j].getLength();
                ++j;
            }
            return new IntegerNDSet(this.Type, lens, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException e) {
            throw new VisADError("IntegerNDSet.clone: " + e.toString());
        }
    }

    public Object cloneButType(MathType type) throws VisADException {
        int[] lens = new int[this.DomainDimension];
        int j = 0;
        while (j < this.DomainDimension) {
            lens[j] = this.L[j].getLength();
            ++j;
        }
        return new IntegerNDSet(type, lens, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String pre) throws VisADException {
        String s = pre + "IntegerNDSet: Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
        int j = 0;
        while (j < this.DomainDimension) {
            s = s + pre + "  Dimension " + j + ":" + " Linear1DSet = " + this.L[j] + "\n";
            ++j;
        }
        return s;
    }
}

