/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DomainException;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldEnumerator;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.Function;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class FieldImpl
extends FunctionImpl
implements Field {
    Set DomainSet;
    CoordinateSystem DomainCoordinateSystem;
    Unit[] DomainUnits;
    int Length;
    private Data[] Range;
    private boolean MissingFlag;

    public FieldImpl(FunctionType type) throws VisADException {
        this(type, null);
    }

    public FieldImpl(FunctionType type, Set set) throws VisADException {
        super(type);
        RealTupleType DomainType = type.getDomain();
        if (set == null) {
            set = DomainType.getDefaultSet();
        }
        if (set == null) {
            throw new SetException("FieldImpl: set cannot be null");
        }
        if (set instanceof DoubleSet || set instanceof FloatSet) {
            throw new SetException("FieldImpl: set may not be DoubleSet or FloatSet");
        }
        if (DomainType.getDimension() != set.getDimension()) {
            throw new SetException("FieldImpl: set and type dimensions don't match");
        }
        this.DomainSet = DomainType.equals(((SetType)set.getType()).getDomain()) ? set : (Set)set.cloneButType(new SetType(DomainType));
        this.DomainCoordinateSystem = this.DomainSet.getCoordinateSystem();
        CoordinateSystem domTypeCs = DomainType.getCoordinateSystem();
        boolean bl = domTypeCs == null ? this.DomainCoordinateSystem != null : this.DomainCoordinateSystem != null && !domTypeCs.getReference().equals(this.DomainCoordinateSystem.getReference());
        if (bl) {
            throw new CoordinateSystemException(domTypeCs, this.DomainCoordinateSystem);
        }
        this.DomainUnits = this.DomainSet.getSetUnits();
        this.Length = this.DomainSet.getLength();
        this.Range = new Data[this.Length];
        this.MissingFlag = true;
    }

    public void setSamples(Data[] range, boolean copy) throws VisADException, RemoteException {
        if (range == null) {
            this.Range = new Data[this.Length];
            this.MissingFlag = true;
            return;
        }
        if (range.length != this.Length) {
            throw new FieldException("FieldImpl.setSamples: bad array length");
        }
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            this.MissingFlag = false;
            MathType t = ((FunctionType)this.Type).getRange();
            int i = 0;
            while (i < this.Length) {
                if (range[i] != null) {
                    if (!t.equals(range[i].getType())) {
                        throw new TypeException("FieldImpl.setSamples: types don't match");
                    }
                    this.Range[i] = copy ? (Data)range[i].dataClone() : range[i];
                } else {
                    this.Range[i] = null;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.Length) {
                if (this.Range[i2] instanceof DataImpl) {
                    ((DataImpl)this.Range[i2]).setParent(this);
                }
                ++i2;
            }
        }
        this.notifyReferences();
    }

    public Set getDomainSet() {
        return this.DomainSet;
    }

    public int getLength() {
        return this.Length;
    }

    public Unit[] getDomainUnits() {
        return this.DomainUnits;
    }

    public CoordinateSystem getDomainCoordinateSystem() {
        return this.DomainCoordinateSystem;
    }

    public String[][] getStringValues() throws VisADException, RemoteException {
        TextType[] textComponents = ((FunctionType)this.Type).getTextComponents();
        if (textComponents == null) {
            return null;
        }
        int[] textIndices = ((FunctionType)this.Type).getTextIndices();
        int n = textComponents.length;
        int len = this.getLength();
        String[][] values = new String[n][len];
        if (this.isMissing()) {
            int k = 0;
            while (k < n) {
                int i = 0;
                while (i < len) {
                    values[k][i] = "";
                    ++i;
                }
                ++k;
            }
            return values;
        }
        MathType RangeType = ((FunctionType)this.Type).getRange();
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            int i = 0;
            while (i < len) {
                int k;
                Data range = this.Range[i];
                if (range == null || range.isMissing()) {
                    k = 0;
                    while (k < n) {
                        values[k][i] = "";
                        ++k;
                    }
                } else if (RangeType instanceof TextType) {
                    values[0][i] = ((Text)range).getValue();
                } else if (RangeType instanceof TupleType) {
                    k = 0;
                    while (k < n) {
                        Text t = (Text)((TupleIface)range).getComponent(textIndices[k]);
                        values[k][i] = t.getValue();
                        ++k;
                    }
                }
                ++i;
            }
        }
        return values;
    }

    public float[][] getFloats() throws VisADException, RemoteException {
        return this.getFloats(true);
    }

    public float[][] getFloats(boolean copy) throws VisADException, RemoteException {
        return Set.doubleToFloat(this.getValues(copy));
    }

    public double[][] getValues() throws VisADException, RemoteException {
        return this.getValues(true);
    }

    public double[][] getValues(boolean copy) throws VisADException, RemoteException {
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (realComponents == null) {
            return null;
        }
        int n = realComponents.length;
        Unit[] units = this.getDefaultRangeUnits();
        int len = this.getLength();
        double[][] values = new double[n][len];
        if (this.isMissing()) {
            int k = 0;
            while (k < n) {
                int i = 0;
                while (i < len) {
                    values[k][i] = Double.NaN;
                    ++i;
                }
                ++k;
            }
            return values;
        }
        MathType RangeType = ((FunctionType)this.Type).getRange();
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            int i = 0;
            while (i < len) {
                int k;
                Data range = this.Range[i];
                if (range == null || range.isMissing()) {
                    k = 0;
                    while (k < n) {
                        values[k][i] = Double.NaN;
                        ++k;
                    }
                } else if (RangeType instanceof RealType) {
                    values[0][i] = ((Real)range).getValue(units[0]);
                } else if (RangeType instanceof TupleType) {
                    k = 0;
                    int j = 0;
                    while (j < ((TupleType)RangeType).getDimension()) {
                        MathType component_type = ((TupleType)RangeType).getComponent(j);
                        Data component = ((TupleIface)range).getComponent(j);
                        if (component_type instanceof RealType) {
                            values[k][i] = ((Real)component).getValue(units[k]);
                            ++k;
                        } else if (component_type instanceof RealTupleType) {
                            int m = 0;
                            while (m < ((TupleType)component_type).getDimension()) {
                                Data comp_comp = ((TupleIface)component).getComponent(m);
                                values[k][i] = ((Real)comp_comp).getValue(units[k]);
                                ++k;
                                ++m;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return values;
    }

    public void setSamples(double[][] range) throws VisADException, RemoteException {
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (!((FunctionType)this.Type).getFlat()) {
            throw new FieldException("FieldImpl.setSamples: not Flat range");
        }
        if (realComponents == null) {
            throw new FieldException("FieldImpl.setSamples: no Real components");
        }
        int n = realComponents.length;
        int len = this.getLength();
        if (range == null || range.length != n) {
            throw new FieldException("FieldImpl.setSamples: bad tuple length");
        }
        if (range[0] == null || range[0].length != len) {
            throw new FieldException("FieldImpl.setSamples: bad array length");
        }
        Unit[] units = this.getDefaultRangeUnits();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            if (RangeType instanceof RealType) {
                int i = 0;
                while (i < len) {
                    this.Range[i] = new Real((RealType)RangeType, range[0][i], units[0]);
                    ++i;
                }
            } else if (RangeType instanceof RealTupleType) {
                int ntup = ((RealTupleType)RangeType).getDimension();
                Real[] reals = new Real[ntup];
                int i = 0;
                while (i < len) {
                    int j = 0;
                    while (j < ntup) {
                        RealType type = (RealType)((RealTupleType)RangeType).getComponent(j);
                        reals[j] = new Real(type, range[j][i], units[j]);
                        ++j;
                    }
                    this.Range[i] = new RealTuple(reals);
                    ++i;
                }
            } else if (RangeType instanceof TupleType) {
                int ntup = ((TupleType)RangeType).getDimension();
                Data[] data = new Real[ntup];
                MathType[] types = new MathType[ntup];
                int j = 0;
                while (j < ntup) {
                    types[j] = ((TupleType)RangeType).getComponent(j);
                    ++j;
                }
                int i = 0;
                while (i < len) {
                    int k = 0;
                    int j2 = 0;
                    while (j2 < ntup) {
                        if (types[j2] instanceof RealType) {
                            data[j2] = new Real((RealType)types[j2], range[k][i], units[k]);
                            ++k;
                        } else {
                            int mtup = ((RealTupleType)types[j2]).getDimension();
                            Real[] reals = new Real[mtup];
                            int m = 0;
                            while (m < mtup) {
                                RealType type = (RealType)((RealTupleType)types[j2]).getComponent(m);
                                reals[m] = new Real(type, range[k][i], units[k]);
                                ++k;
                                ++m;
                            }
                            data[j2] = new RealTuple(reals);
                        }
                        ++j2;
                    }
                    this.Range[i] = new Tuple(data);
                    ++i;
                }
            }
        }
    }

    public void setSamples(float[][] range) throws VisADException, RemoteException {
        this.setSamples(Set.floatToDouble(range));
    }

    public Unit[][] getRangeUnits() throws VisADException, RemoteException {
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (realComponents == null) {
            return null;
        }
        int n = realComponents.length;
        Unit[][] units = new Unit[n][this.Length];
        Unit[] default_units = this.getDefaultRangeUnits();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        int i = 0;
        while (i < this.Length) {
            int k;
            Data range = this.Range[i];
            if (range == null || range.isMissing()) {
                k = 0;
                while (k < n) {
                    units[k][i] = default_units[k];
                    ++k;
                }
            } else if (RangeType instanceof RealType) {
                units[0][i] = ((Real)range).getUnit();
            } else if (RangeType instanceof TupleType) {
                k = 0;
                int j = 0;
                while (j < ((TupleType)RangeType).getDimension()) {
                    MathType component_type = ((TupleType)RangeType).getComponent(i);
                    Data component = ((TupleIface)range).getComponent(j);
                    if (component_type instanceof RealType) {
                        units[k][i] = ((Real)component).getUnit();
                        ++k;
                    } else if (component_type instanceof RealTupleType) {
                        int m = 0;
                        while (m < ((TupleType)component_type).getDimension()) {
                            Data comp_comp = ((TupleIface)component).getComponent(m);
                            units[k][i] = ((Real)comp_comp).getUnit();
                            ++k;
                            ++m;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return units;
    }

    public CoordinateSystem[] getRangeCoordinateSystem() throws VisADException, RemoteException {
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (!(RangeType instanceof RealTupleType)) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: Range is not RealTupleType");
        }
        CoordinateSystem[] cs = new CoordinateSystem[this.Length];
        CoordinateSystem default_cs = ((RealTupleType)RangeType).getCoordinateSystem();
        int i = 0;
        while (i < this.Length) {
            Data range = this.Range[i];
            cs[i] = range == null || range.isMissing() ? default_cs : ((RealTuple)range).getCoordinateSystem();
            ++i;
        }
        return cs;
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int component) throws VisADException, RemoteException {
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (!(RangeType instanceof TupleType) || RangeType instanceof RealTupleType) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: Range must be TupleType but not RealTupleType");
        }
        MathType component_type = ((TupleType)RangeType).getComponent(component);
        if (!(component_type instanceof RealTupleType)) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: selected Range component must be RealTupleType");
        }
        CoordinateSystem[] cs = new CoordinateSystem[this.Length];
        CoordinateSystem default_cs = ((RealTupleType)component_type).getCoordinateSystem();
        int i = 0;
        while (i < this.Length) {
            Data comp;
            Data range = this.Range[i];
            cs[i] = range == null || range.isMissing() ? default_cs : ((comp = ((TupleIface)range).getComponent(component)) == null || comp.isMissing() ? default_cs : ((RealTuple)comp).getCoordinateSystem());
            ++i;
        }
        return cs;
    }

    public Unit[] getDefaultRangeUnits() {
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (realComponents == null) {
            return null;
        }
        int n = realComponents.length;
        Unit[] units = new Unit[n];
        int i = 0;
        while (i < n) {
            units[i] = realComponents[i].getDefaultUnit();
            ++i;
        }
        return units;
    }

    public Data getSample(int index) throws VisADException, RemoteException {
        return this.getSample(index, false);
    }

    public Data getSample(int index, boolean metadataOnly) throws VisADException, RemoteException {
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            if (this.isMissing() || index < 0 || index >= this.Length || this.Range[index] == null) {
                Data data = ((FunctionType)this.Type).getRange().missingData();
                return data;
            }
            Data data = this.Range[index];
            return data;
        }
    }

    public void setSample(RealTuple domain, Data range, boolean copy) throws VisADException, RemoteException {
        if (this.DomainSet == null) {
            throw new FieldException("FieldImpl.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.Type).getDomain().equals(domain.getType())) {
            throw new TypeException("FieldImpl.setSample: bad domain type");
        }
        int dimension = this.DomainSet.getDimension();
        double[][] vals = new double[dimension][1];
        int j = 0;
        while (j < dimension) {
            vals[j][0] = ((Real)domain.getComponent(j)).getValue();
            ++j;
        }
        int[] indices = this.DomainSet.doubleToIndex(vals);
        this.setSample(indices[0], range, copy);
    }

    public void setSample(RealTuple domain, Data range) throws VisADException, RemoteException {
        this.setSample(domain, range, true);
    }

    public void setSample(int index, Data range) throws VisADException, RemoteException {
        this.setSample(index, range, true);
    }

    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        if (this.DomainSet == null) {
            throw new FieldException("FieldImpl.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.Type).getRange().equals(range.getType())) {
            throw new TypeException("FieldImpl.setSample: bad range type");
        }
        if (index >= 0 && index < this.Length) {
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                this.MissingFlag = false;
                this.Range[index] = copy ? (Data)range.dataClone() : range;
                if (this.Range[index] instanceof DataImpl) {
                    ((DataImpl)this.Range[index]).setParent(this);
                }
            }
        }
        this.notifyReferences();
    }

    public boolean isMissing() {
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            boolean bl = this.MissingFlag;
            return bl;
        }
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        boolean field_flag;
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (this.Type.equalsExceptName(data.getType())) {
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            field_flag = true;
            if (((Field)data).isFlatField()) {
                data = data.local();
                data = ((FlatField)data).convertToField();
            }
        } else if (data instanceof Real || ((FunctionType)this.Type).getRange().equalsExceptName(data.getType())) {
            field_flag = false;
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
        } else {
            if (data instanceof Field && ((FunctionType)data.getType()).getRange().equalsExceptName(this.Type)) {
                if (!((FunctionType)data.getType()).getRange().equalsExceptName(new_type)) {
                    throw new TypeException("binary: new_type doesn't match return type");
                }
                return data.binary(this, DataImpl.invertOp(op), new_type, sampling_mode, error_mode);
            }
            throw new TypeException("FieldImpl.binary: types don't match");
        }
        FieldImpl new_field = new FieldImpl((FunctionType)new_type, this.DomainSet);
        if (this.isMissing() || data.isMissing()) {
            return new_field;
        }
        Data[] range = new Data[this.Length];
        MathType m_type = ((FunctionType)new_type).getRange();
        if (field_flag) {
            data = ((Field)data).resample(this.DomainSet, sampling_mode, error_mode);
            int i = 0;
            while (i < this.Length) {
                Data[] dataArray = this.Range;
                synchronized (dataArray) {
                    range[i] = this.Range[i] == null ? null : this.Range[i].binary(((Field)data).getSample(i), op, m_type, sampling_mode, error_mode);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.Length) {
                Data[] dataArray = this.Range;
                synchronized (dataArray) {
                    range[i] = this.Range[i] == null ? null : this.Range[i].binary(data, op, m_type, sampling_mode, error_mode);
                }
                ++i;
            }
        }
        new_field.setSamples(range, false);
        return new_field;
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(new_type)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        MathType m_type = ((FunctionType)new_type).getRange();
        FieldImpl new_field = new FieldImpl((FunctionType)new_type, this.DomainSet);
        if (this.isMissing()) {
            return new_field;
        }
        Data[] range = new Data[this.Length];
        int i = 0;
        while (i < this.Length) {
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                range[i] = this.Range[i] == null ? null : this.Range[i].unary(op, m_type, sampling_mode, error_mode);
            }
            ++i;
        }
        new_field.setSamples(range, false);
        return new_field;
    }

    public static Field combine(Field[] fields) throws VisADException, RemoteException {
        return FieldImpl.combine(fields, 100, 202);
    }

    public static Field combine(Field[] fields, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        FieldImpl new_field;
        int jj;
        int n_dims;
        int domainDim = 0;
        boolean allFlat = true;
        Field field_0 = fields[0];
        int n_fields = fields.length;
        MathType[] fieldRange_s = new MathType[n_fields];
        MathType[][] rangeComp_s = new MathType[n_fields][];
        FunctionType[] fieldType_s = new FunctionType[n_fields];
        boolean cnt = false;
        n_fields = fields.length;
        int n_comps = 0;
        int ii = 0;
        while (ii < n_fields) {
            if (ii == 0) {
                domainDim = field_0.getDomainDimension();
            } else if (domainDim != fields[ii].getDomainDimension()) {
                throw new VisADException("FieldImpl.combine: domain dimensions of inputfields must match");
            }
            if (!fields[ii].isFlatField()) {
                allFlat = false;
            }
            fieldType_s[ii] = (FunctionType)fields[ii].getType();
            fieldRange_s[ii] = ((FunctionType)fields[ii].getType()).getRange();
            MathType range = fieldRange_s[ii];
            if (range instanceof RealType) {
                rangeComp_s[ii] = new MathType[1];
                rangeComp_s[ii][0] = range;
                ++n_comps;
            } else if (range instanceof RealTupleType) {
                rangeComp_s[ii] = new MathType[1];
                rangeComp_s[ii][0] = range;
                ++n_comps;
            } else if (range instanceof TupleType) {
                n_dims = ((TupleType)range).getDimension();
                rangeComp_s[ii] = new MathType[n_dims];
                jj = 0;
                while (jj < n_dims) {
                    rangeComp_s[ii][jj] = ((TupleType)range).getComponent(jj);
                    ++jj;
                }
                n_comps += n_dims;
            } else {
                rangeComp_s[ii] = new MathType[1];
                rangeComp_s[ii][0] = range;
                ++n_comps;
            }
            ++ii;
        }
        Set domainSet_0 = field_0.getDomainSet();
        RealTupleType domainType_0 = ((FunctionType)field_0.getType()).getDomain();
        int n_samples_0 = domainSet_0.getLength();
        if (allFlat) {
            TupleType new_range;
            int length;
            boolean allReal = true;
            int tupleDim = 0;
            cnt = false;
            Vector<CoordinateSystem> coordsys_s = new Vector<CoordinateSystem>();
            Vector<MathType> m_types = new Vector<MathType>();
            Vector<MathType> r_types = new Vector<MathType>();
            ii = 0;
            while (ii < n_fields) {
                MathType m_type;
                CoordinateSystem[] rangeCoordSys_s;
                Field field = fields[ii];
                MathType fieldRange = fieldRange_s[ii];
                if (fieldRange instanceof RealType) {
                    m_types.add(fieldRange);
                    r_types.add(fieldRange);
                    rangeCoordSys_s = field.getRangeCoordinateSystem();
                    coordsys_s.add(rangeCoordSys_s[0]);
                    ++tupleDim;
                } else if (fieldRange instanceof RealTupleType) {
                    n_dims = ((RealTupleType)fieldRange).getDimension();
                    tupleDim += n_dims;
                    rangeCoordSys_s = field.getRangeCoordinateSystem();
                    if (rangeCoordSys_s[0] == null) {
                        jj = 0;
                        while (jj < n_dims) {
                            m_type = ((RealTupleType)fieldRange).getComponent(jj);
                            m_types.add(m_type);
                            r_types.add(m_type);
                            coordsys_s.add(null);
                            ++jj;
                        }
                    } else {
                        m_types.add(fieldRange);
                        coordsys_s.add(rangeCoordSys_s[0]);
                        allReal = false;
                    }
                } else {
                    jj = 0;
                    while (jj < rangeComp_s[ii].length) {
                        rangeCoordSys_s = field.getRangeCoordinateSystem(jj);
                        m_type = rangeComp_s[ii][jj];
                        if (m_type instanceof RealType) {
                            r_types.add(m_type);
                            m_types.add(m_type);
                            coordsys_s.add(rangeCoordSys_s[0]);
                            ++tupleDim;
                        } else if (m_type instanceof RealTupleType) {
                            n_dims = ((RealTupleType)m_type).getDimension();
                            tupleDim += n_dims;
                            if (rangeCoordSys_s[0] == null) {
                                int kk = 0;
                                while (kk < n_dims) {
                                    m_types.add(((RealTupleType)m_type).getComponent(kk));
                                    r_types.add(((RealTupleType)m_type).getComponent(kk));
                                    coordsys_s.add(null);
                                    ++kk;
                                }
                            } else {
                                m_types.add(m_type);
                                coordsys_s.add(rangeCoordSys_s[0]);
                                allReal = false;
                            }
                        }
                        ++jj;
                    }
                }
                ++ii;
            }
            if (allReal) {
                length = r_types.size();
                RealType[] r_array = new RealType[length];
                ii = 0;
                while (ii < length) {
                    r_array[ii] = (RealType)r_types.elementAt(ii);
                    ++ii;
                }
                new_range = new RealTupleType(r_array);
            } else {
                length = m_types.size();
                MathType[] m_array = new MathType[length];
                ii = 0;
                while (ii < length) {
                    m_array[ii] = (MathType)m_types.elementAt(ii);
                    ++ii;
                }
                new_range = new TupleType(m_array);
            }
            FunctionType new_type = new FunctionType(domainType_0, new_range);
            length = coordsys_s.size();
            CoordinateSystem[] all_rangeCoordSys_s = new CoordinateSystem[length];
            ii = 0;
            while (ii < length) {
                all_rangeCoordSys_s[ii] = (CoordinateSystem)coordsys_s.elementAt(ii);
                ++ii;
            }
            Set[] new_rangeSets = new Set[tupleDim];
            Unit[] new_rangeUnits = new Unit[tupleDim];
            double[][] new_values = new double[tupleDim][n_samples_0];
            int cnt_a = 0;
            int cnt_b = 0;
            boolean cnt_c = false;
            int cnt_u = 0;
            boolean n_coordsys = false;
            ii = 0;
            while (ii < n_fields) {
                FlatField f_field = (FlatField)fields[ii].local();
                if (ii > 0) {
                    f_field = (FlatField)f_field.resample(domainSet_0, sampling_mode, error_mode);
                }
                Set[] rangeSets = f_field.getRangeSets();
                int n_sets = rangeSets.length;
                System.arraycopy(rangeSets, 0, new_rangeSets, cnt_a, n_sets);
                cnt_a += n_sets;
                Unit[][] rangeUnits = f_field.getRangeUnits();
                int n_units = rangeUnits.length;
                Unit[] sub_units = new Unit[n_units];
                jj = 0;
                while (jj < n_units) {
                    sub_units[jj] = rangeUnits[jj][0];
                    ++jj;
                }
                System.arraycopy(sub_units, 0, new_rangeUnits, cnt_u, n_units);
                cnt_u += n_units;
                double[][] values = f_field.getValues();
                jj = 0;
                while (jj < values.length) {
                    System.arraycopy(values[jj], 0, new_values[cnt_b++], 0, n_samples_0);
                    ++jj;
                }
                ++ii;
            }
            new_field = new_type.getReal() ? new FlatField(new_type, domainSet_0, null, null, new_rangeSets, null) : new FlatField(new_type, domainSet_0, all_rangeCoordSys_s, new_rangeSets, null);
            ((FlatField)new_field).setSamples(new_values);
        } else {
            TupleType new_range;
            Vector<MathType> sub_types = new Vector<MathType>();
            boolean allReal = true;
            Vector[] v_array = new Vector[n_samples_0];
            ii = 0;
            while (ii < n_samples_0) {
                v_array[ii] = new Vector();
                ++ii;
            }
            ii = 0;
            while (ii < n_fields) {
                int kk;
                Field field = ii == 0 ? (Field)((Object)fields[ii].local()) : fields[ii].resample(domainSet_0, sampling_mode, error_mode);
                MathType fieldRange = fieldRange_s[ii];
                if (fieldRange instanceof RealType) {
                    sub_types.add(fieldRange);
                    kk = 0;
                    while (kk < n_samples_0) {
                        v_array[kk].add(field.getSample(kk));
                        ++kk;
                    }
                } else if (fieldRange instanceof RealTupleType) {
                    if (((RealTupleType)fieldRange).getCoordinateSystem() != null) {
                        sub_types.add(fieldRange);
                        allReal = false;
                        kk = 0;
                        while (kk < n_samples_0) {
                            v_array[kk].add(field.getSample(kk));
                            ++kk;
                        }
                    } else {
                        n_dims = ((RealTupleType)fieldRange).getDimension();
                        jj = 0;
                        while (jj < n_dims) {
                            sub_types.add(((RealTupleType)fieldRange).getComponent(jj));
                            ++jj;
                        }
                        kk = 0;
                        while (kk < n_samples_0) {
                            Data rangeData = field.getSample(kk);
                            jj = 0;
                            while (jj < n_dims) {
                                v_array[kk].add(((RealTuple)rangeData).getComponent(jj));
                                ++jj;
                            }
                            ++kk;
                        }
                    }
                } else if (fieldRange instanceof TupleType && !(fieldRange instanceof RealTupleType)) {
                    if (!((TupleType)fieldRange).getFlat()) {
                        sub_types.add(fieldRange);
                        kk = 0;
                        while (kk < n_samples_0) {
                            v_array[kk].add(field.getSample(kk));
                            ++kk;
                        }
                        allReal = false;
                    } else {
                        n_dims = ((TupleType)fieldRange).getDimension();
                        ii = 0;
                        while (ii < n_dims) {
                            MathType m_type = ((TupleType)fieldRange).getComponent(ii);
                            if (m_type instanceof RealType) {
                                sub_types.add(m_type);
                                kk = 0;
                                while (kk < n_samples_0) {
                                    v_array[kk].add(((TupleIface)field.getSample(kk)).getComponent(ii));
                                    ++kk;
                                }
                            } else if (m_type instanceof RealTupleType) {
                                if (((RealTupleType)m_type).getCoordinateSystem() != null) {
                                    sub_types.add(m_type);
                                    allReal = false;
                                    kk = 0;
                                    while (kk < n_samples_0) {
                                        v_array[kk].add(((TupleIface)field.getSample(kk)).getComponent(ii));
                                        ++kk;
                                    }
                                } else {
                                    jj = 0;
                                    while (jj < ((RealTupleType)m_type).getDimension()) {
                                        sub_types.add(((RealTupleType)m_type).getComponent(jj));
                                        ++jj;
                                    }
                                    kk = 0;
                                    while (kk < n_samples_0) {
                                        RealTuple R_tuple = (RealTuple)((TupleIface)field.getSample(kk)).getComponent(ii);
                                        jj = 0;
                                        while (jj < ((RealTupleType)m_type).getDimension()) {
                                            v_array[kk].add(R_tuple.getComponent(jj));
                                            ++jj;
                                        }
                                        ++kk;
                                    }
                                }
                            }
                            ++ii;
                        }
                    }
                } else if (fieldRange instanceof FunctionType) {
                    sub_types.add(fieldRange);
                    kk = 0;
                    while (kk < n_samples_0) {
                        v_array[kk].add(field.getSample(kk));
                        ++kk;
                    }
                    allReal = false;
                }
                ++ii;
            }
            int size = sub_types.size();
            if (allReal) {
                RealType[] r_types = new RealType[size];
                ii = 0;
                while (ii < size) {
                    r_types[ii] = (RealType)sub_types.elementAt(ii);
                    ++ii;
                }
                new_range = new RealTupleType(r_types);
            } else {
                MathType[] m_types = new MathType[size];
                ii = 0;
                while (ii < size) {
                    m_types[ii] = (MathType)sub_types.elementAt(ii);
                    ++ii;
                }
                new_range = new TupleType(m_types);
            }
            FunctionType new_type = new FunctionType(domainType_0, new_range);
            new_field = new FieldImpl(new_type, domainSet_0);
            ii = 0;
            while (ii < n_samples_0) {
                size = v_array[ii].size();
                Data[] data_s = new Data[size];
                jj = 0;
                while (jj < size) {
                    data_s[jj] = (Data)v_array[ii].elementAt(jj);
                    ++jj;
                }
                Tuple data = new Tuple(data_s);
                new_field.setSample(ii, (Data)data);
                ++ii;
            }
        }
        return new_field;
    }

    public Field extract(MathType type) throws VisADException, RemoteException {
        int index = -1;
        MathType rangeType = ((FunctionType)this.Type).getRange();
        if (!(rangeType instanceof TupleType)) {
            throw new VisADException("FieldImpl.extract: range must be a TupleType");
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        int i = 0;
        while (i < n_comps) {
            MathType test_comp = ((TupleType)rangeType).getComponent(i);
            if (test_comp.equals(type)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            return this.extract(index);
        }
        return null;
    }

    public Field extract(String name) throws VisADException, RemoteException {
        int index = -1;
        MathType rangeType = ((FunctionType)this.Type).getRange();
        if (!(rangeType instanceof TupleType)) {
            throw new VisADException("FieldImpl.extract: range must be a TupleType");
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        int i = 0;
        while (i < n_comps) {
            String test_comp = ((TupleType)rangeType).getComponent(i).toString();
            if (test_comp.equals(name) || test_comp.equals("(" + name + ")")) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            return this.extract(index);
        }
        return null;
    }

    public Field extract(int component) throws VisADException, RemoteException {
        FieldImpl new_field;
        Set domainSet = this.getDomainSet();
        int n_samples = domainSet.getLength();
        MathType rangeType = ((FunctionType)this.Type).getRange();
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        if (!(rangeType instanceof TupleType)) {
            throw new VisADException("extract: range type must be TupleType");
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        if (component + 1 > n_comps) {
            throw new VisADException("extract: component selection too large");
        }
        MathType new_range = ((TupleType)rangeType).getComponent(component);
        FunctionType new_type = new FunctionType(domainType, new_range);
        if (new_range instanceof RealType) {
            Unit[] new_unit = new Unit[]{((RealType)new_range).getDefaultUnit()};
            new_field = new FlatField(new_type, domainSet, null, null, null, new_unit);
            double[][] values = new double[1][n_samples];
            int ii = 0;
            while (ii < n_samples) {
                Real real = (Real)this.getSample(ii);
                double value = real.getValue();
                Unit unit = real.getUnit();
                values[0][ii] = new_unit[0].toThis(value, unit);
                ++ii;
            }
            ((FlatField)new_field).setSamples(values);
        } else if (new_range instanceof RealTupleType) {
            CoordinateSystem coord_out = ((RealTupleType)new_range).getCoordinateSystem();
            int dim = ((RealTupleType)new_range).getDimension();
            Unit[] unit_out = new Unit[dim];
            Unit[] unit_in = new Unit[dim];
            unit_out = ((RealTupleType)new_range).getDefaultUnits();
            new_field = new FlatField(new_type, domainSet, coord_out, null, unit_out);
            double[][] values = new double[dim][n_samples];
            double[][] t_values = new double[dim][1];
            int ii = 0;
            while (ii < n_samples) {
                RealTuple r_tuple = (RealTuple)((TupleIface)this.getSample(ii)).getComponent(component);
                CoordinateSystem coord_in = r_tuple.getCoordinateSystem();
                unit_in = r_tuple.getTupleUnits();
                int jj = 0;
                while (jj < dim) {
                    t_values[jj][0] = ((Real)r_tuple.getComponent(jj)).getValue();
                    ++jj;
                }
                t_values = CoordinateSystem.transformCoordinates((RealTupleType)new_range, coord_out, unit_out, null, (RealTupleType)new_range, coord_in, unit_in, null, t_values);
                jj = 0;
                while (jj < dim) {
                    values[jj][ii] = t_values[jj][0];
                    ++jj;
                }
                ++ii;
            }
            ((FlatField)new_field).setSamples(values);
        } else if (new_range instanceof TupleType && ((TupleType)new_range).getFlat()) {
            MathType m_type;
            new_field = new FlatField(new_type, domainSet);
            int dim = ((TupleType)new_range).getDimension();
            int t_dim = 0;
            int n_coordsys = 0;
            int ii = 0;
            while (ii < dim) {
                m_type = ((TupleType)new_range).getComponent(ii);
                if (m_type instanceof RealType) {
                    ++t_dim;
                } else if (m_type instanceof RealTupleType) {
                    RealTupleType rt_type = (RealTupleType)m_type;
                    t_dim += rt_type.getDimension();
                    if (rt_type.getCoordinateSystem() != null) {
                        ++n_coordsys;
                    }
                }
                ++ii;
            }
            double[][] values = new double[t_dim][n_samples];
            t_dim = 0;
            ii = 0;
            while (ii < n_samples) {
                Data rangeData = this.getSample(ii);
                m_type = rangeData.getType();
                int jj = 0;
                while (jj < dim) {
                    if (m_type instanceof RealType) {
                        values[t_dim][ii] = ((Real)((TupleIface)rangeData).getComponent(jj)).getValue();
                        ++t_dim;
                    } else {
                        RealTuple r_tuple = (RealTuple)((TupleIface)rangeData).getComponent(jj);
                        int kk = 0;
                        while (kk < ((RealTupleType)m_type).getDimension()) {
                            values[t_dim][ii] = ((Real)r_tuple.getComponent(kk)).getValue();
                            ++t_dim;
                            ++kk;
                        }
                    }
                    ++jj;
                }
                ++ii;
            }
            ((FlatField)new_field).setSamples(values);
        } else {
            new_field = new FieldImpl(new_type, domainSet);
            int ii = 0;
            while (ii < n_samples) {
                Data rangeData = this.getSample(ii);
                Data new_rangeData = ((TupleIface)rangeData).getComponent(component);
                new_field.setSample(ii, new_rangeData);
                ++ii;
            }
        }
        return new_field;
    }

    public Field domainFactor(RealType factor) throws DomainException, VisADException, RemoteException {
        int kk;
        Set factor_domain = null;
        Object lengths = null;
        int[] new_lengths = null;
        int[] dim_lengths = null;
        int[] dim_product = null;
        int[] sub_domain = null;
        SampledSet new_domain = null;
        RealTupleType new_domain_type = null;
        FieldImpl new_field = null;
        FieldImpl factor_field = null;
        FunctionType new_type = null;
        double[][] new_range_values = null;
        double[][] old_range_values = null;
        Data[] new_range_data = null;
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        MathType rangeType = ((FunctionType)this.Type).getRange();
        int domainDim = domainType.getDimension();
        RealType[] r_types = new RealType[domainDim - 1];
        int factorIndex = domainType.getIndex(factor);
        if (factorIndex < 0) {
            throw new DomainException("domainFactor: factor not element of domain");
        }
        int cnt = 0;
        int ii = 0;
        while (ii < domainDim) {
            if (ii != factorIndex) {
                r_types[cnt++] = (RealType)domainType.getComponent(ii);
            }
            ++ii;
        }
        new_domain_type = new RealTupleType(r_types);
        if (this.DomainSet instanceof LinearSet) {
            factor_domain = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(factorIndex);
            dim_lengths = ((GriddedSet)this.DomainSet).getLengths();
            Linear1DSet[] L1D_sets = new Linear1DSet[domainDim - 1];
            new_lengths = new int[domainDim - 1];
            sub_domain = new int[domainDim - 1];
            cnt = 0;
            ii = 0;
            while (ii < domainDim) {
                if (ii != factorIndex) {
                    L1D_sets[cnt] = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(ii);
                    new_lengths[cnt] = L1D_sets[cnt].LengthX;
                    sub_domain[cnt] = ii;
                    ++cnt;
                }
                ++ii;
            }
            new_domain = new LinearNDSet((MathType)new_domain_type, L1D_sets);
            new_type = new FunctionType(new_domain_type, rangeType);
        } else {
            if (this.DomainSet instanceof GriddedSet) {
                throw new DomainException("domainFactor: DomainSet is GriddedSet, if aligned use ProductSet");
            }
            if (this.DomainSet instanceof ProductSet) {
                ProductSet prod_set = (ProductSet)((ProductSet)this.DomainSet).product();
                SampledSet[] sets = prod_set.Sets;
                int n_sets = sets.length;
                SampledSet[] sub_sets = new SampledSet[n_sets - 1];
                Set factor_set = null;
                Set fin_factor_set = null;
                int sub_factor_index = -1;
                int fac_set_idx = -1;
                int fac_set_len = -1;
                int[] sub_set_idx = new int[n_sets - 1];
                int[] sub_set_lengths = new int[n_sets - 1];
                cnt = 0;
                kk = 0;
                while (kk < n_sets) {
                    SetType s_type = (SetType)sets[kk].getType();
                    sub_factor_index = s_type.getDomain().getIndex(factor);
                    if (sub_factor_index >= 0) {
                        factor_set = sets[kk];
                        fac_set_idx = kk;
                        fac_set_len = factor_set.getLength();
                    } else {
                        sub_sets[cnt] = sets[kk];
                        sub_set_idx[cnt] = kk;
                        sub_set_lengths[cnt] = sets[kk].getLength();
                        ++cnt;
                    }
                    ++kk;
                }
                int factor_set_dim = factor_set.getDimension();
                int n_sub_sets = sub_sets.length;
                if (factor_set_dim == 1) {
                    fin_factor_set = factor_set;
                    new_lengths = new int[n_sub_sets];
                    sub_domain = new int[n_sub_sets];
                    dim_lengths = new int[n_sets];
                    new_domain = n_sub_sets > 1 ? new ProductSet(sub_sets) : sub_sets[0];
                    factor_domain = factor_set;
                    System.arraycopy(sub_set_lengths, 0, new_lengths, 0, n_sub_sets);
                    System.arraycopy(sub_set_idx, 0, sub_domain, 0, n_sub_sets);
                    ii = 0;
                    while (ii < n_sub_sets) {
                        dim_lengths[sub_set_idx[ii]] = sub_set_lengths[ii];
                        ++ii;
                    }
                    dim_lengths[fac_set_idx] = fac_set_len;
                    new_type = new FunctionType(((SetType)new_domain.getType()).getDomain(), rangeType);
                } else {
                    if (!(factor_set instanceof LinearNDSet)) {
                        throw new DomainException("cannot factor into " + factor_set.getClass());
                    }
                    MathType n_type = null;
                    new_lengths = new int[n_sub_sets + 1];
                    sub_domain = new int[n_sub_sets + 1];
                    dim_lengths = new int[n_sets + 1];
                    Linear1DSet[] L1D_sets = new Linear1DSet[factor_set_dim - 1];
                    cnt = 0;
                    ii = 0;
                    while (ii < factor_set_dim) {
                        if (ii != sub_factor_index) {
                            L1D_sets[cnt] = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(ii);
                            ++cnt;
                        } else {
                            fin_factor_set = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(ii);
                        }
                        ++ii;
                    }
                    LinearNDSet new_set = new LinearNDSet(n_type, L1D_sets);
                    cnt = 0;
                    System.arraycopy(sub_set_lengths, 0, new_lengths, 0, fac_set_idx);
                    System.arraycopy(sub_set_idx, 0, sub_domain, 0, fac_set_idx);
                    cnt += fac_set_idx;
                    new_lengths[fac_set_idx] = new_set.getLength();
                    System.arraycopy(sub_set_lengths, fac_set_idx, new_lengths, ++cnt, n_sub_sets - fac_set_idx);
                    System.arraycopy(sub_set_idx, fac_set_idx, sub_domain, cnt, n_sub_sets - fac_set_idx);
                    new_type = new FunctionType(((SetType)new_set.getType()).getDomain(), rangeType);
                    new_domain = new_set;
                }
            } else {
                if (this.DomainSet instanceof UnionSet) {
                    throw new UnimplementedException("domainFactor: DomainSet is UnionSet");
                }
                if (this.DomainSet instanceof IrregularSet) {
                    throw new DomainException("domainFactor: DomainSet is IrregularSet, can't factor");
                }
            }
        }
        int length = factor_domain.getLength();
        new_range_data = new Data[length];
        dim_product = new int[domainDim];
        kk = 0;
        while (kk < domainDim) {
            dim_product[kk] = 1;
            int mm = 0;
            while (mm < kk) {
                int n = kk;
                dim_product[n] = dim_product[n] * dim_lengths[mm];
                ++mm;
            }
            ++kk;
        }
        int s_dims = new_lengths.length;
        int[] indexes = new int[s_dims];
        int product = 1;
        ii = 0;
        while (ii < s_dims) {
            product *= new_lengths[ii];
            ++ii;
        }
        int[] work = new int[product];
        int k = 0;
        while (k < product) {
            int k2 = k;
            int j = s_dims - 1;
            while (j >= 0) {
                int temp = 1;
                int m = 0;
                while (m < j) {
                    temp *= new_lengths[m];
                    ++m;
                }
                indexes[j] = k2 / temp;
                k2 -= temp * indexes[j];
                --j;
            }
            int t = 0;
            while (t < indexes.length) {
                int n = k;
                work[n] = work[n] + dim_product[sub_domain[t]] * indexes[t];
                ++t;
            }
            ++k;
        }
        if (this.isFlatField()) {
            old_range_values = this.getValues();
            int tup_dim = old_range_values.length;
            new_range_values = new double[tup_dim][work.length];
            ii = 0;
            while (ii < length) {
                new_field = new FlatField(new_type, new_domain);
                int jj = 0;
                while (jj < work.length) {
                    int index = 0;
                    index = ii * dim_product[factorIndex];
                    index += work[jj];
                    kk = 0;
                    while (kk < tup_dim) {
                        new_range_values[kk][jj] = old_range_values[kk][index];
                        ++kk;
                    }
                    ++jj;
                }
                ((FlatField)new_field).setSamples(new_range_values);
                new_range_data[ii] = new_field;
                ++ii;
            }
        } else {
            ii = 0;
            while (ii < length) {
                new_field = new FieldImpl(new_type, new_domain);
                int jj = 0;
                while (jj < work.length) {
                    int index = 0;
                    index = ii * dim_product[factorIndex];
                    new_range_data[jj] = this.getSample(index += work[jj]);
                    ++jj;
                }
                new_field.setSamples(new_range_data, false);
                new_range_data[ii] = new_field;
                ++ii;
            }
        }
        factor_field = new FieldImpl(new FunctionType(factor, new_type), factor_domain);
        factor_field.setSamples(new_range_data, false);
        return factor_field;
    }

    public Field domainMultiply() throws VisADException, RemoteException {
        return this.domainMultiply(1);
    }

    public Field domainMultiply(int collapse_depth) throws VisADException, RemoteException {
        FieldImpl new_field;
        SampledSet new_set = null;
        int n_irregular = 0;
        int n_linear = 0;
        int new_domainDim = 0;
        int new_manifoldDim = 0;
        class Helper {
            int cnt;
            int n_samples;
            int depth;
            int depth_max;
            boolean flat;
            MathType range_type;
            MathType new_range_type;
            SampledSet[] last_set;
            SampledSet[] fac_sets;
            Object[] collapse_array;
            private final /* synthetic */ FieldImpl this$0;

            public Helper(FieldImpl this$0, Data data, int col_depth) throws VisADException, RemoteException {
                this.this$0 = this$0;
                this.cnt = 0;
                MathType m_type = data.getType();
                this.depth = 0;
                this.flat = false;
                this.depth_max = this.checkType(m_type);
                if (this.depth_max == 0) {
                    throw new FieldException("MathType " + m_type.prettyString());
                }
                if (this.depth_max >= col_depth) {
                    this.depth_max = col_depth;
                }
                this.last_set = new SampledSet[this.depth_max + 1];
                this.depth = 0;
                if (!this.setsEqual((Field)data)) {
                    throw new FieldException("sets not equal");
                }
                int length = 1;
                int kk = 0;
                while (kk < this.depth_max) {
                    length *= this.last_set[kk].getLength();
                    ++kk;
                }
                this.collapse_array = new Object[length];
                this.depth = 0;
                this.collapse(data);
            }

            public SampledSet[] getSets() {
                int length = this.last_set.length;
                this.fac_sets = new SampledSet[length];
                int ii = 0;
                while (ii < length) {
                    this.fac_sets[length - 1 - ii] = this.last_set[ii];
                    ++ii;
                }
                return this.fac_sets;
            }

            public Object[] getRangeArray() {
                return this.collapse_array;
            }

            public MathType getRangeType() {
                return this.new_range_type;
            }

            public int checkType(MathType m_type) throws VisADException, RemoteException {
                if (m_type instanceof FunctionType) {
                    if (((FunctionType)m_type).getFlat()) {
                        this.flat = true;
                        this.new_range_type = ((FunctionType)m_type).getRange();
                        return this.depth;
                    }
                    this.range_type = ((FunctionType)m_type).getRange();
                    ++this.depth;
                    return this.checkType(this.range_type);
                }
                this.new_range_type = m_type;
                return this.depth;
            }

            public void collapse(Data data) throws VisADException, RemoteException {
                if (this.depth == this.depth_max) {
                    if (this.flat) {
                        double[][] values = ((FieldImpl)data).getValues();
                        this.collapse_array[this.cnt++] = values;
                    } else {
                        this.collapse_array[this.cnt++] = data;
                    }
                } else {
                    ++this.depth;
                    this.n_samples = ((Field)data).getDomainSet().getLength();
                    int ii = 0;
                    while (ii < this.n_samples) {
                        this.collapse(((FieldImpl)data).getSample(ii));
                        ++ii;
                    }
                }
            }

            public boolean setsEqual(Field field) throws VisADException, RemoteException {
                Set domainSet = field.getDomainSet();
                int n_samples = domainSet.getLength();
                if (this.depth == 0) {
                    this.last_set[this.depth] = (SampledSet)domainSet;
                }
                ++this.depth;
                if (this.last_set[this.depth] == null) {
                    this.last_set[this.depth] = (SampledSet)((Field)field.getSample(0)).getDomainSet();
                }
                int ii = 0;
                while (ii < n_samples) {
                    Field range_data = (Field)field.getSample(ii);
                    Set range_set = range_data.getDomainSet();
                    if (!this.last_set[this.depth].equals(range_set)) {
                        return false;
                    }
                    if (this.depth != this.depth_max) {
                        if (!this.setsEqual(range_data)) {
                            return false;
                        }
                        --this.depth;
                    }
                    ++ii;
                }
                return true;
            }
        }
        Helper helper = new Helper(this, this, collapse_depth);
        SampledSet[] fac_sets = helper.getSets();
        int n_sets = fac_sets.length;
        Object[] new_range = helper.getRangeArray();
        MathType new_range_type = helper.getRangeType();
        SetType[] set_types = new SetType[n_sets];
        int new_length = 1;
        int kk = 0;
        while (kk < n_sets) {
            new_length *= fac_sets[kk].getLength();
            new_domainDim += fac_sets[kk].getDimension();
            new_manifoldDim += fac_sets[kk].getManifoldDimension();
            set_types[kk] = (SetType)fac_sets[kk].getType();
            if (fac_sets[kk] instanceof IrregularSet) {
                ++n_irregular;
            } else if (fac_sets[kk] instanceof LinearSet) {
                ++n_linear;
            }
            ++kk;
        }
        RealType[] r_types = new RealType[new_domainDim];
        int cnt = 0;
        int kk2 = 0;
        while (kk2 < n_sets) {
            RealTupleType domain = set_types[kk2].getDomain();
            int j = 0;
            while (j < domain.getDimension()) {
                r_types[cnt++] = (RealType)domain.getComponent(j);
                ++j;
            }
            ++kk2;
        }
        RealTupleType new_domain_type = new RealTupleType(r_types);
        FunctionType new_function_type = new FunctionType(new_domain_type, new_range_type);
        if (n_irregular > 0) {
            new_set = new ProductSet(fac_sets);
        } else if (n_linear == n_sets) {
            Linear1DSet[] L1D_sets = new Linear1DSet[new_domainDim];
            cnt = 0;
            int kk3 = 0;
            while (kk3 < n_sets) {
                int jj = 0;
                while (jj < fac_sets[kk3].getDimension()) {
                    L1D_sets[cnt++] = ((LinearSet)((Object)fac_sets[kk3])).getLinear1DComponent(jj);
                    ++jj;
                }
                ++kk3;
            }
            new_set = new LinearNDSet((MathType)new_domain_type, L1D_sets);
        } else {
            float[][] new_samples = new float[new_domainDim][new_length];
            float[][] sub_samples = new float[new_domainDim][];
            int[][] manifoldLengths = new int[new_domainDim][];
            int[][] manifoldIndexes = new int[new_domainDim][];
            int[] new_lengths = new int[new_manifoldDim];
            cnt = 0;
            int cnt_m = 0;
            int manifoldDimension = 0;
            int kk4 = 0;
            while (kk4 < n_sets) {
                SampledSet set = fac_sets[kk4];
                float[][] samples = set.getSamples();
                int domainDim = set.getDimension();
                int sub_manifoldDim = ((Set)set).getManifoldDimension();
                int[] lengths = ((GriddedSet)set).getLengths();
                int ii = 0;
                while (ii < domainDim) {
                    sub_samples[cnt] = samples[ii];
                    manifoldLengths[cnt] = lengths;
                    manifoldIndexes[cnt] = new int[sub_manifoldDim];
                    int jj = 0;
                    while (jj < sub_manifoldDim) {
                        manifoldIndexes[cnt][jj] = jj + manifoldDimension;
                        ++jj;
                    }
                    ++cnt;
                    ++ii;
                }
                int ii2 = 0;
                while (ii2 < sub_manifoldDim) {
                    new_lengths[cnt_m++] = lengths[ii2];
                    ++ii2;
                }
                manifoldDimension += sub_manifoldDim;
                ++kk4;
            }
            int[] indexes = new int[new_manifoldDim];
            int k = 0;
            while (k < new_length) {
                int k2 = k;
                int j = new_manifoldDim - 1;
                while (j >= 0) {
                    int temp = 1;
                    int m = 0;
                    while (m < j) {
                        temp *= new_lengths[m];
                        ++m;
                    }
                    indexes[j] = k2 / temp;
                    k2 -= temp * indexes[j];
                    --j;
                }
                int ii = 0;
                while (ii < new_domainDim) {
                    int sub_index = 0;
                    int mm = manifoldIndexes[ii].length - 1;
                    while (mm >= 0) {
                        int product = 1;
                        int nn = 0;
                        while (nn < mm) {
                            product *= manifoldLengths[ii][nn];
                            ++nn;
                        }
                        sub_index += (product *= indexes[manifoldIndexes[ii][mm]]);
                        --mm;
                    }
                    new_samples[ii][k] = sub_samples[ii][sub_index];
                    ++ii;
                }
                ++k;
            }
            new_set = new GriddedSet(new_domain_type, new_samples, new_lengths);
        }
        if (new_function_type.getFlat()) {
            new_field = new FlatField(new_function_type, new_set);
            int tup_dim = new_function_type.getFlatRange().getDimension();
            double[][] new_values = new double[tup_dim][new_length];
            cnt = 0;
            int ii = 0;
            while (ii < new_range.length) {
                double[][] sub_range = (double[][])new_range[ii];
                int len = sub_range[0].length;
                int jj = 0;
                while (jj < tup_dim) {
                    System.arraycopy(sub_range[jj], 0, new_values[jj], cnt, len);
                    ++jj;
                }
                cnt += len;
                ++ii;
            }
            ((FlatField)new_field).setSamples(new_values, false);
        } else {
            new_field = new FieldImpl(new_function_type, new_set);
            int ii = 0;
            while (ii < new_length) {
                new_field.setSample(ii, (Data)new_range[ii]);
                ++ii;
            }
        }
        return new_field;
    }

    public Data derivative(RealTuple location, RealType[] d_partial_s, MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        boolean transform;
        int n_partials;
        Set domainSet = this.getDomainSet();
        int domainDim = domainSet.getDimension();
        int manifoldDimension = domainSet.getManifoldDimension();
        int n_samples = domainSet.getLength();
        CoordinateSystem d_coordsys = this.getDomainCoordinateSystem();
        RealTupleType d_reference = d_coordsys == null ? null : d_coordsys.getReference();
        Object m_type = null;
        Object m_types = null;
        Object r_type = null;
        Object r_types = null;
        Object t_type = null;
        boolean thisDomainFlag = true;
        if (manifoldDimension != domainDim) {
            throw new SetException("derivative: manifoldDimension must equal domain dimension");
        }
        error_mode = 202;
        int sampling_mode = 101;
        if (location != null) {
            thisDomainFlag = false;
        }
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        RealType[] r_comps = domainType.getRealComponents();
        RealType[] r_compsRef = d_reference == null ? null : d_reference.getRealComponents();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (d_partial_s == null) {
            n_partials = domainDim;
            d_partial_s = r_comps;
        } else {
            n_partials = d_partial_s.length;
            if (n_partials > domainDim) {
                throw new VisADException("derivative: too many d_partial components");
            }
        }
        int[] u_index = new int[n_partials];
        double[][] u_vectors = new double[n_partials][domainDim];
        int found = 0;
        int foundRef = 0;
        int ii = 0;
        while (ii < n_partials) {
            int jj = 0;
            while (jj < domainDim) {
                u_vectors[ii][jj] = 0.0;
                if (r_comps[jj].equals(d_partial_s[ii])) {
                    u_index[ii] = jj;
                    u_vectors[ii][jj] = 1.0;
                    ++found;
                } else if (d_reference != null && r_compsRef[jj].equals(d_partial_s[ii])) {
                    u_index[ii] = jj;
                    u_vectors[jj][ii] = 1.0;
                    ++foundRef;
                }
                ++jj;
            }
            ++ii;
        }
        if (found == 0) {
            if (foundRef == 0) {
                throw new VisADException("derivative: d_partial_s not in domain or reference");
            }
            if (0 < foundRef && foundRef < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = true;
        } else {
            if (0 < found && found < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = false;
        }
        Object derivNames = null;
        MathType[] new_range = new MathType[n_partials];
        MathType[] new_types = new MathType[n_partials];
        Unit[] D_units = !transform ? domainSet.getSetUnits() : d_reference.getDefaultUnits();
        if (derivType_s == null) {
            ii = 0;
            while (ii < n_partials) {
                MathType M_type = this.Type.cloneDerivative(d_partial_s[ii]);
                new_types[ii] = thisDomainFlag ? M_type : ((FunctionType)M_type).getRange();
                ++ii;
            }
            derivType_s = new_types;
        } else {
            if (derivType_s.length != n_partials) {
                throw new VisADException("derivative: must be a single MathType for each domain RealType");
            }
            ii = 0;
            while (ii < n_partials) {
                if (thisDomainFlag ? !this.Type.equalsExceptName(derivType_s[ii]) : !((FunctionType)this.Type).getRange().equalsExceptName(derivType_s[ii])) {
                    throw new TypeException("derivative: incompatible with function range");
                }
                ++ii;
            }
        }
        Object neighbors = null;
        Data[] p_derivatives = new Data[n_partials];
        ErrorEstimate[] domainErrors = domainSet.getSetErrors();
        Data[] new_fields = new FieldImpl[n_partials];
        Data[] rangeValues = null;
        int pp = 0;
        while (pp < n_partials) {
            new_fields[pp] = new FieldImpl((FunctionType)derivType_s[pp], domainSet);
            ++pp;
        }
        if (this.isMissing()) {
            if (domainSet instanceof LinearSet && thisDomainFlag) {
                int kk = 0;
                while (kk < n_partials) {
                    RangeType = ((FunctionType)derivType_s[kk]).getRange();
                    int m_index = u_index[kk];
                    neighbors = domainSet.getNeighbors(m_index);
                    float step = (float)((LinearSet)((Object)domainSet)).getLinear1DComponent(kk).getStep();
                    ii = 0;
                    while (ii < n_samples) {
                        int index;
                        int n_index;
                        float distance;
                        if (neighbors[ii][0] == -1) {
                            distance = step;
                            n_index = neighbors[ii][1];
                            index = ii;
                        } else if (neighbors[ii][1] == -1) {
                            distance = step;
                            n_index = ii;
                            index = neighbors[ii][0];
                        } else {
                            distance = 2.0f * step;
                            n_index = neighbors[ii][1];
                            index = neighbors[ii][0];
                        }
                        Data data_1 = this.getSample(n_index);
                        Data data_0 = this.getSample(index);
                        Real deltaDomain = new Real(d_partial_s[kk], distance, D_units[m_index]);
                        Data rangeDiff = data_1.binary(data_0, 2, sampling_mode, error_mode);
                        Data newRange = rangeDiff.binary(deltaDomain, 5, RangeType, sampling_mode, error_mode);
                        ((FieldImpl)new_fields[kk]).setSample(ii, newRange);
                        ++ii;
                    }
                    ++kk;
                }
            } else {
                int kk;
                int n_points;
                float[][] Samples;
                float[][] weights = null;
                if (thisDomainFlag) {
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    domainSet.getNeighbors((int[][])neighbors, weights);
                    if (transform) {
                        Samples = domainSet.getSamples(true);
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    } else {
                        Samples = domainSet.getSamples(false);
                    }
                } else {
                    n_samples = 1;
                    float[][] org_Samples = domainSet.getSamples(false);
                    Field field = this.resample(new SingletonSet(location, null, null, null), 101, error_mode);
                    float[][] evalSamples = field.getDomainSet().getSamples(false);
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    ((SimpleSet)this.DomainSet).valueToInterp(evalSamples, (int[][])neighbors, weights);
                    n_points = neighbors[0].length;
                    int[][] new_neighbors = new int[n_samples][n_points];
                    Data[] new_rangeValues = new Data[n_points + 1];
                    float[][] new_Samples = new float[domainDim][n_points + 1];
                    ii = 0;
                    while (ii < domainDim) {
                        new_Samples[ii][0] = evalSamples[ii][0];
                        ++ii;
                    }
                    new_rangeValues[0] = field.getSample(0);
                    kk = 0;
                    while (kk < n_points) {
                        new_neighbors[0][kk] = kk + 1;
                        new_rangeValues[kk + 1] = this.getSample(neighbors[0][kk]);
                        ii = 0;
                        while (ii < domainDim) {
                            new_Samples[ii][kk + 1] = org_Samples[ii][neighbors[0][kk]];
                            ++ii;
                        }
                        ++kk;
                    }
                    neighbors = new_neighbors;
                    rangeValues = new_rangeValues;
                    Samples = new_Samples;
                    if (transform) {
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    }
                }
                ii = 0;
                while (ii < n_samples) {
                    int dd;
                    n_points = neighbors[ii].length;
                    Data[] rangeDiff_s = new Data[n_points];
                    Data p_derivative = null;
                    double[][] uvecPoint = new double[n_points][domainDim];
                    Data data_0 = thisDomainFlag ? this.getSample(ii) : rangeValues[ii];
                    kk = 0;
                    while (kk < n_points) {
                        dd = 0;
                        while (dd < domainDim) {
                            uvecPoint[kk][dd] = Samples[dd][neighbors[ii][kk]] - Samples[dd][ii];
                            ++dd;
                        }
                        Data data_1 = thisDomainFlag ? this.getSample(neighbors[ii][kk]) : rangeValues[neighbors[ii][kk]];
                        rangeDiff_s[kk] = data_1.binary(data_0, 2, sampling_mode, error_mode);
                        ++kk;
                    }
                    boolean first = true;
                    pp = 0;
                    while (pp < n_partials) {
                        int m_index = u_index[pp];
                        RangeType = ((FunctionType)derivType_s[pp]).getRange();
                        float sum_weights = 0.0f;
                        kk = 0;
                        while (kk < n_points) {
                            float dotproduct = 0.0f;
                            dd = 0;
                            while (dd < domainDim) {
                                dotproduct = (float)((double)dotproduct + uvecPoint[kk][dd] * u_vectors[pp][dd]);
                                ++dd;
                            }
                            float inv_dotproduct = 1.0f / dotproduct;
                            if (!Float.isInfinite(inv_dotproduct)) {
                                sum_weights += weights[ii][kk];
                                float factor = inv_dotproduct * weights[ii][kk];
                                rangeDiff_s[kk] = rangeDiff_s[kk].binary(new Real(factor), 4, sampling_mode, error_mode);
                                if (first) {
                                    p_derivative = rangeDiff_s[kk];
                                    first = false;
                                } else {
                                    p_derivative = p_derivative.binary(rangeDiff_s[kk], 1, sampling_mode, error_mode);
                                }
                            }
                            ++kk;
                        }
                        Real real = new Real(d_partial_s[pp], sum_weights, D_units[m_index]);
                        p_derivative = p_derivative.binary(real, 5, RangeType, sampling_mode, error_mode);
                        ((FieldImpl)new_fields[pp]).setSample(ii, p_derivative);
                        ++pp;
                    }
                    ++ii;
                }
            }
        }
        if (n_partials == 1) {
            return new_fields[0];
        }
        return new Tuple(new_fields);
    }

    public Data derivative(int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = null;
        return this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Data derivative(MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        return this.derivative(null, null, derivType_s, error_mode);
    }

    public Function derivative(RealType d_partial, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = new RealType[]{d_partial};
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Function derivative(RealType d_partial, MathType derivType, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = new MathType[1];
        RealType[] d_partial_s = new RealType[1];
        derivType_s[0] = derivType;
        d_partial_s[0] = d_partial;
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        float[][] error_values;
        Object indices;
        boolean sampling_errors;
        if (this.DomainSet.equals(set)) {
            return this;
        }
        FieldImpl field = new FieldImpl((FunctionType)this.Type, set);
        if (this.isMissing()) {
            return field;
        }
        int dim = this.DomainSet.getDimension();
        if (dim != set.getDimension()) {
            throw new SetException("FieldImpl.resample: bad Set Dimension");
        }
        CoordinateSystem coord_sys = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = error_mode == 202 ? new ErrorEstimate[dim] : set.getSetErrors();
        int length = set.getLength();
        int[] wedge = set.getWedge();
        Data[] range = new Data[length];
        float[][] vals = set.indexToValue(wedge);
        ErrorEstimate[] errors_out = new ErrorEstimate[dim];
        float[][] oldvals = vals;
        try {
            vals = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, errors, vals);
        }
        catch (UnitException ue) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        boolean coord_transform = vals != oldvals;
        boolean bl = sampling_errors = error_mode != 202;
        if (sampling_errors) {
            int i = 0;
            while (i < dim) {
                if (errors_out[i] == null) {
                    sampling_errors = false;
                }
                ++i;
            }
        }
        Data[] sampling_partials = new Data[dim];
        double[] means = new double[dim];
        if (sampling_mode == 101 && this.DomainSet instanceof SimpleSet) {
            indices = new int[length][];
            float[][] coefs = new float[length][];
            ((GriddedSet)this.DomainSet).valueToInterp(vals, (int[][])indices, coefs);
            int i2 = 0;
            while (i2 < length) {
                int len;
                int n = len = indices[i2] == null ? 0 : ((int)indices[i2]).length;
                if (len > 0) {
                    Data r = null;
                    int k = 0;
                    while (k < len) {
                        Data RangeIK;
                        Data[] dataArray = this.Range;
                        synchronized (dataArray) {
                            RangeIK = this.Range[indices[i2][k]];
                        }
                        if (RangeIK == null) {
                            r = null;
                            break;
                        }
                        r = r == null ? RangeIK.multiply(new Real(coefs[i2][k])) : r.add(RangeIK.multiply(new Real(coefs[i2][k])));
                        ++k;
                    }
                    if (r != null) {
                        r = r.changeMathType(((FunctionType)this.Type).getRange());
                    }
                    range[wedge[i2]] = r;
                } else {
                    range[wedge[i2]] = ((FunctionType)this.Type).getRange().missingData();
                }
                if (sampling_errors && !range[wedge[i2]].isMissing()) {
                    int j;
                    int j2 = 0;
                    while (j2 < dim) {
                        means[j2] = vals[j2][i2];
                        ++j2;
                    }
                    error_values = Set.doubleToFloat(ErrorEstimate.init_error_values(errors_out, means));
                    int[][] error_indices = new int[2 * dim][];
                    float[][] error_coefs = new float[2 * dim][];
                    coefs = new float[2 * dim][];
                    ((SimpleSet)this.DomainSet).valueToInterp(error_values, error_indices, error_coefs);
                    int j3 = 0;
                    while (j3 < dim) {
                        Data RangeIK;
                        Data[] dataArray;
                        int k;
                        Data a = null;
                        Data b = null;
                        len = error_indices[2 * j3].length;
                        if (len > 0) {
                            k = 0;
                            while (k < len) {
                                dataArray = this.Range;
                                synchronized (dataArray) {
                                    RangeIK = this.Range[error_indices[2 * j3][k]];
                                }
                                if (RangeIK == null) {
                                    a = null;
                                    break;
                                }
                                a = a == null ? RangeIK.multiply(new Real(error_coefs[2 * j3][k])) : a.add(RangeIK.multiply(new Real(error_coefs[2 * j3][k])));
                                ++k;
                            }
                        }
                        if ((len = error_indices[2 * j3 + 1].length) > 0) {
                            k = 0;
                            while (k < len) {
                                dataArray = this.Range;
                                synchronized (dataArray) {
                                    RangeIK = this.Range[error_indices[2 * j3 + 1][k]];
                                }
                                if (RangeIK == null) {
                                    b = null;
                                    break;
                                }
                                b = b == null ? RangeIK.multiply(new Real(error_coefs[2 * j3 + 1][k])) : b.add(RangeIK.multiply(new Real(error_coefs[2 * j3 + 1][k])));
                                ++k;
                            }
                        }
                        sampling_partials[j3] = a == null || b == null ? null : b.subtract(a).abs();
                        ++j3;
                    }
                    Data error = null;
                    if (error_mode == 200) {
                        j = 0;
                        while (j < dim) {
                            Data e = sampling_partials[j].multiply(sampling_partials[j]);
                            error = error == null ? e : error.add(e);
                            ++j;
                        }
                        error = error.sqrt();
                    } else {
                        j = 0;
                        while (j < dim) {
                            Data e = sampling_partials[j];
                            error = error == null ? e : error.add(e);
                            ++j;
                        }
                    }
                    range[wedge[i2]] = range[wedge[i2]].adjustSamplingError(error, error_mode);
                }
                ++i2;
            }
        } else {
            indices = this.DomainSet.valueToIndex(vals);
            int i = 0;
            while (i < length) {
                Data[] i2 = this.Range;
                synchronized (i2) {
                    range[wedge[i]] = indices[i] >= 0 && this.Range[indices[i]] != null ? this.Range[indices[i]] : ((FunctionType)this.Type).getRange().missingData();
                }
                if (sampling_errors && !range[wedge[i]].isMissing()) {
                    Data e;
                    int j;
                    int j4 = 0;
                    while (j4 < dim) {
                        means[j4] = vals[j4][i];
                        ++j4;
                    }
                    error_values = Set.doubleToFloat(ErrorEstimate.init_error_values(errors_out, means));
                    int[] error_indices = this.DomainSet.valueToIndex(error_values);
                    int j5 = 0;
                    while (j5 < dim) {
                        Data[] dataArray = this.Range;
                        synchronized (dataArray) {
                            sampling_partials[j5] = error_indices[2 * j5] < 0 || this.Range[error_indices[2 * j5]] == null || error_indices[2 * j5 + 1] < 0 || this.Range[error_indices[2 * j5 + 1]] == null ? null : this.Range[error_indices[2 * j5 + 1]].subtract(this.Range[error_indices[2 * j5]]).abs();
                        }
                        ++j5;
                    }
                    Data error = null;
                    if (error_mode == 200) {
                        j = 0;
                        while (j < dim) {
                            e = sampling_partials[j].multiply(sampling_partials[j]);
                            error = error == null ? e : error.add(e);
                            ++j;
                        }
                        error = error.sqrt();
                    } else {
                        j = 0;
                        while (j < dim) {
                            e = sampling_partials[j];
                            error = error == null ? e : error.add(e);
                            ++j;
                        }
                    }
                    range[wedge[i]] = range[wedge[i]].adjustSamplingError(error, error_mode);
                }
                ++i;
            }
        }
        if (coord_transform) {
            MathType RangeType = ((FunctionType)this.Type).getRange();
            if (RangeType instanceof RealVectorType) {
                int n = vals.length;
                float[][] inloc = new float[n][1];
                float[][] outloc = new float[n][1];
                int i = 0;
                while (i < length) {
                    int k = 0;
                    while (k < n) {
                        inloc[k][0] = oldvals[k][i];
                        ++k;
                    }
                    int k2 = 0;
                    while (k2 < n) {
                        outloc[k2][0] = vals[k2][i];
                        ++k2;
                    }
                    range[i] = ((RealVectorType)RangeType).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, ((RealTuple)range[i]).getCoordinateSystem(), inloc, outloc, (RealTuple)range[i]);
                    ++i;
                }
            } else if (RangeType instanceof TupleType && !(RangeType instanceof RealTupleType)) {
                int m = ((TupleType)RangeType).getDimension();
                boolean any_vector = false;
                int j = 0;
                while (j < m) {
                    if (((TupleType)RangeType).getComponent(j) instanceof RealVectorType) {
                        any_vector = true;
                    }
                    ++j;
                }
                if (any_vector) {
                    int n = vals.length;
                    float[][] inloc = new float[n][1];
                    float[][] outloc = new float[n][1];
                    Data[] datums = new Data[m];
                    int i = 0;
                    while (i < length) {
                        int k = 0;
                        while (k < n) {
                            inloc[k][0] = oldvals[k][i];
                            ++k;
                        }
                        int k3 = 0;
                        while (k3 < n) {
                            outloc[k3][0] = vals[k3][i];
                            ++k3;
                        }
                        int j6 = 0;
                        while (j6 < m) {
                            MathType comp_type = ((TupleType)RangeType).getComponent(j6);
                            if (comp_type instanceof RealVectorType) {
                                RealTuple component = (RealTuple)((TupleIface)range[i]).getComponent(j6);
                                datums[j6] = ((RealVectorType)comp_type).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, component.getCoordinateSystem(), inloc, outloc, component);
                            } else {
                                datums[j6] = ((TupleIface)range[i]).getComponent(j6);
                            }
                            ++j6;
                        }
                        range[i] = new Tuple(datums);
                        ++i;
                    }
                }
            }
        }
        field.setSamples(range, false);
        return field;
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return shadow;
        }
        ShadowRealTupleType domain_type = ((ShadowFunctionType)type).getDomain();
        int n = domain_type.getDimension();
        double[][] ranges = new double[2][n];
        shadow = this.DomainSet.computeRanges(domain_type, shadow, ranges, true);
        ShadowType rtype = ((ShadowFunctionType)type).getRange();
        int i = 0;
        while (i < this.Range.length) {
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                if (this.Range[i] != null) {
                    shadow = this.Range[i].computeRanges(rtype, shadow);
                }
            }
            ++i;
        }
        return shadow;
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        if (this.isMissing() || error == null || error.isMissing()) {
            return this;
        }
        FieldImpl field = new FieldImpl((FunctionType)this.Type, this.DomainSet);
        if (this.isMissing()) {
            return field;
        }
        Field new_error = ((Field)error).resample(this.DomainSet, 100, 202);
        Data[] range = new Data[this.Length];
        int i = 0;
        while (i < this.Length) {
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                range[i] = this.Range[i].adjustSamplingError(new_error.getSample(i), error_mode);
            }
            ++i;
        }
        field.setSamples(this.Range, true);
        return field;
    }

    public boolean isFlatField() {
        return false;
    }

    public int __len__() throws VisADException, RemoteException {
        return this.getLength();
    }

    public Data __getitem__(int index) throws VisADException, RemoteException {
        return this.getSample(index);
    }

    public void __setitem__(int index, Data data) throws VisADException, RemoteException {
        this.setSample(index, data);
    }

    public void __setitem__(int index, double data) throws VisADException, RemoteException {
        RealType real = null;
        boolean tuple = false;
        MathType range = ((FunctionType)this.getType()).getRange();
        if (range instanceof RealType) {
            real = (RealType)range;
        } else if (range instanceof RealTupleType && ((RealTupleType)range).getDimension() == 1) {
            real = (RealType)((RealTupleType)range).getComponent(0);
            tuple = true;
        }
        if (real != null) {
            Real r = new Real(real, data);
            if (tuple) {
                this.__setitem__(index, new RealTuple(new Real[]{r}));
            } else {
                this.__setitem__(index, r);
            }
        } else {
            System.out.println("FieldImpl.__setitem__ bad type");
        }
    }

    public Object clone() {
        FieldImpl field;
        try {
            field = new FieldImpl((FunctionType)this.Type, this.DomainSet);
            if (this.isMissing()) {
                return field;
            }
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                field.setSamples(this.Range, true);
            }
        }
        catch (VisADException e) {
            throw new VisADError("FieldImpl.clone: VisADException occured");
        }
        catch (RemoteException e) {
            throw new VisADError("FieldImpl.clone: RemoteException occured");
        }
        return field;
    }

    public String longString(String pre) throws VisADException, RemoteException {
        StringBuffer s = new StringBuffer(pre + "FieldImpl\n" + pre + "  Type: " + this.Type.toString() + "\n");
        if (this.DomainSet != null) {
            s.append(pre + "  DomainSet:\n" + this.DomainSet.longString(pre + "    "));
        } else {
            s.append(pre + "  DomainSet: undefined\n");
        }
        if (this.isMissing()) {
            s.append("  missing\n");
            return s.toString();
        }
        int i = 0;
        while (i < this.Length) {
            s.append(pre + "  Range value " + i + ":\n" + (this.Range[i] == null ? pre + "missing\n" : this.Range[i].longString(pre + "    ")));
            ++i;
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldImpl)) {
            return false;
        }
        FieldImpl fi = (FieldImpl)obj;
        if (!this.getType().equals(fi.getType())) {
            return false;
        }
        if (this.Length != fi.Length) {
            return false;
        }
        if (this.MissingFlag != fi.MissingFlag) {
            return false;
        }
        return !(this.DomainSet == null || fi.DomainSet == null ? this.DomainSet != null || fi.DomainSet != null : !this.DomainSet.equals(fi.DomainSet));
    }

    public Enumeration domainEnumeration() throws VisADException, RemoteException {
        return new FieldEnumerator(this);
    }
}

