/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class ErrorEstimate
implements Serializable,
Comparable {
    final double Error;
    final double Mean;
    final long NumberNotMissing;
    final Unit unit;
    private static final double DERIVATIVE_LOW_LIMIT = 0.01;
    private static final double DERIVATIVE_HI_LIMIT = 100.0;

    public ErrorEstimate(double error, double mean, long number, Unit u) {
        this.unit = u;
        if (Double.isNaN(error) || Double.isNaN(mean) || number <= 0L) {
            this.Error = Double.NaN;
            this.Mean = Double.NaN;
            this.NumberNotMissing = 0L;
        } else {
            this.Error = error;
            this.Mean = mean;
            this.NumberNotMissing = number;
        }
    }

    public ErrorEstimate(double mean, double error, Unit u) {
        this.unit = u;
        if (Double.isNaN(mean)) {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        } else {
            this.NumberNotMissing = 1L;
            this.Mean = mean;
            this.Error = error;
        }
    }

    public ErrorEstimate(ErrorEstimate field_error, ErrorEstimate sample_error, double val, int inc) throws VisADException {
        double ms;
        double es;
        Unit us;
        long ns;
        Unit uf;
        long nf;
        double mf;
        double ef;
        if (field_error == null) {
            ef = Double.NaN;
            mf = Double.NaN;
            nf = 0L;
            uf = null;
        } else {
            ef = field_error.Error;
            mf = field_error.Mean;
            nf = field_error.NumberNotMissing;
            uf = field_error.unit;
        }
        long l = ns = Double.isNaN(val) ? 0L : 1L;
        if (sample_error == null) {
            us = null;
            es = Double.NaN;
            ms = Double.NaN;
        } else {
            us = sample_error.unit;
            if (uf == null || uf == us) {
                es = sample_error.Error;
                ms = val;
            } else {
                es = uf.toThis(sample_error.Error, us);
                ms = uf.toThis(val, us);
            }
        }
        this.unit = field_error != null ? uf : us;
        long number = nf + (long)inc;
        if (number > 0L) {
            double mean = 0.0;
            double error = 0.0;
            if (!Double.isNaN(ef)) {
                error += (double)(number - ns) * ef;
            }
            if (!Double.isNaN(mf)) {
                mean += (double)(number - ns) * mf;
            }
            if (!Double.isNaN(es)) {
                error += (double)ns * es;
            }
            if (!Double.isNaN(ms)) {
                mean += (double)ns * ms;
            }
            this.NumberNotMissing = number;
            this.Error = error / (double)this.NumberNotMissing;
            this.Mean = mean / (double)this.NumberNotMissing;
        } else {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(double value, Unit u, int op, ErrorEstimate a, ErrorEstimate b, int error_mode) throws VisADException {
        this.unit = u;
        if (Double.isNaN(value)) {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        } else {
            this.NumberNotMissing = 1L;
            this.Mean = value;
            this.Error = this.binary(op, a, b, error_mode);
        }
    }

    public ErrorEstimate(double value, Unit u, int op, ErrorEstimate a, int error_mode) throws VisADException {
        this.unit = u;
        if (Double.isNaN(value)) {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        } else {
            this.NumberNotMissing = 1L;
            this.Mean = value;
            this.Error = this.unary(op, a, error_mode);
        }
    }

    public ErrorEstimate(double[] value, double error, Unit u) {
        this.unit = u;
        int number = 0;
        double sum = 0.0;
        int i = 0;
        while (i < value.length) {
            if (!Double.isNaN(value[i])) {
                ++number;
                sum += value[i];
            }
            ++i;
        }
        this.NumberNotMissing = number;
        if (this.NumberNotMissing > 0L) {
            this.Mean = sum / (double)this.NumberNotMissing;
            this.Error = error;
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(float[] value, double error, Unit u) {
        this.unit = u;
        int number = 0;
        double sum = 0.0;
        int i = 0;
        while (i < value.length) {
            if (!Float.isNaN(value[i])) {
                ++number;
                sum += (double)value[i];
            }
            ++i;
        }
        this.NumberNotMissing = number;
        if (this.NumberNotMissing > 0L) {
            this.Mean = sum / (double)this.NumberNotMissing;
            this.Error = error;
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(double[] value, Unit u, int op, ErrorEstimate a, ErrorEstimate b, int error_mode) throws VisADException {
        this.unit = u;
        int number = 0;
        double sum = 0.0;
        int i = 0;
        while (i < value.length) {
            if (!Double.isNaN(value[i])) {
                ++number;
                sum += value[i];
            }
            ++i;
        }
        this.NumberNotMissing = number;
        if (this.NumberNotMissing > 0L) {
            this.Mean = sum / (double)this.NumberNotMissing;
            this.Error = this.binary(op, a, b, error_mode);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(float[] value, Unit u, int op, ErrorEstimate a, ErrorEstimate b, int error_mode) throws VisADException {
        this.unit = u;
        int number = 0;
        double sum = 0.0;
        int i = 0;
        while (i < value.length) {
            if (!Float.isNaN(value[i])) {
                ++number;
                sum += (double)value[i];
            }
            ++i;
        }
        this.NumberNotMissing = number;
        if (this.NumberNotMissing > 0L) {
            this.Mean = sum / (double)this.NumberNotMissing;
            this.Error = this.binary(op, a, b, error_mode);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(double[] value, Unit u, int op, ErrorEstimate a, int error_mode) throws VisADException {
        this.unit = u;
        int number = 0;
        double sum = 0.0;
        int i = 0;
        while (i < value.length) {
            if (!Double.isNaN(value[i])) {
                ++number;
                sum += value[i];
            }
            ++i;
        }
        this.NumberNotMissing = number;
        if (this.NumberNotMissing > 0L) {
            this.Mean = sum / (double)this.NumberNotMissing;
            this.Error = this.unary(op, a, error_mode);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(float[] value, Unit u, int op, ErrorEstimate a, int error_mode) throws VisADException {
        this.unit = u;
        int number = 0;
        double sum = 0.0;
        int i = 0;
        while (i < value.length) {
            if (!Float.isNaN(value[i])) {
                ++number;
                sum += (double)value[i];
            }
            ++i;
        }
        this.NumberNotMissing = number;
        if (this.NumberNotMissing > 0L) {
            this.Mean = sum / (double)this.NumberNotMissing;
            this.Error = this.unary(op, a, error_mode);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public static ErrorEstimate[] copyErrorsArray(ErrorEstimate[] errors) {
        if (errors == null) {
            return null;
        }
        int n = errors.length;
        ErrorEstimate[] ret_errors = new ErrorEstimate[n];
        int i = 0;
        while (i < n) {
            ret_errors[i] = errors[i];
            ++i;
        }
        return ret_errors;
    }

    private double binary(int op, ErrorEstimate a, ErrorEstimate b, int error_mode) throws VisADException {
        double bm;
        double am;
        double error = Double.NaN;
        if (a.isMissing() || b.isMissing() || error_mode == 202) {
            return error;
        }
        Unit u = null;
        switch (op) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                am = this.unit != null && a.unit != null && !this.unit.equals(a.unit) ? Math.abs(this.unit.toThis(a.Mean + 0.5 * a.Error, a.unit) - this.unit.toThis(a.Mean - 0.5 * a.Error, a.unit)) : a.Error;
                bm = this.unit != null && b.unit != null && !this.unit.equals(b.unit) ? Math.abs(this.unit.toThis(b.Mean + 0.5 * b.Error, b.unit) - this.unit.toThis(b.Mean - 0.5 * b.Error, b.unit)) : b.Error;
                am = a.Error;
                bm = b.Error;
                break;
            }
            case 4: {
                if (a.unit != null && b.unit != null) {
                    u = a.unit.multiply(b.unit);
                }
                am = a.Error * b.Mean;
                bm = b.Error * a.Mean;
                break;
            }
            case 5: {
                if (a.unit != null && b.unit != null) {
                    u = a.unit.divide(b.unit);
                }
                double factor = Math.max(0.01, Math.abs(b.Mean));
                am = a.Error / factor;
                bm = b.Error * this.Mean / factor;
                break;
            }
            case 6: {
                if (a.unit != null && b.unit != null) {
                    u = b.unit.divide(a.unit);
                }
                double factor = Math.max(0.01, Math.abs(a.Mean));
                bm = a.Error * this.Mean / factor;
                am = b.Error / factor;
                break;
            }
            case 7: {
                am = a.Error * Math.abs(this.Mean) * (b.Mean / Math.max(0.01, Math.abs(a.Mean)));
                double factor = Math.log(Math.abs(a.Mean));
                if (Double.isNaN(factor)) {
                    factor = 1.0;
                }
                factor = Math.max(0.01, Math.min(100.0, factor));
                bm = b.Error * Math.abs(this.Mean) * factor;
                break;
            }
            case 8: {
                double factor = Math.log(Math.abs(b.Mean));
                if (Double.isNaN(factor)) {
                    factor = 1.0;
                }
                factor = Math.max(0.01, Math.min(100.0, factor));
                am = a.Error * Math.abs(this.Mean) * factor;
                bm = b.Error * Math.abs(this.Mean) * (a.Mean / Math.max(0.01, Math.abs(b.Mean)));
                break;
            }
            case 11: {
                double factor = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(b.Mean));
                am = a.Error * factor;
                bm = b.Error * this.Mean * factor;
                break;
            }
            case 12: {
                double factor = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(b.Mean));
                am = a.Error * factor;
                bm = b.Error * this.Mean * factor;
                break;
            }
            case 13: {
                double factor = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(a.Mean));
                am = a.Error * this.Mean * factor;
                bm = b.Error * factor;
                break;
            }
            case 14: {
                double factor = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(a.Mean));
                am = a.Error * this.Mean * factor;
                bm = b.Error * factor;
                break;
            }
            case 15: {
                am = a.Error;
                bm = b.Error * a.Mean / Math.max(0.01, Math.abs(b.Mean));
                break;
            }
            case 16: {
                am = a.Error * b.Mean / Math.max(0.01, Math.abs(a.Mean));
                bm = b.Error;
                break;
            }
            default: {
                throw new ArithmeticException("ErrorEstimate.binary: illegal operation");
            }
        }
        error = error_mode == 200 ? Math.sqrt(am * am + bm * bm) : Math.abs(am) + Math.abs(bm);
        if (this.unit != null && u != null && !this.unit.equals(u)) {
            error = Math.abs(this.unit.toThis(this.Mean + 0.5 * error, u) - this.unit.toThis(this.Mean - 0.5 * error, u));
        }
        return error;
    }

    private double unary(int op, ErrorEstimate a, int error_mode) throws UnitException {
        double error = Double.NaN;
        if (a.isMissing() || error_mode == 202) {
            return error;
        }
        switch (op) {
            case 21: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 41: 
            case 42: {
                if (this.unit != null && a.unit != null && !this.unit.equals(a.unit)) {
                    error = Math.abs(this.unit.toThis(a.Mean + 0.5 * a.Error, a.unit) - this.unit.toThis(a.Mean - 0.5 * a.Error, a.unit));
                    break;
                }
                error = a.Error;
                break;
            }
            case 22: 
            case 24: {
                double factor = Math.sqrt(1.0 - a.Mean * a.Mean);
                if (Double.isNaN(factor)) {
                    factor = 1.0;
                }
                factor = Math.max(0.01, Math.min(100.0, factor));
                error = a.Error / factor;
                break;
            }
            case 23: 
            case 25: {
                double factor = Math.sqrt(1.0 - a.Mean * a.Mean);
                if (Double.isNaN(factor)) {
                    factor = 1.0;
                }
                factor = Math.max(0.01, Math.min(100.0, factor));
                error = a.Error * 57.29577951308232 / factor;
                break;
            }
            case 26: {
                error = a.Error / Math.min(100.0, 1.0 + a.Mean * a.Mean);
                break;
            }
            case 27: {
                error = a.Error * 57.29577951308232 / Math.min(100.0, 1.0 + a.Mean * a.Mean);
                break;
            }
            case 29: 
            case 36: {
                double factor = Math.sqrt(1.0 - this.Mean * this.Mean);
                if (Double.isNaN(factor)) {
                    factor = 1.0;
                }
                factor = Math.max(0.01, Math.min(100.0, factor));
                error = a.Error * factor;
                break;
            }
            case 30: 
            case 37: {
                double factor = Math.sqrt(1.0 - this.Mean * this.Mean);
                if (Double.isNaN(factor)) {
                    factor = 1.0;
                }
                factor = Math.max(0.01, Math.min(100.0, factor));
                error = a.Error * (Math.PI / 180) * factor;
                break;
            }
            case 31: {
                error = a.Error * Math.abs(this.Mean);
                break;
            }
            case 33: {
                double factor = Math.max(0.01, Math.min(100.0, Math.abs(a.Mean)));
                error = a.Error / factor;
                break;
            }
            case 38: {
                double factor = Math.max(0.01, Math.min(100.0, 2.0 * Math.abs(this.Mean)));
                error = a.Error / factor;
                break;
            }
            case 39: {
                error = a.Error * Math.min(100.0, 1.0 + this.Mean * this.Mean);
                break;
            }
            case 40: {
                error = a.Error * (Math.PI / 180) * Math.min(100.0, 1.0 + this.Mean * this.Mean);
                break;
            }
            default: {
                throw new ArithmeticException("ErrorEstimate.unary: illegal operation");
            }
        }
        return error;
    }

    public boolean isMissing() {
        return Double.isNaN(this.Error);
    }

    public double getMean() {
        return this.Mean;
    }

    public double getErrorValue() {
        return this.Error;
    }

    public long getNumberNotMissing() {
        return this.NumberNotMissing;
    }

    public Unit getUnit() {
        return this.unit;
    }

    static double[][] init_error_values(ErrorEstimate[] errors_in) {
        int n = errors_in.length;
        double[] means = new double[n];
        int j = 0;
        while (j < n) {
            means[j] = errors_in[j].getMean();
            ++j;
        }
        return ErrorEstimate.init_error_values(errors_in, means);
    }

    static double[][] init_error_values(ErrorEstimate[] errors_in, double[] means) {
        int n = errors_in.length;
        double[][] error_values = new double[n][2 * n];
        int j = 0;
        while (j < n) {
            double mean = means[j];
            double error = 0.5 * errors_in[j].getErrorValue();
            int i = 0;
            while (i < n) {
                if (i == j) {
                    error_values[j][2 * i] = mean - error;
                    error_values[j][2 * i + 1] = mean + error;
                } else {
                    error_values[j][2 * i] = mean;
                    error_values[j][2 * i + 1] = mean;
                }
                ++i;
            }
            ++j;
        }
        return error_values;
    }

    public String toString() {
        return "NumberNotMissing = " + this.NumberNotMissing + "  Error = " + (Double.isNaN(this.Error) ? "missing" : Double.toString(this.Error)) + "  Mean = " + (Double.isNaN(this.Mean) ? "missing" : Double.toString(this.Mean));
    }

    public int compareTo(Object obj) {
        int comp;
        if (obj == null) {
            comp = 1;
        } else {
            ErrorEstimate that = (ErrorEstimate)obj;
            if (this.unit == null) {
                comp = that.unit == null ? new Double(this.Error).compareTo(new Double(that.Error)) : -1;
            } else if (that.unit == null) {
                comp = 1;
            } else {
                try {
                    comp = new Double(this.Error).compareTo(new Double(this.unit.toThis(that.Error, that.unit)));
                }
                catch (UnitException e) {
                    comp = 1;
                }
            }
        }
        return comp;
    }
}

