/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRenderer;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.KeyboardBehavior;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADEvent;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.util.Util;

public class DisplayEvent
extends VisADEvent {
    public static final int MOUSE_PRESSED = 1;
    public static final int TRANSFORM_DONE = 2;
    public static final int FRAME_DONE = 3;
    public static final int MOUSE_PRESSED_CENTER = 4;
    public static final int MOUSE_PRESSED_LEFT = 5;
    public static final int MOUSE_PRESSED_RIGHT = 6;
    public static final int MOUSE_RELEASED = 7;
    public static final int MOUSE_RELEASED_CENTER = 8;
    public static final int MOUSE_RELEASED_LEFT = 9;
    public static final int MOUSE_RELEASED_RIGHT = 10;
    public static final int MAP_ADDED = 11;
    public static final int MAPS_CLEARED = 12;
    public static final int REFERENCE_ADDED = 13;
    public static final int REFERENCE_REMOVED = 14;
    public static final int DESTROYED = 15;
    public static final int KEY_PRESSED = 16;
    public static final int KEY_RELEASED = 17;
    public static final int MOUSE_DRAGGED = 18;
    public static final int MOUSE_ENTERED = 19;
    public static final int MOUSE_EXITED = 20;
    public static final int MOUSE_MOVED = 21;
    private static final Component DUMMY = new JPanel();
    private int id = 0;
    private InputEvent input_event = null;
    private Display display;

    public DisplayEvent(Display d, int id_d) {
        this(d, id_d, 0);
    }

    public DisplayEvent(Display d, int id_d, int remoteId) {
        super(null, 0, null, remoteId);
        this.display = d;
        this.id = id_d;
    }

    public DisplayEvent(Display d, int id_d, int x, int y) {
        this(d, id_d, x, y, 0);
    }

    public DisplayEvent(Display d, int id_d, InputEvent e) {
        this(d, id_d, e, 0);
    }

    protected static Component getDisplayComponent(Display d) {
        if (!(d instanceof DisplayImpl)) {
            return DUMMY;
        }
        DisplayImpl di = (DisplayImpl)d;
        Component c = di.getComponent();
        return c == null ? DUMMY : c;
    }

    public DisplayEvent(Display d, int id_d, int x, int y, int remoteId) {
        this(d, id_d, new MouseEvent(DisplayEvent.getDisplayComponent(d), 0, System.currentTimeMillis(), 0, x, y, 1, false), remoteId);
    }

    public DisplayEvent(Display d, int id_d, InputEvent e, int remoteId) {
        super(null, 0, null, remoteId);
        this.display = d;
        this.id = id_d;
        this.input_event = e;
    }

    public DisplayEvent cloneButDisplay(Display dpy) {
        return new DisplayEvent(dpy, this.id, this.input_event, this.getRemoteId());
    }

    public Display getDisplay() {
        return this.display;
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.input_event == null || !(this.input_event instanceof MouseEvent) ? -1 : ((MouseEvent)this.input_event).getX();
    }

    public int getY() {
        return this.input_event == null || !(this.input_event instanceof MouseEvent) ? -1 : ((MouseEvent)this.input_event).getY();
    }

    public int getModifiers() {
        return this.input_event == null ? -1 : this.input_event.getModifiers();
    }

    public InputEvent getInputEvent() {
        return this.input_event;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DisplayEvent: ");
        try {
            String display = this.getDisplay().getName();
            buf.append("Display=");
            buf.append(display);
            buf.append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("Id=");
        buf.append(this.getId());
        buf.append(", X=");
        buf.append(this.getX());
        buf.append(", Y=");
        buf.append(this.getY());
        buf.append(", remoteId=");
        buf.append(this.getRemoteId());
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        KeyboardBehavior kb;
        DisplayRenderer dr;
        boolean j2d = args.length > 0;
        DisplayImpl display = j2d ? new DisplayImplJ2D("display") : new DisplayImplJ3D("display");
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        int size = 32;
        FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
        display.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        display.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        if (!j2d) {
            display.addMap(new ScalarMap(vis_radiance, Display.ZAxis));
        }
        display.addMap(new ScalarMap(RealType.Latitude, Display.Red));
        display.addMap(new ScalarMap(RealType.Longitude, Display.Green));
        display.addMap(new ScalarMap(vis_radiance, Display.Blue));
        GraphicsModeControl mode = display.getGraphicsModeControl();
        mode.setTextureEnable(false);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        display.addReference(ref_imaget1, null);
        final String[] ids = new String[]{"?", "MOUSE_PRESSED", "TRANSFORM_DONE", "FRAME_DONE", "MOUSE_PRESSED_CENTER", "MOUSE_PRESSED_LEFT", "MOUSE_PRESSED_RIGHT", "MOUSE_RELEASED", "MOUSE_RELEASED_CENTER", "MOUSE_RELEASED_LEFT", "MOUSE_RELEASED_RIGHT", "MAP_ADDED", "MAPS_CLEARED", "REFERENCE_ADDED", "REFERENCE_REMOVED", "DESTROYED", "KEY_PRESSED", "KEY_RELEASED", "MOUSE_DRAGGED", "MOUSE_ENTERED", "MOUSE_EXITED", "MOUSE_MOVED"};
        display.enableEvent(18);
        display.enableEvent(19);
        display.enableEvent(20);
        display.enableEvent(21);
        if (j2d) {
            dr = (DisplayRendererJ2D)display.getDisplayRenderer();
            kb = new KeyboardBehaviorJ2D((DisplayRendererJ2D)dr);
            ((DisplayRendererJ2D)dr).addKeyboardBehavior((KeyboardBehaviorJ2D)kb);
        } else {
            dr = (DisplayRendererJ3D)display.getDisplayRenderer();
            kb = new KeyboardBehaviorJ3D((DisplayRendererJ3D)dr);
            ((DisplayRendererJ3D)dr).addKeyboardBehavior((KeyboardBehaviorJ3D)kb);
        }
        display.addDisplayListener(new DisplayListener(){

            public void displayChanged(DisplayEvent e) {
                int id = e.getId();
                System.out.print(System.currentTimeMillis() + ": " + ids[id]);
                InputEvent ie = e.getInputEvent();
                if (ie == null) {
                    System.out.println();
                } else {
                    System.out.print(" [ ");
                    if (ie instanceof MouseEvent) {
                        MouseEvent me = (MouseEvent)ie;
                        int x = me.getX();
                        int y = me.getY();
                        System.out.print("(" + x + ", " + y + ") ");
                    } else if (ie instanceof KeyEvent) {
                        KeyEvent ke = (KeyEvent)ie;
                        char key = ke.getKeyChar();
                        System.out.print("'" + key + "' ");
                    }
                    int mods = ie.getModifiers();
                    if ((mods & 2) != 0) {
                        System.out.print("CTRL ");
                    }
                    if ((mods & 1) != 0) {
                        System.out.print("SHIFT ");
                    }
                    System.out.println("]");
                }
            }
        });
        JFrame frame = new JFrame("VisAD DisplayEvent test");
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        frame.setContentPane(pane);
        pane.add(display.getComponent());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        Util.centerWindow(frame);
        frame.show();
        display.getComponent().requestFocus();
    }
}

