/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DelaunayClarkson;
import visad.DelaunayCustom;
import visad.DelaunayFast;
import visad.DelaunayWatson;
import visad.Display;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.VisADError;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public abstract class Delaunay
implements Serializable {
    public int[][] Tri = null;
    public int[][] Vertices = null;
    public int[][] Walk = null;
    public int[][] Edges = null;
    public int NumEdges = 0;

    public Object clone() {
        try {
            return new DelaunayCustom(null, this.Tri, this.Vertices, this.Walk, this.Edges, this.NumEdges);
        }
        catch (VisADException e) {
            throw new VisADError("Delaunay.clone: " + e.toString());
        }
    }

    public static Delaunay factory(float[][] samples, boolean exact) throws VisADException {
        block11: {
            int choice;
            int FAST = 0;
            int CLARKSON = 1;
            int WATSON = 2;
            int dim = samples.length;
            if (dim < 2) {
                throw new VisADException("Delaunay.factory: dimension must be 2 or higher");
            }
            if (dim > 3) {
                choice = CLARKSON;
            } else {
                int nrs = samples[0].length;
                int i = 1;
                while (i < dim) {
                    nrs = Math.min(nrs, samples[i].length);
                    ++i;
                }
                choice = dim == 2 && !exact && nrs > 10000 ? FAST : (nrs > 3000 ? CLARKSON : WATSON);
            }
            try {
                if (choice == FAST) {
                    DelaunayFast delan = new DelaunayFast(samples);
                    delan.improve(samples, 1);
                    return delan;
                }
                if (choice == CLARKSON) {
                    DelaunayClarkson delan = new DelaunayClarkson(samples);
                    return delan;
                }
                if (choice == WATSON) {
                    DelaunayWatson delan = new DelaunayWatson(samples);
                    return delan;
                }
            }
            catch (Exception e) {
                if (choice == CLARKSON) break block11;
                try {
                    DelaunayClarkson delan = new DelaunayClarkson(samples);
                    return delan;
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static float[][] scale(float[][] samples, float mult, boolean copy) {
        int dim = samples.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            if (samples[i].length < nrs) {
                nrs = samples[i].length;
            }
            ++i;
        }
        float[][] samp = copy ? Set.copyFloats(samples) : samples;
        int i2 = 0;
        while (i2 < dim) {
            int j = 0;
            while (j < nrs) {
                float[] fArray = samp[i2];
                int n = j++;
                fArray[n] = fArray[n] * mult;
            }
            ++i2;
        }
        return samp;
    }

    public static float[][] perturb(float[][] samples, float epsilon, boolean copy) {
        int dim = samples.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            if (samples[i].length < nrs) {
                nrs = samples[i].length;
            }
            ++i;
        }
        float[][] samp = copy ? Set.copyFloats(samples) : samples;
        int i2 = 0;
        while (i2 < dim) {
            int j = 0;
            while (j < nrs) {
                float[] fArray = samp[i2];
                int n = j++;
                fArray[n] = fArray[n] + (float)((double)(2.0f * epsilon) * (Math.random() - 0.5));
            }
            ++i2;
        }
        return samp;
    }

    public boolean test(float[][] samples) {
        int k;
        int k2;
        int dim = samples.length;
        int dim1 = dim + 1;
        int ntris = this.Tri.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            nrs = Math.min(nrs, samples[i].length);
            ++i;
        }
        int i2 = 0;
        while (i2 < ntris) {
            if (this.Tri[i2].length < dim1) {
                return false;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < ntris) {
            int j = 0;
            while (j < dim1) {
                if (this.Tri[i3][j] < 0 || this.Tri[i3][j] >= nrs) {
                    return false;
                }
                ++j;
            }
            ++i3;
        }
        int[] nverts = new int[nrs];
        int i4 = 0;
        while (i4 < nrs) {
            nverts[i4] = 0;
            ++i4;
        }
        int i5 = 0;
        while (i5 < ntris) {
            int j = 0;
            while (j < dim1) {
                int n = this.Tri[i5][j];
                nverts[n] = nverts[n] + 1;
                ++j;
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < nrs) {
            if (nverts[i6] == 0) {
                return false;
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < ntris) {
            int j = i7 + 1;
            while (j < ntris) {
                boolean[] m = new boolean[dim1];
                int mi = 0;
                while (mi < dim1) {
                    m[mi] = false;
                    ++mi;
                }
                k2 = 0;
                while (k2 < dim1) {
                    int l = 0;
                    while (l < dim1) {
                        if (this.Tri[i7][k2] == this.Tri[j][l] && !m[l]) {
                            m[l] = true;
                        }
                        ++l;
                    }
                    ++k2;
                }
                boolean mtot = true;
                k = 0;
                while (k < dim1) {
                    if (!m[k]) {
                        mtot = false;
                    }
                    ++k;
                }
                if (mtot) {
                    return false;
                }
                ++j;
            }
            ++i7;
        }
        int i8 = 0;
        while (i8 < ntris) {
            int j = 0;
            while (j < dim1) {
                if (this.Walk[i8][j] != -1) {
                    boolean found = false;
                    k2 = 0;
                    while (k2 < dim1) {
                        if (this.Walk[this.Walk[i8][j]][k2] == i8) {
                            found = true;
                        }
                        ++k2;
                    }
                    if (!found) {
                        return false;
                    }
                    int sb = 0;
                    k = 0;
                    while (k < dim1) {
                        int l = 0;
                        while (l < dim1) {
                            if (this.Tri[i8][k] == this.Tri[this.Walk[i8][j]][l]) {
                                ++sb;
                            }
                            ++l;
                        }
                        ++k;
                    }
                    if (sb != dim) {
                        return false;
                    }
                }
                ++j;
            }
            ++i8;
        }
        return true;
    }

    public void improve(float[][] samples, int pass) throws VisADException {
        int dim = samples.length;
        int dim1 = dim + 1;
        if (this.Tri[0].length != dim1) {
            throw new SetException("Delaunay.improve: samples dimension does not match");
        }
        if (dim > 2) {
            throw new UnimplementedException("Delaunay.improve: dimension must be 2!");
        }
        int ntris = this.Tri.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < dim) {
            nrs = Math.min(nrs, samples[i].length);
            ++i;
        }
        float[] samp0 = samples[0];
        float[] samp1 = samples[1];
        boolean eflipped = false;
        int p = 0;
        while (p < pass) {
            eflipped = false;
            boolean[] edge = new boolean[this.NumEdges];
            int i2 = 0;
            while (i2 < this.NumEdges) {
                edge[i2] = true;
                ++i2;
            }
            int t = 0;
            while (t < ntris) {
                int[] trit = this.Tri[t];
                int[] walkt = this.Walk[t];
                int[] edgest = this.Edges[t];
                int e = 0;
                while (e < 2) {
                    int curedge = edgest[e];
                    if (edge[curedge]) {
                        int t2 = walkt[e];
                        if (t2 >= 0) {
                            boolean sig;
                            int[] trit2 = this.Tri[t2];
                            int[] walkt2 = this.Walk[t2];
                            int[] edgest2 = this.Edges[t2];
                            int f = walkt2[0] == t ? 0 : (walkt2[1] == t ? 1 : 2);
                            int A = (e + 2) % 3;
                            int B = (A + 1) % 3;
                            int C = (B + 1) % 3;
                            int D = (f + 2) % 3;
                            float ax = samp0[trit[A]];
                            float ay = samp1[trit[A]];
                            float bx = samp0[trit[B]];
                            float by = samp1[trit[B]];
                            float cx = samp0[trit[C]];
                            float cy = samp1[trit[C]];
                            float dx = samp0[trit2[D]];
                            float dy = samp1[trit2[D]];
                            float abx = ax - bx;
                            float aby = ay - by;
                            float acx = ax - cx;
                            float acy = ay - cy;
                            float dbx = dx - bx;
                            float dby = dy - by;
                            float dcx = dx - cx;
                            float dcy = dy - cy;
                            float Q = abx * acx + aby * acy;
                            float R = dbx * abx + dby * aby;
                            float S = acx * dcx + acy * dcy;
                            float T = dbx * dcx + dby * dcy;
                            boolean QD = abx * acy - aby * acx >= 0.0f;
                            boolean RD = dbx * aby - dby * abx >= 0.0f;
                            boolean SD = acx * dcy - acy * dcx >= 0.0f;
                            boolean TD = dcx * dby - dcy * dbx >= 0.0f;
                            boolean bl = sig = (QD ? 1 : 0) + (RD ? 1 : 0) + (SD ? 1 : 0) + (TD ? 1 : 0) < 2;
                            boolean d = QD == sig ? true : (RD == sig ? false : (SD == sig ? false : (TD == sig ? true : (Q < 0.0f && T < 0.0f || R > 0.0f && S > 0.0f ? true : (R < 0.0f && S < 0.0f || Q > 0.0f && T > 0.0f ? false : (Q < 0.0f ? Q : T) < (R < 0.0f ? R : S))))));
                            if (d) {
                                int val;
                                int e4;
                                int e3;
                                int w4;
                                int w3;
                                eflipped = true;
                                int n1 = trit[A];
                                int n2 = trit[B];
                                int n3 = trit[C];
                                int n4 = trit2[D];
                                int w1 = walkt[A];
                                int w2 = walkt[C];
                                int e1 = edgest[A];
                                int e2 = edgest[C];
                                if (trit2[(D + 1) % 3] == trit[C]) {
                                    w3 = walkt2[D];
                                    w4 = walkt2[(D + 2) % 3];
                                    e3 = edgest2[D];
                                    e4 = edgest2[(D + 2) % 3];
                                } else {
                                    w3 = walkt2[(D + 2) % 3];
                                    w4 = walkt2[D];
                                    e3 = edgest2[(D + 2) % 3];
                                    e4 = edgest2[D];
                                }
                                trit[0] = n1;
                                trit[1] = n2;
                                trit[2] = n4;
                                trit2[0] = n1;
                                trit2[1] = n4;
                                trit2[2] = n3;
                                walkt[0] = w1;
                                walkt[1] = w4;
                                walkt[2] = t2;
                                walkt2[0] = t;
                                walkt2[1] = w3;
                                walkt2[2] = w2;
                                if (w2 >= 0) {
                                    val = this.Walk[w2][0] == t ? 0 : (this.Walk[w2][1] == t ? 1 : 2);
                                    this.Walk[w2][val] = t2;
                                }
                                if (w4 >= 0) {
                                    val = this.Walk[w4][0] == t2 ? 0 : (this.Walk[w4][1] == t2 ? 1 : 2);
                                    this.Walk[w4][val] = t;
                                }
                                edgest[0] = e1;
                                edgest[1] = e4;
                                edgest2[1] = e3;
                                edgest2[2] = e2;
                                int[] vertn1 = this.Vertices[n1];
                                int[] vertn2 = this.Vertices[n2];
                                int[] vertn3 = this.Vertices[n3];
                                int[] vertn4 = this.Vertices[n4];
                                int ln1 = vertn1.length;
                                int ln2 = vertn2.length;
                                int ln3 = vertn3.length;
                                int ln4 = vertn4.length;
                                int[] tn1 = new int[ln1 + 1];
                                int[] tn2 = new int[ln2 - 1];
                                int[] tn3 = new int[ln3 - 1];
                                int[] tn4 = new int[ln4 + 1];
                                System.arraycopy(vertn1, 0, tn1, 0, ln1);
                                tn1[ln1] = t2;
                                int c = 0;
                                int i3 = 0;
                                while (i3 < ln2) {
                                    if (vertn2[i3] != t2) {
                                        tn2[c++] = vertn2[i3];
                                    }
                                    ++i3;
                                }
                                c = 0;
                                int i4 = 0;
                                while (i4 < ln3) {
                                    if (vertn3[i4] != t) {
                                        tn3[c++] = vertn3[i4];
                                    }
                                    ++i4;
                                }
                                System.arraycopy(vertn4, 0, tn4, 0, ln4);
                                tn4[ln4] = t;
                                this.Vertices[n1] = tn1;
                                this.Vertices[n2] = tn2;
                                this.Vertices[n3] = tn3;
                                this.Vertices[n4] = tn4;
                            }
                        }
                        edge[curedge] = false;
                    }
                    ++e;
                }
                ++t;
            }
            if (!eflipped) break;
            ++p;
        }
    }

    public void finish_triang(float[][] samples) throws VisADException {
        block40: {
            int i;
            int j;
            int i2;
            int mdim = this.Tri[0].length - 1;
            int mdim1 = mdim + 1;
            int dim = samples.length;
            int dim1 = dim + 1;
            int ntris = this.Tri.length;
            int nrs = samples[0].length;
            int i3 = 1;
            while (i3 < dim) {
                nrs = Math.min(nrs, samples[i3].length);
                ++i3;
            }
            if (this.Vertices == null) {
                this.Vertices = new int[nrs][];
                int[] nverts = new int[nrs];
                i2 = 0;
                while (i2 < ntris) {
                    j = 0;
                    while (j < mdim1) {
                        int n = this.Tri[i2][j];
                        nverts[n] = nverts[n] + 1;
                        ++j;
                    }
                    ++i2;
                }
                i = 0;
                while (i < nrs) {
                    this.Vertices[i] = new int[nverts[i]];
                    nverts[i] = 0;
                    ++i;
                }
                int i4 = 0;
                while (i4 < ntris) {
                    int j2 = 0;
                    while (j2 < mdim1) {
                        int n = this.Tri[i4][j2];
                        int n2 = nverts[n];
                        nverts[n] = n2 + 1;
                        this.Vertices[this.Tri[i4][j2]][n2] = i4;
                        ++j2;
                    }
                    ++i4;
                }
            }
            if (this.Walk == null && mdim <= 3) {
                this.Walk = new int[ntris][mdim1];
                int i5 = 0;
                while (i5 < ntris) {
                    int j3 = 0;
                    while (j3 < mdim1) {
                        int v1 = j3;
                        int v2 = (v1 + 1) % mdim1;
                        this.Walk[i5][j3] = -1;
                        int k = 0;
                        block8: while (k < this.Vertices[this.Tri[i5][v1]].length) {
                            int temp = this.Vertices[this.Tri[i5][v1]][k];
                            if (temp != i5) {
                                int l = 0;
                                while (l < this.Vertices[this.Tri[i5][v2]].length) {
                                    if (mdim == 2) {
                                        if (temp == this.Vertices[this.Tri[i5][v2]][l]) {
                                            this.Walk[i5][j3] = temp;
                                            break block8;
                                        }
                                    } else {
                                        int temp2 = this.Vertices[this.Tri[i5][v2]][l];
                                        int v3 = (v2 + 1) % mdim1;
                                        if (temp == temp2) {
                                            int m = 0;
                                            while (m < this.Vertices[this.Tri[i5][v3]].length) {
                                                if (temp == this.Vertices[this.Tri[i5][v3]][m]) {
                                                    this.Walk[i5][j3] = temp;
                                                    break block8;
                                                }
                                                ++m;
                                            }
                                        }
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                        ++j3;
                    }
                    ++i5;
                }
            }
            if (this.Edges != null || mdim > 3) break block40;
            int edim = 3 * (mdim - 1);
            this.Edges = new int[ntris][edim];
            i2 = 0;
            while (i2 < ntris) {
                j = 0;
                while (j < edim) {
                    this.Edges[i2][j] = -1;
                    ++j;
                }
                ++i2;
            }
            this.NumEdges = 0;
            if (mdim == 2) {
                i = 0;
                while (i < ntris) {
                    int j4 = 0;
                    while (j4 < 3) {
                        if (this.Edges[i][j4] < 0) {
                            int othtri = this.Walk[i][j4];
                            if (othtri >= 0) {
                                int cside = -1;
                                int k = 0;
                                while (k < 3) {
                                    if (this.Walk[othtri][k] == i) {
                                        cside = k;
                                    }
                                    ++k;
                                }
                                if (cside != -1) {
                                    this.Edges[othtri][cside] = this.NumEdges;
                                } else {
                                    throw new SetException("Delaunay.finish_triang: error in triangulation!");
                                }
                            }
                            this.Edges[i][j4] = this.NumEdges++;
                        }
                        ++j4;
                    }
                    ++i;
                }
            } else {
                int[] ptlook1 = new int[]{0, 0, 0, 1, 1, 2};
                int[] ptlook2 = new int[]{1, 2, 3, 2, 3, 3};
                int i6 = 0;
                while (i6 < ntris) {
                    int j5 = 0;
                    while (j5 < 6) {
                        if (this.Edges[i6][j5] < 0) {
                            int endpt1 = this.Tri[i6][ptlook1[j5]];
                            int endpt2 = this.Tri[i6][ptlook2[j5]];
                            int[] set = new int[this.Vertices[endpt1].length];
                            int setlen = 0;
                            int p1 = 0;
                            while (p1 < this.Vertices[endpt1].length) {
                                int temp = this.Vertices[endpt1][p1];
                                int p2 = 0;
                                while (p2 < this.Vertices[endpt2].length) {
                                    if (temp == this.Vertices[endpt2][p2]) {
                                        set[setlen++] = temp;
                                        break;
                                    }
                                    ++p2;
                                }
                                ++p1;
                            }
                            int kk = 0;
                            while (kk < setlen) {
                                int k = set[kk];
                                int l = 0;
                                while (l < edim) {
                                    if (this.Tri[k][ptlook1[l]] == endpt1 && this.Tri[k][ptlook2[l]] == endpt2 || this.Tri[k][ptlook1[l]] == endpt2 && this.Tri[k][ptlook2[l]] == endpt1) {
                                        this.Edges[k][l] = this.NumEdges;
                                    }
                                    ++l;
                                }
                                ++kk;
                            }
                            this.Edges[i6][j5] = this.NumEdges++;
                        }
                        ++j5;
                    }
                    ++i6;
                }
            }
        }
    }

    public String toString() {
        return this.sampleString(null);
    }

    public String sampleString(float[][] samples) {
        int i;
        StringBuffer s = new StringBuffer("");
        if (samples != null) {
            s.append("\nsamples " + samples[0].length + "\n");
            i = 0;
            while (i < samples[0].length) {
                s.append("  " + i + " -> " + samples[0][i] + " " + samples[1][i] + " " + samples[2][i] + "\n");
                ++i;
            }
            s.append("\n");
        }
        s.append("\nTri (triangles -> vertices) " + this.Tri.length + "\n");
        i = 0;
        while (i < this.Tri.length) {
            s.append("  " + i + " -> ");
            int j = 0;
            while (j < this.Tri[i].length) {
                s.append(" " + this.Tri[i][j]);
                ++j;
            }
            s.append("\n");
            ++i;
        }
        s.append("\nVertices (vertices -> triangles) " + this.Vertices.length + "\n");
        int i2 = 0;
        while (i2 < this.Vertices.length) {
            s.append("  " + i2 + " -> ");
            int j = 0;
            while (j < this.Vertices[i2].length) {
                s.append(" " + this.Vertices[i2][j]);
                ++j;
            }
            s.append("\n");
            ++i2;
        }
        s.append("\nWalk (triangles -> triangles) " + this.Walk.length + "\n");
        int i3 = 0;
        while (i3 < this.Walk.length) {
            s.append("  " + i3 + " -> ");
            int j = 0;
            while (j < this.Walk[i3].length) {
                s.append(" " + this.Walk[i3][j]);
                ++j;
            }
            s.append("\n");
            ++i3;
        }
        s.append("\nEdges (triangles -> global edges) " + this.Edges.length + "\n");
        int i4 = 0;
        while (i4 < this.Edges.length) {
            s.append("  " + i4 + " -> ");
            int j = 0;
            while (j < this.Edges[i4].length) {
                s.append(" " + this.Edges[i4][j]);
                ++j;
            }
            s.append("\n");
            ++i4;
        }
        return s.toString();
    }

    public static void main(String[] argv) throws VisADException, RemoteException {
        boolean problem = false;
        int numpass = 0;
        int dim = 0;
        int points = 0;
        int type = 0;
        int l = 1;
        if (argv.length < 3) {
            problem = true;
        } else {
            try {
                dim = Integer.parseInt(argv[0]);
                points = Integer.parseInt(argv[1]);
                type = Integer.parseInt(argv[2]);
                if (argv.length > 3) {
                    l = Integer.parseInt(argv[3]);
                }
                if (dim < 2 || dim > 3 || points < 1 || type < 1 || l < 1 || l > 4) {
                    problem = true;
                }
                if (dim == 3 && type > 2) {
                    System.out.println("Only Clarkson and Watson support 3-D triangulation.\n");
                    System.exit(2);
                }
            }
            catch (NumberFormatException exc) {
                problem = true;
            }
        }
        if (problem) {
            System.out.println("Usage:\n   java visad.Delaunay dim points type [label]\ndim    = The dimension of the triangulation\n         2 = 2-D\n         3 = 3-D\npoints = The number of points to triangulate.\ntype   = The triangulation method to use:\n         1 = Clarkson\n         2 = Watson\n         3 = Fast\n     X + 3 = Fast with X improvement passes\nlabel  = How to label the diagram:\n         1 = No labels (default)\n         2 = Vertex boxes\n         3 = Triangle numbers\n         4 = Vertex numbers\n");
            System.exit(1);
        }
        if (type > 3) {
            numpass = type - 3;
            type = 3;
        }
        float[][] samples = null;
        samples = dim == 2 ? new float[2][points] : new float[3][points];
        float[] samp0 = samples[0];
        float[] samp1 = samples[1];
        float[] samp2 = null;
        if (dim == 3) {
            samp2 = samples[2];
        }
        Delaunay delaun = null;
        int i = 0;
        while (i < points) {
            samp0[i] = (float)(500.0 * Math.random());
            samp1[i] = (float)(500.0 * Math.random());
            ++i;
        }
        if (dim == 3) {
            int i2 = 0;
            while (i2 < points) {
                samp2[i2] = (float)(500.0 * Math.random());
                ++i2;
            }
        }
        System.out.print("Triangulating " + points + " points " + "in " + dim + "-D with ");
        long start = 0L;
        long end = 0L;
        if (type == 1) {
            System.out.println("the Clarkson algorithm.");
            start = System.currentTimeMillis();
            delaun = new DelaunayClarkson(samples);
            end = System.currentTimeMillis();
        } else if (type == 2) {
            System.out.println("the Watson algorithm.");
            start = System.currentTimeMillis();
            delaun = new DelaunayWatson(samples);
            end = System.currentTimeMillis();
        } else if (type == 3) {
            System.out.println("the Fast algorithm.");
            start = System.currentTimeMillis();
            delaun = new DelaunayFast(samples);
            end = System.currentTimeMillis();
        }
        float time = (float)(end - start) / 1000.0f;
        System.out.println("Triangulation took " + time + " seconds.");
        if (numpass > 0) {
            System.out.println("Improving samples: " + numpass + " pass" + (numpass > 1 ? "es..." : "..."));
            start = System.currentTimeMillis();
            delaun.improve(samples, numpass);
            end = System.currentTimeMillis();
            time = (float)(end - start) / 1000.0f;
            System.out.println("Improvement took " + time + " seconds.");
        }
        final int label = l;
        final int[][] tri = delaun.Tri;
        int[][] edges = delaun.Edges;
        int numedges = delaun.NumEdges;
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        if (dim == 2) {
            final float[] s0 = samp0;
            final float[] s1 = samp1;
            JComponent jc = new JComponent(){

                public void paint(Graphics gr) {
                    block5: {
                        block6: {
                            block4: {
                                int i = 0;
                                while (i < tri.length) {
                                    int[] t = tri[i];
                                    gr.drawLine((int)s0[t[0]], (int)s1[t[0]], (int)s0[t[1]], (int)s1[t[1]]);
                                    gr.drawLine((int)s0[t[1]], (int)s1[t[1]], (int)s0[t[2]], (int)s1[t[2]]);
                                    gr.drawLine((int)s0[t[2]], (int)s1[t[2]], (int)s0[t[0]], (int)s1[t[0]]);
                                    ++i;
                                }
                                if (label != 2) break block4;
                                int i2 = 0;
                                while (i2 < s0.length) {
                                    gr.drawRect((int)s0[i2] - 2, (int)s1[i2] - 2, 4, 4);
                                    ++i2;
                                }
                                break block5;
                            }
                            if (label != 3) break block6;
                            int i = 0;
                            while (i < tri.length) {
                                int t0 = tri[i][0];
                                int t1 = tri[i][1];
                                int t2 = tri[i][2];
                                int avgX = (int)((s0[t0] + s0[t1] + s0[t2]) / 3.0f);
                                int avgY = (int)((s1[t0] + s1[t1] + s1[t2]) / 3.0f);
                                gr.drawString(String.valueOf(i), avgX - 4, avgY);
                                ++i;
                            }
                            break block5;
                        }
                        if (label != 4) break block5;
                        int i = 0;
                        while (i < s0.length) {
                            gr.drawString("" + i, (int)s0[i], (int)s1[i]);
                            ++i;
                        }
                    }
                }
            };
            frame.getContentPane().add(jc);
        } else {
            RealTupleType rtt;
            RealType t;
            TextType text;
            float[][] samps = samples;
            float[] s0 = samp0;
            float[] s1 = samp1;
            float[] s2 = samp2;
            RealType x = RealType.getRealType("x");
            RealType y = RealType.getRealType("y");
            RealType z = RealType.getRealType("z");
            RealTupleType xyz = new RealTupleType(x, y, z);
            int[] e0 = new int[]{0, 0, 0, 1, 1, 2};
            int[] e1 = new int[]{1, 2, 3, 2, 3, 3};
            SampledSet[] gsp = new Gridded3DSet[numedges];
            int i3 = 0;
            while (i3 < numedges) {
                gsp[i3] = null;
                ++i3;
            }
            int i4 = 0;
            while (i4 < edges.length) {
                int[] trii = tri[i4];
                int[] edgesi = edges[i4];
                int j = 0;
                while (j < 6) {
                    if (gsp[edgesi[j]] == null) {
                        float[][] pts = new float[3][2];
                        float[] p0 = pts[0];
                        float[] p1 = pts[1];
                        float[] p2 = pts[2];
                        int tp0 = trii[e0[j]];
                        int tp1 = trii[e1[j]];
                        p0[0] = samp0[tp0];
                        p1[0] = samp1[tp0];
                        p2[0] = samp2[tp0];
                        p0[1] = samp0[tp1];
                        p1[1] = samp1[tp1];
                        p2[1] = samp2[tp1];
                        gsp[edgesi[j]] = new Gridded3DSet((MathType)xyz, pts, 2);
                    }
                    ++j;
                }
                ++i4;
            }
            UnionSet tet = new UnionSet((MathType)xyz, gsp);
            DataReferenceImpl tetref = new DataReferenceImpl("tet");
            tetref.setData(tet);
            DisplayImplJ3D display = new DisplayImplJ3D("image display");
            display.addMap(new ScalarMap(x, Display.XAxis));
            display.addMap(new ScalarMap(y, Display.YAxis));
            display.addMap(new ScalarMap(z, Display.ZAxis));
            display.addMap(new ConstantMap(1.0, Display.Red));
            display.addMap(new ConstantMap(1.0, Display.Green));
            display.addMap(new ConstantMap(0.0, Display.Blue));
            if (label == 2) {
                throw new UnimplementedException("Delaunay.main: vertex boxes");
            }
            if (label == 3) {
                int len = tri.length;
                text = new TextType("text");
                t = RealType.getRealType("t");
                rtt = new RealTupleType(new RealType[]{t});
                Linear1DSet time_set = new Linear1DSet((MathType)rtt, 0.0, len - 1, len);
                TupleType text_tuple = new TupleType(new MathType[]{x, y, z, text});
                FunctionType text_function = new FunctionType(t, text_tuple);
                FieldImpl text_field = new FieldImpl(text_function, time_set);
                int i5 = 0;
                while (i5 < len) {
                    int t0 = tri[i5][0];
                    int t1 = tri[i5][1];
                    int t2 = tri[i5][2];
                    int t3 = tri[i5][3];
                    int avgX = (int)((s0[t0] + s0[t1] + s0[t2] + s0[t3]) / 4.0f);
                    int avgY = (int)((s1[t0] + s1[t1] + s1[t2] + s1[t3]) / 4.0f);
                    int avgZ = (int)((s2[t0] + s2[t1] + s2[t2] + s2[t3]) / 4.0f);
                    Data[] td = new Data[]{new Real(x, (double)avgX), new Real(y, (double)avgY), new Real(z, (double)avgZ), new Text(text, "" + i5)};
                    Tuple tt = new Tuple(text_tuple, td);
                    text_field.setSample(i5, (Data)tt);
                    ++i5;
                }
                display.addMap(new ScalarMap(text, Display.Text));
                DataReferenceImpl rtf = new DataReferenceImpl("rtf");
                rtf.setData(text_field);
                display.addReference(rtf, null);
            } else if (label == 4) {
                int len = s0.length;
                text = new TextType("text");
                t = RealType.getRealType("t");
                rtt = new RealTupleType(new RealType[]{t});
                Linear1DSet time_set = new Linear1DSet((MathType)rtt, 0.0, len - 1, len);
                TupleType text_tuple = new TupleType(new MathType[]{x, y, z, text});
                FunctionType text_function = new FunctionType(t, text_tuple);
                FieldImpl text_field = new FieldImpl(text_function, time_set);
                int i6 = 0;
                while (i6 < len) {
                    Data[] td = new Data[]{new Real(x, (double)s0[i6]), new Real(y, (double)s1[i6]), new Real(z, (double)s2[i6]), new Text(text, "" + i6)};
                    Tuple tt = new Tuple(text_tuple, td);
                    text_field.setSample(i6, (Data)tt);
                    ++i6;
                }
                display.addMap(new ScalarMap(text, Display.Text));
                DataReferenceImpl rtf = new DataReferenceImpl("rtf");
                rtf.setData(text_field);
                display.addReference(rtf, null);
            }
            display.addReference(tetref);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(display.getComponent());
            frame.getContentPane().add(panel);
        }
        ((Component)frame).setSize(new Dimension(510, 530));
        frame.setTitle("Triangulation results");
        ((Component)frame).setVisible(true);
    }
}

