/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import visad.CommonUnit;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public final class DateTime
extends Real {
    private static final double secondsPerDay = 86400.0;
    private static final String isoTimeFmtPattern = "yyyy-MM-dd HH:mm:ss'Z'";
    private static String formatPattern = "yyyy-MM-dd HH:mm:ss'Z'";
    private static final TimeZone defaultTimeZone;
    private static TimeZone timeZone;
    private final GregorianCalendar utcCalendar = new GregorianCalendar(defaultTimeZone);

    public DateTime(Real real) throws VisADException {
        super(RealType.Time, real.getValue(CommonUnit.secondsSinceTheEpoch), CommonUnit.secondsSinceTheEpoch);
        this.utcCalendar.setTime(new Date(Math.round(this.getValue() * 1000.0)));
    }

    public DateTime(double seconds) throws VisADException {
        this(new Real(RealType.Time, seconds, CommonUnit.secondsSinceTheEpoch));
    }

    public DateTime(Date date) throws VisADException {
        this(new Real(RealType.Time, (double)date.getTime() / 1000.0, CommonUnit.secondsSinceTheEpoch));
    }

    public DateTime() throws VisADException {
        this(new Real(RealType.Time, (double)System.currentTimeMillis() / 1000.0, CommonUnit.secondsSinceTheEpoch));
    }

    public DateTime(int year, int day, double seconds) throws VisADException {
        this(DateTime.fromYearDaySeconds(year, day, seconds));
    }

    public static Real fromYearDaySeconds(int year, int day, double seconds) throws VisADException {
        if (day < 1) {
            throw new VisADException("DateTime.fromYearDaySeconds: invalid day");
        }
        if (seconds > 86400.0 || seconds < 0.0) {
            throw new VisADException("DateTime.fromYearDaySeconds: invalid seconds");
        }
        return DateTime.fromYearDaySecondsTrusted(year, day, seconds);
    }

    private static Real fromYearDaySecondsTrusted(int year, int day, double seconds) throws VisADException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        ((Calendar)cal).setTimeZone(defaultTimeZone);
        if (year == 0) {
            year = -1;
        }
        cal.set(0, year < 0 ? 0 : 1);
        cal.set(1, Math.abs(year));
        cal.setLenient(true);
        cal.set(6, day);
        int temp = (int)Math.round(seconds * 1000.0);
        int secs = temp / 1000;
        int millis = temp % 1000;
        cal.set(13, secs);
        cal.set(14, millis);
        return new Real(RealType.Time, (double)cal.getTime().getTime() / 1000.0, CommonUnit.secondsSinceTheEpoch);
    }

    public Real getReal() {
        return this;
    }

    public String toString() {
        return this.formattedString(!formatPattern.equals(isoTimeFmtPattern) ? formatPattern : (this.utcCalendar.get(0) == 0 ? "yyyy-MM-dd HH:mm:ss'Z' 'BCE'" : isoTimeFmtPattern), timeZone);
    }

    public String toValueString() {
        return this.toString();
    }

    public String formattedString(String pattern, TimeZone timezone) {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(timezone);
        if (pattern != null) {
            sdf.applyPattern(pattern);
        }
        return new String(sdf.format(this.utcCalendar.getTime(), buf, new FieldPosition(0)).toString());
    }

    public String dateString() {
        String pattern = this.utcCalendar.get(0) == 0 ? "yyyy-MM-dd 'BCE'" : "yyyy-MM-dd";
        return this.formattedString(pattern, defaultTimeZone);
    }

    public String timeString() {
        return this.formattedString("HH:mm:ss'Z'", defaultTimeZone);
    }

    public static void setFormatPattern(String pattern) {
        formatPattern = pattern;
    }

    public static String getFormatPattern() {
        return formatPattern;
    }

    public static void setFormatTimeZone(TimeZone tz) {
        timeZone = tz;
    }

    public static TimeZone getFormatTimeZone() {
        return timeZone;
    }

    public static void resetFormat() {
        formatPattern = isoTimeFmtPattern;
        timeZone = defaultTimeZone;
    }

    public static DateTime createDateTime(String dateString) throws VisADException {
        return DateTime.createDateTime(dateString, formatPattern, defaultTimeZone);
    }

    public static DateTime createDateTime(String dateString, String format) throws VisADException {
        return DateTime.createDateTime(dateString, format, defaultTimeZone);
    }

    public static DateTime createDateTime(String dateString, String format, TimeZone timezone) throws VisADException {
        Date d;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(timezone);
            sdf.applyPattern(format);
            d = sdf.parse(dateString);
        }
        catch (ParseException pe) {
            throw new VisADException("invalid date string: " + dateString);
        }
        return new DateTime(d);
    }

    public int compareTo(Object oo) {
        return super.compareTo((DateTime)oo);
    }

    public static Gridded1DDoubleSet makeTimeSet(DateTime[] times) throws VisADException {
        Arrays.sort(times);
        double[][] timeValues = new double[1][times.length];
        int i = 0;
        while (i < times.length) {
            timeValues[0][i] = times[i].getValue();
            ++i;
        }
        return new Gridded1DDoubleSet((MathType)RealType.Time, timeValues, times.length);
    }

    public static Gridded1DDoubleSet makeTimeSet(double[] times) throws VisADException {
        Arrays.sort(times);
        double[][] alltimes = new double[1][times.length];
        int i = 0;
        while (i < times.length) {
            alltimes[0][i] = times[i];
            ++i;
        }
        return new Gridded1DDoubleSet((MathType)RealType.Time, alltimes, times.length);
    }

    public static DateTime[] timeSetToArray(Gridded1DSet timeSet) throws VisADException {
        Unit unit = timeSet.getSetUnits()[0];
        if (!Unit.canConvert(unit, CommonUnit.secondsSinceTheEpoch)) {
            throw new VisADException("Invalid Units for timeSet");
        }
        double[][] values = !unit.equals(CommonUnit.secondsSinceTheEpoch) ? Unit.convertTuple(timeSet.getDoubles(), new Unit[]{unit}, new Unit[]{CommonUnit.secondsSinceTheEpoch}) : timeSet.getDoubles();
        DateTime[] times = new DateTime[timeSet.getLength()];
        int i = 0;
        while (i < timeSet.getLength()) {
            times[i] = new DateTime(values[0][i]);
            ++i;
        }
        return times;
    }

    public static void main(String[] args) throws VisADException {
        Real r;
        System.out.println("\nInitialized using DateTime(1959, 284, 36600.):");
        DateTime a = new DateTime(1959, 284, 36600.0);
        System.out.println("\n\ttoString()        = " + a + "\n\tdateString()      = " + a.dateString() + "\n\ttimeString()      = " + a.timeString() + "\n\tformattedString() = " + a.formattedString("(EEE) dd-MMM-yy hh:mm:SS.sss z", TimeZone.getTimeZone("EST")) + "\n\t  (using pattern " + "'(EEE) dd-MMM-yy hh:mm:SS.sss z' and timezone 'EST')");
        System.out.println("\nIncrementing 5 times by 20 days each time:\n");
        int i = 0;
        while (i < 5) {
            r = new Real(RealType.Time, a.getValue() + 1728000.0, CommonUnit.secondsSinceTheEpoch);
            a = new DateTime(r);
            System.out.println("\t" + a);
            ++i;
        }
        System.out.println("\nInitialized using Real of RealType.Time but no Unit (backward compatibility):");
        r = new Real(RealType.Time, a.getValue() + 86400.0);
        a = new DateTime(r);
        System.out.println("\n\t" + a);
        System.out.println("\nInitialized with a BCE date DateTime(-5, 196, 24493.):");
        a = new DateTime(-5, 193, 24493.0);
        System.out.println("\n\ttoString()        = " + a + "\n\tdateString()      = " + a.dateString() + "\n\ttimeString()      = " + a.timeString());
        Date date = new Date();
        a = new DateTime(date);
        System.out.println("\nInitialized with current Date(): " + a);
        a = new DateTime((double)date.getTime() / 1000.0);
        System.out.println("\nInitialized with current seconds since the epoch: " + a + "\n");
        a = DateTime.createDateTime(a.toString());
        System.out.println("\nUsing createDateTime with string of current Date(): " + a);
    }

    static {
        timeZone = defaultTimeZone = TimeZone.getTimeZone("GMT");
    }
}

