/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AVControl;
import visad.AnimationControl;
import visad.CommonUnit;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.DataReference;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.Field;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.RemoteData;
import visad.RemoteDataReference;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.TextType;
import visad.ToggleControl;
import visad.TupleType;
import visad.Unit;
import visad.ValueControl;
import visad.VisADException;
import visad.VisADRay;
import visad.collab.CollabUtil;

public abstract class DataRenderer
implements Cloneable {
    private DisplayImpl display = null;
    private DisplayRenderer displayRenderer;
    private transient DataDisplayLink[] Links = null;
    private boolean[] feasible;
    private boolean[] is_null;
    private boolean[] changed;
    private boolean any_changed;
    private boolean all_feasible;
    private boolean any_transform_control;
    private Vector exceptionVector = new Vector();
    private boolean suppress_exceptions = false;
    protected boolean enabled = true;
    boolean lat_lon_in = false;
    boolean lat_lon_in_by_coord = false;
    boolean lat_lon_out = false;
    boolean lat_lon_out_by_coord = false;
    int lat_lon_dimension = -1;
    ShadowRealTupleType shadow_data_out = null;
    RealTupleType data_out = null;
    Unit[] data_units_out = null;
    ShadowRealTupleType shadow_data_in = null;
    RealTupleType data_in = null;
    Unit[] data_units_in = null;
    CoordinateSystem[] data_coord_in = null;
    ScalarMap[] sdo_maps = null;
    ScalarMap[] sdi_maps = null;
    int[] sdo_spatial_index = null;
    int[] sdi_spatial_index = null;
    int lat_index = -1;
    int lon_index = -1;
    int other_index = -1;
    boolean other_meters = false;
    RealVectorType[] rvts = new RealVectorType[]{null, null};
    CoordinateSystem display_coordinate_system = null;
    DisplayTupleType spatial_tuple = null;
    int[] spatial_value_indices = new int[]{-1, -1, -1};
    float[] default_spatial_in = new float[]{0.0f, 0.0f, 0.0f};
    boolean lat_lon_spatial = false;
    ScalarMap lat_map = null;
    ScalarMap lon_map = null;
    int lat_spatial_index = -1;
    int lon_spatial_index = -1;
    double[] ranges = null;
    private float[][] spatialValues = null;
    private int lastIndex = -1;
    double[] lastD = null;
    float[] lastX = new float[6];
    private int closeIndex = -1;
    private float offsetx = 0.0f;
    private float offsety = 0.0f;
    private float offsetz = 0.0f;
    private int offset_count = 0;
    private static final int OFFSET_COUNT_INIT = 30;
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private transient MathType type = null;
    private transient ShadowType shadow = null;
    private float point_x;
    private float point_y;
    private float point_z;
    private float line_x;
    private float line_y;
    private float line_z;
    private float[] f = new float[1];
    private float[] d = new float[1];
    private float[][] value = new float[1][1];
    private String whyNotDirect = null;
    private int[] axisToComponent = new int[]{-1, -1, -1};
    private ScalarMap[] directMap = new ScalarMap[]{null, null, null};
    private int domainAxis = -1;
    private int directManifoldDimension = 0;
    DisplayTupleType tuple;
    private static final String notRealFunction = "FunctionType must be Real";
    private static final String notSimpleField = "not simple field";
    private static final String notSimpleTuple = "not simple tuple";
    private static final String multipleMapping = "RealType with multiple mappings";
    private static final String multipleSpatialMapping = "RealType with multiple spatial mappings";
    private static final String nonSpatial = "no spatial mapping";
    private static final String viaReference = "spatial mapping through Reference";
    private static final String domainDimension = "domain dimension must be 1";
    private static final String domainNotSpatial = "domain must be mapped to spatial";
    private static final String rangeType = "range must be RealType or RealTupleType";
    private static final String rangeNotSpatial = "range must be mapped to spatial";
    private static final String domainSet = "domain Set must be Gridded1DSet";
    private static final String tooFewSpatial = "Function without spatial domain";
    private static final String functionTooFew = "Function directManifoldDimension < 2";
    private static final String badCoordSysManifoldDim = "bad directManifoldDimension with spatial CoordinateSystem";
    private static final String lostConnection = "lost connection to Data server";
    private boolean stop = false;
    private int LastMouseModifiers = 0;
    private boolean isDirectManipulation;
    protected boolean pickCrawlToCursor = true;
    private float ray_pos;
    private static final int HALF_GUESSES = 200;
    private static final int GUESSES = 401;
    private static final float RAY_POS_INC = 0.1f;
    private static final int TRYS = 10;
    private static final double EPS = (double)0.001f;
    static /* synthetic */ Class class$visad$AVControl;

    public void clearExceptions() {
        this.exceptionVector.removeAllElements();
    }

    public void suppressExceptions(boolean suppress) {
        this.suppress_exceptions = suppress;
    }

    public void addException(Exception error) {
        this.exceptionVector.addElement(error);
    }

    public Vector getExceptionVector() {
        return this.suppress_exceptions ? new Vector() : (Vector)this.exceptionVector.clone();
    }

    public boolean get_all_feasible() {
        return this.all_feasible;
    }

    public boolean get_any_changed() {
        return this.any_changed;
    }

    public boolean get_any_transform_control() {
        return this.any_transform_control;
    }

    public void set_all_feasible(boolean b) {
        this.all_feasible = b;
    }

    public abstract void setLinks(DataDisplayLink[] var1, DisplayImpl var2) throws VisADException;

    public void toggle(boolean on) {
        this.enabled = on;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public synchronized void setLinks(DataDisplayLink[] links) {
        if (links == null || links.length == 0) {
            return;
        }
        this.Links = links;
        this.feasible = new boolean[this.Links.length];
        this.is_null = new boolean[this.Links.length];
        this.changed = new boolean[this.Links.length];
        int i = 0;
        while (i < this.Links.length) {
            this.feasible[i] = false;
            this.is_null[i] = true;
            ++i;
        }
    }

    public DataDisplayLink[] getLinks() {
        return this.Links;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public void setDisplay(DisplayImpl d) {
        this.display = d;
    }

    public DisplayRenderer getDisplayRenderer() {
        return this.displayRenderer;
    }

    public void setDisplayRenderer(DisplayRenderer r) {
        this.displayRenderer = r;
    }

    public boolean checkAction() {
        int i = 0;
        while (i < this.Links.length) {
            if (this.Links[i].checkTicks() || !this.feasible[i]) {
                return true;
            }
            Enumeration maps = this.Links[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                if (!map.checkTicks(this, this.Links[i])) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public DataShadow prepareAction(boolean go, boolean initialize, DataShadow shadow) throws VisADException, RemoteException {
        this.any_changed = false;
        this.all_feasible = true;
        this.any_transform_control = false;
        int i = 0;
        while (i < this.Links.length) {
            block12: {
                this.changed[i] = false;
                DataReference ref = this.Links[i].getDataReference();
                if (this.Links[i].checkTicks() || !this.feasible[i] || go) {
                    this.changed[i] = true;
                    this.any_changed = true;
                    try {
                        this.feasible[i] = this.Links[i].prepareData();
                        this.is_null[i] = this.Links[i].getData() == null;
                    }
                    catch (RemoteException re) {
                        if (CollabUtil.isDisconnectException(re)) {
                            this.getDisplay().connectionFailed(this, this.Links[i]);
                            this.removeLink(this.Links[i]);
                            --i;
                            break block12;
                        }
                        throw re;
                    }
                    if (!this.feasible[i]) {
                        this.all_feasible = false;
                        this.clearBranch();
                    }
                    if (initialize && this.feasible[i]) {
                        Data data;
                        ShadowType type = this.Links[i].getShadow().getAdaptedShadowType();
                        try {
                            data = this.Links[i].getData();
                        }
                        catch (RemoteException re) {
                            if (CollabUtil.isDisconnectException(re)) {
                                this.getDisplay().connectionFailed(this, this.Links[i]);
                                this.removeLink(this.Links[i]);
                                --i;
                                break block12;
                            }
                            throw re;
                        }
                        shadow = this.computeRanges(data, type, shadow);
                    }
                }
                if (this.feasible[i]) {
                    Enumeration maps = this.Links[i].getSelectedMapVector().elements();
                    while (maps.hasMoreElements()) {
                        ScalarMap map = (ScalarMap)maps.nextElement();
                        if (!map.checkTicks(this, this.Links[i])) continue;
                        this.any_transform_control = true;
                    }
                }
            }
            ++i;
        }
        return shadow;
    }

    public DataShadow computeRanges(Data data, ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        shadow = shadow == null ? data.computeRanges(type, this.display.getScalarCount()) : data.computeRanges(type, shadow);
        return shadow;
    }

    public abstract void clearBranch();

    public abstract boolean doAction() throws VisADException, RemoteException;

    public boolean getBadScale(boolean anyBadMap) {
        boolean badScale = false;
        int i = 0;
        while (i < this.Links.length) {
            if (!(this.feasible[i] || !anyBadMap && this.is_null[i])) {
                return true;
            }
            Enumeration maps = this.Links[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                badScale |= map.badRange();
            }
            ++i;
        }
        return badScale;
    }

    public abstract void clearScene();

    public void clearAVControls() {
        Enumeration controls = this.display.getControls(class$visad$AVControl == null ? (class$visad$AVControl = DataRenderer.class$("visad.AVControl")) : class$visad$AVControl).elements();
        while (controls.hasMoreElements()) {
            ((AVControl)controls.nextElement()).clearSwitches(this);
        }
        ProjectionControl control = this.display.getProjectionControl();
        control.clearSwitches(this);
        this.lat_index = -1;
        this.lon_index = -1;
    }

    public abstract ShadowType makeShadowFunctionType(FunctionType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowRealTupleType(RealTupleType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowRealType(RealType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowSetType(SetType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowTextType(TextType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowTupleType(TupleType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public boolean isTransformControl(Control control, DataDisplayLink link) {
        if (control instanceof ProjectionControl || control instanceof ToggleControl) {
            return false;
        }
        return !(control instanceof AnimationControl) && !(control instanceof ValueControl);
    }

    public DataDisplayLink getLink() {
        return null;
    }

    public boolean isLegalTextureMap() {
        return true;
    }

    public RealVectorType getRealVectorTypes(int index) {
        if (index == 0 || index == 1) {
            return this.rvts[index];
        }
        return null;
    }

    public int[] getLatLonIndices() {
        return new int[]{this.lat_index, this.lon_index};
    }

    public void setLatLonIndices(int[] indices) {
        this.lat_index = indices[0];
        this.lon_index = indices[1];
    }

    public int getEarthDimension() {
        return this.lat_lon_dimension;
    }

    public Unit[] getEarthUnits() {
        Object units = null;
        units = this.lat_lon_in ? this.data_units_in : (this.lat_lon_out ? this.data_units_out : (this.lat_lon_spatial ? new Unit[]{RealType.Latitude.getDefaultUnit(), RealType.Longitude.getDefaultUnit()} : null));
        int lat = this.lat_index;
        int lon = this.lon_index;
        int other = this.other_index;
        if (units == null) {
            return null;
        }
        if (((Unit[])units).length == 2) {
            return new Unit[]{lat >= 0 ? units[lat] : null, lon >= 0 ? units[lon] : null};
        }
        if (((Unit[])units).length == 3) {
            return new Unit[]{lat >= 0 ? units[lat] : null, lon >= 0 ? units[lon] : null, other >= 0 ? units[other] : null};
        }
        return null;
    }

    public float getLatLonRange() {
        double[] rlat = null;
        double[] rlon = null;
        int lat = this.lat_index;
        int lon = this.lon_index;
        if (this.lat_lon_out && !this.lat_lon_out_by_coord || this.lat_lon_in && this.lat_lon_in_by_coord) {
            double[] dArray;
            double[] dArray2;
            if (lat >= 0) {
                dArray2 = this.sdo_maps[lat].getRange();
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = Double.NaN;
                dArray2 = dArray3;
                dArray3[1] = Double.NaN;
            }
            rlat = dArray2;
            if (lon >= 0) {
                dArray = this.sdo_maps[lon].getRange();
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = Double.NaN;
                dArray = dArray4;
                dArray4[1] = Double.NaN;
            }
            rlon = dArray;
        } else if (this.lat_lon_in && !this.lat_lon_in_by_coord || this.lat_lon_out && this.lat_lon_out_by_coord) {
            double[] dArray;
            double[] dArray5;
            if (lat >= 0) {
                dArray5 = this.sdi_maps[lat].getRange();
            } else {
                double[] dArray6 = new double[2];
                dArray6[0] = Double.NaN;
                dArray5 = dArray6;
                dArray6[1] = Double.NaN;
            }
            rlat = dArray5;
            if (lon >= 0) {
                dArray = this.sdi_maps[lon].getRange();
            } else {
                double[] dArray7 = new double[2];
                dArray7[0] = Double.NaN;
                dArray = dArray7;
                dArray7[1] = Double.NaN;
            }
            rlon = dArray;
        } else if (this.lat_lon_spatial) {
            rlat = this.lat_map.getRange();
            rlon = this.lon_map.getRange();
        } else {
            return 1.0f;
        }
        double dlat = Math.abs(rlat[1] - rlat[0]);
        double dlon = Math.abs(rlon[1] - rlon[0]);
        if (dlat != dlat) {
            dlat = 1.0;
        }
        if (dlon != dlon) {
            dlon = 1.0;
        }
        return dlat > dlon ? (float)dlat : (float)dlon;
    }

    public float[][] earthToSpatial(float[][] locs, float[] vert) throws VisADException {
        return this.earthToSpatial(locs, vert, null);
    }

    public float[][] earthToSpatial(float[][] locs, float[] vert, float[][] base_spatial_locs) throws VisADException {
        int i;
        int k;
        int k2;
        int j;
        int i2;
        float[][] temp;
        int lat = this.lat_index;
        int lon = this.lon_index;
        int other = this.other_index;
        if (this.lat_index < 0 || this.lon_index < 0) {
            return null;
        }
        int size = locs[0].length;
        if (((float[][])locs).length < this.lat_lon_dimension) {
            temp = locs;
            locs = new float[this.lat_lon_dimension][];
            i2 = 0;
            while (i2 < ((float[][])locs).length) {
                locs[i2] = temp[i2];
                ++i2;
            }
            float[] zero = new float[size];
            int j2 = 0;
            while (j2 < size) {
                zero[j2] = 0.0f;
                ++j2;
            }
            int i3 = ((float[][])locs).length;
            while (i3 < this.lat_lon_dimension) {
                locs[i3] = zero;
                ++i3;
            }
        } else if (((float[][])locs).length > this.lat_lon_dimension) {
            temp = locs;
            locs = new float[this.lat_lon_dimension][];
            i2 = 0;
            while (i2 < this.lat_lon_dimension) {
                locs[i2] = temp[i2];
                ++i2;
            }
        }
        Object tuple_locs = new float[this.lat_lon_dimension][];
        Object spatial_locs = new float[3][];
        tuple_locs[lat] = locs[0];
        tuple_locs[lon] = locs[1];
        if (this.lat_lon_dimension == 3) {
            tuple_locs[other] = locs[2];
        }
        int vert_index = -1;
        if (this.lat_lon_in) {
            if (this.lat_lon_in_by_coord) {
                if (this.data_coord_in.length == 1) {
                    tuple_locs = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[0], this.data_units_in, null, tuple_locs);
                } else {
                    float[][] temp2 = new float[this.lat_lon_dimension][1];
                    j = 0;
                    while (j < size) {
                        k2 = 0;
                        while (k2 < this.lat_lon_dimension) {
                            temp2[k2][0] = tuple_locs[k2][j];
                            ++k2;
                        }
                        temp2 = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[j], this.data_units_in, null, temp2);
                        k = 0;
                        while (k < this.lat_lon_dimension) {
                            tuple_locs[k][j] = temp2[k][0];
                            ++k;
                        }
                        ++j;
                    }
                }
                i = 0;
                while (i < this.lat_lon_dimension) {
                    spatial_locs[this.sdo_spatial_index[i]] = this.sdo_maps[i].scaleValues(tuple_locs[i]);
                    ++i;
                }
                if (this.lat_lon_dimension == 2) {
                    vert_index = 3 - (this.sdo_spatial_index[0] + this.sdo_spatial_index[1]);
                }
            } else {
                i = 0;
                while (i < this.lat_lon_dimension) {
                    spatial_locs[this.sdi_spatial_index[i]] = this.sdi_maps[i].scaleValues(tuple_locs[i]);
                    ++i;
                }
                if (this.lat_lon_dimension == 2) {
                    vert_index = 3 - (this.sdi_spatial_index[0] + this.sdi_spatial_index[1]);
                }
            }
        } else if (this.lat_lon_out) {
            if (this.lat_lon_out_by_coord) {
                if (this.data_coord_in.length == 1) {
                    tuple_locs = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[0], this.data_units_in, null, this.data_out, null, this.data_units_out, null, tuple_locs);
                } else {
                    float[][] temp3 = new float[this.lat_lon_dimension][1];
                    j = 0;
                    while (j < size) {
                        k2 = 0;
                        while (k2 < this.lat_lon_dimension) {
                            temp3[k2][0] = tuple_locs[k2][j];
                            ++k2;
                        }
                        temp3 = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[j], this.data_units_in, null, this.data_out, null, this.data_units_out, null, temp3);
                        k = 0;
                        while (k < this.lat_lon_dimension) {
                            tuple_locs[k][j] = temp3[k][0];
                            ++k;
                        }
                        ++j;
                    }
                }
                i = 0;
                while (i < this.lat_lon_dimension) {
                    spatial_locs[this.sdi_spatial_index[i]] = this.sdi_maps[i].scaleValues(tuple_locs[i]);
                    ++i;
                }
                if (this.lat_lon_dimension == 2) {
                    vert_index = 3 - (this.sdi_spatial_index[0] + this.sdi_spatial_index[1]);
                }
            } else {
                i = 0;
                while (i < this.lat_lon_dimension) {
                    spatial_locs[this.sdo_spatial_index[i]] = this.sdo_maps[i].scaleValues(tuple_locs[i]);
                    ++i;
                }
                if (this.lat_lon_dimension == 2) {
                    vert_index = 3 - (this.sdo_spatial_index[0] + this.sdo_spatial_index[1]);
                }
            }
        } else if (this.lat_lon_spatial) {
            spatial_locs[this.lat_spatial_index] = this.lat_map.scaleValues(tuple_locs[lat]);
            spatial_locs[this.lon_spatial_index] = this.lon_map.scaleValues(tuple_locs[lon]);
            vert_index = 3 - (this.lat_spatial_index + this.lon_spatial_index);
        } else {
            return null;
        }
        i = 0;
        while (i < 3) {
            if (spatial_locs[i] == null) {
                if (base_spatial_locs != null && base_spatial_locs[i] != null) {
                    spatial_locs[i] = base_spatial_locs[i];
                } else {
                    spatial_locs[i] = new float[size];
                    float def = this.default_spatial_in[i];
                    int j3 = 0;
                    while (j3 < size) {
                        spatial_locs[i][j3] = def;
                        ++j3;
                    }
                }
            }
            ++i;
        }
        if (vert != null && vert_index > -1 && spatial_locs[vert_index] != null) {
            int j4 = 0;
            while (j4 < size) {
                float[] fArray = spatial_locs[vert_index];
                int n = j4;
                fArray[n] = fArray[n] + vert[j4];
                ++j4;
            }
        }
        if (this.display_coordinate_system != null && spatial_locs != null && ((float[][])spatial_locs).length > 0 && spatial_locs[0] != null && spatial_locs[0].length > 0) {
            spatial_locs = this.display_coordinate_system.toReference((float[][])spatial_locs);
        }
        return spatial_locs;
    }

    public float[][] spatialToEarth(float[][] spatial_locs) throws VisADException {
        float[][] base_spatial_locs = new float[3][];
        return this.spatialToEarth(spatial_locs, base_spatial_locs);
    }

    public float[][] spatialToEarth(float[][] spatial_locs, float[][] base_spatial_locs) throws VisADException {
        int i;
        int lat = this.lat_index;
        int lon = this.lon_index;
        int other = this.other_index;
        if (this.lat_index < 0 || this.lon_index < 0) {
            return null;
        }
        if (spatial_locs.length != 3) {
            return null;
        }
        int size = 0;
        int i2 = 0;
        while (i2 < 3) {
            if (spatial_locs[i2] != null && spatial_locs[i2].length > size) {
                size = spatial_locs[i2].length;
            }
            ++i2;
        }
        if (size == 0) {
            return null;
        }
        int i3 = 0;
        while (i3 < 3) {
            if (spatial_locs[i3] == null) {
                spatial_locs[i3] = new float[size];
                int j = 0;
                while (j < size) {
                    spatial_locs[i3][j] = 0.0f;
                    ++j;
                }
            }
            ++i3;
        }
        if (this.display_coordinate_system != null) {
            spatial_locs = this.display_coordinate_system.fromReference(spatial_locs);
        }
        base_spatial_locs[0] = spatial_locs[0];
        base_spatial_locs[1] = spatial_locs[1];
        base_spatial_locs[2] = spatial_locs[2];
        Object tuple_locs = new float[this.lat_lon_dimension][];
        if (this.lat_lon_in) {
            if (this.lat_lon_in_by_coord) {
                i = 0;
                while (i < this.lat_lon_dimension) {
                    tuple_locs[i] = this.sdo_maps[i].inverseScaleValues(spatial_locs[this.sdo_spatial_index[i]]);
                    ++i;
                }
                if (this.data_coord_in.length == 1) {
                    tuple_locs = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[0], this.data_units_in, null, this.data_out, null, this.data_units_out, null, tuple_locs);
                } else {
                    float[][] temp = new float[this.lat_lon_dimension][1];
                    int j = 0;
                    while (j < size) {
                        int k = 0;
                        while (k < this.lat_lon_dimension) {
                            temp[k][0] = tuple_locs[k][j];
                            ++k;
                        }
                        temp = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[j], this.data_units_in, null, this.data_out, null, this.data_units_out, null, temp);
                        int k2 = 0;
                        while (k2 < this.lat_lon_dimension) {
                            tuple_locs[k2][j] = temp[k2][0];
                            ++k2;
                        }
                        ++j;
                    }
                }
            } else {
                i = 0;
                while (i < this.lat_lon_dimension) {
                    tuple_locs[i] = this.sdi_maps[i].inverseScaleValues(spatial_locs[this.sdi_spatial_index[i]]);
                    ++i;
                }
            }
        } else if (this.lat_lon_out) {
            if (this.lat_lon_out_by_coord) {
                i = 0;
                while (i < this.lat_lon_dimension) {
                    tuple_locs[i] = this.sdi_maps[i].inverseScaleValues(spatial_locs[this.sdi_spatial_index[i]]);
                    ++i;
                }
                if (this.data_coord_in.length == 1) {
                    tuple_locs = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[0], this.data_units_in, null, tuple_locs);
                } else {
                    float[][] temp = new float[this.lat_lon_dimension][1];
                    int j = 0;
                    while (j < size) {
                        int k = 0;
                        while (k < this.lat_lon_dimension) {
                            temp[k][0] = tuple_locs[k][j];
                            ++k;
                        }
                        temp = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[j], this.data_units_in, null, temp);
                        int k3 = 0;
                        while (k3 < this.lat_lon_dimension) {
                            tuple_locs[k3][j] = temp[k3][0];
                            ++k3;
                        }
                        ++j;
                    }
                }
            } else {
                i = 0;
                while (i < this.lat_lon_dimension) {
                    tuple_locs[i] = this.sdo_maps[i].inverseScaleValues(spatial_locs[this.sdo_spatial_index[i]]);
                    ++i;
                }
            }
        } else if (this.lat_lon_spatial) {
            tuple_locs[lat] = this.lat_map.inverseScaleValues(spatial_locs[this.lat_spatial_index]);
            tuple_locs[lon] = this.lon_map.inverseScaleValues(spatial_locs[this.lon_spatial_index]);
        } else {
            return null;
        }
        float[][] locs = new float[this.lat_lon_dimension][];
        locs[0] = tuple_locs[lat];
        locs[1] = tuple_locs[lon];
        if (this.lat_lon_dimension == 3) {
            locs[2] = tuple_locs[other];
        }
        return locs;
    }

    public void setEarthSpatialData(ShadowRealTupleType s_d_i, ShadowRealTupleType s_d_o, RealTupleType d_o, Unit[] d_u_o, RealTupleType d_i, CoordinateSystem[] d_c_i, Unit[] d_u_i) throws VisADException {
        RealType real;
        int i;
        ScalarMap[] maps;
        int k;
        if (d_o != null && d_o instanceof RealVectorType && (k = this.getFlowMaps(s_d_o, maps = new ScalarMap[3])) > -1) {
            this.rvts[k] = (RealVectorType)d_o;
        }
        if (d_i != null && d_i instanceof RealVectorType && (k = this.getFlowMaps(s_d_i, maps = new ScalarMap[3])) > -1) {
            this.rvts[k] = (RealVectorType)d_i;
        }
        int lat_index_local = -1;
        int lon_index_local = -1;
        int other_index_local = -1;
        int n = 0;
        int m = 0;
        if (d_i != null) {
            n = d_i.getDimension();
            i = 0;
            while (i < n) {
                real = (RealType)d_i.getComponent(i);
                if (RealType.Latitude.equals(real)) {
                    lat_index_local = i;
                }
                if (RealType.Longitude.equals(real)) {
                    lon_index_local = i;
                }
                ++i;
            }
        }
        if (lat_index_local > -1 && lon_index_local > -1 && (n == 2 || n == 3)) {
            if (s_d_i != null && s_d_i.getAllSpatial() && !s_d_i.getSpatialReference()) {
                this.lat_lon_in_by_coord = false;
                this.sdi_spatial_index = new int[s_d_i.getDimension()];
                this.sdi_maps = this.getSpatialMaps(s_d_i, this.sdi_spatial_index);
                if (this.sdi_maps == null) {
                    throw new DisplayException("sdi_maps null A");
                }
            } else if (s_d_o != null && s_d_o.getAllSpatial() && !s_d_o.getSpatialReference()) {
                this.lat_lon_in_by_coord = true;
                this.sdo_spatial_index = new int[s_d_o.getDimension()];
                this.sdo_maps = this.getSpatialMaps(s_d_o, this.sdo_spatial_index);
                if (this.sdo_maps == null) {
                    throw new DisplayException("sdo_maps null A");
                }
            } else {
                return;
            }
            this.lat_lon_in = true;
            this.lat_lon_out = false;
            this.lat_lon_out_by_coord = false;
            this.lat_lon_spatial = false;
            this.lat_lon_dimension = n;
            if (n == 3 && Unit.canConvert(d_u_i[other_index_local = 3 - (lat_index_local + lon_index_local)], CommonUnit.meter)) {
                this.other_meters = true;
            }
        } else {
            lat_index_local = -1;
            lon_index_local = -1;
            other_index_local = -1;
            if (d_o != null) {
                m = d_o.getDimension();
                i = 0;
                while (i < m) {
                    real = (RealType)d_o.getComponent(i);
                    if (RealType.Latitude.equals(real)) {
                        lat_index_local = i;
                    }
                    if (RealType.Longitude.equals(real)) {
                        lon_index_local = i;
                    }
                    ++i;
                }
            }
            if (lat_index_local < 0 || lon_index_local < 0 || m != 2 && m != 3) {
                return;
            }
            if (s_d_o != null && s_d_o.getAllSpatial() && !s_d_o.getSpatialReference()) {
                this.lat_lon_out_by_coord = false;
                this.sdo_spatial_index = new int[s_d_o.getDimension()];
                this.sdo_maps = this.getSpatialMaps(s_d_o, this.sdo_spatial_index);
                if (this.sdo_maps == null) {
                    throw new DisplayException("sdo_maps null B");
                }
            } else if (s_d_i != null && s_d_i.getAllSpatial() && !s_d_i.getSpatialReference()) {
                this.lat_lon_out_by_coord = true;
                this.sdi_spatial_index = new int[s_d_i.getDimension()];
                this.sdi_maps = this.getSpatialMaps(s_d_i, this.sdi_spatial_index);
                if (this.sdi_maps == null) {
                    throw new DisplayException("sdi_maps null B");
                }
            } else {
                return;
            }
            this.lat_lon_out = true;
            this.lat_lon_in = false;
            this.lat_lon_in_by_coord = false;
            this.lat_lon_spatial = false;
            this.lat_lon_dimension = m;
            if (m == 3 && Unit.canConvert(d_u_i[other_index_local = 3 - (lat_index_local + lon_index_local)], CommonUnit.meter)) {
                this.other_meters = true;
            }
        }
        this.shadow_data_out = s_d_o;
        this.data_out = d_o;
        this.data_units_out = d_u_o;
        this.shadow_data_in = s_d_i;
        this.data_in = d_i;
        this.data_units_in = d_u_i;
        this.data_coord_in = d_c_i;
        this.lat_index = lat_index_local;
        this.lon_index = lon_index_local;
        this.other_index = other_index_local;
    }

    private ScalarMap[] getSpatialMaps(ShadowRealTupleType srt, int[] spatial_index) {
        int n = srt.getDimension();
        ScalarMap[] maps = new ScalarMap[n];
        int i = 0;
        while (i < n) {
            ShadowRealType real = (ShadowRealType)srt.getComponent(i);
            Enumeration ms = real.getSelectedMapVector().elements();
            while (ms.hasMoreElements()) {
                ScalarMap map = (ScalarMap)ms.nextElement();
                DisplayRealType dreal = map.getDisplayScalar();
                DisplayTupleType tuple = dreal.getTuple();
                if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
                maps[i] = map;
                spatial_index[i] = dreal.getTupleIndex();
                break;
            }
            if (maps[i] == null) {
                return null;
            }
            ++i;
        }
        return maps;
    }

    private int getFlowMaps(ShadowRealTupleType srt, ScalarMap[] maps) {
        int n = srt.getDimension();
        maps[0] = null;
        maps[1] = null;
        maps[2] = null;
        DisplayTupleType ftuple = null;
        int i = 0;
        while (i < n) {
            ShadowRealType real = (ShadowRealType)srt.getComponent(i);
            Enumeration ms = real.getSelectedMapVector().elements();
            while (ms.hasMoreElements()) {
                ScalarMap map = (ScalarMap)ms.nextElement();
                DisplayRealType dreal = map.getDisplayScalar();
                DisplayTupleType tuple = dreal.getTuple();
                if (!Display.DisplayFlow1Tuple.equals(tuple) && !Display.DisplayFlow2Tuple.equals(tuple)) continue;
                if (ftuple != null && !ftuple.equals(tuple)) {
                    return -1;
                }
                ftuple = tuple;
                maps[i] = map;
                break;
            }
            if (maps[i] == null) {
                return -1;
            }
            ++i;
        }
        return Display.DisplayFlow1Tuple.equals(ftuple) ? 0 : 1;
    }

    public double[] getRanges() {
        return this.ranges;
    }

    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.display_coordinate_system;
    }

    public void setEarthSpatialDisplay(CoordinateSystem coord, DisplayTupleType t, DisplayImpl display, int[] indices, float[] default_values, double[] r) throws VisADException {
        this.display_coordinate_system = coord;
        this.spatial_tuple = t;
        System.arraycopy(indices, 0, this.spatial_value_indices, 0, 3);
        this.ranges = r;
        int i = 0;
        while (i < 3) {
            int default_index = display.getDisplayScalarIndex((DisplayRealType)t.getComponent(i));
            this.default_spatial_in[i] = default_values[default_index];
            ++i;
        }
        if (this.lat_index > -1 && this.lon_index > -1) {
            return;
        }
        this.lat_index = -1;
        this.lon_index = -1;
        this.other_index = -1;
        int valueArrayLength = display.getValueArrayLength();
        int[] valueToScalar = display.getValueToScalar();
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        int i2 = 0;
        while (i2 < valueArrayLength) {
            ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i2]);
            ScalarType real = map.getScalar();
            DisplayRealType dreal = map.getDisplayScalar();
            DisplayTupleType tuple = dreal.getTuple();
            if (tuple != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                if (RealType.Latitude.equals(real)) {
                    this.lat_index = 0;
                    this.lat_map = map;
                    this.lat_spatial_index = dreal.getTupleIndex();
                }
                if (RealType.Longitude.equals(real)) {
                    this.lon_index = 1;
                    this.lon_map = map;
                    this.lon_spatial_index = dreal.getTupleIndex();
                }
            }
            ++i2;
        }
        if (this.lat_index > -1 && this.lon_index > -1) {
            this.lat_lon_spatial = true;
            this.lat_lon_dimension = 2;
            this.lat_lon_out = false;
            this.lat_lon_in_by_coord = false;
            this.lat_lon_in = false;
        } else {
            this.lat_lon_spatial = false;
            this.lat_index = -1;
            this.lon_index = -1;
        }
    }

    public synchronized void realCheckDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            this.link = null;
            return;
        }
        this.link = Links[0];
        this.ref = this.link.getDataReference();
        this.shadow = this.link.getShadow().getAdaptedShadowType();
        this.type = this.link.getType();
        this.tuple = null;
        if (this.type instanceof FunctionType) {
            Data data;
            ShadowRealTupleType domain = ((ShadowFunctionType)this.shadow).getDomain();
            ShadowType range = ((ShadowFunctionType)this.shadow).getRange();
            this.tuple = domain.getDisplaySpatialTuple();
            if (!((FunctionType)this.type).getReal()) {
                this.whyNotDirect = notRealFunction;
                return;
            }
            if (this.shadow.getLevelOfDifficulty() != 3) {
                this.whyNotDirect = notSimpleField;
                return;
            }
            if (this.shadow.getMultipleSpatialDisplayScalar()) {
                this.whyNotDirect = multipleSpatialMapping;
                return;
            }
            if (domain.getDimension() != 1) {
                this.whyNotDirect = domainDimension;
                return;
            }
            if (!(Display.DisplaySpatialCartesianTuple.equals(this.tuple) || this.tuple != null && this.tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.whyNotDirect = domainNotSpatial;
                return;
            }
            if (domain.getSpatialReference()) {
                this.whyNotDirect = viaReference;
                return;
            }
            DisplayTupleType rtuple = null;
            if (range instanceof ShadowRealTupleType) {
                rtuple = ((ShadowRealTupleType)range).getDisplaySpatialTuple();
            } else if (range instanceof ShadowRealType) {
                rtuple = ((ShadowRealType)range).getDisplaySpatialTuple();
            } else {
                this.whyNotDirect = rangeType;
                return;
            }
            if (!this.tuple.equals(rtuple)) {
                this.whyNotDirect = rangeNotSpatial;
                return;
            }
            if (range instanceof ShadowRealTupleType && ((ShadowRealTupleType)range).getSpatialReference()) {
                this.whyNotDirect = viaReference;
                return;
            }
            try {
                data = this.link.getData();
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    this.link = null;
                    this.whyNotDirect = lostConnection;
                    return;
                }
                throw re;
            }
            if (!(data instanceof Field) || !(((Field)data).getDomainSet() instanceof Gridded1DSet)) {
                this.whyNotDirect = domainSet;
                return;
            }
            if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
                this.tuple = null;
            }
            this.domainAxis = -1;
            int i = 0;
            while (i < 3) {
                this.axisToComponent[i] = -1;
                this.directMap[i] = null;
                ++i;
            }
            this.directManifoldDimension = this.setDirectMap((ShadowRealType)domain.getComponent(0), -1, true);
            if (range instanceof ShadowRealType) {
                this.directManifoldDimension += this.setDirectMap((ShadowRealType)range, 0, false);
            } else if (range instanceof ShadowRealTupleType) {
                ShadowRealTupleType r = (ShadowRealTupleType)range;
                int i2 = 0;
                while (i2 < r.getDimension()) {
                    this.directManifoldDimension += this.setDirectMap((ShadowRealType)r.getComponent(i2), i2, false);
                    ++i2;
                }
            }
            if (this.domainAxis == -1) {
                this.whyNotDirect = tooFewSpatial;
                return;
            }
            if (this.directManifoldDimension < 2) {
                this.whyNotDirect = functionTooFew;
                return;
            }
            boolean twod = this.displayRenderer.getMode2D();
            if (this.tuple != null && (!twod && this.directManifoldDimension != 3 || twod && this.directManifoldDimension != 2)) {
                this.whyNotDirect = badCoordSysManifoldDim;
                return;
            }
            this.setIsDirectManipulation(true);
        } else if (this.type instanceof RealTupleType) {
            this.tuple = ((ShadowRealTupleType)this.shadow).getDisplaySpatialTuple();
            if (this.shadow.getLevelOfDifficulty() != 5) {
                this.whyNotDirect = notSimpleTuple;
                return;
            }
            if (this.shadow.getMultipleSpatialDisplayScalar()) {
                this.whyNotDirect = multipleSpatialMapping;
                return;
            }
            if (!(Display.DisplaySpatialCartesianTuple.equals(this.tuple) || this.tuple != null && this.tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.whyNotDirect = nonSpatial;
                return;
            }
            if (((ShadowRealTupleType)this.shadow).getSpatialReference()) {
                this.whyNotDirect = viaReference;
                return;
            }
            if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
                this.tuple = null;
            }
            this.domainAxis = -1;
            int i = 0;
            while (i < 3) {
                this.axisToComponent[i] = -1;
                this.directMap[i] = null;
                ++i;
            }
            this.directManifoldDimension = 0;
            int i3 = 0;
            while (i3 < ((ShadowRealTupleType)this.shadow).getDimension()) {
                this.directManifoldDimension += this.setDirectMap((ShadowRealType)((ShadowRealTupleType)this.shadow).getComponent(i3), i3, false);
                ++i3;
            }
            boolean twod = this.displayRenderer.getMode2D();
            if (this.tuple != null && (!twod && this.directManifoldDimension != 3 || twod && this.directManifoldDimension != 2)) {
                this.whyNotDirect = badCoordSysManifoldDim;
                return;
            }
            this.setIsDirectManipulation(true);
        } else if (this.type instanceof RealType) {
            this.tuple = ((ShadowRealType)this.shadow).getDisplaySpatialTuple();
            if (this.shadow.getLevelOfDifficulty() != 5) {
                this.whyNotDirect = notSimpleTuple;
                return;
            }
            if (this.shadow.getMultipleSpatialDisplayScalar()) {
                this.whyNotDirect = multipleSpatialMapping;
                return;
            }
            if (!(Display.DisplaySpatialCartesianTuple.equals(this.tuple) || this.tuple != null && this.tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.whyNotDirect = nonSpatial;
                return;
            }
            if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
                this.tuple = null;
            }
            this.domainAxis = -1;
            int i = 0;
            while (i < 3) {
                this.axisToComponent[i] = -1;
                this.directMap[i] = null;
                ++i;
            }
            this.directManifoldDimension = this.setDirectMap((ShadowRealType)this.shadow, 0, false);
            boolean twod = this.displayRenderer.getMode2D();
            if (this.tuple != null && (!twod && this.directManifoldDimension != 3 || twod && this.directManifoldDimension != 2)) {
                this.whyNotDirect = badCoordSysManifoldDim;
                return;
            }
            this.setIsDirectManipulation(true);
        }
    }

    synchronized int setDirectMap(ShadowRealType real, int component, boolean domain) {
        Enumeration maps = real.getSelectedMapVector().elements();
        while (maps.hasMoreElements()) {
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType dreal = map.getDisplayScalar();
            DisplayTupleType tuple = dreal.getTuple();
            if (!Display.DisplaySpatialCartesianTuple.equals(tuple) && (tuple == null || tuple.getCoordinateSystem() == null || !Display.DisplaySpatialCartesianTuple.equals(tuple.getCoordinateSystem().getReference()))) continue;
            int index = dreal.getTupleIndex();
            if (domain) {
                this.domainAxis = index;
            } else {
                this.axisToComponent[index] = component;
            }
            this.directMap[index] = map;
            return 1;
        }
        return 0;
    }

    private int getDirectManifoldDimension() {
        return this.directManifoldDimension;
    }

    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    private int getAxisToComponent(int i) {
        return this.axisToComponent[i];
    }

    private ScalarMap getDirectMap(int i) {
        return this.directMap[i];
    }

    private int getDomainAxis() {
        return this.domainAxis;
    }

    public synchronized void setSpatialValues(float[][] spatial_values) {
        this.spatialValues = spatial_values;
    }

    public synchronized float checkClose(double[] origin, double[] direction) {
        float distance = Float.MAX_VALUE;
        this.lastIndex = -1;
        if (this.spatialValues == null) {
            return distance;
        }
        float o_x = (float)origin[0];
        float o_y = (float)origin[1];
        float o_z = (float)origin[2];
        float d_x = (float)direction[0];
        float d_y = (float)direction[1];
        float d_z = (float)direction[2];
        int i = 0;
        while (i < this.spatialValues[0].length) {
            float dot;
            float d;
            float x = this.spatialValues[0][i] - o_x;
            float y = this.spatialValues[1][i] - o_y;
            float z = this.spatialValues[2][i] - o_z;
            if ((d = (float)Math.sqrt((x -= (dot = x * d_x + y * d_y + z * d_z) * d_x) * x + (y -= dot * d_y) * y + (z -= dot * d_z) * z)) < distance) {
                distance = d;
                this.closeIndex = i;
                this.offsetx = x;
                this.offsety = y;
                this.offsetz = z;
            }
            ++i;
        }
        return distance;
    }

    public synchronized void release_direct() {
    }

    public void stop_direct() {
        this.stop = true;
    }

    public int getLastMouseModifiers() {
        return this.LastMouseModifiers;
    }

    public void setLastMouseModifiers(int mouseModifiers) {
        this.LastMouseModifiers = mouseModifiers;
    }

    public synchronized void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
        if (this.spatialValues == null || this.ref == null || this.shadow == null || this.link == null) {
            return;
        }
        if (first) {
            this.stop = false;
        } else if (this.stop) {
            return;
        }
        float o_x = (float)ray.position[0];
        float o_y = (float)ray.position[1];
        float o_z = (float)ray.position[2];
        float d_x = (float)ray.vector[0];
        float d_y = (float)ray.vector[1];
        float d_z = (float)ray.vector[2];
        if (this.pickCrawlToCursor) {
            if (first) {
                this.offset_count = 30;
            } else if (this.offset_count > 0) {
                --this.offset_count;
            }
            if (this.offset_count > 0) {
                float mult = (float)this.offset_count / 30.0f;
                o_x += mult * this.offsetx;
                o_y += mult * this.offsety;
                o_z += mult * this.offsetz;
            }
        }
        if (first) {
            this.point_x = this.spatialValues[0][this.closeIndex];
            this.point_y = this.spatialValues[1][this.closeIndex];
            this.point_z = this.spatialValues[2][this.closeIndex];
            int lineAxis = -1;
            if (this.getDirectManifoldDimension() == 3) {
                this.line_x = d_x;
                this.line_y = d_y;
                this.line_z = d_z;
            } else {
                int i;
                if (this.getDirectManifoldDimension() == 2) {
                    if (this.displayRenderer.getMode2D()) {
                        lineAxis = 2;
                    } else {
                        i = 0;
                        while (i < 3) {
                            if (this.getAxisToComponent(i) < 0 && this.getDomainAxis() != i) {
                                lineAxis = i;
                            }
                            ++i;
                        }
                    }
                } else if (this.getDirectManifoldDimension() == 1) {
                    i = 0;
                    while (i < 3) {
                        if (this.getAxisToComponent(i) >= 0) {
                            lineAxis = i;
                        }
                        ++i;
                    }
                }
                this.line_x = lineAxis == 0 ? 1.0f : 0.0f;
                this.line_y = lineAxis == 1 ? 1.0f : 0.0f;
                this.line_z = lineAxis == 2 ? 1.0f : 0.0f;
            }
        }
        float[] x = new float[3];
        if (this.getDirectManifoldDimension() == 1) {
            float ld = d_x * this.line_x + d_y * this.line_y + d_z * this.line_z;
            float od = o_x * d_x + o_y * d_y + o_z * d_z;
            float pd = this.point_x * d_x + this.point_y * d_y + this.point_z * d_z;
            float ol = o_x * this.line_x + o_y * this.line_y + o_z * this.line_z;
            float pl = this.point_x * this.line_x + this.point_y * this.line_y + this.point_z * this.line_z;
            if (ld * ld == 1.0f) {
                return;
            }
            float t = (pl - ol - ld * (pd - od)) / (ld * ld - 1.0f);
            x[0] = this.point_x + t * this.line_x;
            x[1] = this.point_y + t * this.line_y;
            x[2] = this.point_z + t * this.line_z;
        } else {
            float dot = (this.point_x - o_x) * this.line_x + (this.point_y - o_y) * this.line_y + (this.point_z - o_z) * this.line_z;
            float dot2 = d_x * this.line_x + d_y * this.line_y + d_z * this.line_z;
            if ((double)dot2 == 0.0) {
                return;
            }
            x[0] = o_x + (dot /= dot2) * d_x;
            x[1] = o_y + dot * d_y;
            x[2] = o_z + dot * d_z;
        }
        try {
            Data data;
            float[] xx = new float[]{x[0], x[1], x[2]};
            if (this.tuple != null) {
                float[][] cursor = new float[][]{{x[0]}, {x[1]}, {x[2]}};
                float[][] new_cursor = this.tuple.getCoordinateSystem().fromReference(cursor);
                x[0] = new_cursor[0][0];
                x[1] = new_cursor[1][0];
                x[2] = new_cursor[2][0];
            }
            DataImpl newData = null;
            try {
                data = this.link.getData();
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    this.link = null;
                    return;
                }
                throw re;
            }
            if (this.type instanceof RealType) {
                this.addPoint(xx);
                int i = 0;
                while (i < 3) {
                    if (this.getAxisToComponent(i) >= 0) {
                        this.f[0] = x[i];
                        this.d = this.getDirectMap(i).inverseScaleValues(this.f);
                        RealType rtype = (RealType)this.type;
                        newData = new Real(rtype, (double)this.d[0], rtype.getDefaultUnit(), null);
                        Vector<String> vect = new Vector<String>();
                        Real r = new Real(rtype, (double)this.d[0]);
                        Unit overrideUnit = this.getDirectMap(i).getOverrideUnit();
                        Unit rtunit = rtype.getDefaultUnit();
                        if (!(overrideUnit == null || overrideUnit.equals(rtunit) || Unit.canConvert(rtunit, CommonUnit.secondsSinceTheEpoch) && !rtunit.getAbsoluteUnit().equals(rtunit))) {
                            double dval = overrideUnit.toThis(this.d[0], rtunit);
                            r = new Real(rtype, dval, overrideUnit);
                        }
                        String valueString = r.toValueString();
                        vect.addElement(rtype.getName() + " = " + valueString);
                        this.getDisplayRenderer().setCursorStringVector(vect);
                        break;
                    }
                    ++i;
                }
                this.ref.setData(newData);
                this.link.clearData();
            } else if (this.type instanceof RealTupleType) {
                int j;
                this.addPoint(xx);
                int n = ((RealTuple)data).getDimension();
                Real[] reals = new Real[n];
                Vector<String> vect = new Vector<String>();
                int i = 0;
                while (i < 3) {
                    j = this.getAxisToComponent(i);
                    if (j >= 0) {
                        this.f[0] = x[i];
                        this.d = this.getDirectMap(i).inverseScaleValues(this.f);
                        Real c = (Real)((RealTuple)data).getComponent(j);
                        RealType rtype = (RealType)c.getType();
                        reals[j] = new Real(rtype, (double)this.d[0], rtype.getDefaultUnit(), null);
                        Real r = new Real(rtype, (double)this.d[0]);
                        Unit overrideUnit = this.getDirectMap(i).getOverrideUnit();
                        Unit rtunit = rtype.getDefaultUnit();
                        if (!(overrideUnit == null || overrideUnit.equals(rtunit) || Unit.canConvert(rtunit, CommonUnit.secondsSinceTheEpoch) && !rtunit.getAbsoluteUnit().equals(rtunit))) {
                            double dval = overrideUnit.toThis(this.d[0], rtunit);
                            r = new Real(rtype, dval, overrideUnit);
                        }
                        String valueString = r.toValueString();
                        vect.addElement(rtype.getName() + " = " + valueString);
                    }
                    ++i;
                }
                this.getDisplayRenderer().setCursorStringVector(vect);
                j = 0;
                while (j < n) {
                    if (reals[j] == null) {
                        reals[j] = (Real)((RealTuple)data).getComponent(j);
                    }
                    ++j;
                }
                newData = new RealTuple((RealTupleType)this.type, reals, ((RealTuple)data).getCoordinateSystem());
                this.ref.setData(newData);
                this.link.clearData();
            } else if (this.type instanceof FunctionType) {
                int j;
                Vector<String> vect = new Vector<String>();
                if (first) {
                    this.lastIndex = -1;
                }
                int k = this.getDomainAxis();
                this.f[0] = x[k];
                this.d = this.getDirectMap(k).inverseScaleValues(this.f);
                RealType rtype = (RealType)this.getDirectMap(k).getScalar();
                double dsave = this.d[0];
                Unit[] us = ((Field)data).getDomainUnits();
                if (us != null && us[0] != null) {
                    this.d[0] = (float)us[0].toThis(this.d[0], rtype.getDefaultUnit());
                }
                Real r = new Real(rtype, dsave);
                Unit overrideUnit = this.getDirectMap(k).getOverrideUnit();
                Unit rtunit = rtype.getDefaultUnit();
                if (!(overrideUnit == null || overrideUnit.equals(rtunit) || Unit.canConvert(rtunit, CommonUnit.secondsSinceTheEpoch) && !rtunit.getAbsoluteUnit().equals(rtunit))) {
                    dsave = overrideUnit.toThis(dsave, rtunit);
                    r = new Real(rtype, dsave, overrideUnit);
                }
                String valueString = r.toValueString();
                vect.addElement(rtype.getName() + " = " + valueString);
                Gridded1DSet set = (Gridded1DSet)((Field)data).getDomainSet();
                this.value[0][0] = this.d[0];
                int[] indices = set.valueToIndex(this.value);
                int thisIndex = indices[0];
                if (thisIndex < 0) {
                    this.lastIndex = -1;
                    return;
                }
                if (this.lastIndex < 0) {
                    this.addPoint(xx);
                } else {
                    this.lastX[3] = xx[0];
                    this.lastX[4] = xx[1];
                    this.lastX[5] = xx[2];
                    this.addPoint(this.lastX);
                }
                this.lastX[0] = xx[0];
                this.lastX[1] = xx[1];
                this.lastX[2] = xx[2];
                MathType range = ((FunctionType)this.type).getRange();
                int n = range instanceof RealType ? 1 : ((RealTupleType)range).getDimension();
                double[] thisD = new double[n];
                boolean[] directComponent = new boolean[n];
                int j2 = 0;
                while (j2 < n) {
                    thisD[j2] = Double.NaN;
                    directComponent[j2] = false;
                    ++j2;
                }
                int i = 0;
                while (i < 3) {
                    j = this.getAxisToComponent(i);
                    if (j >= 0) {
                        this.f[0] = x[i];
                        this.d = this.getDirectMap(i).inverseScaleValues(this.f);
                        rtype = (RealType)this.getDirectMap(i).getScalar();
                        r = new Real(rtype, (double)this.d[0]);
                        overrideUnit = this.getDirectMap(i).getOverrideUnit();
                        rtunit = rtype.getDefaultUnit();
                        if (!(overrideUnit == null || overrideUnit.equals(rtunit) || Unit.canConvert(rtunit, CommonUnit.secondsSinceTheEpoch) && !rtunit.getAbsoluteUnit().equals(rtunit))) {
                            double dval = overrideUnit.toThis(this.d[0], rtunit);
                            r = new Real(rtype, dval, overrideUnit);
                        }
                        valueString = r.toValueString();
                        vect.addElement(rtype.getName() + " = " + valueString);
                        thisD[j] = this.d[0];
                        directComponent[j] = true;
                    }
                    ++i;
                }
                this.getDisplayRenderer().setCursorStringVector(vect);
                if (this.lastIndex < 0) {
                    this.lastIndex = thisIndex;
                    this.lastD = new double[n];
                    j = 0;
                    while (j < n) {
                        this.lastD[j] = thisD[j];
                        ++j;
                    }
                }
                Real[] reals = new Real[n];
                int m = Math.abs(this.lastIndex - thisIndex) + 1;
                indices = new int[m];
                int index = thisIndex;
                int inc = this.lastIndex >= thisIndex ? 1 : -1;
                int i2 = 0;
                while (i2 < m) {
                    indices[i2] = index;
                    index += inc;
                    ++i2;
                }
                float[][] values = set.indexToValue(indices);
                double coefDiv = values[0][m - 1] - values[0][0];
                int i3 = 0;
                while (i3 < m) {
                    index = indices[i3];
                    double coef = i3 == 0 || coefDiv == 0.0 ? 0.0 : (double)(values[0][i3] - values[0][0]) / coefDiv;
                    Data tuple = ((Field)data).getSample(index);
                    if (tuple instanceof Real) {
                        if (directComponent[0]) {
                            rtype = (RealType)tuple.getType();
                            tuple = new Real(rtype, thisD[0] + coef * (this.lastD[0] - thisD[0]), rtype.getDefaultUnit(), null);
                        }
                    } else {
                        int j3 = 0;
                        while (j3 < n) {
                            Real c = (Real)((RealTuple)tuple).getComponent(j3);
                            if (directComponent[j3]) {
                                rtype = (RealType)c.getType();
                                reals[j3] = new Real(rtype, thisD[j3] + coef * (this.lastD[j3] - thisD[j3]), rtype.getDefaultUnit(), null);
                            } else {
                                reals[j3] = c;
                            }
                            ++j3;
                        }
                        tuple = new RealTuple(reals);
                    }
                    ((Field)data).setSample(index, tuple);
                    ++i3;
                }
                if (this.ref instanceof RemoteDataReference && !(data instanceof RemoteData)) {
                    this.ref.setData(data);
                    this.link.clearData();
                }
                this.lastIndex = thisIndex;
                int j4 = 0;
                while (j4 < n) {
                    this.lastD[j4] = thisD[j4];
                    ++j4;
                }
            }
        }
        catch (VisADException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
    }

    public void addPoint(float[] x) throws VisADException {
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.isDirectManipulation = false;
    }

    public void setIsDirectManipulation(boolean b) {
        this.isDirectManipulation = b;
    }

    public boolean getIsDirectManipulation() {
        return this.isDirectManipulation;
    }

    public void setPickCrawlToCursor(boolean b) {
        this.pickCrawlToCursor = b;
    }

    public boolean getPickCrawlToCursor() {
        return this.pickCrawlToCursor;
    }

    public float findRayManifoldIntersection(boolean first, double[] origin, double[] direction, DisplayTupleType tuple, int otherindex, float othervalue) throws VisADException {
        this.ray_pos = Float.NaN;
        if (otherindex < 0) {
            return this.ray_pos;
        }
        CoordinateSystem tuplecs = null;
        if (tuple != null) {
            tuplecs = tuple.getCoordinateSystem();
        }
        if (tuple == null || tuplecs == null) {
            this.ray_pos = (float)(((double)othervalue - origin[otherindex]) / direction[otherindex]);
        } else {
            double adjust = Double.NaN;
            if (Display.DisplaySpatialSphericalTuple.equals(tuple) && otherindex == 1) {
                adjust = 360.0;
            }
            if (first) {
                this.ray_pos = Float.NaN;
                float[][] guesses = new float[3][401];
                int i = 0;
                while (i < 401) {
                    float rp = (float)(i - 200) * 0.1f;
                    guesses[0][i] = (float)(origin[0] + (double)rp * direction[0]);
                    guesses[1][i] = (float)(origin[1] + (double)rp * direction[1]);
                    guesses[2][i] = (float)(origin[2] + (double)rp * direction[2]);
                    if (adjust == adjust) {
                        guesses[otherindex][i] = (float)(((double)othervalue + 0.5 * adjust + (double)guesses[otherindex][i]) % adjust - ((double)othervalue + 0.5 * adjust));
                    }
                    ++i;
                }
                guesses = tuplecs.fromReference(guesses);
                double distance = Double.MAX_VALUE;
                float lastg = 0.0f;
                int i2 = 0;
                while (i2 < 401) {
                    float g = othervalue - guesses[otherindex][i2];
                    if (i2 > 0 && (g < 0.0f && lastg >= 0.0f || g >= 0.0f && lastg < 0.0f)) {
                        float r = (float)i2 - Math.abs(g) / (Math.abs(lastg) + Math.abs(g));
                        this.ray_pos = (r - 200.0f) * 0.1f;
                        break;
                    }
                    lastg = g;
                    double d = Math.abs(othervalue - guesses[otherindex][i2]);
                    if (d < distance) {
                        distance = d;
                        this.ray_pos = (float)(i2 - 200) * 0.1f;
                    }
                    ++i2;
                }
            }
            if (this.ray_pos == this.ray_pos) {
                double error_limit = 0.001f;
                double r = this.ray_pos;
                double error = 1.0;
                double[][] guesses = new double[3][3];
                int itry = 0;
                while (itry < 10 && r == r) {
                    double g;
                    double rp = r + (double)0.001f;
                    double rm = r - (double)0.001f;
                    guesses[0][0] = origin[0] + rp * direction[0];
                    guesses[1][0] = origin[1] + rp * direction[1];
                    guesses[2][0] = origin[2] + rp * direction[2];
                    guesses[0][1] = origin[0] + r * direction[0];
                    guesses[1][1] = origin[1] + r * direction[1];
                    guesses[2][1] = origin[2] + r * direction[2];
                    guesses[0][2] = origin[0] + rm * direction[0];
                    guesses[1][2] = origin[1] + rm * direction[1];
                    guesses[2][2] = origin[2] + rm * direction[2];
                    guesses = tuplecs.fromReference(guesses);
                    if (adjust == adjust) {
                        guesses[otherindex][0] = ((double)othervalue + 0.5 * adjust + guesses[otherindex][0]) % adjust - ((double)othervalue + 0.5 * adjust);
                        guesses[otherindex][1] = ((double)othervalue + 0.5 * adjust + guesses[otherindex][1]) % adjust - ((double)othervalue + 0.5 * adjust);
                        guesses[otherindex][2] = ((double)othervalue + 0.5 * adjust + guesses[otherindex][2]) % adjust - ((double)othervalue + 0.5 * adjust);
                    }
                    if ((error = Math.abs(g = (double)othervalue - guesses[otherindex][1])) <= (double)0.001f) break;
                    double gp = (double)othervalue - guesses[otherindex][0];
                    double gm = (double)othervalue - guesses[otherindex][2];
                    double dg = (gp - gm) / (double)0.002f;
                    r -= g / dg;
                    ++itry;
                }
                this.ray_pos = error < error_limit ? (float)r : Float.NaN;
            }
        }
        return this.ray_pos;
    }

    public void removeLink(DataDisplayLink link) {
        int newLen = this.Links.length - 1;
        if (newLen < 0) {
            return;
        }
        DataDisplayLink[] newLinks = new DataDisplayLink[newLen];
        int n = 0;
        int i = 0;
        while (i <= newLen) {
            if (this.Links[i] != link) {
                if (n == newLen) {
                    return;
                }
                newLinks[n++] = this.Links[i];
            }
            ++i;
        }
        if (n < newLen) {
            DataDisplayLink[] newest = new DataDisplayLink[n];
            System.arraycopy(newLinks, 0, newest, 0, n);
            newLinks = newest;
        }
        this.Links = newLinks;
    }

    public abstract Object clone() throws CloneNotSupportedException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

