/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Vector;
import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public class CartesianProductCoordinateSystem
extends CoordinateSystem {
    private CoordinateSystem[] csArray;

    public CartesianProductCoordinateSystem(CoordinateSystem a, CoordinateSystem b) throws VisADException {
        this(new CoordinateSystem[]{a, b});
    }

    public CartesianProductCoordinateSystem(CoordinateSystem[] csArray) throws VisADException {
        super(CartesianProductCoordinateSystem.getProductReference(csArray), CartesianProductCoordinateSystem.getProductUnits(csArray));
        this.csArray = csArray;
    }

    public CoordinateSystem[] getCoordinateSystems() {
        return this.csArray;
    }

    public CoordinateSystem getCoordinateSystem(int index) {
        return this.csArray[index];
    }

    static RealTupleType getProductReference(CoordinateSystem[] csArray) throws VisADException {
        if (csArray == null) {
            throw new VisADException("CoordinateSystem array can't be null");
        }
        if (csArray.length < 2) {
            throw new VisADException("CoordinateSystem array must have more than one element");
        }
        Vector<RealType> typeVector = new Vector<RealType>();
        int i = 0;
        while (i < csArray.length) {
            CoordinateSystem cs = csArray[i];
            if (cs == null) {
                throw new VisADException("CoordinateSystem array can't have null members " + i);
            }
            RealType[] reals = cs.getReference().getRealComponents();
            int j = 0;
            while (j < reals.length) {
                typeVector.add(reals[j]);
                ++j;
            }
            ++i;
        }
        return new RealTupleType(typeVector.toArray(new RealType[typeVector.size()]));
    }

    static Unit[] getProductUnits(CoordinateSystem[] csArray) throws VisADException {
        if (csArray == null) {
            throw new VisADException("CoordinateSystem array can't be null");
        }
        if (csArray.length < 2) {
            throw new VisADException("CoordinateSystem array must have more than one element");
        }
        Vector<Unit> unitVector = new Vector<Unit>();
        int i = 0;
        while (i < csArray.length) {
            Unit[] units = csArray[i].getCoordinateSystemUnits();
            int j = 0;
            while (j < units.length) {
                unitVector.add(units[j]);
                ++j;
            }
            ++i;
        }
        return unitVector.toArray(new Unit[unitVector.size()]);
    }

    public double[][] toReference(double[][] input) throws VisADException {
        if (input.length != this.getDimension() || input == null) {
            throw new VisADException("input has wrong dimension");
        }
        int numElements = input[0].length;
        double[][] output = new double[this.getDimension()][numElements];
        int pointer = 0;
        int i = 0;
        while (i < this.csArray.length) {
            int dimension = this.csArray[i].getDimension();
            double[][] temp = new double[dimension][numElements];
            int j = 0;
            while (j < dimension) {
                temp[j] = (double[])input[pointer + j].clone();
                ++j;
            }
            temp = this.csArray[i].toReference(temp);
            int j2 = 0;
            while (j2 < dimension) {
                output[pointer + j2] = temp[j2];
                ++j2;
            }
            pointer += dimension;
            ++i;
        }
        return output;
    }

    public double[][] fromReference(double[][] refTuple) throws VisADException {
        if (refTuple.length != this.getDimension() || refTuple == null) {
            throw new VisADException("refTuple has wrong dimension");
        }
        int numElements = refTuple[0].length;
        double[][] output = new double[this.getDimension()][numElements];
        int pointer = 0;
        int i = 0;
        while (i < this.csArray.length) {
            int dimension = this.csArray[i].getDimension();
            double[][] temp = new double[dimension][numElements];
            int j = 0;
            while (j < dimension) {
                temp[j] = (double[])refTuple[pointer + j].clone();
                ++j;
            }
            temp = this.csArray[i].fromReference(temp);
            int j2 = 0;
            while (j2 < dimension) {
                output[pointer + j2] = temp[j2];
                ++j2;
            }
            pointer += dimension;
            ++i;
        }
        return output;
    }

    public float[][] toReference(float[][] input) throws VisADException {
        if (input.length != this.getDimension() || input == null) {
            throw new VisADException("input has wrong dimension");
        }
        int numElements = input[0].length;
        float[][] output = new float[this.getDimension()][numElements];
        int pointer = 0;
        int i = 0;
        while (i < this.csArray.length) {
            int dimension = this.csArray[i].getDimension();
            float[][] temp = new float[dimension][numElements];
            int j = 0;
            while (j < dimension) {
                temp[j] = (float[])input[pointer + j].clone();
                ++j;
            }
            temp = this.csArray[i].toReference(temp);
            int j2 = 0;
            while (j2 < dimension) {
                output[pointer + j2] = (float[])temp[j2].clone();
                ++j2;
            }
            pointer += dimension;
            ++i;
        }
        return output;
    }

    public float[][] fromReference(float[][] refTuple) throws VisADException {
        if (refTuple.length != this.getDimension() || refTuple == null) {
            throw new VisADException("refTuple has wrong dimension");
        }
        int numElements = refTuple[0].length;
        float[][] output = new float[this.getDimension()][numElements];
        int pointer = 0;
        int i = 0;
        while (i < this.csArray.length) {
            int dimension = this.csArray[i].getDimension();
            float[][] temp = new float[dimension][numElements];
            int j = 0;
            while (j < dimension) {
                temp[j] = (float[])refTuple[pointer + j].clone();
                ++j;
            }
            temp = this.csArray[i].fromReference(temp);
            int j2 = 0;
            while (j2 < dimension) {
                output[pointer + j2] = temp[j2];
                ++j2;
            }
            pointer += dimension;
            ++i;
        }
        return output;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof CartesianProductCoordinateSystem) {
            int n = this.csArray.length;
            CoordinateSystem[] ocsa = ((CartesianProductCoordinateSystem)o).csArray;
            if (n != ocsa.length) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!this.csArray[i].equals(ocsa[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

