/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class CMYCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{null, null, null};

    public CMYCoordinateSystem(RealTupleType reference) throws VisADException {
        super(reference, coordinate_system_units);
    }

    CMYCoordinateSystem(RealTupleType reference, boolean b) {
        super(reference, coordinate_system_units, b);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        int i = 0;
        while (i < len) {
            value[0][i] = 1.0 - tuples[0][i];
            value[1][i] = 1.0 - tuples[1][i];
            value[2][i] = 1.0 - tuples[2][i];
            ++i;
        }
        return value;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        int i = 0;
        while (i < len) {
            value[0][i] = 1.0 - tuples[0][i];
            value[1][i] = 1.0 - tuples[1][i];
            value[2][i] = 1.0 - tuples[2][i];
            ++i;
        }
        return value;
    }

    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        int i = 0;
        while (i < len) {
            value[0][i] = 1.0f - tuples[0][i];
            value[1][i] = 1.0f - tuples[1][i];
            value[2][i] = 1.0f - tuples[2][i];
            ++i;
        }
        return value;
    }

    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        int i = 0;
        while (i < len) {
            value[0][i] = 1.0f - tuples[0][i];
            value[1][i] = 1.0f - tuples[1][i];
            value[2][i] = 1.0f - tuples[2][i];
            ++i;
        }
        return value;
    }

    public boolean equals(Object cs) {
        return cs instanceof CMYCoordinateSystem;
    }
}

