/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import visad.SI;
import visad.VisADException;

public final class BaseQuantity
implements Serializable {
    private static final Map nameDB = new TreeMap();
    private static final Map aliasDB = new TreeMap();
    private static final AbstractList indexDB = new Vector(8);
    private final String name;
    private final int index;

    private BaseQuantity(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static synchronized BaseQuantity add(String name) throws VisADException {
        String key = BaseQuantity.key(name);
        if (nameDB.containsKey(key)) {
            throw new VisADException("Attempt to redefine existing base quantity \"" + name + "\"");
        }
        BaseQuantity q = new BaseQuantity(name, indexDB.size());
        nameDB.put(key, q);
        indexDB.add(q);
        return q;
    }

    public static synchronized BaseQuantity add(String name, String alias) throws VisADException {
        return BaseQuantity.add(name, new String[]{alias});
    }

    public static synchronized BaseQuantity add(String name, String[] aliases) throws VisADException {
        int i = 0;
        while (i < aliases.length) {
            if (aliasDB.containsKey(BaseQuantity.key(aliases[i]))) {
                throw new VisADException("Attempt to redefine existing base quantity alias \"" + aliases[i] + "\"");
            }
            ++i;
        }
        BaseQuantity q = BaseQuantity.add(name);
        int i2 = 0;
        while (i2 < aliases.length) {
            aliasDB.put(BaseQuantity.key(aliases[i2]), q);
            ++i2;
        }
        return q;
    }

    private static String key(String name) {
        return name.toLowerCase();
    }

    public static synchronized int size() {
        return indexDB.size();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public static synchronized BaseQuantity getByName(String name) {
        return (BaseQuantity)nameDB.get(BaseQuantity.key(name));
    }

    public static synchronized BaseQuantity getByAlias(String name) {
        return (BaseQuantity)aliasDB.get(BaseQuantity.key(name));
    }

    public static synchronized BaseQuantity get(String name) {
        BaseQuantity q = BaseQuantity.getByName(name);
        return q != null ? q : BaseQuantity.getByAlias(name);
    }

    public static BaseQuantity get(int i) {
        return (BaseQuantity)indexDB.get(i);
    }

    static {
        try {
            BaseQuantity.add("electric current", new String[]{SI.ampere.quantityName(), "current"});
            BaseQuantity.add("luminous intensity", SI.candela.quantityName());
            BaseQuantity.add("thermodynamic temperature", new String[]{SI.kelvin.quantityName(), "temperature"});
            BaseQuantity.add("mass", SI.kilogram.quantityName());
            BaseQuantity.add("length", SI.meter.quantityName());
            BaseQuantity.add("time", SI.second.quantityName());
            BaseQuantity.add("amount of substance", SI.mole.quantityName());
            BaseQuantity.add("plane angle", new String[]{SI.radian.quantityName(), "angle"});
            BaseQuantity.add("solid angle", SI.steradian.quantityName());
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }
}

