/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.lang.reflect.Array;
import ucar.netcdf.AttrVal;
import ucar.netcdf.Named;
import ucar.netcdf.NumericAttrVal;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.StringAttrVal;

public class Attribute
implements Named,
Serializable,
Cloneable {
    private final String name;
    private final AttrVal value;

    public Attribute(String name, Number value) {
        Class componentType = Attribute.primitiveClass(value);
        if (!ProtoVariable.checkComponentType(componentType)) {
            throw new IllegalArgumentException("Invalid Type: " + componentType);
        }
        this.name = name;
        this.value = new NumericAttrVal(value, componentType);
    }

    public Attribute(String name, double value) {
        this.name = name;
        double[] darray = new double[]{value};
        this.value = new NumericAttrVal(darray);
    }

    public Attribute(String name, String theValue) {
        this.name = name;
        this.value = new StringAttrVal(theValue);
    }

    public Attribute(String name, Object theValue) {
        Class<?> aClass = theValue.getClass();
        if (!aClass.isArray()) {
            throw new IllegalArgumentException("Not an Array");
        }
        Class<?> componentType = aClass.getComponentType();
        if (!ProtoVariable.checkComponentType(componentType)) {
            throw new IllegalArgumentException("Invalid Type: " + componentType);
        }
        this.name = name;
        this.value = componentType == Character.TYPE ? new StringAttrVal((char[])theValue) : new NumericAttrVal(Attribute.arrayClone(theValue));
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode();
    }

    public boolean equals(Object oo) {
        Attribute aa;
        if (this == oo) {
            return true;
        }
        if (oo instanceof Attribute && this.name.equals((aa = (Attribute)oo).getName())) {
            return this.value.equals(aa.value);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toCdl(buf);
        return buf.toString();
    }

    public final String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value.getValue();
    }

    public String getStringValue() {
        return (String)this.value.getValue();
    }

    public Object get(int index) {
        return this.value.get(index);
    }

    public Number getNumericValue(int index) {
        return this.value.getNumericValue(index);
    }

    public Number getNumericValue() {
        return this.value.getNumericValue();
    }

    public boolean isString() {
        return this.value instanceof StringAttrVal;
    }

    public Class getComponentType() {
        return this.value.getComponentType();
    }

    public int getLength() {
        return this.value.getLength();
    }

    public void toCdl(StringBuffer buf) {
        buf.append(":");
        buf.append(this.getName());
        buf.append(" = ");
        this.value.toCdl(buf);
        buf.append(" ;");
    }

    static Object arrayClone(Object src) {
        int length = Array.getLength(src);
        Object aa = Array.newInstance(src.getClass().getComponentType(), length);
        System.arraycopy(src, 0, aa, 0, length);
        return aa;
    }

    static Class primitiveClass(Number nn) {
        try {
            return (Class)nn.getClass().getDeclaredField("TYPE").get(nn);
        }
        catch (NoSuchFieldException ee) {
            throw new Error();
        }
        catch (IllegalAccessException ee) {
            throw new Error();
        }
    }
}

