/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

public class IndexIterator {
    protected final int[] counter;
    protected final int[] limits;
    protected int ncycles;

    public static boolean isZero(int[] iv) {
        int ii = 0;
        while (ii < iv.length) {
            if (iv[ii] != 0) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public static boolean equals(int[] lhs, int[] rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        int ii = 0;
        while (ii < lhs.length) {
            if (lhs[ii] != rhs[ii]) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public IndexIterator(int[] theLimits) {
        this.counter = new int[theLimits.length];
        this.limits = theLimits;
        this.ncycles = 0;
    }

    public IndexIterator(int[] initCounter, int[] theLimits) {
        this.counter = initCounter == null ? new int[theLimits.length] : (int[])initCounter.clone();
        this.limits = theLimits;
        this.ncycles = 0;
    }

    public boolean notDone() {
        return this.ncycles <= 0;
    }

    public int[] value() {
        return this.counter;
    }

    /*
     * Unable to fully structure code
     */
    public void incr() {
        digit = this.counter.length - 1;
        if (digit >= 0) ** GOTO lbl13
        ++this.ncycles;
        return;
lbl-1000:
        // 1 sources

        {
            v0 = digit;
            this.counter[v0] = this.counter[v0] + 1;
            if (this.counter[digit] < this.limits[digit]) break;
            this.counter[digit] = 0;
            if (digit == 0) {
                ++this.ncycles;
                break;
            }
            --digit;
lbl13:
            // 2 sources

            ** while (digit >= 0)
        }
lbl14:
        // 3 sources

    }

    public void advance(int nsteps) {
        while (nsteps-- > 0) {
            this.incr();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int last = this.counter.length - 1;
        int ii = 0;
        while (ii <= last) {
            buf.append(this.counter[ii]);
            if (ii == last) break;
            buf.append(" ");
            ++ii;
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        int[] edges = new int[args.length];
        int ii = 0;
        while (ii < args.length) {
            Integer av = new Integer(args[ii]);
            edges[ii] = av;
            ++ii;
        }
        System.out.println(edges);
        IndexIterator odo = new IndexIterator(edges);
        ii = 0;
        while (odo.notDone()) {
            System.out.println(odo);
            odo.incr();
            ++ii;
        }
        System.out.print("\t");
        System.out.println(ii);
    }
}

