/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.test;

import java.io.FileOutputStream;
import java.util.Date;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.BinaryTableHeaderParser;
import nom.tam.fits.Column;
import nom.tam.fits.Fits;
import nom.tam.fits.HDU;
import nom.tam.fits.Header;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public class FitsTester {
    public static void main(String[] args) {
        FitsTester.testSimpleWrite();
        FitsTester.testSimpleRead();
        FitsTester.testNetRead();
        FitsTester.testSkipAndRead();
        FitsTester.testReadByRow();
        FitsTester.testWriteByRow();
        FitsTester.testBuildByColumn();
        FitsTester.testVarCols();
        FitsTester.testRandomGroups();
    }

    static void testRandomGroups() {
        FitsTester.start("Write and read a random groups data set");
        try {
            short[] pararr = new short[5];
            short[][] dataArr = new short[50][50];
            Object[][] test = new Object[10][2];
            test[0][0] = pararr;
            test[0][1] = dataArr;
            RandomGroupsHDU hdu = new RandomGroupsHDU(test);
            BufferedDataOutputStream os = new BufferedDataOutputStream(new FileOutputStream("test6.fits"));
            int padding = hdu.getData().getPadding();
            hdu.getHeader().write(os);
            int i = 0;
            while (i < 10) {
                pararr[2] = (short)i;
                pararr[3] = (short)(i * i);
                dataArr[i][i] = (short)(i * i * i);
                os.writePrimitiveArray(pararr);
                os.writePrimitiveArray(dataArr);
                ++i;
            }
            byte[] pad = new byte[padding];
            os.write(pad);
            os.flush();
            os.close();
            os = null;
        }
        catch (Exception e) {
            System.out.println("Error writing random groups data");
            e.printStackTrace(System.out);
            return;
        }
        try {
            Fits rg = new Fits("Test6.fits");
            BasicHDU[] HDUs = rg.read();
            HDUs[0].info();
            Object[][] data = (Object[][])HDUs[0].getData().getData();
            int i = 0;
            while (i < 10) {
                short[] par = (short[])data[i][0];
                System.out.println("    Group:" + (i + 1) + " params2,3= " + par[2] + " " + par[3]);
                short[][] arr = (short[][])data[i][1];
                System.out.println("           Data[i][i] = " + arr[i][i]);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error reading random groups data");
            e.printStackTrace(System.out);
        }
        FitsTester.end("Test Random Groups");
    }

    static void testVarCols() {
        int j;
        int i;
        BinaryTableHDU table;
        BasicHDU[] myHDUs;
        Fits myFits;
        FitsTester.start("Build and read variable length columns");
        try {
            myFits = new Fits();
            myFits.addHDU(new PrimaryHDU());
            myFits.addHDU(HDU.create(FitsTester.genTable()));
            myHDUs = myFits.read();
            table = (BinaryTableHDU)myHDUs[1];
            int[][] varData = new int[8][];
            i = 0;
            while (i < 8) {
                varData[i] = new int[i + 1];
                j = 0;
                while (j <= i) {
                    varData[i][j] = 2 * j;
                    ++j;
                }
                ++i;
            }
            System.out.println("    Written to FITS:");
            int i2 = 0;
            while (i2 < varData.length) {
                System.out.print("       " + i2 + ":");
                int j2 = 0;
                while (j2 < varData[i2].length) {
                    System.out.print(" " + j2 + ":" + varData[i2][j2]);
                    ++j2;
                }
                System.out.println("");
                ++i2;
            }
            Column newCol = table.makeVarColumn((Object[])varData, "J");
            newCol.addKey(Header.formatFields("TTYPE", "'TestVar '", "Name of variable column"));
            table.addColumn(newCol);
            BufferedDataOutputStream obs = new BufferedDataOutputStream(new FileOutputStream("test5.fits"));
            myFits.write(obs);
            obs.flush();
            obs.close();
        }
        catch (Exception e) {
            System.out.println("Exception writing test5.fits:" + e);
            e.printStackTrace(System.out);
        }
        try {
            myFits = new Fits("test5.fits");
            myHDUs = myFits.read();
            if (myHDUs == null) {
                System.out.println("Error: test5.fits doesn't seem to have any HDUs!");
                return;
            }
            table = (BinaryTableHDU)myHDUs[1];
            table.info();
            int[][] varcol = (int[][])table.getVarData("TestVar");
            if (varcol == null) {
                System.out.println("Error: test5.fits TestVar data not found");
                return;
            }
            System.out.println("    Read from FITS:");
            i = 0;
            while (i < varcol.length) {
                System.out.print("       " + i + ":");
                j = 0;
                while (j < varcol[i].length) {
                    System.out.print(" " + j + ":" + varcol[i][j]);
                    ++j;
                }
                System.out.println("");
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception reading test5.fits: " + e);
            e.printStackTrace(System.out);
        }
        FitsTester.end("Test Var columns");
    }

    static void testBuildByColumn() {
        FitsTester.start("Build by Column");
        try {
            Fits myFits = new Fits();
            myFits.addHDU(new PrimaryHDU());
            BinaryTableHDU myHDU = new BinaryTableHDU();
            int[][][] column = new int[8][][];
            int i = 0;
            while (i < 8) {
                column[i] = new int[4][3];
                column[i][0][0] = i;
                ++i;
            }
            myHDU.addColumn((Object[])column);
            float[][] column2 = new float[8][10];
            int i2 = 0;
            while (i2 < 8) {
                column2[i2][0] = 100 * i2;
                ++i2;
            }
            myHDU.addColumn((Object[])column2);
            double[][] column3 = new double[8][4];
            myHDU.addColumn((Object[])column3);
            myFits.addHDU(myHDU);
            BufferedDataOutputStream obs = new BufferedDataOutputStream(new FileOutputStream("test4.fits"));
            myFits.write(obs);
            obs.flush();
            obs.close();
            obs = null;
            myFits = new Fits("test4.fits");
            BasicHDU[] myHDUs = myFits.read();
            if (myHDUs == null) {
                System.out.println("Error: test4.fits doesn't seem to have any HDUs!");
                return;
            }
            int i3 = 0;
            while (i3 < myHDUs.length) {
                myHDUs[i3].info();
                ++i3;
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception writing/reading test4.fits: " + e);
            e.printStackTrace(System.out);
        }
        FitsTester.end("Build by column: ");
    }

    static void testWriteByRow() {
        FitsTester.start("Write data row by row");
        Object[] aRow = new Object[]{new int[30], new float[10][10], new double[2][3][4]};
        String[] names = new String[]{"RandomName1", "RandomName2", "RandomName3"};
        int nrows = 20;
        try {
            Object[][] testTable = new Object[][]{aRow};
            BinaryTableHDU dummy = new BinaryTableHDU(testTable);
            Header myHeader = dummy.getHeader();
            myHeader.addIntValue("NAXIS2", nrows, "Number of rows");
            int i = 0;
            while (i < 3) {
                myHeader.findKey("TFORM" + (i + 1));
                myHeader.addStringValue("TTYPE" + (i + 1), names[i], "");
                ++i;
            }
            BufferedDataOutputStream obs = new BufferedDataOutputStream(new FileOutputStream("test2.fits"));
            PrimaryHDU rg = new PrimaryHDU();
            rg.write(obs);
            myHeader.write(obs);
            int i2 = 0;
            while (i2 < nrows) {
                ((int[])aRow[0])[0] = i2++;
                obs.writePrimitiveArray(aRow);
            }
            int paddingSize = myHeader.paddedDataSize() - myHeader.trueDataSize();
            byte[] pad = new byte[paddingSize];
            obs.write(pad);
            obs.flush();
            obs.close();
        }
        catch (Exception e) {
            System.out.println("Caught exception writing test2.fits: " + e);
            return;
        }
        try {
            Fits myFits = new Fits("test2.fits");
            BasicHDU[] myHDUs = myFits.read();
            if (myHDUs == null) {
                System.out.println("Error: test2.fits doesn't seem to have any HDUs!");
                return;
            }
            int i = 0;
            while (i < myHDUs.length) {
                myHDUs[i].info();
                ++i;
            }
            BinaryTable data = (BinaryTable)myHDUs[1].getData();
            int i3 = 0;
            while (i3 < data.getNrow()) {
                int[] col0 = (int[])data.getElement(i3, 0);
                System.out.println("    Row marker is:" + col0[0]);
                ++i3;
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception reading test2.fits:" + e);
            e.printStackTrace(System.out);
        }
        FitsTester.end("Writing data row by row");
    }

    static void testReadByRow() {
        FitsTester.start("Read row by row");
        try {
            Fits myFits = new Fits("test1.fits");
            myFits.skipHDU(2);
            BufferedDataInputStream ibs = myFits.getStream();
            Header myHeader = Header.readHeader(ibs);
            if (myHeader == null) {
                System.out.println("Third HDU from test1.fits is null!");
                return;
            }
            Object[] aRow = new BinaryTableHeaderParser(myHeader).getModelRow();
            int nrows = myHeader.getIntValue("NAXIS2");
            byte[] col1 = (byte[])aRow[0];
            int i = 0;
            while (i < nrows) {
                ibs.readPrimitiveArray(aRow);
                System.out.println("    Reading row:" + (i + 1) + " with marker:" + col1[0]);
                ++i;
            }
            ibs.skipBytes(myHeader.paddedDataSize() - myHeader.trueDataSize());
        }
        catch (Exception e) {
            System.out.println("Caught exception reading by rows:" + e);
            e.printStackTrace(System.out);
        }
        FitsTester.end("Reading row by row");
    }

    static void testSkipAndRead() {
        FitsTester.start("Skip to third extension");
        try {
            Fits myFits = new Fits("test1.fits");
            myFits.skipHDU(2);
            BasicHDU[] myHDUs = myFits.read();
            if (myHDUs == null) {
                System.out.println("Error: test1.fits third extension doesn't exist!");
                return;
            }
            int i = 0;
            while (i < myHDUs.length) {
                myHDUs[i].info();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception in skip and read:" + e);
        }
        FitsTester.end("Skip to third extension");
    }

    static void testSimpleWrite() {
        FitsTester.start("Write a FITS file");
        try {
            Fits myFits = new Fits();
            int[] dims1 = new int[]{20, 20, 20};
            myFits.addHDU(HDU.create(ArrayFuncs.generateArray(Float.TYPE, dims1)));
            int[] dims2 = new int[]{2, 2, 2, 8, 16};
            myFits.addHDU(HDU.create(ArrayFuncs.generateArray(Integer.TYPE, dims2)));
            myFits.addHDU(HDU.create(FitsTester.genTable()));
            FileOutputStream fo = new FileOutputStream("test1.fits");
            BufferedDataOutputStream o = new BufferedDataOutputStream(fo);
            myFits.write(o);
        }
        catch (Exception e) {
            System.err.println("Exception thrown:" + e);
            e.printStackTrace(System.out);
            return;
        }
        FitsTester.end("Write a FITS file");
    }

    static void testSimpleRead() {
        BasicHDU[] myHDUs;
        FitsTester.start("Read a FITS file");
        try {
            Fits myFits = new Fits("test1.fits");
            myHDUs = myFits.read();
        }
        catch (Exception e) {
            System.out.println("Caught an exception reading test1.fits:" + e);
            e.printStackTrace(System.out);
            return;
        }
        if (myHDUs == null) {
            System.out.println("Error: test1.fits doesn't seem to have any HDUs!");
            return;
        }
        int i = 0;
        while (i < myHDUs.length) {
            try {
                if (myHDUs[i] == null) {
                    System.out.println("test1.fits HDU#" + i + " is null");
                } else {
                    myHDUs[i].info();
                }
            }
            catch (Exception e) {
                System.out.println("Caught an exception examining test1.fits HDU#" + i + ":" + e);
                e.printStackTrace(System.out);
            }
            ++i;
        }
        FitsTester.end("Read a FITS file");
    }

    static void testNetRead() {
        BasicHDU[] myHDUs;
        FitsTester.start("Read compressed FITS file over the network");
        String testURL = "http://legacy.gsfc.nasa.gov/FTP/compton/data/egret/phase01/pnt_0010/counts_vp0010_g001.fits.gz";
        try {
            Fits myFits = new Fits(testURL);
            myHDUs = myFits.read();
        }
        catch (Exception e) {
            System.out.println("Caught an exception reading over the net:" + e);
            e.printStackTrace(System.out);
            return;
        }
        if (myHDUs == null) {
            System.out.println("Error: net file doesn't seem to have any HDUs!");
            return;
        }
        int i = 0;
        while (i < myHDUs.length) {
            try {
                myHDUs[i].info();
            }
            catch (Exception e) {
                System.out.println("Caught an exception examining net HDU#" + i + ":" + e);
                e.printStackTrace(System.out);
                return;
            }
            ++i;
        }
        FitsTester.end("Read over net");
    }

    static Object[][] genTable() {
        Object[] row1 = new Object[6];
        int[] dims0 = new int[]{10};
        row1[0] = ArrayFuncs.generateArray(Byte.TYPE, dims0);
        int[] dims1 = new int[]{5, 5};
        row1[1] = ArrayFuncs.generateArray(Short.TYPE, dims1);
        int[] dims2 = new int[]{5, 2};
        row1[2] = ArrayFuncs.generateArray(Integer.TYPE, dims2);
        int[] dims3 = new int[]{3, 3, 2};
        row1[3] = ArrayFuncs.generateArray(Integer.TYPE, dims3);
        int[] dims4 = new int[]{4, 3, 2};
        row1[4] = ArrayFuncs.generateArray(Float.TYPE, dims4);
        int[] dims5 = new int[]{6, 7};
        row1[5] = ArrayFuncs.generateArray(Double.TYPE, dims5);
        Object[][] table = new Object[8][6];
        int i = 0;
        while (i < 8) {
            table[i] = (Object[])ArrayFuncs.deepClone(row1);
            byte[] col0 = (byte[])table[i][0];
            col0[0] = (byte)i;
            ++i;
        }
        return table;
    }

    static void start(String msg) {
        System.out.println("***************************************");
        System.out.println("Start:  " + msg + " @ " + new Date());
    }

    static void end(String msg) {
        System.out.println("End:    " + msg + " @ " + new Date());
        System.out.println("");
        System.out.println("");
        System.out.println("");
    }
}

