/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.RandomGroupsData;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsHDU
extends BasicHDU {
    public RandomGroupsHDU(Header myHeader) throws FitsException {
        super(myHeader);
        this.myData = this.manufactureData();
    }

    public RandomGroupsHDU(Object[][] data) throws FitsException {
        super(new Header());
        this.myData = new RandomGroupsData(data);
        RandomGroupsHDU.pointToData(this.myHeader, data);
    }

    static void pointToData(Header h, Object[][] data) throws FitsException {
        Class dbase;
        if (data.length <= 0 || data[0].length != 2) {
            throw new FitsException("Data not conformable to Random Groups");
        }
        int gcount = data.length;
        Object paraSamp = data[0][0];
        Object dataSamp = data[0][1];
        Class pbase = ArrayFuncs.getBaseClass(paraSamp);
        if (pbase != (dbase = ArrayFuncs.getBaseClass(dataSamp))) {
            throw new FitsException("Data and parameters do not agree in type for random group");
        }
        int[] pdims = ArrayFuncs.getDimensions(paraSamp);
        int[] ddims = ArrayFuncs.getDimensions(dataSamp);
        if (pdims.length != 1) {
            throw new FitsException("Parameters are not 1 d array for random groups");
        }
        h.setSimple(true);
        if (dbase == Byte.TYPE) {
            h.setBitpix(8);
        } else if (dbase == Short.TYPE) {
            h.setBitpix(16);
        } else if (dbase == Integer.TYPE) {
            h.setBitpix(32);
        } else if (dbase == Long.TYPE) {
            h.setBitpix(64);
        } else if (dbase == Float.TYPE) {
            h.setBitpix(-32);
        } else if (dbase == Double.TYPE) {
            h.setBitpix(-64);
        } else {
            throw new FitsException("Data type:" + dbase + " not supported for random groups");
        }
        h.setNaxes(ddims.length + 1);
        h.addIntValue("NAXIS1", 0, "");
        int i = 2;
        while (i <= ddims.length + 1) {
            h.addIntValue("NAXIS" + i, ddims[i - 2], "");
            ++i;
        }
        h.addBooleanValue("GROUPS", true, "");
        h.addIntValue("GCOUNT", data.length, "");
        h.addIntValue("PCOUNT", pdims[0], "");
    }

    public static boolean isHeader(Header myHeader) {
        return myHeader.getBooleanValue("SIMPLE") & myHeader.getBooleanValue("GROUPS");
    }

    public boolean isHeader() {
        return RandomGroupsHDU.isHeader(this.myHeader);
    }

    public Data manufactureData() throws FitsException {
        if (this.myHeader != null) {
            return new RandomGroupsData(this.myHeader);
        }
        return null;
    }

    public void info() {
        System.out.println("Random Groups HDU");
        if (this.myHeader != null) {
            System.out.println("   HeaderInformation:");
            System.out.println("     Ngroups:" + this.myHeader.getIntValue("GCOUNT"));
            System.out.println("     Npar:   " + this.myHeader.getIntValue("PCOUNT"));
            System.out.println("     BITPIX: " + this.myHeader.getIntValue("BITPIX"));
            System.out.println("     NAXIS:  " + this.myHeader.getIntValue("NAXIS"));
            int i = 0;
            while (i < this.myHeader.getIntValue("NAXIS")) {
                System.out.println("      NAXIS" + (i + 1) + "= " + this.myHeader.getIntValue("NAXIS" + (i + 1)));
                ++i;
            }
        } else {
            System.out.println("    No Header Information");
        }
        Object[][] data = null;
        if (this.myData != null) {
            data = (Object[][])this.myData.getData();
        }
        if (data == null || data.length < 1 || data[0].length != 2) {
            System.out.println("    Invalid/unreadable data");
        } else {
            System.out.println("    Number of groups:" + data.length);
            System.out.println("    Parameters: " + ArrayFuncs.arrayDescription(data[0][0]));
            System.out.println("    Data:" + ArrayFuncs.arrayDescription(data[0][1]));
        }
    }
}

