/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHeaderParser;
import nom.tam.fits.Column;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayFuncs;

public class BinaryTableHDU
extends TableHDU {
    public BinaryTableHDU(Header header) throws FitsException {
        super(header);
        if (!this.isHeader()) {
            throw new BadHeaderException("Not a valid binary table header");
        }
    }

    public BinaryTableHDU(Object[][] table) throws FitsException {
        super(null);
        this.myData = table == null ? new BinaryTable() : new BinaryTable(table);
        this.myHeader = BinaryTableHeaderParser.pointToTable((BinaryTable)this.myData);
        this.setColumnStrings();
    }

    public BinaryTableHDU() throws FitsException {
        this((Object[][])null);
    }

    public static boolean isHeader(Header header) {
        String card0 = header.getCard(0);
        return card0 != null && card0.startsWith("XTENSION= 'BINTABLE'");
    }

    public boolean isHeader() {
        return BinaryTableHDU.isHeader(this.myHeader);
    }

    protected void setColumnStrings() {
        this.addColumnString("TTYPE");
        this.addColumnString("TFORM");
        this.addColumnString("TDIM");
        this.addColumnString("TSCAL");
        this.addColumnString("TZERO");
    }

    public void addColumn(Object[] data) throws FitsException {
        BinaryTable myData = (BinaryTable)this.myData;
        myData.addColumn(data);
        int ncol = myData.getNcol();
        if (ncol > 1) {
            int lastMark = -2;
            int j = 0;
            while (j < this.columnStrings.size()) {
                String key = (String)this.columnStrings.elementAt(j) + (ncol - 1);
                this.myHeader.findKey(key);
                if (this.myHeader.getMark() > lastMark) {
                    lastMark = this.myHeader.getMark();
                }
                ++j;
            }
            this.myHeader.setMark(lastMark);
        } else {
            this.myHeader.findKey("TFIELDS");
            int lastMark = this.myHeader.getMark();
            int j = 1;
            while (true) {
                String card;
                if ((card = this.myHeader.getCard(lastMark + j)) == null) {
                    System.out.println("mark to " + (lastMark + j));
                    this.myHeader.unsetMark();
                    break;
                }
                if (!card.substring(0, 8).equals("COMMENT ") && !card.substring(0, 8).equals("        ")) {
                    this.myHeader.setMark(lastMark + j);
                    break;
                }
                ++j;
            }
        }
        BinaryTableHeaderParser.addColumn(ncol - 1, data, this.myHeader);
    }

    public int findColumn(String name) {
        int i = 1;
        while (i <= this.myHeader.getIntValue("TFIELDS", 0)) {
            String tform = this.myHeader.getStringValue("TTYPE" + i);
            if (tform != null && tform.equals(name)) {
                return i - 1;
            }
            ++i;
        }
        return -1;
    }

    public Column getColumn(String name) throws FitsException {
        int col = this.findColumn(name);
        if (col < 0) {
            return null;
        }
        return this.getColumn(col);
    }

    public Column getColumn(int colNumber) throws FitsException {
        Column thisCol = new Column();
        Object[] col = ((BinaryTable)this.myData).getColumn(colNumber);
        thisCol.setData(col);
        int i = 0;
        while (i < this.columnStrings.size()) {
            String card = this.myHeader.findKey((String)this.columnStrings.elementAt(i) + colNumber);
            if (card != null) {
                thisCol.addKey(card);
            }
            ++i;
        }
        return thisCol;
    }

    public void addColumn(Column col) throws FitsException {
        BinaryTable myData = (BinaryTable)this.myData;
        this.addColumn(col.getData());
        int ncol = myData.getNcol();
        String[] keys = col.getKeys(ncol);
        this.myHeader.deleteKey("TDIMS" + ncol);
        this.myHeader.getStringValue("TFORM" + ncol);
        int i = 0;
        while (i < keys.length) {
            if (keys[i].substring(0, 5).equals("TFORM")) {
                HeaderCard card = new HeaderCard(keys[i]);
                this.myHeader.addStringValue(card.getKey(), card.getValue(), card.getComment());
            } else {
                this.myHeader.addLine(keys[i]);
            }
            ++i;
        }
    }

    public Column makeVarColumn(Object[] data) throws FitsException {
        return this.makeVarColumn(data, null, null);
    }

    public Column makeVarColumn(Object[] data, String type) throws FitsException {
        return this.makeVarColumn(data, type, null);
    }

    public Column makeVarColumn(Object[] data, String type, String[] keys) throws FitsException {
        char classChar;
        Class baseClass = ArrayFuncs.getBaseClass(data);
        if (baseClass == Byte.TYPE) {
            classChar = type != null && type.equals("S") ? (char)'S' : (type != null && type.equals("L") ? (char)'L' : 'B');
        } else if (baseClass == Integer.TYPE) {
            classChar = 'J';
        } else if (baseClass == Short.TYPE) {
            classChar = 'I';
        } else if (baseClass == Float.TYPE) {
            classChar = type != null && type.equals("C") ? (char)'C' : 'E';
        } else if (baseClass == Double.TYPE) {
            classChar = type != null && type.equals("M") ? (char)'M' : 'D';
        } else {
            throw new FitsException("Invalid Base class for variable column");
        }
        Column varColumn = ((BinaryTable)this.myData).addVarData(data);
        varColumn.addKey(Header.formatFields("TFORM", "'1P" + classChar + "     '", "VariableLength Column"));
        this.myHeader.addIntValue("PCOUNT", ((BinaryTable)this.myData).getHeapSize(), "Size of Heap Area");
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                varColumn.addKey(keys[i]);
                ++i;
            }
        }
        return varColumn;
    }

    public Object getVarData(String name) throws FitsException {
        int colNum = this.findColumn(name);
        if (colNum < 0) {
            return null;
        }
        return this.getVarData(colNum);
    }

    public Object getVarData(int col) throws FitsException {
        Class<Number> baseClass;
        char typeChar;
        String tform = this.myHeader.getStringValue("TFORM" + (col + 1));
        if (tform == null) {
            throw new FitsException("TFORM not found for column(0 indexed):" + col);
        }
        if (tform.substring(0, 2).equals("1P")) {
            typeChar = tform.charAt(2);
        } else if (tform.charAt(0) == 'P') {
            typeChar = tform.charAt(1);
        } else {
            throw new FitsException("Requested column does not seem to be variable: TFORM=" + tform);
        }
        boolean complex = false;
        switch (typeChar) {
            case 'B': 
            case 'L': 
            case 'S': {
                baseClass = Byte.TYPE;
                break;
            }
            case 'I': {
                baseClass = Short.TYPE;
                break;
            }
            case 'J': {
                baseClass = Integer.TYPE;
                break;
            }
            case 'K': {
                baseClass = Long.TYPE;
                break;
            }
            case 'E': {
                baseClass = Float.TYPE;
                break;
            }
            case 'D': {
                baseClass = Double.TYPE;
                break;
            }
            case 'C': {
                complex = true;
                baseClass = Float.TYPE;
                break;
            }
            case 'M': {
                complex = true;
                baseClass = Double.TYPE;
                break;
            }
            default: {
                throw new FitsException("Unable to understand variable column format:" + tform);
            }
        }
        return ((BinaryTable)this.myData).getVarData(col, baseClass, complex);
    }

    public Data manufactureData() throws FitsException {
        this.setColumnStrings();
        return new BinaryTable(this.myHeader);
    }

    public int getNumColumns() {
        return this.myHeader.getIntValue("TFIELDS", 0);
    }

    public int getNumRows() {
        return this.myHeader.getIntValue("NAXIS2", 0);
    }

    public String getColumnName(int index) throws FitsException {
        int flds = this.myHeader.getIntValue("TFIELDS", 0);
        if (index < 0 || index >= flds) {
            throw new FitsException("Bad column index " + index + " (only " + flds + " columns)");
        }
        return this.getTrimmedString("TTYPE" + (index + 1));
    }

    public String getColumnFITSType(int index) throws FitsException {
        int flds = this.myHeader.getIntValue("TFIELDS", 0);
        if (index < 0 || index >= flds) {
            throw new FitsException("Bad column index " + index + " (only " + flds + " columns)");
        }
        return this.getTrimmedString("TFORM" + (index + 1));
    }

    public void info() {
        BinaryTable myData = (BinaryTable)this.myData;
        System.out.println("  Binary Table");
        System.out.println("      Header Information:");
        int nhcol = this.myHeader.getIntValue("TFIELDS", -1);
        int nrow = this.myHeader.getIntValue("NAXIS2", -1);
        int rowsize = this.myHeader.getIntValue("NAXIS1", -1);
        System.out.print("          " + nhcol + " fields");
        System.out.println(", " + nrow + " rows of length " + rowsize);
        int i = 1;
        while (i <= nhcol) {
            System.out.print("           " + i + ":");
            this.checkField("TTYPE" + i);
            this.checkField("TFORM" + i);
            this.checkField("TDIM" + i);
            System.out.println(" ");
            ++i;
        }
        System.out.println("      Data Information:");
        if (myData == null || myData.getNrow() == 0 || myData.getNcol() == 0) {
            System.out.println("         No data present");
            if (myData.getHeapSize() > 0) {
                System.out.println("         Heap size is: " + myData.getHeapSize() + " bytes");
            }
        } else {
            System.out.println("         Number of rows=" + myData.getNrow());
            System.out.println("         Number of columns=" + myData.getNcol());
            if (myData.getHeapSize() > 0) {
                System.out.println("         Heap size is: " + myData.getHeapSize() + " bytes");
            }
            int[][] dimens = myData.getDimens();
            char[] types = myData.getTypes();
            int i2 = 0;
            while (i2 < myData.getNcol()) {
                System.out.print("         " + (i2 + 1) + ":" + types[i2] + " [");
                int comma = 32;
                int dim = 0;
                while (dim < dimens[i2].length) {
                    System.out.print("" + (char)comma + dimens[i2][dim]);
                    comma = 44;
                    ++dim;
                }
                System.out.println(" ]");
                ++i2;
            }
        }
    }
}

