/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.io.OpenDialog;
import ij.text.TextPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame {
    private TextPanel textPanel;

    public TextWindow(String title, String data, int width, int height) {
        this(title, "", data, width, height);
    }

    public TextWindow(String title, String headings, String data, int width, int height) {
        super(title);
        Image img;
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.textPanel.setTitle(title);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(headings);
        this.textPanel.append(data);
        ImageJ ij = IJ.getInstance();
        if (ij != null && (img = ij.getIconImage()) != null) {
            this.setIconImage(img);
        }
        ((Component)this).setSize(width, height);
        ((Component)this).setVisible(true);
    }

    public TextWindow(String path, int width, int height) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.add("Center", this.textPanel);
        if (this.openFile(path)) {
            ((Component)this).setSize(width, height);
            ((Component)this).setVisible(true);
        } else {
            this.dispose();
        }
    }

    public void append(String text) {
        this.textPanel.append(text);
    }

    public void setFont(Font font) {
        this.textPanel.setFont(font);
    }

    boolean openFile(String path) {
        OpenDialog od = new OpenDialog("Open Text File...", path);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return false;
        }
        path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            this.load(r);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return true;
        }
        this.textPanel.setTitle(name);
        this.setTitle(name);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader in) throws IOException {
        String s;
        boolean count = false;
        while ((s = in.readLine()) != null) {
            this.textPanel.appendLine(s);
        }
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            ((Component)this).setVisible(false);
            this.dispose();
            this.textPanel.flush();
        }
    }
}

