/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.ImagePlus;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ThresholdPlot
extends Canvas
implements Measurements,
MouseListener {
    static final int WIDTH = 256;
    static final int HEIGHT = 64;
    double minThreshold = 85.0;
    double maxThreshold = 170.0;
    int[] histogram;
    Color[] hColors;
    int hmax;
    Image os;
    Graphics osg;
    boolean blackAndWhite;

    public ThresholdPlot() {
        this.addMouseListener(this);
        this.setSize(257, 65);
    }

    void setHistogram(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (!(ip instanceof ByteProcessor)) {
            double min = ip.getMin();
            double max = ip.getMax();
            ip.setMinAndMax(min, max);
            ip = new ByteProcessor(ip.createImage());
        }
        ip.setMask(imp.getMask());
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 9, null);
        int maxCount2 = 0;
        this.histogram = stats.histogram;
        int i = 0;
        while (i < stats.nBins) {
            if (this.histogram[i] > maxCount2 && i != stats.mode) {
                maxCount2 = this.histogram[i];
            }
            ++i;
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[stats.mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
        ColorModel cm = ip.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            return;
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int mapSize = icm.getMapSize();
        if (mapSize != 256) {
            return;
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        icm.getReds(r);
        icm.getGreens(g);
        icm.getBlues(b);
        this.hColors = new Color[256];
        int i2 = 0;
        while (i2 < 256) {
            this.hColors[i2] = new Color(r[i2] & 0xFF, g[i2] & 0xFF, b[i2] & 0xFF);
            ++i2;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.histogram != null) {
            if (this.os == null) {
                this.os = this.createImage(256, 64);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 256, 64);
                this.osg.setColor(Color.gray);
                int i = 0;
                while (i < 256) {
                    if (this.hColors != null) {
                        this.osg.setColor(this.hColors[i]);
                    }
                    this.osg.drawLine(i, 64, i, 64 - 64 * this.histogram[i] / this.hmax);
                    ++i;
                }
                this.osg.dispose();
            }
            g.drawImage(this.os, 0, 0, this);
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, 256, 64);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, 256, 64);
        if (!this.blackAndWhite) {
            g.setColor(Color.red);
        }
        g.drawRect((int)this.minThreshold, 1, (int)(this.maxThreshold - this.minThreshold), 64);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

