/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.ThresholdPlot;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;

public class ThresholdAdjuster
extends PlugInFrame
implements PlugIn,
Measurements,
Runnable,
ActionListener,
AdjustmentListener {
    static final double defaultMinThreshold = 85.0;
    static final double defaultMaxThreshold = 170.0;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static Frame instance;
    ThresholdPlot plot = new ThresholdPlot();
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    Panel panel;
    Button autoB;
    Button resetB;
    Button applyB;
    Button stateB;
    Button setB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    ImageJ ij;
    double minThreshold;
    double maxThreshold;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Label label1;
    Label label2;
    boolean done;
    boolean invertedLut;
    boolean blackAndWhite;
    int lutColor = 0;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;
    static /* synthetic */ Class class$ij$plugin$frame$PasteController;

    public ThresholdAdjuster() {
        super("Threshold");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(class$ij$plugin$frame$PasteController == null ? (class$ij$plugin$frame$PasteController = ThresholdAdjuster.class$("ij.plugin.frame.PasteController")) : class$ij$plugin$frame$PasteController);
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.plot, c);
        this.minSlider = new Scrollbar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.minSlider, c);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 10);
        this.label1 = new Label("       ", 2);
        this.label1.setFont(font);
        this.add((Component)this.label1, c);
        this.maxSlider = new Scrollbar(0, this.sliderRange * 2 / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.maxSlider, c);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 10);
        this.label2 = new Label("       ", 2);
        this.label2.setFont(font);
        this.add((Component)this.label2, c);
        this.panel = new Panel();
        this.autoB = new Button("Auto");
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.applyB = new Button("Apply");
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.resetB = new Button("Reset");
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.stateB = new Button("B&W");
        this.stateB.addActionListener(this);
        this.stateB.addKeyListener(this.ij);
        this.panel.add(this.stateB);
        this.setB = new Button("Set");
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.panel, c);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        this.thread = new Thread((Runnable)this, "ThresholdAdjuster");
        this.thread.start();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            this.setup(imp);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
        } else {
            this.maxValue = this.maxSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b == this.applyB) {
            this.doApplyLut = true;
        } else if (b == this.stateB) {
            this.blackAndWhite = this.stateB.getLabel().equals("B&W");
            if (this.blackAndWhite) {
                this.stateB.setLabel("Red");
                this.lutColor = 1;
            } else {
                this.stateB.setLabel("B&W");
                this.lutColor = 0;
            }
            this.doStateChange = true;
        } else if (b == this.setB) {
            this.doSet = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        int type = imp.getType();
        if (type == 4) {
            return null;
        }
        ImageProcessor ip = imp.getProcessor();
        boolean minMaxChange = false;
        if (type == 1 || type == 2) {
            if (ip.getMin() != this.previousMin || ip.getMax() != this.previousMax) {
                minMaxChange = true;
            }
            this.previousMin = ip.getMin();
            this.previousMax = ip.getMax();
        }
        int id = imp.getID();
        if (minMaxChange || id != this.previousImageID || type != this.previousImageType) {
            this.invertedLut = imp.isInvertedLut();
            this.minThreshold = ip.getMinThreshold();
            this.maxThreshold = ip.getMaxThreshold();
            if (this.minThreshold == -808080.0) {
                this.minThreshold = 85.0;
                this.maxThreshold = 170.0;
            }
            this.plot.setHistogram(imp);
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            this.updateLabels(imp, ip);
            this.updatePlot();
            this.updateScrollBars();
            imp.updateAndDraw();
        }
        this.previousImageID = id;
        this.previousImageType = type;
        return ip;
    }

    void scaleUpAndSet(ImageProcessor ip, double minThreshold, double maxThreshold) {
        if (!(ip instanceof ByteProcessor) && minThreshold != -808080.0) {
            double min = ip.getMin();
            double max = ip.getMax();
            if (max > min) {
                minThreshold = min + minThreshold / 255.0 * (max - min);
                maxThreshold = min + maxThreshold / 255.0 * (max - min);
            } else {
                minThreshold = -808080.0;
            }
        }
        ip.setThreshold(minThreshold, maxThreshold, this.lutColor);
    }

    double scaleDown(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (threshold - min) / (max - min) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return min + threshold / 255.0 * (max - min);
        }
        return -808080.0;
    }

    void updatePlot() {
        this.plot.minThreshold = this.minThreshold;
        this.plot.maxThreshold = this.maxThreshold;
        this.plot.blackAndWhite = this.blackAndWhite;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        double min = ip.getMinThreshold();
        double max = ip.getMaxThreshold();
        if (min == -808080.0) {
            this.label1.setText("");
            this.label2.setText("");
        } else {
            Calibration cal = imp.getCalibration();
            if (cal.calibrated()) {
                min = cal.getCValue((int)min);
                max = cal.getCValue((int)max);
            }
            if ((double)((int)min) == min && (double)((int)max) == max || ip instanceof ShortProcessor) {
                this.label1.setText("" + (int)min);
                this.label2.setText("" + (int)max);
            } else {
                this.label1.setText("" + IJ.d2s(min, 2));
                this.label2.setText("" + IJ.d2s(max, 2));
            }
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
        this.maxSlider.setValue((int)this.maxThreshold);
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        int[] mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustMinThreshold(ImagePlus imp, ImageProcessor ip, double value) {
        if (IJ.altKeyDown()) {
            double width = this.maxThreshold - this.minThreshold;
            if (width < 1.0) {
                width = 1.0;
            }
            this.minThreshold = value;
            this.maxThreshold = this.minThreshold + width;
            if (this.minThreshold + width > 255.0) {
                this.minThreshold = 255.0 - width;
                this.maxThreshold = this.minThreshold + width;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.maxSlider.setValue((int)this.maxThreshold);
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            return;
        }
        this.minThreshold = value;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
            this.maxSlider.setValue((int)this.maxThreshold);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
    }

    void adjustMaxThreshold(ImagePlus imp, ImageProcessor ip, int cvalue) {
        this.maxThreshold = cvalue;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        this.plot.setHistogram(imp);
        ip.setThreshold(-808080.0, 0.0, 0);
        this.updateScrollBars();
    }

    void doSet(ImagePlus imp, ImageProcessor ip) {
        boolean outOfRange;
        double level1 = ip.getMinThreshold();
        double level2 = ip.getMaxThreshold();
        if (level1 == -808080.0) {
            level1 = this.scaleUp(ip, 85.0);
            level2 = this.scaleUp(ip, 170.0);
        }
        GenericDialog gd = new GenericDialog("Set Threshold Levels");
        gd.addNumericField("Lower Threshold Level: ", level1, 0);
        gd.addNumericField("Upper Threshold Level: ", level2, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        level1 = gd.getNextNumber();
        level2 = gd.getNextNumber();
        if (level2 < level1) {
            level2 = level1;
        }
        double minDisplay = ip.getMin();
        double maxDisplay = ip.getMax();
        ip.resetMinAndMax();
        double minValue = ip.getMin();
        double maxValue = ip.getMax();
        if (level1 < minValue) {
            level1 = minValue;
        }
        if (level2 > maxValue) {
            level2 = maxValue;
        }
        boolean bl = outOfRange = level1 < minDisplay || level2 > maxDisplay;
        if (outOfRange) {
            this.plot.setHistogram(imp);
        } else {
            ip.setMinAndMax(minDisplay, maxDisplay);
        }
        this.minThreshold = this.scaleDown(ip, level1);
        this.maxThreshold = this.scaleDown(ip, level2);
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        boolean useBlackAndWhite;
        boolean not8Bits;
        boolean bl = not8Bits = !(ip instanceof ByteProcessor);
        if (not8Bits) {
            double min = ip.getMin();
            double max = ip.getMax();
            ip.setMinAndMax(min, max);
            ip = new ByteProcessor(ip.createImage());
        }
        if (!(useBlackAndWhite = this.stateB.getLabel().equals("Red"))) {
            GenericDialog gd = new GenericDialog("Apply Lut", this);
            gd.addCheckbox("Set thresholded pixels to foreground color", fill1);
            gd.addCheckbox("Set remaining pixels to background color", fill2);
            gd.addMessage("");
            gd.addCheckbox("Black forground, white background", useBW);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            fill1 = gd.getNextBoolean();
            fill2 = gd.getNextBoolean();
            useBW = useBlackAndWhite = gd.getNextBoolean();
        } else {
            fill1 = true;
            fill2 = true;
        }
        Undo.setup(1, imp);
        ip.snapshot();
        this.reset(imp, ip);
        int savePixel = ip.getPixel(0, 0);
        if (useBlackAndWhite) {
            ip.setColor(Color.black);
        } else {
            ip.setColor(Toolbar.getForegroundColor());
        }
        ip.drawPixel(0, 0);
        int fcolor = ip.getPixel(0, 0);
        if (useBlackAndWhite) {
            ip.setColor(Color.white);
        } else {
            ip.setColor(Toolbar.getBackgroundColor());
        }
        ip.drawPixel(0, 0);
        int bcolor = ip.getPixel(0, 0);
        ip.setColor(Toolbar.getForegroundColor());
        ip.putPixel(0, 0, savePixel);
        int[] lut = new int[256];
        int i = 0;
        while (i < 256) {
            lut[i] = (double)i >= this.minThreshold && (double)i <= this.maxThreshold ? (int)((byte)(fill1 ? fcolor : (byte)i)) : (int)((byte)(fill2 ? bcolor : (byte)i));
            ++i;
        }
        if (not8Bits) {
            ip.applyTable(lut);
            new ImagePlus(imp.getTitle(), ip).show();
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply threshold to all " + stack.getSize() + " slices in the stack?");
            if (d.cancelPressed()) {
                return;
            }
            if (d.yesPressed()) {
                new StackProcessor(stack, ip).applyTable(lut);
            } else {
                ip.applyTable(lut);
            }
        } else {
            ip.applyTable(lut);
        }
        imp.changes = true;
        if (this.plot.histogram != null) {
            this.plot.setHistogram(imp);
        }
    }

    void changeState(ImagePlus imp, ImageProcessor ip) {
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void autoThreshold(ImagePlus imp, ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        ImageStatistics stats = imp.getStatistics(24);
        int threshold = ((ByteProcessor)ip).getAutoThreshold();
        if (stats.max - (double)stats.mode < (double)stats.mode - stats.min) {
            this.minThreshold = stats.min;
            this.maxThreshold = threshold;
        } else {
            this.minThreshold = threshold;
            this.maxThreshold = stats.max;
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    public void run() {
        while (!this.done) {
            ThresholdAdjuster thresholdAdjuster = this;
            synchronized (thresholdAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int min = this.minValue;
        int max = this.maxValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doStateChange) {
            action = 4;
        } else if (this.doSet) {
            action = 7;
        } else if (this.minValue >= 0) {
            action = 5;
        } else if (this.maxValue >= 0) {
            action = 6;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        if (!imp.lock()) {
            imp = null;
            return;
        }
        ImageProcessor ip = this.setup(imp);
        if (ip == null) {
            imp.unlock();
            IJ.beep();
            IJ.showStatus("RGB images cannot be thresolded");
            return;
        }
        switch (action) {
            case 0: {
                this.reset(imp, ip);
                break;
            }
            case 1: {
                this.autoThreshold(imp, ip);
                break;
            }
            case 3: {
                this.apply(imp, ip);
                break;
            }
            case 4: {
                this.changeState(imp, ip);
                break;
            }
            case 7: {
                this.doSet(imp, ip);
                break;
            }
            case 5: {
                this.adjustMinThreshold(imp, ip, min);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(imp, ip, max);
            }
        }
        this.updatePlot();
        this.updateLabels(imp, ip);
        ip.setLutAnimation(true);
        imp.updateAndDraw();
        imp.unlock();
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

