/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.gui.SaveChangesDialog;
import ij.plugin.frame.PlugInFrame;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Editor
extends PlugInFrame
implements ActionListener,
TextListener {
    public static final int MAX_SIZE = 28000;
    private TextArea ta;
    private String path;
    private boolean changes;
    private static String searchString = "";
    private static int lineNumber = 1;

    public Editor() {
        super("Editor");
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        m.add(new MenuItem("Save", new MenuShortcut(83)));
        m.add(new MenuItem("Save As..."));
        m.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        m.addActionListener(this);
        mb.add(m);
        m = new Menu("Edit");
        m.add(new MenuItem("Find...", new MenuShortcut(70)));
        m.add(new MenuItem("Find Next", new MenuShortcut(71)));
        m.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        m.addActionListener(this);
        mb.add(m);
        this.setMenuBar(mb);
        this.ta = new TextArea();
        this.ta.addTextListener(this);
        this.add(this.ta);
        this.pack();
    }

    public void create(String name, String text) {
        this.ta.append(text);
        this.ta.setCaretPosition(0);
        this.setTitle(name);
        this.changes = true;
        ((Component)this).setVisible(true);
    }

    public void open(String dir, String name) {
        this.path = dir + name;
        File file = new File(this.path);
        int size = (int)file.length();
        if (size > 28000 && !IJ.isMacintosh()) {
            IJ.error("This file is too large for ImageJ to open.\n \n    File size: " + size + " bytes\n" + "    Max. size: " + 28000 + " bytes");
            this.dispose();
            return;
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            this.create(name, new String(sb));
            this.changes = false;
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return;
        }
    }

    public void display(String title, String text) {
        this.ta.selectAll();
        this.ta.replaceRange(text, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setTitle(title);
        this.changes = false;
        ((Component)this).setVisible(true);
    }

    void save() {
        if (this.path == null) {
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        try {
            String s;
            BufferedReader br = new BufferedReader(new CharArrayReader(chars));
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
            while ((s = br.readLine()) != null) {
                bw.write(s, 0, s.length());
                bw.newLine();
            }
            bw.close();
            this.changes = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if ("Save".equals(what)) {
            this.save();
        } else if ("Compile and Run".equals(what)) {
            this.compileAndRun();
        } else if ("Save As...".equals(what)) {
            this.saveAs();
        } else if ("Find...".equals(what)) {
            this.find(null);
        } else if ("Find Next".equals(what)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(what)) {
            this.gotoLine();
        }
    }

    public void textValueChanged(TextEvent evt) {
        this.changes = true;
    }

    public void processWindowEvent(WindowEvent e) {
        boolean canceled = true;
        if (e.getID() == 201) {
            if (this.getTitle().equals("Errors") || this.close()) {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    boolean close() {
        boolean okay = true;
        if (this.changes) {
            SaveChangesDialog d = new SaveChangesDialog((Frame)this, this.getTitle());
            if (d.cancelPressed()) {
                okay = false;
            } else if (d.savePressed()) {
                this.save();
            }
        }
        return okay;
    }

    void saveAs() {
        FileDialog fd = new FileDialog((Frame)this, "Save As...", 1);
        fd.setFile(this.getTitle());
        fd.setDirectory(Menus.getPlugInsPath());
        ((Component)fd).setVisible(true);
        String name = fd.getFile();
        String dir = fd.getDirectory();
        fd.dispose();
        if (name != null) {
            this.path = dir + name;
            this.save();
            this.changes = false;
            this.setTitle(name);
        }
    }

    void find(String s) {
        if (s == null) {
            GenericDialog gd = new GenericDialog("Find", this);
            gd.addStringField("Find: ", searchString, 20);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            s = gd.getNextString();
        }
        if (s.equals("")) {
            return;
        }
        String text = this.ta.getText();
        int index = text.indexOf(s, this.ta.getCaretPosition() + 1);
        if (index < 0) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(index);
        this.ta.setSelectionEnd(index + s.length());
        searchString = s;
    }

    void gotoLine() {
        GenericDialog gd = new GenericDialog("Go to Line", this);
        gd.addNumericField("Go to line number: ", lineNumber, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        if (n < 1) {
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 1;
        int loc = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\n') {
                ++count;
            }
            if (count == n) {
                loc = i + 1;
                break;
            }
            ++i;
        }
        this.ta.setCaretPosition(loc);
        lineNumber = n;
    }
}

