/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ContrastPlot
extends Canvas
implements MouseListener {
    static final int WIDTH = 120;
    static final int HEIGHT = 80;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Graphics osg;

    public ContrastPlot() {
        this.addMouseListener(this);
        this.setSize(121, 81);
    }

    void setHistogram(ImageStatistics stats) {
        int maxCount2 = 0;
        this.histogram = stats.histogram;
        int i = 0;
        while (i < stats.nBins) {
            if (this.histogram[i] > maxCount2 && i != stats.mode) {
                maxCount2 = this.histogram[i];
            }
            ++i;
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[stats.mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        double scale = 120.0 / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        if (this.max != this.min) {
            slope = 80.0 / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = 80;
        } else {
            x1 = 0;
            y1 = this.max > this.min ? 80 - (int)((this.defaultMin - this.min) * slope) : 80;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = 120;
            y2 = this.max > this.min ? 80 - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null) {
                this.os = this.createImage(120, 80);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 120, 80);
                this.osg.setColor(Color.gray);
                int i = 0;
                while (i < 120) {
                    this.osg.drawLine(i, 80, i, 80 - 80 * this.histogram[i * 2] / this.hmax);
                    ++i;
                }
                this.osg.dispose();
            }
            g.drawImage(this.os, 0, 0, this);
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, 120, 80);
        }
        g.setColor(Color.black);
        g.drawLine(x1, y1, x2, y2);
        g.drawRect(0, 0, 120, 80);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

