/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInFrame;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.image.IndexColorModel;

public class ContrastAdjuster
extends PlugInFrame
implements PlugIn,
Runnable,
ActionListener,
AdjustmentListener {
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    private static Frame instance;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doHistogram;
    boolean doApplyLut;
    boolean doThreshold;
    boolean doUpdate;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button histB;
    Button applyB;
    Button threshB;
    Button updateB;
    int previousImageID;
    int previousType;
    ImageJ ij;
    double min;
    double max;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label brightnessLabel;
    Label contrastLabel;
    boolean done;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int BRIGHTNESS = 5;
    static final int CONTRAST = 6;
    static final int UPDATE = 7;
    static /* synthetic */ Class class$ij$plugin$frame$ContrastAdjuster;

    public ContrastAdjuster() {
        super("B&C");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(class$ij$plugin$frame$ContrastAdjuster == null ? (class$ij$plugin$frame$ContrastAdjuster = ContrastAdjuster.class$("ij.plugin.frame.ContrastAdjuster")) : class$ij$plugin$frame$ContrastAdjuster);
        this.ij = IJ.getInstance();
        Font monoFont = new Font("Monospaced", 0, 12);
        Font sanFont = new Font("SansSerif", 0, 12);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        int y = 0;
        c.gridy = y++;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 0, 10);
        gridbag.setConstraints(this.plot, c);
        this.add(this.plot);
        this.panel = new Panel();
        c.gridy = y++;
        c.insets = new Insets(0, 10, 0, 10);
        gridbag.setConstraints(this.panel, c);
        this.panel.setLayout(new BorderLayout());
        this.minLabel = new Label("      ", 0);
        this.minLabel.setFont(monoFont);
        this.panel.add("West", this.minLabel);
        this.maxLabel = new Label("      ", 2);
        this.maxLabel.setFont(monoFont);
        this.panel.add("East", this.maxLabel);
        this.add(this.panel);
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        c.gridy = y++;
        c.insets = new Insets(5, 10, 0, 10);
        gridbag.setConstraints(this.brightnessSlider, c);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        this.panel = new Panel();
        c.gridy = y++;
        c.insets = new Insets(0, 10, 0, 10);
        gridbag.setConstraints(this.panel, c);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        Label label = new Label("Brightness");
        label.setFont(sanFont);
        this.panel.add(label);
        this.brightnessLabel = new Label("", 0);
        this.brightnessLabel.setFont(monoFont);
        this.panel.add(this.brightnessLabel);
        this.add(this.panel);
        this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        c.gridy = y++;
        c.insets = new Insets(5, 10, 0, 10);
        gridbag.setConstraints(this.contrastSlider, c);
        this.add(this.contrastSlider);
        this.contrastSlider.addAdjustmentListener(this);
        this.contrastSlider.setUnitIncrement(1);
        this.panel = new Panel();
        c.gridy = y++;
        c.insets = new Insets(0, 10, 0, 10);
        gridbag.setConstraints(this.panel, c);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        label = new Label("Contrast");
        label.setFont(sanFont);
        this.panel.add(label);
        this.contrastLabel = new Label("", 0);
        this.contrastLabel.setFont(monoFont);
        this.panel.add(this.contrastLabel);
        this.add(this.panel);
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(3, 2, 0, 0));
        this.autoB = new Button("Auto");
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new Button("Reset");
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.histB = new Button("Hist");
        this.histB.addActionListener(this);
        this.histB.addKeyListener(this.ij);
        this.panel.add(this.histB);
        this.applyB = new Button("Apply");
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.threshB = new Button("Thresh");
        this.threshB.addActionListener(this);
        this.threshB.addKeyListener(this.ij);
        this.panel.add(this.threshB);
        this.updateB = new Button("Update");
        this.updateB.addActionListener(this);
        this.updateB.addKeyListener(this.ij);
        this.panel.add(this.updateB);
        c.gridy = y++;
        c.insets = new Insets(10, 5, 10, 5);
        gridbag.setConstraints(this.panel, c);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b == this.histB) {
            this.doHistogram = true;
        } else if (b == this.applyB) {
            this.doApplyLut = true;
        } else if (b == this.threshB) {
            this.doThreshold = true;
        } else if (b == this.updateB) {
            this.doUpdate = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        int type = imp.getType();
        this.RGBImage = type == 4;
        boolean newIP = !imp.isProcessor();
        ImageProcessor ip = imp.getProcessor();
        if (imp.getID() != this.previousImageID || this.RGBImage && newIP || type != this.previousType) {
            if (this.RGBImage) {
                ip.snapshot();
            }
            if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
                ip.resetMinAndMax();
                this.defaultMin = ip.getMin();
                this.defaultMax = ip.getMax();
            } else {
                this.defaultMin = 0.0;
                this.defaultMax = 255.0;
            }
            this.min = ip.getMin();
            this.max = ip.getMax();
            if (IJ.debugMode) {
                IJ.write("min: " + this.min);
                IJ.write("max: " + this.max);
                IJ.write("defaultMin: " + this.defaultMin);
                IJ.write("defaultMax: " + this.defaultMax);
            }
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
            this.plot.histogram = null;
        }
        this.previousImageID = imp.getID();
        this.previousType = type;
        return ip;
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        boolean realValue;
        double min = ip.getMin();
        double max = ip.getMax();
        int type = imp.getType();
        Calibration cal = imp.getCalibration();
        boolean bl = realValue = type == 2;
        if (cal.calibrated()) {
            min = cal.getCValue((int)min);
            max = cal.getCValue((int)max);
            if (type != 1) {
                realValue = true;
            }
        }
        if (realValue) {
            this.minLabel.setText("" + IJ.d2s(min));
            this.maxLabel.setText("" + IJ.d2s(max));
        } else {
            this.minLabel.setText(IJ.d2s(min, 0));
            this.maxLabel.setText(IJ.d2s(max, 0));
        }
    }

    void updateScrollBars() {
        double mid = this.sliderRange / 2;
        double c = (this.defaultMax - this.defaultMin) / (this.max - this.min) * mid;
        if (c > mid) {
            c = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * mid;
        }
        this.contrast = (int)c;
        this.contrastSlider.setValue(this.contrast);
        double level = this.min + (this.max - this.min) / 2.0;
        double normalizedLevel = 1.0 - (level - this.defaultMin) / (this.defaultMax - this.defaultMin);
        this.brightness = (int)(normalizedLevel * (double)this.sliderRange);
        this.brightnessSlider.setValue(this.brightness);
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        int[] mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustBrightness(ImagePlus imp, ImageProcessor ip, double bvalue) {
        double center = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - bvalue) / (double)this.sliderRange);
        double width = this.max - this.min;
        this.min = center - width / 2.0;
        this.max = center + width / 2.0;
        ip.setMinAndMax(this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
    }

    void adjustContrast(ImagePlus imp, ImageProcessor ip, int cvalue) {
        double center = this.min + (this.max - this.min) / 2.0;
        double range = this.defaultMax - this.defaultMin;
        double mid = this.sliderRange / 2;
        double slope = (double)cvalue <= mid ? (double)cvalue / mid : mid / (double)(this.sliderRange - cvalue);
        if (slope > 0.0) {
            this.min = center - 0.5 * range / slope;
            this.max = center + 0.5 * range / slope;
        }
        ip.setMinAndMax(this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
    }

    void reset(ImageProcessor ip) {
        if (this.RGBImage) {
            ip.reset();
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        ip.setMinAndMax(this.min, this.max);
        this.updateScrollBars();
    }

    void update(ImagePlus imp, ImageProcessor ip) {
        if (this.min == 0.0 && this.max == 0.0 || imp.getType() != this.previousType) {
            IJ.beep();
        } else {
            ip.setMinAndMax(this.min, this.max);
            this.updateScrollBars();
        }
    }

    void plotHistogram(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            this.reset(ip);
        }
        this.plot.setHistogram(imp.getStatistics());
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        if (imp.getType() == 4 && imp.getStackSize() > 1) {
            this.applyRGBStack(imp);
            return;
        }
        if (imp.getType() != 0) {
            IJ.beep();
            IJ.showStatus("Apply requires an 8-bit grayscale image or an RGB stack");
            return;
        }
        int[] table = new int[256];
        LookUpTable lut = imp.createLut();
        IndexColorModel cm = (IndexColorModel)lut.getColorModel();
        boolean invertedLut = ((ByteProcessor)ip).isInvertedLut();
        int i = 0;
        while (i < cm.getMapSize()) {
            table[i] = invertedLut ? 255 - cm.getRed(i) & 0xFF : cm.getRed(i) & 0xFF;
            ++i;
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply LUT to all " + stack.getSize() + " slices in the stack?");
            if (d.cancelPressed()) {
                return;
            }
            if (d.yesPressed()) {
                new StackProcessor(stack, ip).applyTable(table);
            } else {
                ip.applyTable(table);
            }
        } else {
            ip.applyTable(table);
        }
        this.reset(ip);
        imp.changes = true;
        if (this.plot.histogram != null) {
            this.plotHistogram(imp, ip);
        }
    }

    void applyRGBStack(ImagePlus imp) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            return;
        }
        int i = 1;
        while (i <= n) {
            if (i != current) {
                imp.setSlice(i);
                ImageProcessor ip = imp.getProcessor();
                ip.setMinAndMax(this.min, this.max);
                IJ.showProgress((double)i / (double)n);
            }
            ++i;
        }
        imp.setSlice(current);
        imp.changes = true;
    }

    void threshold(ImagePlus imp, ImageProcessor ip) {
        int threshold = (int)((this.defaultMax - this.defaultMin) / 2.0);
        this.min = threshold;
        this.max = threshold;
        ip.setMinAndMax(this.min, this.max);
        this.setThreshold(ip);
        this.updateScrollBars();
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(this.max, 255.0, 2);
        } else {
            ip.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        int[] mask;
        if (this.RGBImage) {
            ip.reset();
        }
        Calibration cal = imp.getCalibration();
        imp.setCalibration(null);
        ImageStatistics stats = imp.getStatistics();
        imp.setCalibration(cal);
        int[] histogram = stats.histogram;
        int threshold = stats.pixelCount / 5000;
        int i = -1;
        boolean found = false;
        do {
            boolean bl = found = histogram[++i] > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            boolean bl = found = histogram[--i] > threshold;
        } while (!found && i > 0);
        int hmax = i;
        if (hmax > hmin) {
            imp.killRoi();
            this.min = stats.histMin + (double)hmin * stats.binSize;
            this.max = stats.histMin + (double)hmax * stats.binSize;
            ip.setMinAndMax(this.min, this.max);
        }
        this.updateScrollBars();
        Roi roi = imp.getRoi();
        if (roi != null && (mask = roi.getMask()) != null) {
            ip.reset(mask);
        }
    }

    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int bvalue = this.brightnessValue;
        int cvalue = this.contrastValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doHistogram) {
            action = 2;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doThreshold) {
            action = 4;
        } else if (this.doUpdate) {
            action = 7;
        } else if (this.brightnessValue >= 0) {
            action = 5;
        } else if (this.contrastValue >= 0) {
            action = 6;
        } else {
            return;
        }
        this.brightnessValue = -1;
        this.contrastValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doHistogram = false;
        this.doApplyLut = false;
        this.doThreshold = false;
        this.doUpdate = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        if (!imp.lock()) {
            imp = null;
            return;
        }
        ImageProcessor ip = action != 7 ? this.setup(imp) : imp.getProcessor();
        switch (action) {
            case 0: {
                this.reset(ip);
                break;
            }
            case 1: {
                this.autoAdjust(imp, ip);
                break;
            }
            case 2: {
                this.plotHistogram(imp, ip);
                break;
            }
            case 3: {
                this.apply(imp, ip);
                break;
            }
            case 4: {
                this.threshold(imp, ip);
                break;
            }
            case 7: {
                this.update(imp, ip);
                break;
            }
            case 5: {
                this.adjustBrightness(imp, ip, bvalue);
                break;
            }
            case 6: {
                this.adjustContrast(imp, ip, cvalue);
            }
        }
        this.updatePlot();
        this.updateLabels(imp, ip);
        imp.updateAndDraw();
        imp.unlock();
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

