/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugInFilter,
Measurements {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1183;
    }

    public void run(ImageProcessor ip) {
        if (this.imp.getStackSize() < 2) {
            IJ.showMessage("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi.getType() >= 5) {
            IJ.showMessage("ZAxisProfiler", "This command does not work with line selections.");
            return;
        }
        float[] y = this.getZAxisProfile(roi);
        if (y != null) {
            float[] x = new float[y.length];
            int i = 0;
            while (i < x.length) {
                x[i] = i + 1;
                ++i;
            }
            Rectangle r = this.imp.getRoi().getBoundingRect();
            new PlotWindow(this.imp.getTitle() + "-" + r.x + "-" + r.y, "Slice", "Mean", x, y).draw();
        }
    }

    float[] getZAxisProfile(Roi roi) {
        ImageStack stack = this.imp.getStack();
        int size = stack.getSize();
        float[] values = new float[size];
        int[] mask = this.imp.getMask();
        Rectangle r = this.imp.getRoi().getBoundingRect();
        Calibration cal = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int measurements = Analyzer.getMeasurements();
        boolean showResults = measurements != 0 && measurements != 256;
        measurements |= 2;
        if (showResults && !Analyzer.resetCounter()) {
            return null;
        }
        int i = 1;
        while (i <= size) {
            ImageProcessor ip = stack.getProcessor(i);
            ip.setRoi(r);
            ip.setMask(mask);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            if (showResults) {
                analyzer.displayResults();
            }
            values[i - 1] = (float)stats.mean;
            ++i;
        }
        return values;
    }
}

