/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

class RollingBall {
    byte[] data;
    int patchwidth;
    int shrinkfactor = 8;

    RollingBall(int radius) {
        int arcTrimPer = 20;
        if (radius <= 100) {
            this.shrinkfactor = 4;
            arcTrimPer = 16;
        } else if (radius <= 30) {
            this.shrinkfactor = 2;
            arcTrimPer = 12;
        } else if (radius <= 10) {
            this.shrinkfactor = 1;
            arcTrimPer = 12;
        }
        this.buildRollingBall(radius, arcTrimPer);
    }

    void buildRollingBall(int ballradius, int arcTrimPer) {
        this.shrinkfactor = this.shrinkfactor;
        int smallballradius = ballradius / this.shrinkfactor;
        if (smallballradius < 1) {
            smallballradius = 1;
        }
        int rsquare = smallballradius * smallballradius;
        int diam = smallballradius * 2;
        int xtrim = arcTrimPer * diam / 100;
        this.patchwidth = diam - xtrim - xtrim;
        int halfpatchwidth = smallballradius - xtrim;
        int ballsize = (this.patchwidth + 1) * (this.patchwidth + 1);
        this.data = new byte[ballsize];
        int i = 0;
        while (i < ballsize) {
            int xval = i % (this.patchwidth + 1) - halfpatchwidth;
            int yval = i / (this.patchwidth + 1) - halfpatchwidth;
            int temp = rsquare - xval * xval - yval * yval;
            this.data[i] = temp >= 0 ? (byte)Math.round(Math.sqrt(temp)) : (byte)0;
            ++i;
        }
    }
}

