/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Properties;

public class ParticleAnalyzer
implements PlugInFilter {
    public static final int SHOW_RESULTS = 1;
    public static final int SHOW_SUMMARY = 2;
    public static final int SHOW_OUTLINES = 4;
    public static final int EXCLUDE_EDGE_PARTICLES = 8;
    public static final int SHOW_SIZE_DISTRIBUTION = 16;
    public static final int SHOW_PROGRESS = 32;
    public static final int CLEAR_WORKSHEET = 64;
    static final String OPTIONS = "ap.options";
    static final String BINS = "ap.bins";
    private static int staticMinSize = 1;
    private static int staticMaxSize = 999999;
    private static int staticOptions = Prefs.getInt("ap.options", 66);
    private static int staticBins = Prefs.getInt("ap.bins", 20);
    protected ImagePlus imp;
    protected ResultsTable rt;
    protected Analyzer analyzer;
    private int level1;
    private int level2;
    private int minSize;
    private int maxSize;
    private int sizeBins;
    private int options;
    private int measurements;
    private Calibration calibration;
    private String arg;
    private int fillColor;
    private boolean thresholdingLUT;
    private boolean showResults;
    private boolean showOutlines;
    private boolean showSummary;
    private boolean excludeEdgeParticles;
    private boolean showSizeDistribution;
    private boolean resetCounter;
    private boolean showProgress;
    private ImageProcessor ip2;
    private int width;
    private int height;
    static /* synthetic */ Class class$ij$plugin$filter$ParticleAnalyzer;

    public ParticleAnalyzer(int options, int measurements, ResultsTable rt, double minSize, double maxSize) {
        this.options = options;
        this.measurements = measurements;
        this.rt = rt;
        if (this.rt == null) {
            this.rt = new ResultsTable();
        }
        this.minSize = (int)minSize;
        this.maxSize = (int)maxSize;
        this.sizeBins = staticBins;
    }

    public ParticleAnalyzer() {
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$ParticleAnalyzer == null ? (class$ij$plugin$filter$ParticleAnalyzer = ParticleAnalyzer.class$("ij.plugin.filter.ParticleAnalyzer")) : class$ij$plugin$filter$ParticleAnalyzer);
        return 385;
    }

    public void run(ImageProcessor ip) {
        if (!this.showDialog()) {
            return;
        }
        this.imp.startTiming();
        this.analyze(this.imp, ip);
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Analyze Particles", IJ.getInstance());
        this.minSize = staticMinSize;
        this.maxSize = staticMaxSize;
        this.sizeBins = staticBins;
        this.options = staticOptions;
        gd.addNumericField("Minimum Size (pixels):", this.minSize, 0);
        gd.addNumericField("Maximum Size (pixels):", this.maxSize, 0);
        gd.addNumericField("Bins (2-256):", this.sizeBins, 0);
        gd.addCheckbox("Display Results", (this.options & 1) != 0);
        gd.addCheckbox("Show Outlines", (this.options & 4) != 0);
        gd.addCheckbox("Exclude Edge Particles", (this.options & 8) != 0);
        gd.addCheckbox("Size Distribution", (this.options & 0x10) != 0);
        gd.addCheckbox("Clear Worksheet", (this.options & 0x40) != 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.minSize = (int)gd.getNextNumber();
        this.maxSize = (int)gd.getNextNumber();
        this.sizeBins = (int)gd.getNextNumber();
        if (gd.invalidNumber()) {
            IJ.error("Minimum Size, Maximum Size or Bins invalid.");
            return false;
        }
        staticMinSize = this.minSize;
        staticMaxSize = this.maxSize;
        staticBins = this.sizeBins;
        this.options = gd.getNextBoolean() ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.options = gd.getNextBoolean() ? (this.options |= 4) : (this.options &= 0xFFFFFFFB);
        this.options = gd.getNextBoolean() ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
        this.options = gd.getNextBoolean() ? (this.options |= 0x10) : (this.options &= 0xFFFFFFEF);
        this.options = gd.getNextBoolean() ? (this.options |= 0x40) : (this.options &= 0xFFFFFFBF);
        staticOptions = this.options;
        this.options |= 0x20;
        return true;
    }

    public boolean analyze(ImagePlus imp) {
        return this.analyze(imp, imp.getProcessor());
    }

    public boolean analyze(ImagePlus imp, ImageProcessor ip) {
        this.showResults = (this.options & 1) != 0;
        this.showOutlines = (this.options & 4) != 0;
        this.excludeEdgeParticles = (this.options & 8) != 0;
        this.showSizeDistribution = (this.options & 0x10) != 0;
        this.resetCounter = (this.options & 0x40) != 0;
        this.showProgress = (this.options & 0x20) != 0;
        ip.snapshot();
        ip.setProgressBar(null);
        if (!this.setThresholdLevels(imp, ip)) {
            return false;
        }
        if (this.showOutlines) {
            this.ip2 = new ByteProcessor(ip.getWidth(), ip.getHeight());
            this.ip2.setColor(Color.white);
            this.ip2.fill();
            this.ip2.setColor(Color.black);
        }
        this.calibration = imp.getCalibration();
        byte[] pixels = (byte[])ip.getPixels();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        Rectangle r = ip.getRoi();
        int[] mask = imp.getMask();
        int inc = r.height / 20;
        if (inc < 1) {
            inc = 1;
        }
        int mi = 0;
        if (this.rt == null) {
            this.rt = Analyzer.getResultsTable();
            this.analyzer = new Analyzer(imp);
        } else {
            this.analyzer = new Analyzer(imp, this.measurements, this.rt);
        }
        if (this.resetCounter && !Analyzer.resetCounter()) {
            return false;
        }
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.running = true;
        }
        boolean canceled = false;
        if (this.measurements == 0) {
            this.measurements = Analyzer.getMeasurements();
        }
        int y = r.y;
        while (y < r.y + r.height) {
            int offset = y * this.width;
            int x = r.x;
            while (x < r.x + r.width) {
                int value = pixels[offset + x] & 0xFF;
                if (mask != null && mask[mi++] != -16777216) {
                    value = -1;
                }
                if (value >= this.level1 && value <= this.level2) {
                    this.analyzeParticle(x, y, imp, ip);
                }
                ++x;
            }
            if (this.showProgress && y % inc == 0) {
                IJ.showProgress((double)(y - r.y) / (double)r.height);
            }
            if (win != null) {
                boolean bl = canceled = !win.running;
            }
            if (canceled) break;
            ++y;
        }
        if (this.showProgress) {
            IJ.showProgress(1.0);
        }
        imp.killRoi();
        ip.setRoi(null);
        ip.reset();
        if (!canceled) {
            this.showResults();
        }
        return true;
    }

    boolean setThresholdLevels(ImagePlus imp, ImageProcessor ip) {
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        boolean invertedLut = imp.isInvertedLut();
        if (t1 == -808080.0) {
            ImageStatistics stats = imp.getStatistics();
            if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                IJ.error("8-bit binary or thresholded image required.");
                return false;
            }
            if (invertedLut) {
                this.level1 = 255;
                this.level2 = 255;
                this.fillColor = 64;
            } else {
                this.level1 = 0;
                this.level2 = 0;
                this.fillColor = 192;
            }
        } else {
            this.level1 = (int)t1;
            this.level2 = (int)t2;
            if (this.level1 > 0) {
                this.fillColor = 0;
            } else if (this.level2 < 255) {
                this.fillColor = 255;
            } else {
                return false;
            }
        }
        return true;
    }

    void drawOutline(Roi roi, int count) {
        Rectangle r = roi.getBoundingRect();
        int nPoints = ((PolygonRoi)roi).getNCoordinates();
        int[] xp = ((PolygonRoi)roi).getXCoordinates();
        int[] yp = ((PolygonRoi)roi).getYCoordinates();
        int x = r.x;
        int y = r.y;
        this.ip2.moveTo(x + xp[0], y + yp[0]);
        int i = 1;
        while (i < nPoints) {
            this.ip2.lineTo(x + xp[i], y + yp[i]);
            ++i;
        }
        this.ip2.lineTo(x + xp[0], y + yp[0]);
        String s = IJ.d2s(count, 0);
        this.ip2.moveTo(r.x + r.width / 2 - this.ip2.getStringWidth(s) / 2, r.y + r.height / 2 + 4);
        this.ip2.drawString(s);
    }

    void analyzeParticle(int x, int y, ImagePlus imp, ImageProcessor ip) {
        int[] mask;
        Wand wand = new Wand(ip);
        wand.autoOutline(x, y, this.level1, this.level2);
        if (wand.npoints == 0) {
            IJ.write("wand error: " + x + " " + y);
            return;
        }
        PolygonRoi roi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, imp, 4);
        Rectangle r = roi.getBoundingRect();
        ip.setRoi(r);
        if (r.width > 1 && r.height > 1) {
            ip.setMask(((Roi)roi).getMask());
        }
        ip.setColor(this.fillColor);
        ByteStatistics s = new ByteStatistics(ip, this.measurements, this.calibration);
        boolean include = true;
        if (this.excludeEdgeParticles && (r.x == 0 || r.y == 0 || r.x + r.width == this.width || r.y + r.height == this.height)) {
            include = false;
        }
        if (s.pixelCount >= this.minSize && s.pixelCount <= this.maxSize && include) {
            this.saveResults(s, roi);
        }
        if ((mask = ip.getMask()) != null) {
            ip.fill(mask);
        } else {
            ip.fill();
        }
    }

    protected void saveResults(ImageStatistics stats, Roi roi) {
        this.analyzer.saveResults(stats, roi);
        if (this.showResults) {
            this.analyzer.displayResults();
        }
        if (this.showOutlines) {
            this.drawOutline(roi, this.rt.getCounter());
        }
    }

    void showResults() {
        int count = this.rt.getCounter();
        if (count == 0) {
            return;
        }
        FloatProcessor ip = null;
        if (this.showSizeDistribution) {
            if (ip == null) {
                ip = new FloatProcessor(count, 1, this.rt.getColumn(0), null);
            }
            new HistogramWindow("Particle Size Distribution", new ImagePlus("", ip), this.sizeBins);
        }
        if (this.ip2 != null) {
            new ImagePlus("Outlines", this.ip2).show();
        }
    }

    public static void savePreferences(Properties prefs) {
        ((Hashtable)prefs).put(OPTIONS, Integer.toString(staticOptions));
        ((Hashtable)prefs).put(BINS, Integer.toString(staticBins));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

