/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class ImageMath
implements PlugInFilter {
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private static boolean first;
    private static double addValue;
    private static double mulValue;
    private static double minValue;
    private static double maxValue;
    private static final String defaultAndValue = "11110000";
    private static String andValue;
    private static final double defaultGammaValue = 0.5;
    private static double gammaValue;
    static /* synthetic */ Class class$ij$plugin$filter$ImageMath;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        first = true;
        IJ.register(class$ij$plugin$filter$ImageMath == null ? (class$ij$plugin$filter$ImageMath = ImageMath.class$("ij.plugin.filter.ImageMath")) : class$ij$plugin$filter$ImageMath);
        return IJ.setupDialog(imp, 95);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            if (first) {
                addValue = this.getValue("Add: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.add((int)addValue);
            return;
        }
        if (this.arg.equals("sub")) {
            if (first) {
                addValue = this.getValue("Subtract: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.add((int)(-addValue));
            return;
        }
        if (this.arg.equals("mul")) {
            if (first) {
                mulValue = this.getValue("Multiple: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            ip.multiply(mulValue);
            return;
        }
        if (this.arg.equals("div")) {
            if (first) {
                mulValue = this.getValue("Divide: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (mulValue != 0.0) {
                ip.multiply(1.0 / mulValue);
            }
            return;
        }
        if (this.arg.equals("and")) {
            if (first) {
                andValue = this.getBinaryValue("AND (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.and(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("or")) {
            if (first) {
                andValue = this.getBinaryValue("OR (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.or(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("xor")) {
            if (first) {
                andValue = this.getBinaryValue("XOR (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.xor(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if ((this.arg.equals("min") || this.arg.equals("max")) && ip instanceof ColorProcessor) {
            IJ.error("RGB images not supported");
            this.canceled = true;
            return;
        }
        if (this.arg.equals("min")) {
            if (first) {
                minValue = this.getValue("Minimum: ", minValue, 0);
            }
            if (this.canceled) {
                return;
            }
            int y = 0;
            while (y < ip.getHeight()) {
                int x = 0;
                while (x < ip.getWidth()) {
                    double v = ip.getPixelValue(x, y);
                    if (v < minValue) {
                        v = minValue;
                    }
                    ip.putPixelValue(x, y, v);
                    ++x;
                }
                ++y;
            }
            return;
        }
        if (this.arg.equals("max")) {
            if (first) {
                maxValue = this.getValue("Maximum: ", maxValue, 0);
            }
            if (this.canceled) {
                return;
            }
            int y = 0;
            while (y < ip.getHeight()) {
                int x = 0;
                while (x < ip.getWidth()) {
                    double v = ip.getPixelValue(x, y);
                    if (v > maxValue) {
                        v = maxValue;
                    }
                    ip.putPixelValue(x, y, v);
                    ++x;
                }
                ++y;
            }
            return;
        }
        if (this.arg.equals("gamma")) {
            if (first) {
                gammaValue = this.getValue("Gamma (0.1-5.0): ", gammaValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (gammaValue < 0.1 || gammaValue > 5.0) {
                IJ.error("Gamma must be between 0.1 and 5.0");
                gammaValue = 0.5;
                return;
            }
            ip.gamma(gammaValue);
            return;
        }
        if (this.arg.equals("log")) {
            ip.log();
            return;
        }
        if (this.arg.equals("reciprocal")) {
            if (!(ip instanceof FloatProcessor)) {
                IJ.error("32-bit float image required");
                this.canceled = true;
                return;
            }
            float[] pixels = (float[])ip.getPixels();
            int i = 0;
            while (i < ip.getWidth() * ip.getHeight()) {
                pixels[i] = pixels[i] == 0.0f ? Float.NaN : 1.0f / pixels[i];
                ++i;
            }
            return;
        }
    }

    double getValue(String prompt, double defaultValue, int digits) {
        GenericDialog gd = new GenericDialog("Math", IJ.getInstance());
        gd.addNumericField(prompt, defaultValue, digits);
        gd.showDialog();
        if (first) {
            this.imp.startTiming();
        }
        first = false;
        this.canceled = gd.wasCanceled();
        if (this.canceled) {
            return defaultValue;
        }
        return gd.getNextNumber();
    }

    String getBinaryValue(String prompt, String defaultValue) {
        GenericDialog gd = new GenericDialog("Math", IJ.getInstance());
        gd.addStringField(prompt, defaultValue);
        gd.showDialog();
        if (first) {
            this.imp.startTiming();
        }
        first = false;
        this.canceled = gd.wasCanceled();
        if (this.canceled) {
            return defaultValue;
        }
        return gd.getNextString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        addValue = 25.0;
        mulValue = 1.25;
        minValue = 0.0;
        maxValue = 255.0;
        andValue = defaultAndValue;
        gammaValue = 0.5;
    }
}

