/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class ZProjector
implements PlugIn {
    public static final int AVG_METHOD = 0;
    public static final int MAX_METHOD = 1;
    public static final int SUM_METHOD = 2;
    public static final int SD_METHOD = 3;
    public static final String[] METHODS = new String[]{"Average Intensity", "Max Intensity", "Sum Slices", "Standard Deviation"};
    private static int method = 0;
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int FLOAT_TYPE = 2;
    private ImagePlus projImage = null;
    private ImagePlus imp = null;
    private int startSlice = 1;
    private int stopSlice = 1;
    static /* synthetic */ Class class$ij$plugin$ZProjector;

    public ZProjector() {
    }

    public ZProjector(ImagePlus imp) {
        this.setImage(imp);
    }

    public void setImage(ImagePlus imp) {
        this.imp = imp;
        this.startSlice = 1;
        this.stopSlice = imp.getStackSize();
    }

    public void setStartSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.startSlice = slice;
    }

    public void setStopSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.stopSlice = slice;
    }

    public ImagePlus getProjection() {
        return this.projImage;
    }

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (this.imp.getStackSize() == 1) {
            IJ.showMessage("ZProjection", "Stack required");
            return;
        }
        if (this.imp.getType() == 4) {
            IJ.showMessage("ZProjection", "RGB stacks are not supported.");
            return;
        }
        this.startSlice = 1;
        this.stopSlice = this.imp.getStackSize();
        GenericDialog gd = this.buildControlDialog(this.startSlice, this.stopSlice);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        long tstart = System.currentTimeMillis();
        this.doProjection(gd);
        if (arg.equals("")) {
            long tstop = System.currentTimeMillis();
            this.projImage.show("ZProjector: " + IJ.d2s((double)(tstop - tstart) / 1000.0, 2) + " seconds");
        }
        this.imp.unlock();
        IJ.register(class$ij$plugin$ZProjector == null ? (class$ij$plugin$ZProjector = ZProjector.class$("ij.plugin.ZProjector")) : class$ij$plugin$ZProjector);
    }

    private void doProjection(GenericDialog gd) {
        this.setStartSlice((int)gd.getNextNumber());
        this.setStopSlice((int)gd.getNextNumber());
        method = gd.getNextChoiceIndex();
        this.computeProjection(method);
    }

    protected GenericDialog buildControlDialog(int start, int stop) {
        GenericDialog gd = new GenericDialog("ZProjection", IJ.getInstance());
        gd.addNumericField("Start slice:", this.startSlice, 0);
        gd.addNumericField("Stop slice:", this.stopSlice, 0);
        gd.addChoice("Projection Type", METHODS, METHODS[method]);
        return gd;
    }

    public void computeProjection(int method) {
        int ptype;
        if (this.imp == null) {
            return;
        }
        FloatProcessor fp = new FloatProcessor(this.imp.getWidth(), this.imp.getHeight());
        ImageStack stack = this.imp.getStack();
        RayFunction rayFunc = this.getRayFunction(method, fp);
        if (IJ.debugMode) {
            IJ.write("\nProjecting stack from: " + this.startSlice + " to: " + this.stopSlice);
        }
        if (stack.getProcessor(1) instanceof ByteProcessor) {
            ptype = 0;
        } else if (stack.getProcessor(1) instanceof ShortProcessor) {
            ptype = 1;
        } else if (stack.getProcessor(1) instanceof FloatProcessor) {
            ptype = 2;
        } else {
            IJ.error("ZProjection_: Unknown processor type.");
            return;
        }
        Object[] pixelArray = stack.getImageArray();
        int n = this.startSlice;
        while (n <= this.stopSlice) {
            IJ.showStatus("ZProjection - projecting slice: " + n);
            this.projectSlice(pixelArray[n - 1], rayFunc, ptype);
            ++n;
        }
        if (method == 2) {
            fp.resetMinAndMax();
            this.projImage = new ImagePlus("Sum", fp);
        } else if (method == 3) {
            rayFunc.postProcess();
            fp.resetMinAndMax();
            this.projImage = new ImagePlus("Standard Deviation", fp);
        } else {
            rayFunc.postProcess();
            this.projImage = this.makeOutputImage(this.imp, fp, ptype);
        }
        if (this.projImage == null) {
            IJ.error("ZProjection - error computing projection.");
        }
    }

    private RayFunction getRayFunction(int method, FloatProcessor fp) {
        if (method == 0 || method == 2) {
            return new AverageIntensity(fp, this.stopSlice - this.startSlice + 1);
        }
        if (method == 1) {
            return new MaxIntensity(fp);
        }
        if (method == 3) {
            return new StandardDeviation(fp, this.stopSlice - this.startSlice + 1);
        }
        IJ.error("ZProjection - unknown method.");
        return null;
    }

    private ImagePlus makeOutputImage(ImagePlus imp, FloatProcessor fp, int ptype) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        float[] pixels = (float[])fp.getPixels();
        ImageProcessor oip = null;
        int size = pixels.length;
        switch (ptype) {
            case 0: {
                oip = imp.getProcessor().createProcessor(width, height);
                byte[] pixels8 = (byte[])oip.getPixels();
                int i = 0;
                while (i < size) {
                    pixels8[i] = (byte)pixels[i];
                    ++i;
                }
                break;
            }
            case 1: {
                oip = imp.getProcessor().createProcessor(width, height);
                short[] pixels16 = (short[])oip.getPixels();
                int i = 0;
                while (i < size) {
                    pixels16[i] = (short)pixels[i];
                    ++i;
                }
                break;
            }
            case 2: {
                oip = new FloatProcessor(width, height, pixels, null);
            }
        }
        oip.resetMinAndMax();
        return new ImagePlus("zprojection", oip);
    }

    private void projectSlice(Object pixelArray, RayFunction rayFunc, int ptype) {
        switch (ptype) {
            case 0: {
                rayFunc.projectSlice((byte[])pixelArray);
                break;
            }
            case 1: {
                rayFunc.projectSlice((short[])pixelArray);
                break;
            }
            case 2: {
                rayFunc.projectSlice((float[])pixelArray);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StandardDeviation
    extends RayFunction {
        FloatProcessor fp;
        private float[] sum;
        private float[] sum2;
        private int num;
        private int len;

        public StandardDeviation(FloatProcessor fp, int num) {
            this.sum = (float[])fp.getPixels();
            this.len = this.sum.length;
            this.sum2 = new float[this.len];
            this.num = num;
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                int v = pixels[i] & 0xFF;
                int n = i;
                this.sum[n] = this.sum[n] + (float)v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + (float)(v * v);
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                int v = pixels[i] & 0xFFFF;
                int n = i;
                this.sum[n] = this.sum[n] + (float)v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + (float)(v * v);
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                float v = pixels[i];
                int n = i;
                this.sum[n] = this.sum[n] + v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + v * v;
            }
        }

        public void postProcess() {
            double n = this.num;
            int i = 0;
            while (i < this.len) {
                double stdDev;
                this.sum[i] = this.num > 1 ? ((stdDev = (n * (double)this.sum2[i] - (double)(this.sum[i] * this.sum[i])) / n) > 0.0 ? (float)Math.sqrt(stdDev / (n - 1.0)) : 0.0f) : 0.0f;
                ++i;
            }
        }
    }

    class MaxIntensity
    extends RayFunction {
        private FloatProcessor fp;
        private float[] fpixels;
        private int len;

        public MaxIntensity(FloatProcessor fp) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            int i = 0;
            while (i < this.len) {
                this.fpixels[i] = -3.4028235E38f;
                ++i;
            }
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                if ((float)(pixels[i] & 0xFF) > this.fpixels[i]) {
                    this.fpixels[i] = pixels[i] & 0xFF;
                }
                ++i;
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                if ((float)(pixels[i] & 0xFFFF) > this.fpixels[i]) {
                    this.fpixels[i] = pixels[i] & 0xFFFF;
                }
                ++i;
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                if (pixels[i] > this.fpixels[i]) {
                    this.fpixels[i] = pixels[i];
                }
                ++i;
            }
        }
    }

    class AverageIntensity
    extends RayFunction {
        private float[] fpixels;
        private int num;
        private int len;

        public AverageIntensity(FloatProcessor fp, int num) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            this.num = num;
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFF);
                ++i;
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFFFF);
                ++i;
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + pixels[i];
                ++i;
            }
        }

        public void postProcess() {
            float fnum = this.num;
            int i = 0;
            while (i < this.len) {
                int n = i++;
                this.fpixels[n] = this.fpixels[n] / fnum;
            }
        }
    }

    abstract class RayFunction {
        RayFunction() {
        }

        public abstract void projectSlice(byte[] var1);

        public abstract void projectSlice(short[] var1);

        public abstract void projectSlice(float[] var1);

        public void postProcess() {
        }
    }
}

