/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class TextReader
extends ImagePlus
implements PlugIn {
    private static String defaultDirectory;
    int words = 0;
    int chars = 0;
    int lines = 0;

    public void run(String arg) {
        ImageProcessor ip;
        OpenDialog od = new OpenDialog("Acquire Text Image...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            ip = this.openFile(path);
        }
        catch (Exception e) {
            IJ.showMessage("TextReader", e.getMessage());
            return;
        }
        this.setProcessor(name, ip);
        if (arg.equals("")) {
            this.show();
        }
    }

    public ImageProcessor openFile(String path) throws IOException {
        this.lines = 0;
        this.chars = 0;
        this.words = 0;
        BufferedReader r = new BufferedReader(new FileReader(path));
        this.countLines(r);
        ((Reader)r).close();
        r = new BufferedReader(new FileReader(path));
        int width = this.words / this.lines;
        float[] pixels = new float[width * this.lines];
        FloatProcessor ip = new FloatProcessor(width, this.lines, pixels, null);
        this.read(r, width * this.lines, pixels);
        ((ImageProcessor)ip).resetMinAndMax();
        return ip;
    }

    public void countLines(Reader r) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        int width = 1;
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.eolIsSignificant(true);
        block4: while (tok.nextToken() != -1) {
            switch (tok.ttype) {
                case 10: {
                    ++this.lines;
                    if (this.lines == 1) {
                        width = this.words;
                    }
                    if (this.lines % 20 != 0 || width <= 1 || this.lines > width) continue block4;
                    IJ.showProgress((double)this.lines / (double)width / 2.0);
                    break;
                }
                case -3: {
                    ++this.words;
                }
            }
        }
    }

    public void read(Reader r, int size, float[] pixels) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.parseNumbers();
        int i = 0;
        int inc = size / 20;
        while (tok.nextToken() != -1) {
            if (tok.ttype != -2) continue;
            pixels[i++] = (float)tok.nval;
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
    }
}

