/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;

public class StackWriter
implements PlugIn {
    private static String[] choices = new String[]{"Tiff", "Gif", "Jpeg", "Raw"};
    private static String fileType = "Tiff";
    private static int ndigits = 4;
    static /* synthetic */ Class class$ij$plugin$StackWriter;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp != null && imp.getStackSize() < 2) {
            IJ.error("This command requires a stack.");
            return;
        }
        String name = imp.getTitle();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        GenericDialog gd = new GenericDialog("Save Stack", IJ.getInstance());
        gd.addChoice("Save Slices as:", choices, fileType);
        gd.addStringField("Name:", name, 12);
        gd.addNumericField("Digits (1-8):", ndigits, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        fileType = gd.getNextChoice();
        name = gd.getNextString();
        ndigits = (int)gd.getNextNumber();
        int number = 0;
        if (ndigits < 1) {
            ndigits = 1;
        }
        if (ndigits > 8) {
            ndigits = 8;
        }
        if (fileType.equals("Gif") && !FileSaver.okForGif(imp)) {
            return;
        }
        if (fileType.equals("Jpeg") && !FileSaver.okForJpeg(imp)) {
            return;
        }
        String extension = "";
        if (fileType.equals("Tiff")) {
            extension = ".tif";
        } else if (fileType.equals("Jpeg")) {
            extension = ".jpg";
        } else if (fileType.equals("Gif")) {
            extension = ".gif";
        } else if (fileType.equals("Raw")) {
            extension = ".raw";
        }
        String digits = this.getDigits(number);
        SaveDialog sd = new SaveDialog("StackWriter", name + digits + extension, extension);
        String name2 = sd.getFileName();
        if (name2 == null) {
            return;
        }
        String directory = sd.getDirectory();
        ImageStack stack = imp.getStack();
        ImagePlus tmp = new ImagePlus();
        int nSlices = stack.getSize();
        String path = directory + name;
        int i = 1;
        while (i <= nSlices) {
            IJ.showStatus("writing: " + i + "/" + nSlices);
            IJ.showProgress((double)i / (double)nSlices);
            tmp.setProcessor(null, stack.getProcessor(i));
            digits = this.getDigits(number++);
            if (fileType.equals("Tiff") ? !new FileSaver(tmp).saveAsTiff(path + digits + extension) : (fileType.equals("Gif") ? !new FileSaver(tmp).saveAsGif(path + digits + extension) : (fileType.equals("Jpeg") ? !new FileSaver(tmp).saveAsJpeg(path + digits + extension) : fileType.equals("Raw") && !new FileSaver(tmp).saveAsRaw(path + digits + extension)))) break;
            System.gc();
            ++i;
        }
        IJ.showStatus("");
        IJ.showProgress(1.0);
        IJ.register(class$ij$plugin$StackWriter == null ? (class$ij$plugin$StackWriter = StackWriter.class$("ij.plugin.StackWriter")) : class$ij$plugin$StackWriter);
    }

    String getDigits(int n) {
        String digits = "00000000" + n;
        return digits.substring(digits.length() - ndigits, digits.length());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

